/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.base.io.ByteBuffers;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.PartitionTransforms;
import io.trino.plugin.iceberg.SortFieldUtils;
import io.trino.plugin.iceberg.TrinoMetricsReporter;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.util.DefaultLocationProvider;
import io.trino.plugin.iceberg.util.ObjectStoreLocationProvider;
import io.trino.plugin.iceberg.util.Timestamps;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.Utils;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;

public final class IcebergUtil {
    public static final String TRINO_TABLE_METADATA_INFO_VALID_FOR = "trino_table_metadata_info_valid_for";
    public static final String COLUMN_TRINO_NOT_NULL_PROPERTY = "trino_not_null";
    public static final String COLUMN_TRINO_TYPE_ID_PROPERTY = "trino_type_id";
    public static final String METADATA_FOLDER_NAME = "metadata";
    public static final String METADATA_FILE_EXTENSION = ".metadata.json";
    public static final String TRINO_QUERY_ID_NAME = "trino_query_id";
    private static final Pattern SIMPLE_NAME = Pattern.compile("[a-z][a-z0-9]*");
    private static final Pattern METADATA_FILE_NAME_PATTERN = Pattern.compile("(?<version>\\d+)-(?<uuid>[-a-fA-F0-9]*)(?<compression>\\.[a-zA-Z0-9]+)?" + Pattern.quote(".metadata.json") + "(?<compression2>\\.[a-zA-Z0-9]+)?");
    private static final Pattern HADOOP_GENERATED_METADATA_FILE_NAME_PATTERN = Pattern.compile("v(?<version>\\d+)(?<compression>\\.[a-zA-Z0-9]+)?" + Pattern.quote(".metadata.json") + "(?<compression2>\\.[a-zA-Z0-9]+)?");

    private IcebergUtil() {
    }

    public static Table loadIcebergTable(TrinoCatalog catalog, IcebergTableOperationsProvider tableOperationsProvider, ConnectorSession session, SchemaTableName table) {
        IcebergTableOperations operations = tableOperationsProvider.createTableOperations(catalog, session, table.getSchemaName(), table.getTableName(), Optional.empty(), Optional.empty());
        return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER);
    }

    public static Table getIcebergTableWithMetadata(TrinoCatalog catalog, IcebergTableOperationsProvider tableOperationsProvider, ConnectorSession session, SchemaTableName table, TableMetadata tableMetadata) {
        IcebergTableOperations operations = tableOperationsProvider.createTableOperations(catalog, session, table.getSchemaName(), table.getTableName(), Optional.empty(), Optional.empty());
        operations.initializeFromMetadata(tableMetadata);
        return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER);
    }

    public static Map<String, Object> getIcebergTableProperties(Table icebergTable) {
        String orcBloomFilterFpp;
        SortOrder sortOrder;
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"format", (Object)IcebergUtil.getFileFormat(icebergTable));
        if (!icebergTable.spec().fields().isEmpty()) {
            properties.put((Object)"partitioning", PartitionFields.toPartitionFields(icebergTable.spec()));
        }
        if ((sortOrder = icebergTable.sortOrder()).isSorted() && sortOrder.fields().stream().allMatch(sortField -> sortField.transform().isIdentity())) {
            List<String> sortColumnNames = SortFieldUtils.toSortFields(sortOrder);
            properties.put((Object)"sorted_by", sortColumnNames);
        }
        if (!icebergTable.location().isEmpty()) {
            properties.put((Object)"location", (Object)icebergTable.location());
        }
        int formatVersion = ((BaseTable)icebergTable).operations().current().formatVersion();
        properties.put((Object)"format_version", (Object)formatVersion);
        String orcBloomFilterColumns = (String)icebergTable.properties().get("orc.bloom.filter.columns");
        if (orcBloomFilterColumns != null) {
            properties.put((Object)"orc_bloom_filter_columns", (Object)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)orcBloomFilterColumns));
        }
        if ((orcBloomFilterFpp = (String)icebergTable.properties().get("orc.bloom.filter.fpp")) != null) {
            properties.put((Object)"orc_bloom_filter_fpp", (Object)Double.parseDouble(orcBloomFilterFpp));
        }
        return properties.buildOrThrow();
    }

    public static List<IcebergColumnHandle> getColumns(Schema schema, TypeManager typeManager) {
        return (List)schema.columns().stream().map(column -> IcebergUtil.getColumnHandle(column, typeManager)).collect(ImmutableList.toImmutableList());
    }

    public static List<ColumnMetadata> getColumnMetadatas(Schema schema, TypeManager typeManager) {
        List icebergColumns = schema.columns();
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)(icebergColumns.size() + 2));
        icebergColumns.stream().map(column -> ColumnMetadata.builder().setName(column.name()).setType(TypeConverter.toTrinoType(column.type(), typeManager)).setNullable(column.isOptional()).setComment(Optional.ofNullable(column.doc())).build()).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
        columns.add((Object)IcebergColumnHandle.pathColumnMetadata());
        columns.add((Object)IcebergColumnHandle.fileModifiedTimeColumnMetadata());
        return columns.build();
    }

    public static IcebergColumnHandle getColumnHandle(Types.NestedField column, TypeManager typeManager) {
        io.trino.spi.type.Type type = TypeConverter.toTrinoType(column.type(), typeManager);
        return new IcebergColumnHandle(ColumnIdentity.createColumnIdentity(column), type, (List<Integer>)ImmutableList.of(), type, Optional.ofNullable(column.doc()));
    }

    public static Schema schemaFromHandles(List<IcebergColumnHandle> columns) {
        List icebergColumns = (List)columns.stream().map(column -> Types.NestedField.optional((int)column.getId(), (String)column.getName(), (Type)TypeConverter.toIcebergType(column.getType(), column.getColumnIdentity()))).collect(ImmutableList.toImmutableList());
        return new Schema(Types.StructType.of((List)icebergColumns).asStructType().fields());
    }

    public static Map<PartitionField, Integer> getIdentityPartitions(PartitionSpec partitionSpec) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (int i = 0; i < partitionSpec.fields().size(); ++i) {
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            if (!field.transform().isIdentity()) continue;
            columns.put((Object)field, (Object)i);
        }
        return columns.buildOrThrow();
    }

    public static Map<Integer, Type.PrimitiveType> primitiveFieldTypes(Schema schema) {
        return (Map)IcebergUtil.primitiveFieldTypes(schema.columns()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Stream<Map.Entry<Integer, Type.PrimitiveType>> primitiveFieldTypes(List<Types.NestedField> nestedFields) {
        return nestedFields.stream().flatMap(IcebergUtil::primitiveFieldTypes);
    }

    private static Stream<Map.Entry<Integer, Type.PrimitiveType>> primitiveFieldTypes(Types.NestedField nestedField) {
        Type fieldType = nestedField.type();
        if (fieldType.isPrimitiveType()) {
            return Stream.of(Map.entry(nestedField.fieldId(), fieldType.asPrimitiveType()));
        }
        if (fieldType.isNestedType()) {
            return IcebergUtil.primitiveFieldTypes(fieldType.asNestedType().fields());
        }
        throw new IllegalStateException("Unsupported field type: " + String.valueOf(nestedField));
    }

    public static IcebergFileFormat getFileFormat(Table table) {
        return IcebergUtil.getFileFormat(table.properties());
    }

    public static IcebergFileFormat getFileFormat(Map<String, String> storageProperties) {
        return IcebergFileFormat.fromIceberg(FileFormat.valueOf((String)storageProperties.getOrDefault("write.format.default", "parquet").toUpperCase(Locale.ENGLISH)));
    }

    public static Optional<String> getTableComment(Table table) {
        return Optional.ofNullable((String)table.properties().get("comment"));
    }

    public static String quotedTableName(SchemaTableName name) {
        return IcebergUtil.quotedName(name.getSchemaName()) + "." + IcebergUtil.quotedName(name.getTableName());
    }

    private static String quotedName(String name) {
        if (SIMPLE_NAME.matcher(name).matches()) {
            return name;
        }
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }

    public static boolean canEnforceColumnConstraintInSpecs(TypeOperators typeOperators, Table table, Set<Integer> partitionSpecIds, IcebergColumnHandle columnHandle, Domain domain) {
        return table.specs().values().stream().filter(partitionSpec -> partitionSpecIds.contains(partitionSpec.specId())).allMatch(spec -> IcebergUtil.canEnforceConstraintWithinPartitioningSpec(typeOperators, spec, columnHandle, domain));
    }

    private static boolean canEnforceConstraintWithinPartitioningSpec(TypeOperators typeOperators, PartitionSpec spec, IcebergColumnHandle column, Domain domain) {
        for (PartitionField field : spec.getFieldsBySourceId(column.getId())) {
            if (!IcebergUtil.canEnforceConstraintWithPartitionField(typeOperators, field, column, domain)) continue;
            return true;
        }
        return false;
    }

    private static boolean canEnforceConstraintWithPartitionField(TypeOperators typeOperators, PartitionField field, IcebergColumnHandle column, Domain domain) {
        if (field.transform().isVoid()) {
            return false;
        }
        if (field.transform().isIdentity()) {
            return true;
        }
        PartitionTransforms.ColumnTransform transform = PartitionTransforms.getColumnTransform(field, column.getType());
        if (transform.preservesNonNull()) {
            return false;
        }
        ValueSet valueSet = domain.getValues();
        boolean canEnforce = (Boolean)valueSet.getValuesProcessor().transform(ranges -> {
            MethodHandle targetTypeEqualOperator = typeOperators.getEqualOperator(transform.getType(), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            for (Range range : ranges.getOrderedRanges()) {
                if (IcebergUtil.canEnforceRangeWithPartitioningField(field, transform, range, targetTypeEqualOperator)) continue;
                return false;
            }
            return true;
        }, discreteValues -> false, allOrNone -> true);
        return canEnforce;
    }

    private static boolean canEnforceRangeWithPartitioningField(PartitionField field, PartitionTransforms.ColumnTransform transform, Range range, MethodHandle targetTypeEqualOperator) {
        Optional adjacentValue;
        Object boundedValue;
        if (!transform.isMonotonic()) {
            return false;
        }
        io.trino.spi.type.Type type = range.getType();
        if (!type.isOrderable()) {
            return false;
        }
        if (!range.isLowUnbounded()) {
            boundedValue = range.getLowBoundedValue();
            Optional optional = adjacentValue = range.isLowInclusive() ? type.getPreviousValue(boundedValue) : type.getNextValue(boundedValue);
            if (adjacentValue.isEmpty() || IcebergUtil.yieldSamePartitioningValue(field, transform, type, boundedValue, adjacentValue.get(), targetTypeEqualOperator)) {
                return false;
            }
        }
        if (!range.isHighUnbounded()) {
            boundedValue = range.getHighBoundedValue();
            Optional optional = adjacentValue = range.isHighInclusive() ? type.getNextValue(boundedValue) : type.getPreviousValue(boundedValue);
            if (adjacentValue.isEmpty() || IcebergUtil.yieldSamePartitioningValue(field, transform, type, boundedValue, adjacentValue.get(), targetTypeEqualOperator)) {
                return false;
            }
        }
        return true;
    }

    private static boolean yieldSamePartitioningValue(PartitionField field, PartitionTransforms.ColumnTransform transform, io.trino.spi.type.Type sourceType, Object first, Object second, MethodHandle targetTypeEqualOperator) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        Object firstTransformed = transform.getValueTransform().apply(Utils.nativeValueToBlock((io.trino.spi.type.Type)sourceType, (Object)first), 0);
        Object secondTransformed = transform.getValueTransform().apply(Utils.nativeValueToBlock((io.trino.spi.type.Type)sourceType, (Object)second), 0);
        Verify.verify((firstTransformed != null && secondTransformed != null ? 1 : 0) != 0, (String)"Transform for %s returned null for non-null input", (Object)field);
        try {
            return targetTypeEqualOperator.invoke(firstTransformed, secondTransformed);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static Object deserializePartitionValue(io.trino.spi.type.Type type, String valueString, String name) {
        if (valueString == null) {
            return null;
        }
        try {
            if (type.equals((Object)BooleanType.BOOLEAN)) {
                if (valueString.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return false;
                }
                throw new IllegalArgumentException();
            }
            if (type.equals((Object)IntegerType.INTEGER)) {
                return Long.parseLong(valueString);
            }
            if (type.equals((Object)BigintType.BIGINT)) {
                return Long.parseLong(valueString);
            }
            if (type.equals((Object)RealType.REAL)) {
                return (long)Float.floatToRawIntBits(Float.parseFloat(valueString));
            }
            if (type.equals((Object)DoubleType.DOUBLE)) {
                return Double.parseDouble(valueString);
            }
            if (type.equals((Object)DateType.DATE)) {
                return Long.parseLong(valueString);
            }
            if (type.equals((Object)TimeType.TIME_MICROS)) {
                return Long.parseLong(valueString) * 1000000L;
            }
            if (type.equals((Object)TimestampType.TIMESTAMP_MICROS)) {
                return Long.parseLong(valueString);
            }
            if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
                return Timestamps.timestampTzFromMicros(Long.parseLong(valueString));
            }
            if (type instanceof VarcharType) {
                VarcharType varcharType = (VarcharType)type;
                Slice value = Slices.utf8Slice((String)valueString);
                if (!varcharType.isUnbounded() && SliceUtf8.countCodePoints((Slice)value) > varcharType.getBoundedLength()) {
                    throw new IllegalArgumentException();
                }
                return value;
            }
            if (type.equals((Object)VarbinaryType.VARBINARY)) {
                return Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(valueString));
            }
            if (type.equals((Object)UuidType.UUID)) {
                return UuidType.javaUuidToTrinoUuid((UUID)UUID.fromString(valueString));
            }
            if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                BigDecimal decimal = new BigDecimal(valueString);
                if ((decimal = decimal.setScale(decimalType.getScale(), RoundingMode.UNNECESSARY)).precision() > decimalType.getPrecision()) {
                    throw new IllegalArgumentException();
                }
                BigInteger unscaledValue = decimal.unscaledValue();
                return decimalType.isShort() ? Long.valueOf(unscaledValue.longValue()) : Int128.valueOf((BigInteger)unscaledValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", valueString, type.getDisplayName(), name));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid partition type " + String.valueOf(type));
    }

    public static Map<Integer, Optional<String>> getPartitionKeys(FileScanTask scanTask) {
        return IcebergUtil.getPartitionKeys(((DataFile)scanTask.file()).partition(), scanTask.spec());
    }

    public static Map<Integer, Optional<String>> getPartitionKeys(StructLike partition, PartitionSpec spec) {
        Map<PartitionField, Integer> fieldToIndex = IcebergUtil.getIdentityPartitions(spec);
        ImmutableMap.Builder partitionKeys = ImmutableMap.builder();
        fieldToIndex.forEach((field, index) -> {
            int id = field.sourceId();
            Type type = spec.schema().findType(id);
            Class javaClass = type.typeId().javaClass();
            Object value = partition.get(index.intValue(), javaClass);
            if (value == null) {
                partitionKeys.put((Object)id, Optional.empty());
            } else {
                String partitionValue = type.typeId() == Type.TypeID.FIXED || type.typeId() == Type.TypeID.BINARY ? Base64.getEncoder().encodeToString(ByteBuffers.getWrappedBytes((ByteBuffer)((ByteBuffer)value))) : value.toString();
                partitionKeys.put((Object)id, Optional.of(partitionValue));
            }
        });
        return partitionKeys.buildOrThrow();
    }

    public static Map<ColumnHandle, NullableValue> getPartitionValues(Set<IcebergColumnHandle> identityPartitionColumns, Map<Integer, Optional<String>> partitionKeys) {
        ImmutableMap.Builder bindings = ImmutableMap.builder();
        for (IcebergColumnHandle partitionColumn : identityPartitionColumns) {
            Object partitionValue = IcebergUtil.deserializePartitionValue(partitionColumn.getType(), partitionKeys.get(partitionColumn.getId()).orElse(null), partitionColumn.getName());
            NullableValue bindingValue = new NullableValue(partitionColumn.getType(), partitionValue);
            bindings.put((Object)partitionColumn, (Object)bindingValue);
        }
        return bindings.buildOrThrow();
    }

    public static LocationProvider getLocationProvider(SchemaTableName schemaTableName, String tableLocation, Map<String, String> storageProperties) {
        if (storageProperties.containsKey("write.location-provider.impl")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + String.valueOf(schemaTableName) + " specifies " + storageProperties.get("write.location-provider.impl") + " as a location provider. Writing to Iceberg tables with custom location provider is not supported.");
        }
        if (PropertyUtil.propertyAsBoolean(storageProperties, (String)"write.object-storage.enabled", (boolean)false)) {
            return new ObjectStoreLocationProvider(tableLocation, storageProperties);
        }
        return new DefaultLocationProvider(tableLocation, storageProperties);
    }

    public static Schema schemaFromMetadata(List<ColumnMetadata> columns) {
        ArrayList<Types.NestedField> icebergColumns = new ArrayList<Types.NestedField>();
        int visibleColumnCount = (int)columns.stream().filter(column -> !column.isHidden()).count();
        AtomicInteger nextFieldId = new AtomicInteger(visibleColumnCount + 1);
        for (ColumnMetadata column2 : columns) {
            if (column2.isHidden()) continue;
            int index = icebergColumns.size() + 1;
            Type type = TypeConverter.toIcebergTypeForNewColumn(column2.getType(), nextFieldId);
            Types.NestedField field = Types.NestedField.of((int)index, (boolean)column2.isNullable(), (String)column2.getName(), (Type)type, (String)column2.getComment());
            icebergColumns.add(field);
        }
        Types.StructType icebergSchema = Types.StructType.of(icebergColumns);
        return new Schema(icebergSchema.asStructType().fields());
    }

    public static Transaction newCreateTableTransaction(TrinoCatalog catalog, ConnectorTableMetadata tableMetadata, ConnectorSession session, boolean replace, String tableLocation) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        Schema schema = IcebergUtil.schemaFromMetadata(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        SortOrder sortOrder = SortFieldUtils.parseSortFields(schema, IcebergTableProperties.getSortOrder(tableMetadata.getProperties()));
        if (replace) {
            return catalog.newCreateOrReplaceTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, tableLocation, IcebergUtil.createTableProperties(tableMetadata));
        }
        return catalog.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, tableLocation, IcebergUtil.createTableProperties(tableMetadata));
    }

    public static Map<String, String> createTableProperties(ConnectorTableMetadata tableMetadata) {
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        IcebergFileFormat fileFormat = IcebergTableProperties.getFileFormat(tableMetadata.getProperties());
        propertiesBuilder.put((Object)"write.format.default", (Object)fileFormat.toIceberg().toString());
        propertiesBuilder.put((Object)"format-version", (Object)Integer.toString(IcebergTableProperties.getFormatVersion(tableMetadata.getProperties())));
        List<String> columns = IcebergTableProperties.getOrcBloomFilterColumns(tableMetadata.getProperties());
        if (!columns.isEmpty()) {
            IcebergUtil.checkFormatForProperty(fileFormat.toIceberg(), FileFormat.ORC, "orc_bloom_filter_columns");
            IcebergUtil.validateOrcBloomFilterColumns(tableMetadata, columns);
            propertiesBuilder.put((Object)"orc.bloom.filter.columns", (Object)Joiner.on((String)",").join(columns));
            propertiesBuilder.put((Object)"orc.bloom.filter.fpp", (Object)String.valueOf(IcebergTableProperties.getOrcBloomFilterFpp(tableMetadata.getProperties())));
        }
        if (tableMetadata.getComment().isPresent()) {
            propertiesBuilder.put((Object)"comment", (Object)((String)tableMetadata.getComment().get()));
        }
        return propertiesBuilder.buildOrThrow();
    }

    public static Optional<Snapshot> firstSnapshot(Table table) {
        Snapshot current = table.currentSnapshot();
        Preconditions.checkArgument((current != null ? 1 : 0) != 0, (String)"No current snapshot in %s when looking for the first snapshot", (Object)table);
        do {
            if (current.parentId() != null) continue;
            return Optional.of(current);
        } while ((current = table.snapshot(current.parentId().longValue())) != null);
        return Optional.empty();
    }

    public static Optional<Snapshot> firstSnapshotAfter(Table table, long baseSnapshotId) {
        Snapshot current = table.currentSnapshot();
        Preconditions.checkArgument((current != null ? 1 : 0) != 0, (String)"No current snapshot in %s when looking for the first snapshot after %s", (Object)table, (long)baseSnapshotId);
        Preconditions.checkArgument((current.snapshotId() != baseSnapshotId ? 1 : 0) != 0, (String)"No snapshot after %s in %s, current snapshot is %s", (Object)baseSnapshotId, (Object)table, (Object)current);
        do {
            if (current.parentId() == null) {
                return Optional.empty();
            }
            if (current.parentId() != baseSnapshotId) continue;
            return Optional.of(current);
        } while ((current = table.snapshot(current.parentId().longValue())) != null);
        return Optional.empty();
    }

    public static long getSnapshotIdAsOfTime(Table table, long epochMillis) {
        return table.history().stream().filter(logEntry -> logEntry.timestampMillis() <= epochMillis).max(Comparator.comparing(HistoryEntry::timestampMillis)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("No version history table %s at or before %s", table.name(), Instant.ofEpochMilli(epochMillis)))).snapshotId();
    }

    public static void validateTableCanBeDropped(Table table) {
        if (table.properties().containsKey("write.object-storage.path") || table.properties().containsKey("write.folder-storage.path") || table.properties().containsKey("write.metadata.path") || table.properties().containsKey("write.data.path")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table contains Iceberg path override properties and cannot be dropped from Trino: " + table.name());
        }
    }

    private static void checkFormatForProperty(FileFormat actualStorageFormat, FileFormat expectedStorageFormat, String propertyName) {
        if (actualStorageFormat != expectedStorageFormat) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", propertyName, actualStorageFormat));
        }
    }

    private static void validateOrcBloomFilterColumns(ConnectorTableMetadata tableMetadata, List<String> orcBloomFilterColumns) {
        Set allColumns = (Set)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        if (!allColumns.containsAll(orcBloomFilterColumns)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Orc bloom filter columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(orcBloomFilterColumns), (Set)allColumns)));
        }
    }

    public static int parseVersion(String metadataFileName) throws TrinoException {
        Preconditions.checkArgument((!metadataFileName.contains("/") ? 1 : 0) != 0, (String)"Not a file name: %s", (Object)metadataFileName);
        Matcher matcher = METADATA_FILE_NAME_PATTERN.matcher(metadataFileName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("version"));
        }
        matcher = HADOOP_GENERATED_METADATA_FILE_NAME_PATTERN.matcher(metadataFileName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("version"));
        }
        throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Invalid metadata file name: " + metadataFileName);
    }

    public static String fixBrokenMetadataLocation(String location) {
        String fileName = IcebergUtil.fileName(location);
        String correctSuffix = "/metadata/" + fileName;
        String brokenSuffix = "//metadata/" + fileName;
        if (!location.endsWith(brokenSuffix)) {
            return location;
        }
        return location.replaceFirst(Pattern.quote(brokenSuffix) + "$", Matcher.quoteReplacement(correctSuffix));
    }

    public static String fileName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static void commit(SnapshotUpdate<?> update, ConnectorSession session) {
        update.set(TRINO_QUERY_ID_NAME, session.getQueryId());
        update.commit();
    }

    public static TableScan buildTableScan(Table icebergTable, MetadataTableType metadataTableType) {
        return MetadataTableUtils.createMetadataTableInstance((Table)icebergTable, (MetadataTableType)metadataTableType).newScan();
    }

    public static Map<String, Integer> columnNameToPositionInSchema(Schema schema) {
        return (Map)Streams.mapWithIndex(schema.columns().stream(), (column, position) -> Maps.immutableEntry((Object)column.name(), (Object)Long.valueOf(position).intValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

