/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;

public class SnapshotsTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private static final String COMMITTED_AT_COLUMN_NAME = "committed_at";
    private static final String SNAPSHOT_ID_COLUMN_NAME = "snapshot_id";
    private static final String PARENT_ID_COLUMN_NAME = "parent_id";
    private static final String OPERATION_COLUMN_NAME = "operation";
    private static final String MANIFEST_LIST_COLUMN_NAME = "manifest_list";
    private static final String SUMMARY_COLUMN_NAME = "summary";

    public SnapshotsTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata(COMMITTED_AT_COLUMN_NAME, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).add((Object)new ColumnMetadata(SNAPSHOT_ID_COLUMN_NAME, (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata(PARENT_ID_COLUMN_NAME, (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata(OPERATION_COLUMN_NAME, (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata(MANIFEST_LIST_COLUMN_NAME, (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata(SUMMARY_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(SnapshotsTable.buildPages(this.tableMetadata, session, this.icebergTable));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, ConnectorSession session, Table icebergTable) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        TableScan tableScan = IcebergUtil.buildTableScan(icebergTable, MetadataTableType.SNAPSHOTS);
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        Map<String, Integer> columnNameToPosition = IcebergUtil.columnNameToPositionInSchema(tableScan.schema());
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(fileScanTask -> SnapshotsTable.addRows((DataTask)fileScanTask, pagesBuilder, timeZoneKey, columnNameToPosition));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return pagesBuilder.build();
    }

    private static void addRows(DataTask dataTask, PageListBuilder pagesBuilder, TimeZoneKey timeZoneKey, Map<String, Integer> columnNameToPositionInSchema) {
        try (CloseableIterable dataRows = dataTask.rows();){
            dataRows.forEach(dataTaskRow -> SnapshotsTable.addRow(pagesBuilder, dataTaskRow, timeZoneKey, columnNameToPositionInSchema));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void addRow(PageListBuilder pagesBuilder, StructLike structLike, TimeZoneKey timeZoneKey, Map<String, Integer> columnNameToPositionInSchema) {
        pagesBuilder.beginRow();
        pagesBuilder.appendTimestampTzMillis((Long)structLike.get(columnNameToPositionInSchema.get(COMMITTED_AT_COLUMN_NAME).intValue(), Long.class) / 1000L, timeZoneKey);
        pagesBuilder.appendBigint((Long)structLike.get(columnNameToPositionInSchema.get(SNAPSHOT_ID_COLUMN_NAME).intValue(), Long.class));
        Long parentId = (Long)structLike.get(columnNameToPositionInSchema.get(PARENT_ID_COLUMN_NAME).intValue(), Long.class);
        pagesBuilder.appendBigint(parentId != null ? Long.valueOf(parentId) : null);
        pagesBuilder.appendVarchar((String)structLike.get(columnNameToPositionInSchema.get(OPERATION_COLUMN_NAME).intValue(), String.class));
        pagesBuilder.appendVarchar((String)structLike.get(columnNameToPositionInSchema.get(MANIFEST_LIST_COLUMN_NAME).intValue(), String.class));
        pagesBuilder.appendVarcharVarcharMap((Map)structLike.get(columnNameToPositionInSchema.get(SUMMARY_COLUMN_NAME).intValue(), Map.class));
        pagesBuilder.endRow();
    }
}

