/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.connector.SortOrder;
import java.util.Objects;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;

public class TrinoSortField {
    private final int sourceColumnId;
    private final SortOrder sortOrder;

    @JsonCreator
    public TrinoSortField(@JsonProperty(value="sourceColumnId") int sourceColumnId, @JsonProperty(value="sortOrder") SortOrder sortOrder) {
        this.sourceColumnId = sourceColumnId;
        this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
    }

    public static TrinoSortField fromIceberg(SortField sortField) {
        SortOrder sortOrder = switch (sortField.direction()) {
            default -> throw new MatchException(null, null);
            case SortDirection.ASC -> {
                switch (sortField.nullOrder()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NULLS_FIRST: {
                        yield SortOrder.ASC_NULLS_FIRST;
                    }
                    case NULLS_LAST: 
                }
                yield SortOrder.ASC_NULLS_LAST;
            }
            case SortDirection.DESC -> {
                switch (sortField.nullOrder()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NULLS_FIRST: {
                        yield SortOrder.DESC_NULLS_FIRST;
                    }
                    case NULLS_LAST: 
                }
                yield SortOrder.DESC_NULLS_LAST;
            }
        };
        return new TrinoSortField(sortField.sourceId(), sortOrder);
    }

    @JsonProperty
    public int getSourceColumnId() {
        return this.sourceColumnId;
    }

    @JsonProperty
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrinoSortField that = (TrinoSortField)o;
        return this.sourceColumnId == that.sourceColumnId && this.sortOrder == that.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(this.sourceColumnId, this.sortOrder);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceColumnId", this.sourceColumnId).add("sortOrder", (Object)this.sortOrder).toString();
    }
}

