/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.AccessDeniedException;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.airlift.log.Logger;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TrinoViewUtil;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.glue.AwsApiCallStats;
import io.trino.plugin.hive.metastore.glue.AwsSdkUtil;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TrinoMetricsReporter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.metrics.MetricsReporter;

public class TrinoGlueCatalog
extends AbstractTrinoCatalog {
    private static final Logger LOG = Logger.get(TrinoGlueCatalog.class);
    private static final int PER_QUERY_CACHES_SIZE = 1000;
    private final String trinoVersion;
    private final TypeManager typeManager;
    private final boolean cacheTableMetadata;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final Optional<String> defaultSchemaLocation;
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;
    private final boolean hideMaterializedViewStorageTable;
    private final boolean isUsingSystemSecurity;
    private final Cache<SchemaTableName, Table> glueTableCache = EvictableCacheBuilder.newBuilder().maximumSize((long)Math.max(1000, 1000)).build();
    private final Cache<SchemaTableName, TableMetadata> tableMetadataCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<SchemaTableName, ConnectorViewDefinition> viewCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<SchemaTableName, MaterializedViewData> materializedViewCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();

    public TrinoGlueCatalog(CatalogName catalogName, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, boolean cacheTableMetadata, IcebergTableOperationsProvider tableOperationsProvider, String trinoVersion, AWSGlueAsync glueClient, GlueMetastoreStats stats, boolean isUsingSystemSecurity, Optional<String> defaultSchemaLocation, boolean useUniqueTableLocation, boolean hideMaterializedViewStorageTable) {
        super(catalogName, typeManager, tableOperationsProvider, fileSystemFactory, useUniqueTableLocation);
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.cacheTableMetadata = cacheTableMetadata;
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.isUsingSystemSecurity = isUsingSystemSecurity;
        this.defaultSchemaLocation = Objects.requireNonNull(defaultSchemaLocation, "defaultSchemaLocation is null");
        this.hideMaterializedViewStorageTable = hideMaterializedViewStorageTable;
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        if (!namespace.equals(namespace.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        return (Boolean)this.stats.getGetDatabase().call(() -> {
            try {
                this.glueClient.getDatabase(new GetDatabaseRequest().withName(namespace));
                return true;
            }
            catch (EntityNotFoundException e) {
                return false;
            }
            catch (AmazonServiceException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
            }
        });
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        try {
            return (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getDatabases(arg_0), (Object)new GetDatabasesRequest(), GetDatabasesRequest::setNextToken, GetDatabasesResult::getNextToken, (AwsApiCallStats)this.stats.getGetDatabases()).map(GetDatabasesResult::getDatabaseList).flatMap(Collection::stream).map(Database::getName).collect(ImmutableList.toImmutableList());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent()) {
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        try {
            this.glueTableCache.invalidateAll();
            this.stats.getDeleteDatabase().call(() -> this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(namespace)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace, (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        try {
            GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName(namespace);
            Database database = (Database)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(getDatabaseRequest).getDatabase());
            ImmutableMap.Builder metadata = ImmutableMap.builder();
            if (database.getLocationUri() != null) {
                metadata.put((Object)"location", (Object)database.getLocationUri());
            }
            if (database.getParameters() != null) {
                metadata.putAll(database.getParameters());
            }
            return metadata.buildOrThrow();
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace, (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((owner.getType() == PrincipalType.USER ? 1 : 0) != 0, (Object)"Owner type must be USER");
        Preconditions.checkArgument((boolean)owner.getName().equals(session.getUser().toLowerCase(Locale.ENGLISH)), (Object)"Explicit schema owner is not supported");
        try {
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(new CreateDatabaseRequest().withDatabaseInput(this.createDatabaseInput(namespace, properties))));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(namespace, (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    private DatabaseInput createDatabaseInput(String namespace, Map<String, Object> properties) {
        DatabaseInput databaseInput = new DatabaseInput().withName(namespace);
        properties.forEach((property, value) -> {
            switch (property) {
                case "location": {
                    databaseInput.setLocationUri((String)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized property: " + property);
                }
            }
        });
        return databaseInput;
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg Glue catalogs");
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listRelations(session, namespace).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Map<SchemaTableName, RelationType> getRelationTypes(ConnectorSession session, Optional<String> namespace) {
        return (Map)this.listRelations(session, namespace).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        ImmutableList.Builder unfilteredResult = ImmutableList.builder();
        ImmutableList.Builder filteredResult = ImmutableList.builder();
        HashMap<SchemaTableName, Table> unprocessed = new HashMap<SchemaTableName, Table>();
        this.listNamespaces(session, namespace).stream().flatMap(glueNamespace -> this.getGlueTables((String)glueNamespace).map(table -> Map.entry(new SchemaTableName(glueNamespace, table.getName()), table))).forEach(entry -> {
            Map tableParameters;
            SchemaTableName name = (SchemaTableName)entry.getKey();
            Table table = (Table)entry.getValue();
            String tableType = GlueToTrinoConverter.getTableType((Table)table);
            if (ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)(tableParameters = GlueToTrinoConverter.getTableParameters((Table)table)))) {
                IcebergMaterializedViewDefinition definition = IcebergMaterializedViewDefinition.decodeMaterializedViewData(table.getViewOriginalText());
                unfilteredResult.add((Object)RelationColumnsMetadata.forMaterializedView((SchemaTableName)name, this.toSpiMaterializedViewColumns(definition.getColumns())));
            } else if (ViewReaderUtil.isTrinoView((String)tableType, (Map)tableParameters)) {
                ConnectorViewDefinition definition = ViewReaderUtil.PrestoViewReader.decodeViewData((String)table.getViewOriginalText());
                unfilteredResult.add((Object)RelationColumnsMetadata.forView((SchemaTableName)name, (List)definition.getColumns()));
            } else if (isRedirected.test(name)) {
                unfilteredResult.add((Object)RelationColumnsMetadata.forRedirectedTable((SchemaTableName)name));
            } else if (HiveUtil.isIcebergTable((Map)tableParameters)) {
                Optional<List<ColumnMetadata>> columnMetadata = this.getCachedColumnMetadata(table);
                if (columnMetadata.isPresent()) {
                    unfilteredResult.add((Object)RelationColumnsMetadata.forTable((SchemaTableName)name, columnMetadata.get()));
                } else {
                    unprocessed.put(name, table);
                    if (unprocessed.size() >= 1000) {
                        this.getColumnsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
                        unprocessed.clear();
                    }
                }
            }
        });
        if (!unprocessed.isEmpty()) {
            this.getColumnsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
        }
        ImmutableList unfilteredResultList = unfilteredResult.build();
        Set availableNames = (Set)relationFilter.apply((Set)unfilteredResultList.stream().map(RelationColumnsMetadata::name).collect(ImmutableSet.toImmutableSet()));
        return Optional.of(Stream.concat(unfilteredResultList.stream().filter(commentMetadata -> availableNames.contains(commentMetadata.name())), filteredResult.build().stream()).iterator());
    }

    private void getColumnsFromIcebergMetadata(ConnectorSession session, Map<SchemaTableName, Table> glueTables, UnaryOperator<Set<SchemaTableName>> relationFilter, Consumer<RelationColumnsMetadata> resultsCollector) {
        for (SchemaTableName tableName : (Set)relationFilter.apply(glueTables.keySet())) {
            List<ColumnMetadata> columns;
            Table table = glueTables.get(tableName);
            CacheUtils.uncheckedCacheGet(this.glueTableCache, (Object)tableName, () -> table);
            try {
                columns = IcebergUtil.getColumnMetadatas(this.loadTable(session, tableName).schema(), this.typeManager);
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to get metadata for table: %s", new Object[]{tableName});
                return;
            }
            resultsCollector.accept(RelationColumnsMetadata.forTable((SchemaTableName)tableName, columns));
        }
    }

    @Override
    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        if (!this.cacheTableMetadata) {
            return Optional.empty();
        }
        ImmutableList.Builder unfilteredResult = ImmutableList.builder();
        ImmutableList.Builder filteredResult = ImmutableList.builder();
        HashMap<SchemaTableName, Table> unprocessed = new HashMap<SchemaTableName, Table>();
        this.listNamespaces(session, namespace).stream().flatMap(glueNamespace -> this.getGlueTables((String)glueNamespace).map(table -> Map.entry(new SchemaTableName(glueNamespace, table.getName()), table))).forEach(entry -> {
            Map tableParameters;
            SchemaTableName name = (SchemaTableName)entry.getKey();
            Table table = (Table)entry.getValue();
            String tableType = GlueToTrinoConverter.getTableType((Table)table);
            if (ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)(tableParameters = GlueToTrinoConverter.getTableParameters((Table)table)))) {
                Optional<String> comment = IcebergMaterializedViewDefinition.decodeMaterializedViewData(table.getViewOriginalText()).getComment();
                unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, comment));
            } else if (ViewReaderUtil.isTrinoView((String)tableType, (Map)tableParameters)) {
                Optional comment = ViewReaderUtil.PrestoViewReader.decodeViewData((String)table.getViewOriginalText()).getComment();
                unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, (Optional)comment));
            } else if (isRedirected.test(name)) {
                unfilteredResult.add((Object)RelationCommentMetadata.forRedirectedTable((SchemaTableName)name));
            } else if (!HiveUtil.isIcebergTable((Map)tableParameters)) {
                unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, Optional.empty()));
            } else {
                String metadataLocation = (String)tableParameters.get("metadata_location");
                String metadataValidForMetadata = (String)tableParameters.get("trino_table_metadata_info_valid_for");
                if (metadataValidForMetadata != null && metadataValidForMetadata.equals(metadataLocation)) {
                    Optional<String> comment = Optional.ofNullable((String)tableParameters.get("comment"));
                    unfilteredResult.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)name, comment));
                } else {
                    unprocessed.put(name, table);
                    if (unprocessed.size() >= 1000) {
                        this.getCommentsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
                        unprocessed.clear();
                    }
                }
            }
        });
        if (!unprocessed.isEmpty()) {
            this.getCommentsFromIcebergMetadata(session, unprocessed, relationFilter, arg_0 -> ((ImmutableList.Builder)filteredResult).add(arg_0));
        }
        ImmutableList unfilteredResultList = unfilteredResult.build();
        Set availableNames = (Set)relationFilter.apply((Set)unfilteredResultList.stream().map(RelationCommentMetadata::name).collect(ImmutableSet.toImmutableSet()));
        return Optional.of(Stream.concat(unfilteredResultList.stream().filter(commentMetadata -> availableNames.contains(commentMetadata.name())), filteredResult.build().stream()).iterator());
    }

    private void getCommentsFromIcebergMetadata(ConnectorSession session, Map<SchemaTableName, Table> glueTables, UnaryOperator<Set<SchemaTableName>> relationFilter, Consumer<RelationCommentMetadata> resultsCollector) {
        for (SchemaTableName tableName : (Set)relationFilter.apply(glueTables.keySet())) {
            Optional<String> comment;
            Table table = glueTables.get(tableName);
            CacheUtils.uncheckedCacheGet(this.glueTableCache, (Object)tableName, () -> table);
            try {
                comment = IcebergUtil.getTableComment(this.loadTable(session, tableName));
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to get metadata for table: %s", new Object[]{tableName});
                return;
            }
            resultsCollector.accept(RelationCommentMetadata.forRelation((SchemaTableName)tableName, comment));
        }
    }

    @Override
    public org.apache.iceberg.Table loadTable(ConnectorSession session, SchemaTableName table) {
        TableMetadata metadata;
        if (this.viewCache.asMap().containsKey(table) || this.materializedViewCache.asMap().containsKey(table)) {
            throw new TableNotFoundException(table);
        }
        try {
            metadata = (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)table, () -> {
                IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, table.getSchemaName(), table.getTableName(), Optional.empty(), Optional.empty());
                return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER).operations().current();
            });
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, table, metadata);
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession session, List<SchemaTableName> tables) {
        if (!this.cacheTableMetadata) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder metadatas = ImmutableMap.builder();
        for (SchemaTableName tableName : tables) {
            Optional<List<ColumnMetadata>> columnMetadata;
            try {
                columnMetadata = this.getCachedColumnMetadata(tableName);
            }
            catch (TableNotFoundException ignore) {
                continue;
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to access get metadata of table %s during bulk retrieval of table columns", new Object[]{tableName});
                continue;
            }
            columnMetadata.ifPresent(columns -> metadatas.put((Object)tableName, columns));
        }
        return metadatas.buildOrThrow();
    }

    private Optional<List<ColumnMetadata>> getCachedColumnMetadata(SchemaTableName tableName) {
        if (!this.cacheTableMetadata || this.viewCache.asMap().containsKey(tableName) || this.materializedViewCache.asMap().containsKey(tableName)) {
            return Optional.empty();
        }
        Table glueTable = this.getTable(tableName, false);
        return this.getCachedColumnMetadata(glueTable);
    }

    private Optional<List<ColumnMetadata>> getCachedColumnMetadata(Table glueTable) {
        if (!this.cacheTableMetadata) {
            return Optional.empty();
        }
        Map tableParameters = GlueToTrinoConverter.getTableParameters((Table)glueTable);
        String metadataLocation = (String)tableParameters.get("metadata_location");
        String metadataValidForMetadata = (String)tableParameters.get("trino_table_metadata_info_valid_for");
        if (metadataLocation == null || !metadataLocation.equals(metadataValidForMetadata) || glueTable.getStorageDescriptor() == null || glueTable.getStorageDescriptor().getColumns() == null) {
            return Optional.empty();
        }
        List glueColumns = glueTable.getStorageDescriptor().getColumns();
        if (glueColumns.stream().noneMatch(column -> GlueToTrinoConverter.getColumnParameters((Column)column).containsKey("trino_type_id"))) {
            return Optional.empty();
        }
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)glueColumns.size());
        for (Column glueColumn : glueColumns) {
            Map columnParameters = GlueToTrinoConverter.getColumnParameters((Column)glueColumn);
            String trinoTypeId = columnParameters.getOrDefault("trino_type_id", glueColumn.getType());
            boolean notNull = Boolean.parseBoolean(columnParameters.getOrDefault("trino_not_null", "false"));
            Type type = this.typeManager.getType(TypeId.of((String)trinoTypeId));
            columns.add((Object)ColumnMetadata.builder().setName(glueColumn.getName()).setType(type).setComment(Optional.ofNullable(glueColumn.getComment())).setNullable(!notNull).build());
        }
        return Optional.of(columns.build());
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = (BaseTable)this.loadTable(session, schemaTableName);
        IcebergUtil.validateTableCanBeDropped((org.apache.iceberg.Table)table);
        try {
            this.deleteTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        try {
            CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)table.operations().current());
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e, "Failed to delete table data referenced by metadata");
        }
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, table.location());
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public void dropCorruptedTable(ConnectorSession session, SchemaTableName schemaTableName) {
        Table table = this.dropTableFromMetastore(session, schemaTableName);
        String metadataLocation = (String)GlueToTrinoConverter.getTableParameters((Table)table).get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table %s is missing [%s] property", schemaTableName, "metadata_location"));
        }
        String tableLocation = metadataLocation.replaceFirst("/metadata/[^/]*$", "");
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, tableLocation);
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public Transaction newCreateOrReplaceTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.newCreateOrReplaceTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName schemaTableName, TableMetadata tableMetadata) throws TrinoException {
        TableInput tableInput = GlueIcebergUtil.getTableInput(this.typeManager, schemaTableName.getTableName(), Optional.of(session.getUser()), tableMetadata, tableMetadata.metadataFileLocation(), (Map<String, String>)ImmutableMap.of(), this.cacheTableMetadata);
        this.createTable(schemaTableName.getSchemaName(), tableInput);
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName schemaTableName) {
        this.dropTableFromMetastore(session, schemaTableName);
        this.invalidateTableCache(schemaTableName);
    }

    private Table dropTableFromMetastore(ConnectorSession session, SchemaTableName schemaTableName) {
        Table table = this.getTableAndCacheMetadata(session, schemaTableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!HiveUtil.isIcebergTable((Map)GlueToTrinoConverter.getTableParameters((Table)table))) {
            throw new UnknownTableTypeException(schemaTableName);
        }
        try {
            this.deleteTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        return table;
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        boolean newTableCreated = false;
        try {
            Table table = this.getTableAndCacheMetadata(session, from).orElseThrow(() -> new TableNotFoundException(from));
            HashMap<String, String> tableParameters = new HashMap<String, String>(GlueToTrinoConverter.getTableParameters((Table)table));
            FileIO io = this.loadTable(session, from).io();
            String metadataLocation = (String)tableParameters.remove("metadata_location");
            if (metadataLocation == null) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table %s is missing [%s] property", from, "metadata_location"));
            }
            TableMetadata metadata = TableMetadataParser.read((FileIO)io, (InputFile)io.newInputFile(metadataLocation));
            TableInput tableInput = GlueIcebergUtil.getTableInput(this.typeManager, to.getTableName(), Optional.ofNullable(table.getOwner()), metadata, metadataLocation, tableParameters, this.cacheTableMetadata);
            this.createTable(to.getSchemaName(), tableInput);
            newTableCreated = true;
            this.deleteTable(from.getSchemaName(), from.getTableName());
            this.invalidateTableCache(from);
        }
        catch (RuntimeException e) {
            block6: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(to.getSchemaName(), to.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block6;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    private Optional<Table> getTableAndCacheMetadata(ConnectorSession session, SchemaTableName schemaTableName) {
        Table table;
        try {
            table = this.getTable(schemaTableName, false);
        }
        catch (TableNotFoundException e) {
            return Optional.empty();
        }
        String tableType = GlueToTrinoConverter.getTableType((Table)table);
        Map parameters = GlueToTrinoConverter.getTableParameters((Table)table);
        if (HiveUtil.isIcebergTable((Map)parameters) && !this.tableMetadataCache.asMap().containsKey(schemaTableName)) {
            if (this.viewCache.asMap().containsKey(schemaTableName) || this.materializedViewCache.asMap().containsKey(schemaTableName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. Table cannot also be a view/materialized view");
            }
            String metadataLocation = (String)parameters.get("metadata_location");
            try {
                CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)schemaTableName, () -> TableMetadataParser.read((FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session)), (String)metadataLocation));
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to cache table metadata from table at %s", new Object[]{metadataLocation});
            }
        } else if (ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)parameters)) {
            if (this.viewCache.asMap().containsKey(schemaTableName) || this.tableMetadataCache.asMap().containsKey(schemaTableName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. Materialized View cannot also be a table or view");
            }
            try {
                CacheUtils.uncheckedCacheGet(this.materializedViewCache, (Object)schemaTableName, () -> {
                    ConnectorMaterializedViewDefinition materializedView = this.createMaterializedViewDefinition(schemaTableName, table);
                    return new MaterializedViewData(materializedView, Optional.ofNullable((String)parameters.get("metadata_location")));
                });
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to cache materialized view from %s", new Object[]{schemaTableName});
            }
        } else if (ViewReaderUtil.isTrinoView((String)tableType, (Map)parameters) && !this.viewCache.asMap().containsKey(schemaTableName)) {
            if (this.materializedViewCache.asMap().containsKey(schemaTableName) || this.tableMetadataCache.asMap().containsKey(schemaTableName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. View cannot also be a materialized view or table");
            }
            try {
                TrinoViewUtil.getView(Optional.ofNullable(table.getViewOriginalText()), (String)tableType, (Map)parameters, Optional.ofNullable(table.getOwner())).ifPresent(viewDefinition -> CacheUtils.uncheckedCacheGet(this.viewCache, (Object)schemaTableName, () -> viewDefinition));
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e, "Failed to cache view from %s", new Object[]{schemaTableName});
            }
        }
        return Optional.of(table);
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName(schemaTableName.getSchemaName());
        String databaseLocation = (String)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(getDatabaseRequest).getDatabase().getLocationUri());
        String tableName = this.createNewTableName(schemaTableName.getTableName());
        if (databaseLocation == null) {
            if (this.defaultSchemaLocation.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Schema '%s' location cannot be determined. Either set the 'location' property when creating the schema, or set the 'hive.metastore.glue.default-warehouse-dir' catalog property.", schemaTableName.getSchemaName()));
            }
            String schemaDirectoryName = schemaTableName.getSchemaName() + ".db";
            databaseLocation = Locations.appendPath((String)this.defaultSchemaLocation.get(), (String)schemaDirectoryName);
        }
        return Locations.appendPath((String)databaseLocation, (String)tableName);
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(schemaViewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)definition), session.getUser(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
        Failsafe.with((Policy)RetryPolicy.builder().withMaxRetries(3).withDelay(Duration.ofMillis(100L)).abortIf(throwable -> !replace || throwable instanceof ViewAlreadyExistsException).build(), (Policy[])new RetryPolicy[0]).run(() -> this.doCreateView(session, schemaViewName, viewTableInput, replace));
    }

    private void doCreateView(ConnectorSession session, SchemaTableName schemaViewName, TableInput viewTableInput, boolean replace) {
        Optional<Table> existing = this.getTableAndCacheMetadata(session, schemaViewName);
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isTrinoView((String)GlueToTrinoConverter.getTableType((Table)existing.get()), (Map)GlueToTrinoConverter.getTableParameters((Table)existing.get()))) {
                throw new ViewAlreadyExistsException(schemaViewName);
            }
            this.updateTable(schemaViewName.getSchemaName(), viewTableInput);
            return;
        }
        try {
            this.createTable(schemaViewName.getSchemaName(), viewTableInput);
        }
        catch (AlreadyExistsException e) {
            throw new ViewAlreadyExistsException(schemaViewName);
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            Table existingView = this.getTableAndCacheMetadata(session, source).orElseThrow(() -> new TableNotFoundException(source));
            this.viewCache.invalidate((Object)source);
            TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(target.getTableName(), existingView.getViewOriginalText(), existingView.getOwner(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
            this.createTable(target.getSchemaName(), viewTableInput);
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (Exception e) {
            block5: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (Exception cleanupException) {
                        if (cleanupException.equals(e)) break block5;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        if (this.getView(session, schemaViewName).isEmpty()) {
            throw new ViewNotFoundException(schemaViewName);
        }
        try {
            this.viewCache.invalidate((Object)schemaViewName);
            this.deleteTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listRelations(session, namespace).filter(entry -> entry.getValue() == RelationType.VIEW).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition cachedView = (ConnectorViewDefinition)this.viewCache.getIfPresent((Object)viewName);
        if (cachedView != null) {
            return Optional.of(cachedView);
        }
        if (this.tableMetadataCache.asMap().containsKey(viewName) || this.materializedViewCache.asMap().containsKey(viewName)) {
            return Optional.empty();
        }
        Optional<Table> table = this.getTableAndCacheMetadata(session, viewName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        Table viewDefinition = table.get();
        return TrinoViewUtil.getView(Optional.ofNullable(viewDefinition.getViewOriginalText()), (String)GlueToTrinoConverter.getTableType((Table)viewDefinition), (Map)GlueToTrinoConverter.getTableParameters((Table)viewDefinition), Optional.ofNullable(viewDefinition.getOwner()));
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        ConnectorViewDefinition definition = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), comment, definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.updateView(session, viewName, newDefinition);
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorViewDefinition definition = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getComment(), definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.updateView(session, viewName, newDefinition);
    }

    private void updateView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition newDefinition) {
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(viewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)newDefinition), session.getUser(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
        try {
            this.updateTable(viewName.getSchemaName(), viewTableInput);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listRelations(session, namespace).filter(entry -> entry.getValue() == RelationType.MATERIALIZED_VIEW).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, boolean replace, boolean ignoreExisting) {
        Optional<Table> existing = this.getTableAndCacheMetadata(session, viewName);
        if (existing.isPresent()) {
            if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)existing.get()), (Map)GlueToTrinoConverter.getTableParameters((Table)existing.get()))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Existing table is not a Materialized View: " + String.valueOf(viewName));
            }
            if (!replace) {
                if (ignoreExisting) {
                    return;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + String.valueOf(viewName));
            }
        }
        if (this.hideMaterializedViewStorageTable) {
            Location storageMetadataLocation = this.createMaterializedViewStorage(session, viewName, definition, materializedViewProperties);
            TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)), session.getUser(), this.createMaterializedViewProperties(session, storageMetadataLocation));
            if (existing.isPresent()) {
                this.updateTable(viewName.getSchemaName(), materializedViewTableInput);
            } else {
                this.createTable(viewName.getSchemaName(), materializedViewTableInput);
            }
        } else {
            this.createMaterializedViewWithStorageTable(session, viewName, definition, materializedViewProperties, existing);
        }
    }

    private void createMaterializedViewWithStorageTable(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, Optional<Table> existing) {
        SchemaTableName storageTable = this.createMaterializedViewStorageTable(session, viewName, definition, materializedViewProperties);
        TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)), this.isUsingSystemSecurity ? null : session.getUser(), this.createMaterializedViewProperties(session, storageTable));
        if (existing.isPresent()) {
            block6: {
                try {
                    this.updateTable(viewName.getSchemaName(), materializedViewTableInput);
                }
                catch (RuntimeException e) {
                    try {
                        this.dropTable(session, storageTable);
                    }
                    catch (RuntimeException suppressed) {
                        LOG.warn((Throwable)suppressed, "Failed to drop new storage table '%s' for materialized view '%s'", new Object[]{storageTable, viewName});
                        if (e == suppressed) break block6;
                        e.addSuppressed(suppressed);
                    }
                }
            }
            this.dropStorageTable(session, existing.get());
        } else {
            this.createTable(viewName.getSchemaName(), materializedViewTableInput);
        }
    }

    @Override
    public void updateMaterializedViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorMaterializedViewDefinition definition = this.doGetMaterializedView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorMaterializedViewDefinition newDefinition = new ConnectorMaterializedViewDefinition(definition.getOriginalSql(), definition.getStorageTable(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorMaterializedViewDefinition.Column(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getGracePeriod(), definition.getComment(), definition.getOwner(), definition.getPath());
        this.updateMaterializedView(viewName, newDefinition);
    }

    private void updateMaterializedView(SchemaTableName viewName, ConnectorMaterializedViewDefinition newDefinition) {
        Table table = this.getTable(viewName, false);
        TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(newDefinition)), table.getOwner(), GlueToTrinoConverter.getTableParameters((Table)table));
        try {
            this.updateTable(viewName.getSchemaName(), materializedViewTableInput);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        Table view = this.getTableAndCacheMetadata(session, viewName).orElseThrow(() -> new MaterializedViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)view), (Map)GlueToTrinoConverter.getTableParameters((Table)view))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + view.getDatabaseName() + "." + view.getName());
        }
        this.materializedViewCache.invalidate((Object)viewName);
        this.dropStorageTable(session, view);
        this.deleteTable(view.getDatabaseName(), view.getName());
    }

    private void dropStorageTable(ConnectorSession session, Table view) {
        Map parameters = GlueToTrinoConverter.getTableParameters((Table)view);
        String storageTableName = (String)parameters.get("storage_table");
        if (storageTableName != null) {
            String storageSchema = Optional.ofNullable((String)parameters.get("storage_schema")).orElse(view.getDatabaseName());
            try {
                this.dropTable(session, new SchemaTableName(storageSchema, storageTableName));
            }
            catch (TrinoException e) {
                LOG.warn((Throwable)e, "Failed to drop storage table '%s.%s' for materialized view '%s'", new Object[]{storageSchema, storageTableName, view.getName()});
            }
        }
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        MaterializedViewData materializedViewData = (MaterializedViewData)this.materializedViewCache.getIfPresent((Object)viewName);
        if (materializedViewData != null) {
            return Optional.of(materializedViewData.connectorMaterializedViewDefinition);
        }
        if (this.tableMetadataCache.asMap().containsKey(viewName) || this.viewCache.asMap().containsKey(viewName)) {
            return Optional.empty();
        }
        Optional<Table> maybeTable = this.getTableAndCacheMetadata(session, viewName);
        if (maybeTable.isEmpty()) {
            return Optional.empty();
        }
        Table table = maybeTable.get();
        if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)table), (Map)GlueToTrinoConverter.getTableParameters((Table)table))) {
            return Optional.empty();
        }
        return Optional.of(this.createMaterializedViewDefinition(viewName, table));
    }

    private ConnectorMaterializedViewDefinition createMaterializedViewDefinition(SchemaTableName viewName, Table table) {
        String storageMetadataLocation;
        Map materializedViewParameters = GlueToTrinoConverter.getTableParameters((Table)table);
        String storageTable = (String)materializedViewParameters.get("storage_table");
        if (storageTable == null == ((storageMetadataLocation = (String)materializedViewParameters.get("metadata_location")) == null)) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Materialized view should have exactly one of the %s properties set: %s".formatted(ImmutableList.of((Object)"storage_table", (Object)"metadata_location"), materializedViewParameters));
        }
        if (storageTable != null) {
            String storageSchema = Optional.ofNullable((String)materializedViewParameters.get("storage_schema")).orElse(viewName.getSchemaName());
            SchemaTableName storageTableName = new SchemaTableName(storageSchema, storageTable);
            String viewOriginalText = table.getViewOriginalText();
            if (viewOriginalText == null) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Materialized view did not have original text " + String.valueOf(viewName));
            }
            return this.getMaterializedViewDefinition(Optional.ofNullable(table.getOwner()), viewOriginalText, storageTableName);
        }
        SchemaTableName storageTableName = new SchemaTableName(viewName.getSchemaName(), IcebergTableName.tableNameWithType(viewName.getTableName(), TableType.MATERIALIZED_VIEW_STORAGE));
        return this.getMaterializedViewDefinition(Optional.ofNullable(table.getOwner()), table.getViewOriginalText(), storageTableName);
    }

    @Override
    public Optional<BaseTable> getMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName) {
        String storageMetadataLocation;
        MaterializedViewData materializedViewData = (MaterializedViewData)this.materializedViewCache.getIfPresent((Object)viewName);
        if (materializedViewData == null) {
            Optional<Table> maybeTable = this.getTableAndCacheMetadata(session, viewName);
            if (maybeTable.isEmpty()) {
                return Optional.empty();
            }
            Table materializedView = maybeTable.get();
            Verify.verify((boolean)ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)materializedView), (Map)GlueToTrinoConverter.getTableParameters((Table)materializedView)), (String)"getMaterializedViewStorageTable received a table, not a materialized view", (Object[])new Object[0]);
            storageMetadataLocation = (String)GlueToTrinoConverter.getTableParameters((Table)materializedView).get("metadata_location");
            Preconditions.checkState((storageMetadataLocation != null ? 1 : 0) != 0, (Object)("Storage location missing in definition of materialized view " + materializedView.getName()));
        } else {
            storageMetadataLocation = materializedViewData.storageMetadataLocation.orElseThrow(() -> new IllegalStateException("Storage location not defined for materialized view " + String.valueOf(viewName)));
        }
        SchemaTableName storageTableName = new SchemaTableName(viewName.getSchemaName(), IcebergTableName.tableNameWithType(viewName.getTableName(), TableType.MATERIALIZED_VIEW_STORAGE));
        IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, storageTableName.getSchemaName(), storageTableName.getTableName(), Optional.empty(), Optional.empty());
        try {
            TableMetadata metadata = this.getMaterializedViewTableMetadata(session, storageTableName, storageMetadataLocation);
            operations.initializeFromMetadata(metadata);
            return Optional.of(new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(storageTableName), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    private TableMetadata getMaterializedViewTableMetadata(ConnectorSession session, SchemaTableName storageTableName, String storageMetadataLocation) {
        Objects.requireNonNull(storageTableName, "storageTableName is null");
        Objects.requireNonNull(storageMetadataLocation, "storageMetadataLocation is null");
        return (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)storageTableName, () -> {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            return TableMetadataParser.read((FileIO)new ForwardingFileIo(fileSystem), (String)storageMetadataLocation);
        });
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            Table glueTable = this.getTableAndCacheMetadata(session, source).orElseThrow(() -> new TableNotFoundException(source));
            this.materializedViewCache.invalidate((Object)source);
            Map tableParameters = GlueToTrinoConverter.getTableParameters((Table)glueTable);
            if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)glueTable), (Map)tableParameters)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + String.valueOf(source));
            }
            TableInput tableInput = GlueIcebergUtil.getMaterializedViewTableInput(target.getTableName(), glueTable.getViewOriginalText(), glueTable.getOwner(), tableParameters);
            this.createTable(target.getSchemaName(), tableInput);
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (RuntimeException e) {
            block6: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block6;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName, String hiveCatalogName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(hiveCatalogName, "hiveCatalogName is null");
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional<Table> table = this.getTableAndCacheMetadata(session, new SchemaTableName(tableNameBase.getSchemaName(), tableNameBase.getTableName()));
        if (table.isEmpty() || io.trino.plugin.hive.TableType.VIRTUAL_VIEW.name().equals(GlueToTrinoConverter.getTableTypeNullable((Table)table.get()))) {
            return Optional.empty();
        }
        if (!HiveUtil.isIcebergTable((Map)GlueToTrinoConverter.getTableParameters((Table)table.get()))) {
            return Optional.of(new CatalogSchemaTableName(hiveCatalogName, tableName));
        }
        return Optional.empty();
    }

    @Override
    protected void invalidateTableCache(SchemaTableName schemaTableName) {
        this.tableMetadataCache.invalidate((Object)schemaTableName);
    }

    Table getTable(SchemaTableName tableName, boolean invalidateCaches) {
        if (invalidateCaches) {
            this.glueTableCache.invalidate((Object)tableName);
        }
        try {
            return (Table)CacheUtils.uncheckedCacheGet(this.glueTableCache, (Object)tableName, () -> {
                try {
                    GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(tableName.getSchemaName()).withName(tableName.getTableName());
                    return (Table)this.stats.getGetTable().call(() -> this.glueClient.getTable(getTableRequest).getTable());
                }
                catch (EntityNotFoundException e) {
                    throw new TableNotFoundException(tableName, (Throwable)e);
                }
            });
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Get table request failed: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)((Object)e))), e.getCause());
        }
    }

    private Stream<Map.Entry<SchemaTableName, RelationType>> listRelations(ConnectorSession session, Optional<String> namespace) {
        List<String> namespaces = this.listNamespaces(session, namespace);
        return namespaces.stream().flatMap(glueNamespace -> this.getGlueTablesWithExceptionHandling((String)glueNamespace).map(table -> {
            Map tableParameters;
            String tableType = GlueToTrinoConverter.getTableType((Table)table);
            RelationType relationType = ViewReaderUtil.isTrinoView((String)tableType, (Map)(tableParameters = GlueToTrinoConverter.getTableParameters((Table)table))) ? RelationType.VIEW : (ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)tableParameters) ? RelationType.MATERIALIZED_VIEW : RelationType.TABLE);
            return Map.entry(new SchemaTableName(glueNamespace, table.getName()), relationType);
        }));
    }

    private Stream<Table> getGlueTablesWithExceptionHandling(final String glueNamespace) {
        return Streams.stream((Iterator)new AbstractIterator<Table>(){
            private Iterator<Table> delegate;

            protected Table computeNext() {
                boolean firstCall = this.delegate == null;
                try {
                    if (this.delegate == null) {
                        this.delegate = TrinoGlueCatalog.this.getGlueTables(glueNamespace).iterator();
                    }
                    if (!this.delegate.hasNext()) {
                        return (Table)this.endOfData();
                    }
                    return this.delegate.next();
                }
                catch (EntityNotFoundException e) {
                    return (Table)this.endOfData();
                }
                catch (AccessDeniedException e) {
                    if (!firstCall) {
                        LOG.warn((Throwable)e, "Permission denied when getting next batch of tables from namespace %s", new Object[]{glueNamespace});
                    }
                    return (Table)this.endOfData();
                }
                catch (AmazonServiceException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
                }
            }
        });
    }

    private Stream<Table> getGlueTables(String glueNamespace) {
        return AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), (Object)new GetTablesRequest().withDatabaseName(glueNamespace), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, (AwsApiCallStats)this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream);
    }

    private void createTable(String schemaName, TableInput tableInput) {
        this.glueTableCache.invalidateAll();
        this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withDatabaseName(schemaName).withTableInput(tableInput)));
    }

    private void updateTable(String schemaName, TableInput tableInput) {
        this.glueTableCache.invalidateAll();
        this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(schemaName).withTableInput(tableInput)));
    }

    private void deleteTable(String schema, String table) {
        this.glueTableCache.invalidateAll();
        this.stats.getDeleteTable().call(() -> this.glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(schema).withName(table)));
    }

    private record MaterializedViewData(ConnectorMaterializedViewDefinition connectorMaterializedViewDefinition, Optional<String> storageMetadataLocation) {
        private MaterializedViewData {
            Objects.requireNonNull(connectorMaterializedViewDefinition, "connectorMaterializedViewDefinition is null");
            Objects.requireNonNull(storageMetadataLocation, "storageMetadataLocation is null");
        }
    }
}

