/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergSecurityConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;

public class TrinoHiveCatalogFactory
implements TrinoCatalogFactory {
    private final CatalogName catalogName;
    private final HiveMetastoreFactory metastoreFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final String trinoVersion;
    private final boolean isUniqueTableLocation;
    private final boolean isUsingSystemSecurity;
    private final boolean deleteSchemaLocationsFallback;
    private final boolean hideMaterializedViewStorageTable;

    @Inject
    public TrinoHiveCatalogFactory(IcebergConfig config, CatalogName catalogName, HiveMetastoreFactory metastoreFactory, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, NodeVersion nodeVersion, IcebergSecurityConfig securityConfig) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationProvider is null");
        this.trinoVersion = nodeVersion.toString();
        this.isUniqueTableLocation = config.isUniqueTableLocation();
        this.isUsingSystemSecurity = securityConfig.getSecuritySystem() == IcebergSecurityConfig.IcebergSecurity.SYSTEM;
        this.deleteSchemaLocationsFallback = config.isDeleteSchemaLocationsFallback();
        this.hideMaterializedViewStorageTable = config.isHideMaterializedViewStorageTable();
    }

    @Override
    public TrinoCatalog create(ConnectorIdentity identity) {
        CachingHiveMetastore metastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)this.metastoreFactory.createMetastore(Optional.of(identity)), (long)1000L);
        return new TrinoHiveCatalog(this.catalogName, metastore, new TrinoViewHiveMetastore((HiveMetastore)metastore, this.isUsingSystemSecurity, this.trinoVersion, "Trino Iceberg connector"), this.fileSystemFactory, this.typeManager, this.tableOperationsProvider, this.isUniqueTableLocation, this.isUsingSystemSecurity, this.deleteSchemaLocationsFallback, this.hideMaterializedViewStorageTable);
    }
}

