/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcClient;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.io.FileIO;

public class IcebergJdbcTableOperations
extends AbstractIcebergTableOperations {
    private final IcebergJdbcClient jdbcClient;

    public IcebergJdbcTableOperations(FileIO fileIo, IcebergJdbcClient jdbcClient, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
    }

    @Override
    protected String getRefreshedLocation(boolean invalidateCaches) {
        return this.jdbcClient.getMetadataLocation(this.database, this.tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()));
    }

    @Override
    protected void commitNewTable(TableMetadata metadata) {
        Verify.verify((boolean)this.version.isEmpty(), (String)"commitNewTable called on a table which already exists", (Object[])new Object[0]);
        String newMetadataLocation = this.writeNewMetadata(metadata, 0);
        this.jdbcClient.createTable(this.database, this.tableName, newMetadataLocation);
        this.shouldRefresh = true;
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version.orElseThrow() + 1);
        this.jdbcClient.alterTable(this.database, this.tableName, newMetadataLocation, this.currentMetadataLocation);
        this.shouldRefresh = true;
    }

    @Override
    protected void commitMaterializedViewRefresh(TableMetadata base, TableMetadata metadata) {
        throw new UnsupportedOperationException();
    }
}

