/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class IcebergNessieCatalogConfig {
    private String defaultReferenceName = "main";
    private String defaultWarehouseDir;
    private URI serverUri;
    private Duration readTimeout = new Duration(25000.0, TimeUnit.MILLISECONDS);
    private Duration connectionTimeout = new Duration(5000.0, TimeUnit.MILLISECONDS);
    private boolean enableCompression = true;
    private Security security;
    private Optional<String> bearerToken = Optional.empty();

    @NotNull
    public String getDefaultReferenceName() {
        return this.defaultReferenceName;
    }

    @Config(value="iceberg.nessie-catalog.ref")
    @ConfigDescription(value="The default Nessie reference to work on")
    public IcebergNessieCatalogConfig setDefaultReferenceName(String defaultReferenceName) {
        this.defaultReferenceName = defaultReferenceName;
        return this;
    }

    @NotNull
    public URI getServerUri() {
        return this.serverUri;
    }

    @Config(value="iceberg.nessie-catalog.uri")
    @ConfigDescription(value="The URI to connect to the Nessie server")
    public IcebergNessieCatalogConfig setServerUri(URI serverUri) {
        this.serverUri = serverUri;
        return this;
    }

    @NotEmpty
    public String getDefaultWarehouseDir() {
        return this.defaultWarehouseDir;
    }

    @Config(value="iceberg.nessie-catalog.default-warehouse-dir")
    @ConfigDescription(value="The default warehouse to use for Nessie")
    public IcebergNessieCatalogConfig setDefaultWarehouseDir(String defaultWarehouseDir) {
        this.defaultWarehouseDir = defaultWarehouseDir;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="iceberg.nessie-catalog.read-timeout")
    @ConfigDescription(value="The read timeout for the client.")
    public IcebergNessieCatalogConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="iceberg.nessie-catalog.connection-timeout")
    @ConfigDescription(value="The connection timeout for the client.")
    public IcebergNessieCatalogConfig setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public boolean isCompressionEnabled() {
        return this.enableCompression;
    }

    @Config(value="iceberg.nessie-catalog.enable-compression")
    @ConfigDescription(value="Configure whether compression should be enabled or not.")
    public IcebergNessieCatalogConfig setCompressionEnabled(boolean enableCompression) {
        this.enableCompression = enableCompression;
        return this;
    }

    public Optional<Security> getSecurity() {
        return Optional.ofNullable(this.security);
    }

    @Config(value="iceberg.nessie-catalog.authentication.type")
    @ConfigDescription(value="The authentication type to use")
    public IcebergNessieCatalogConfig setSecurity(Security security) {
        this.security = security;
        return this;
    }

    public Optional<String> getBearerToken() {
        return this.bearerToken;
    }

    @Config(value="iceberg.nessie-catalog.authentication.token")
    @ConfigDescription(value="The token to use with BEARER authentication")
    @ConfigSecuritySensitive
    public IcebergNessieCatalogConfig setBearerToken(String token) {
        this.bearerToken = Optional.ofNullable(token);
        return this;
    }

    @AssertTrue(message="'iceberg.nessie-catalog.authentication.token' must be configured only with 'iceberg.nessie-catalog.authentication.type' BEARER")
    public @AssertTrue(message="'iceberg.nessie-catalog.authentication.token' must be configured only with 'iceberg.nessie-catalog.authentication.type' BEARER") boolean isTokenConfiguredWithoutType() {
        return this.getSecurity().filter(Predicate.isEqual((Object)Security.BEARER)).isPresent() || this.getBearerToken().isEmpty();
    }

    @AssertTrue(message="'iceberg.nessie-catalog.authentication.token' must be configured with 'iceberg.nessie-catalog.authentication.type' BEARER")
    public @AssertTrue(message="'iceberg.nessie-catalog.authentication.token' must be configured with 'iceberg.nessie-catalog.authentication.type' BEARER") boolean isMissingTokenForBearerAuth() {
        return this.getSecurity().filter(Predicate.isEqual((Object)Security.BEARER)).isEmpty() || this.getBearerToken().isPresent();
    }

    public static enum Security {
        BEARER;

    }
}

