/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.common.base.Verify;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.apache.iceberg.nessie.NessieUtil;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Reference;

public class IcebergNessieTableOperations
extends AbstractIcebergTableOperations {
    private final NessieIcebergClient nessieClient;
    private IcebergTable table;

    protected IcebergNessieTableOperations(NessieIcebergClient nessieClient, FileIO fileIo, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        this.nessieClient = Objects.requireNonNull(nessieClient, "nessieClient is null");
    }

    @Override
    public TableMetadata refresh() {
        this.refreshNessieClient();
        return super.refresh();
    }

    private void refreshNessieClient() {
        try {
            this.nessieClient.refresh();
        }
        catch (NessieNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Failed to refresh as ref '%s' is no longer valid.", this.nessieClient.refName()), (Throwable)e);
        }
    }

    @Override
    public TableMetadata refresh(boolean invalidateCaches) {
        this.refreshNessieClient();
        return super.refresh(invalidateCaches);
    }

    @Override
    protected void refreshFromMetadataLocation(String newLocation) {
        super.refreshFromMetadataLocation(newLocation, location -> NessieUtil.updateTableMetadataWithNessieSpecificProperties((TableMetadata)TableMetadataParser.read((FileIO)this.fileIo, (String)location), (String)location, (IcebergTable)this.table, (String)this.getSchemaTableName().toString(), (Reference)this.nessieClient.getReference()));
    }

    @Override
    protected String getRefreshedLocation(boolean invalidateCaches) {
        this.table = this.nessieClient.table(IcebergNessieUtil.toIdentifier(new SchemaTableName(this.database, this.tableName)));
        if (this.table == null) {
            throw new TableNotFoundException(this.getSchemaTableName());
        }
        return this.table.getMetadataLocation();
    }

    @Override
    protected void commitNewTable(TableMetadata metadata) {
        Verify.verify((boolean)this.version.isEmpty(), (String)"commitNewTable called on a table which already exists", (Object[])new Object[0]);
        try {
            this.nessieClient.commitTable(null, metadata, this.writeNewMetadata(metadata, 0), this.table, IcebergNessieTableOperations.toKey(new SchemaTableName(this.database, this.tableName)));
        }
        catch (NessieNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, String.format("Cannot commit: ref '%s' no longer exists", this.nessieClient.refName()), (Throwable)e);
        }
        catch (NessieConflictException e) {
            throw new CommitFailedException((Throwable)e, "Cannot commit: ref hash is out of date. Update the ref '%s' and try again", new Object[]{this.nessieClient.refName()});
        }
        this.shouldRefresh = true;
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        Verify.verify((this.version.orElseThrow() >= 0 ? 1 : 0) != 0, (String)"commitToExistingTable called on a new table", (Object[])new Object[0]);
        try {
            this.nessieClient.commitTable(base, metadata, this.writeNewMetadata(metadata, this.version.getAsInt() + 1), this.table, IcebergNessieTableOperations.toKey(new SchemaTableName(this.database, this.tableName)));
        }
        catch (NessieNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, String.format("Cannot commit: ref '%s' no longer exists", this.nessieClient.refName()), (Throwable)e);
        }
        catch (NessieConflictException e) {
            throw new CommitFailedException((Throwable)e, "Cannot commit: ref hash is out of date. Update the ref '%s' and try again", new Object[]{this.nessieClient.refName()});
        }
        this.shouldRefresh = true;
    }

    @Override
    protected void commitMaterializedViewRefresh(TableMetadata base, TableMetadata metadata) {
        throw new UnsupportedOperationException();
    }

    private static ContentKey toKey(SchemaTableName tableName) {
        return ContentKey.of((Namespace)Namespace.parse((String)tableName.getSchemaName()), (String)tableName.getTableName());
    }
}

