/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.AssertTrue;
import java.util.Optional;

public class OAuth2SecurityConfig {
    private String credential;
    private String token;

    public Optional<String> getCredential() {
        return Optional.ofNullable(this.credential);
    }

    @Config(value="iceberg.rest-catalog.oauth2.credential")
    @ConfigDescription(value="The credential to exchange for a token in the OAuth2 client credentials flow with the server")
    @ConfigSecuritySensitive
    public OAuth2SecurityConfig setCredential(String credential) {
        this.credential = credential;
        return this;
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Config(value="iceberg.rest-catalog.oauth2.token")
    @ConfigDescription(value="The Bearer token which will be used for interactions with the server")
    @ConfigSecuritySensitive
    public OAuth2SecurityConfig setToken(String token) {
        this.token = token;
        return this;
    }

    @AssertTrue(message="OAuth2 requires a credential or token")
    public @AssertTrue(message="OAuth2 requires a credential or token") boolean credentialOrTokenPresent() {
        return this.credential != null || this.token != null;
    }
}

