/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions.tablechanges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;

public class TableChangesFunction
extends AbstractConnectorTableFunction {
    private static final String FUNCTION_NAME = "table_changes";
    private static final String SCHEMA_VAR_NAME = "SCHEMA";
    private static final String TABLE_VAR_NAME = "TABLE";
    private static final String START_SNAPSHOT_VAR_NAME = "START_SNAPSHOT_ID";
    private static final String END_SNAPSHOT_VAR_NAME = "END_SNAPSHOT_ID";
    private final TrinoCatalogFactory trinoCatalogFactory;
    private final TypeManager typeManager;

    @Inject
    public TableChangesFunction(TrinoCatalogFactory trinoCatalogFactory, TypeManager typeManager) {
        super("system", FUNCTION_NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name(SCHEMA_VAR_NAME).type((Type)VarcharType.createUnboundedVarcharType()).build(), (Object)ScalarArgumentSpecification.builder().name(TABLE_VAR_NAME).type((Type)VarcharType.createUnboundedVarcharType()).build(), (Object)ScalarArgumentSpecification.builder().name(START_SNAPSHOT_VAR_NAME).type((Type)BigintType.BIGINT).build(), (Object)ScalarArgumentSpecification.builder().name(END_SNAPSHOT_VAR_NAME).type((Type)BigintType.BIGINT).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        this.trinoCatalogFactory = Objects.requireNonNull(trinoCatalogFactory, "trinoCatalogFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
        String schema = ((Slice)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(SCHEMA_VAR_NAME)).getValue())).toStringUtf8();
        String table = ((Slice)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(TABLE_VAR_NAME)).getValue())).toStringUtf8();
        long startSnapshotId = (Long)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(START_SNAPSHOT_VAR_NAME)).getValue());
        long endSnapshotId = (Long)TableChangesFunction.checkNonNull(((ScalarArgument)arguments.get(END_SNAPSHOT_VAR_NAME)).getValue());
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        Table icebergTable = this.trinoCatalogFactory.create(session.getIdentity()).loadTable(session, schemaTableName);
        TableChangesFunction.checkSnapshotExists(icebergTable, startSnapshotId);
        TableChangesFunction.checkSnapshotExists(icebergTable, endSnapshotId);
        ImmutableList.Builder columns = ImmutableList.builder();
        Schema tableSchema = (Schema)icebergTable.schemas().get(icebergTable.snapshot(endSnapshotId).schemaId());
        tableSchema.columns().stream().map(column -> new Descriptor.Field(column.name(), Optional.of(TypeConverter.toTrinoType(column.type(), this.typeManager)))).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
        columns.add((Object)new Descriptor.Field("_change_type", Optional.of(VarcharType.createUnboundedVarcharType())));
        columns.add((Object)new Descriptor.Field("_change_version_id", Optional.of(BigintType.BIGINT)));
        columns.add((Object)new Descriptor.Field("_change_timestamp", Optional.of(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)));
        columns.add((Object)new Descriptor.Field("_change_ordinal", Optional.of(IntegerType.INTEGER)));
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        IcebergUtil.getColumns(tableSchema, this.typeManager).forEach(arg_0 -> ((ImmutableList.Builder)columnHandlesBuilder).add(arg_0));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483643, "_change_type", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)VarcharType.createUnboundedVarcharType(), (List<Integer>)ImmutableList.of(), (Type)VarcharType.createUnboundedVarcharType(), Optional.empty()));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483642, "_change_version_id", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)BigintType.BIGINT, (List<Integer>)ImmutableList.of(), (Type)BigintType.BIGINT, Optional.empty()));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483641, "_change_timestamp", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (List<Integer>)ImmutableList.of(), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, Optional.empty()));
        columnHandlesBuilder.add((Object)new IcebergColumnHandle(new ColumnIdentity(-2147483640, "_change_ordinal", ColumnIdentity.TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of()), (Type)IntegerType.INTEGER, (List<Integer>)ImmutableList.of(), (Type)IntegerType.INTEGER, Optional.empty()));
        ImmutableList columnHandles = columnHandlesBuilder.build();
        accessControl.checkCanSelectFromColumns(null, schemaTableName, (Set)columnHandles.stream().map(IcebergColumnHandle::getName).collect(ImmutableSet.toImmutableSet()));
        return TableFunctionAnalysis.builder().returnedType(new Descriptor((List)columns.build())).handle((ConnectorTableFunctionHandle)new TableChangesFunctionHandle(schemaTableName, SchemaParser.toJson((Schema)tableSchema), (List<IcebergColumnHandle>)columnHandles, Optional.ofNullable((String)icebergTable.properties().get("schema.name-mapping.default")), startSnapshotId, endSnapshotId)).build();
    }

    private static Object checkNonNull(Object argumentValue) {
        if (argumentValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "table_changes arguments may not be null");
        }
        return argumentValue;
    }

    private static void checkSnapshotExists(Table icebergTable, long snapshotId) {
        if (icebergTable.snapshot(snapshotId) == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Snapshot not found in Iceberg table history: " + snapshotId);
        }
    }
}

