/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.type.TypeInfoUtils;
import java.util.stream.Collectors;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class HiveSchemaUtil {
    private HiveSchemaUtil() {
    }

    public static TypeInfo convert(Type type) {
        return TypeInfoUtils.getTypeInfoFromTypeString((String)HiveSchemaUtil.convertToTypeString(type));
    }

    private static String convertToTypeString(Type type) {
        return switch (type.typeId()) {
            default -> throw new MatchException(null, null);
            case Type.TypeID.BOOLEAN -> "boolean";
            case Type.TypeID.INTEGER -> "int";
            case Type.TypeID.LONG -> "bigint";
            case Type.TypeID.FLOAT -> "float";
            case Type.TypeID.DOUBLE -> "double";
            case Type.TypeID.DATE -> "date";
            case Type.TypeID.TIME, Type.TypeID.STRING, Type.TypeID.UUID -> "string";
            case Type.TypeID.TIMESTAMP -> "timestamp";
            case Type.TypeID.FIXED, Type.TypeID.BINARY -> "binary";
            case Type.TypeID.DECIMAL -> "decimal(%s,%s)".formatted(((Types.DecimalType)type).precision(), ((Types.DecimalType)type).scale());
            case Type.TypeID.LIST -> "array<%s>".formatted(HiveSchemaUtil.convert(type.asListType().elementType()));
            case Type.TypeID.MAP -> "map<%s,%s>".formatted(HiveSchemaUtil.convert(type.asMapType().keyType()), HiveSchemaUtil.convert(type.asMapType().valueType()));
            case Type.TypeID.STRUCT -> "struct<%s>".formatted(type.asStructType().fields().stream().map(field -> "%s:%s".formatted(field.name(), HiveSchemaUtil.convert(field.type()))).collect(Collectors.joining(",")));
        };
    }
}

