/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Traverser;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcReader;
import io.trino.orc.metadata.OrcType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;

public final class OrcIcebergIds {
    private OrcIcebergIds() {
    }

    public static Map<Integer, OrcColumn> fileColumnsByIcebergId(OrcReader reader, Optional<NameMapping> nameMapping) {
        List fileColumns = reader.getRootColumn().getNestedColumns();
        if (nameMapping.isPresent() && !OrcIcebergIds.hasIds(reader.getRootColumn())) {
            fileColumns = (List)fileColumns.stream().map(orcColumn -> OrcIcebergIds.setMissingFieldIds(orcColumn, (NameMapping)nameMapping.get(), (List<String>)ImmutableList.of((Object)orcColumn.getColumnName()))).collect(ImmutableList.toImmutableList());
        }
        return OrcIcebergIds.mapIdsToOrcFileColumns(fileColumns);
    }

    private static boolean hasIds(OrcColumn column) {
        if (column.getAttributes().containsKey("iceberg.id")) {
            return true;
        }
        return column.getNestedColumns().stream().anyMatch(OrcIcebergIds::hasIds);
    }

    private static OrcColumn setMissingFieldIds(OrcColumn column, NameMapping nameMapping, List<String> qualifiedPath) {
        MappedField mappedField = nameMapping.find(qualifiedPath);
        ImmutableMap.Builder attributes = ImmutableMap.builder();
        attributes.putAll(column.getAttributes());
        if (mappedField != null && mappedField.id() != null) {
            attributes.put((Object)"iceberg.id", (Object)String.valueOf(mappedField.id()));
        }
        List orcColumns = (List)column.getNestedColumns().stream().map(nestedColumn -> OrcIcebergIds.setMissingFieldIds(nestedColumn, nameMapping, (List<String>)ImmutableList.builder().addAll((Iterable)qualifiedPath).add((Object)OrcIcebergIds.pathName(column, nestedColumn)).build())).collect(ImmutableList.toImmutableList());
        return new OrcColumn(column.getPath(), column.getColumnId(), column.getColumnName(), column.getColumnType(), column.getOrcDataSourceId(), orcColumns, (Map)attributes.buildOrThrow());
    }

    private static String pathName(OrcColumn column, OrcColumn nestedColumn) {
        if (column.getColumnType() == OrcType.OrcTypeKind.LIST) {
            return "element";
        }
        return nestedColumn.getColumnName();
    }

    private static Map<Integer, OrcColumn> mapIdsToOrcFileColumns(List<OrcColumn> columns) {
        ImmutableMap.Builder columnsById = ImmutableMap.builder();
        Traverser.forTree(OrcColumn::getNestedColumns).depthFirstPreOrder(columns).forEach(column -> {
            String fieldId = (String)column.getAttributes().get("iceberg.id");
            if (fieldId != null) {
                columnsById.put((Object)Integer.parseInt(fieldId), column);
            }
        });
        return columnsById.buildOrThrow();
    }
}

