/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpRequest;

class AwsSdkHttpAttributesGetter
implements HttpClientAttributesGetter<ExecutionAttributes, Response> {
    AwsSdkHttpAttributesGetter() {
    }

    public String getUrlFull(ExecutionAttributes request) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        return httpRequest.getUri().toString();
    }

    public String getHttpRequestMethod(ExecutionAttributes request) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        return httpRequest.method().name();
    }

    public List<String> getHttpRequestHeader(ExecutionAttributes request, String name) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        List value = (List)httpRequest.headers().get(name);
        return value == null ? Collections.emptyList() : value;
    }

    public Integer getHttpResponseStatusCode(ExecutionAttributes request, Response response, @Nullable Throwable error) {
        return response.getSdkHttpResponse().statusCode();
    }

    public List<String> getHttpResponseHeader(ExecutionAttributes request, Response response, String name) {
        List value = (List)response.getSdkHttpResponse().headers().get(name);
        return value == null ? Collections.emptyList() : value;
    }

    @Nullable
    public String getServerAddress(ExecutionAttributes request) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        return httpRequest.host();
    }

    public Integer getServerPort(ExecutionAttributes request) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        return httpRequest.port();
    }
}

