/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetryBuilder;
import io.opentelemetry.instrumentation.awssdk.v2_2.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsImpl;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsClient;

public class AwsSdkTelemetry {
    private final Instrumenter<ExecutionAttributes, Response> requestInstrumenter;
    private final Instrumenter<SqsReceiveRequest, Response> consumerReceiveInstrumenter;
    private final Instrumenter<SqsProcessRequest, Void> consumerProcessInstrumenter;
    private final Instrumenter<ExecutionAttributes, Response> producerInstrumenter;
    private final boolean captureExperimentalSpanAttributes;
    @Nullable
    private final TextMapPropagator messagingPropagator;
    private final boolean useXrayPropagator;
    private final boolean recordIndividualHttpError;

    public static AwsSdkTelemetry create(OpenTelemetry openTelemetry) {
        return AwsSdkTelemetry.builder(openTelemetry).build();
    }

    public static AwsSdkTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new AwsSdkTelemetryBuilder(openTelemetry);
    }

    AwsSdkTelemetry(OpenTelemetry openTelemetry, List<String> capturedHeaders, boolean captureExperimentalSpanAttributes, boolean useMessagingPropagator, boolean useXrayPropagator, boolean recordIndividualHttpError, boolean messagingReceiveInstrumentationEnabled) {
        this.useXrayPropagator = useXrayPropagator;
        this.messagingPropagator = useMessagingPropagator ? openTelemetry.getPropagators().getTextMapPropagator() : null;
        AwsSdkInstrumenterFactory instrumenterFactory = new AwsSdkInstrumenterFactory(openTelemetry, this.messagingPropagator, capturedHeaders, captureExperimentalSpanAttributes, messagingReceiveInstrumentationEnabled, useXrayPropagator);
        this.requestInstrumenter = instrumenterFactory.requestInstrumenter();
        this.consumerReceiveInstrumenter = instrumenterFactory.consumerReceiveInstrumenter();
        this.consumerProcessInstrumenter = instrumenterFactory.consumerProcessInstrumenter();
        this.producerInstrumenter = instrumenterFactory.producerInstrumenter();
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.recordIndividualHttpError = recordIndividualHttpError;
    }

    public ExecutionInterceptor newExecutionInterceptor() {
        return new TracingExecutionInterceptor(this.requestInstrumenter, this.consumerReceiveInstrumenter, this.consumerProcessInstrumenter, this.producerInstrumenter, this.captureExperimentalSpanAttributes, this.messagingPropagator, this.useXrayPropagator, this.recordIndividualHttpError);
    }

    @NoMuzzle
    public SqsClient wrap(SqsClient sqsClient) {
        return SqsImpl.wrap(sqsClient);
    }

    @NoMuzzle
    public SqsAsyncClient wrap(SqsAsyncClient sqsClient) {
        return SqsImpl.wrap(sqsClient);
    }
}

