/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;

enum SqsProcessRequestAttributesGetter implements MessagingAttributesGetter<SqsProcessRequest, Void>
{
    INSTANCE;


    public String getSystem(SqsProcessRequest request) {
        return "AmazonSQS";
    }

    public String getDestination(SqsProcessRequest request) {
        int i;
        SdkRequest sdkRequest = (SdkRequest)request.getRequest().getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        String queueUrl = SqsAccess.getQueueUrl(sdkRequest);
        if (queueUrl != null && (i = queueUrl.lastIndexOf(47)) > 0) {
            return queueUrl.substring(i + 1);
        }
        return null;
    }

    public boolean isTemporaryDestination(SqsProcessRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadSize(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadCompressedSize(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(SqsProcessRequest request, @Nullable Void response) {
        return request.getMessage().getMessageId();
    }

    public List<String> getMessageHeader(SqsProcessRequest request, String name) {
        String value = request.getMessage().getMessageAttribute(name);
        return value != null ? Collections.singletonList(value) : Collections.emptyList();
    }
}

