/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.metastore.Column;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HiveColumnHandle
implements ColumnHandle {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(HiveColumnHandle.class);
    public static final int PATH_COLUMN_INDEX = -11;
    public static final String PATH_COLUMN_NAME = "$path";
    public static final HiveType PATH_HIVE_TYPE = HiveType.HIVE_STRING;
    public static final Type PATH_TYPE = VarcharType.VARCHAR;
    public static final int BUCKET_COLUMN_INDEX = -12;
    public static final String BUCKET_COLUMN_NAME = "$bucket";
    public static final HiveType BUCKET_HIVE_TYPE = HiveType.HIVE_INT;
    public static final Type BUCKET_TYPE_SIGNATURE = IntegerType.INTEGER;
    public static final int FILE_SIZE_COLUMN_INDEX = -13;
    public static final String FILE_SIZE_COLUMN_NAME = "$file_size";
    public static final HiveType FILE_SIZE_TYPE = HiveType.HIVE_LONG;
    public static final Type FILE_SIZE_TYPE_SIGNATURE = BigintType.BIGINT;
    public static final int FILE_MODIFIED_TIME_COLUMN_INDEX = -14;
    public static final String FILE_MODIFIED_TIME_COLUMN_NAME = "$file_modified_time";
    public static final HiveType FILE_MODIFIED_TIME_TYPE = HiveType.HIVE_TIMESTAMP;
    public static final Type FILE_MODIFIED_TIME_TYPE_SIGNATURE = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;
    public static final int PARTITION_COLUMN_INDEX = -15;
    public static final String PARTITION_COLUMN_NAME = "$partition";
    public static final HiveType PARTITION_HIVE_TYPE = HiveType.HIVE_STRING;
    public static final Type PARTITION_TYPE_SIGNATURE = VarcharType.VARCHAR;
    public static final int UPDATE_ROW_ID_COLUMN_INDEX = -16;
    public static final String UPDATE_ROW_ID_COLUMN_NAME = "$row_id";
    private final String baseColumnName;
    private final int baseHiveColumnIndex;
    private final HiveType baseHiveType;
    private final Type baseType;
    private final Optional<String> comment;
    private final Optional<HiveColumnProjectionInfo> hiveColumnProjectionInfo;
    private final String name;
    private final ColumnType columnType;

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="baseColumnName") String baseColumnName, @JsonProperty(value="baseHiveColumnIndex") int baseHiveColumnIndex, @JsonProperty(value="baseHiveType") HiveType baseHiveType, @JsonProperty(value="baseType") Type baseType, @JsonProperty(value="hiveColumnProjectionInfo") Optional<HiveColumnProjectionInfo> hiveColumnProjectionInfo, @JsonProperty(value="columnType") ColumnType columnType, @JsonProperty(value="comment") Optional<String> comment) {
        this.baseColumnName = Objects.requireNonNull(baseColumnName, "baseColumnName is null");
        Preconditions.checkArgument((baseHiveColumnIndex >= 0 || columnType == ColumnType.PARTITION_KEY || columnType == ColumnType.SYNTHESIZED ? 1 : 0) != 0, (Object)"baseHiveColumnIndex is negative");
        this.baseHiveColumnIndex = baseHiveColumnIndex;
        this.baseHiveType = Objects.requireNonNull(baseHiveType, "baseHiveType is null");
        this.baseType = Objects.requireNonNull(baseType, "baseType is null");
        this.hiveColumnProjectionInfo = Objects.requireNonNull(hiveColumnProjectionInfo, "hiveColumnProjectionInfo is null");
        this.name = this.baseColumnName + hiveColumnProjectionInfo.map(HiveColumnProjectionInfo::getPartialName).orElse("");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public static HiveColumnHandle createBaseColumn(String topLevelColumnName, int topLevelColumnIndex, HiveType hiveType, Type type, ColumnType columnType, Optional<String> comment) {
        return new HiveColumnHandle(topLevelColumnName, topLevelColumnIndex, hiveType, type, Optional.empty(), columnType, comment);
    }

    public HiveColumnHandle getBaseColumn() {
        return this.isBaseColumn() ? this : HiveColumnHandle.createBaseColumn(this.baseColumnName, this.baseHiveColumnIndex, this.baseHiveType, this.baseType, this.columnType, this.comment);
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getBaseColumnName() {
        return this.baseColumnName;
    }

    @JsonProperty
    public HiveType getBaseHiveType() {
        return this.baseHiveType;
    }

    @JsonProperty
    public Type getBaseType() {
        return this.baseType;
    }

    @JsonProperty
    public int getBaseHiveColumnIndex() {
        return this.baseHiveColumnIndex;
    }

    @JsonProperty
    public Optional<HiveColumnProjectionInfo> getHiveColumnProjectionInfo() {
        return this.hiveColumnProjectionInfo;
    }

    public HiveType getHiveType() {
        return this.hiveColumnProjectionInfo.map(HiveColumnProjectionInfo::getHiveType).orElse(this.baseHiveType);
    }

    public Type getType() {
        return this.hiveColumnProjectionInfo.map(HiveColumnProjectionInfo::getType).orElse(this.baseType);
    }

    public boolean isPartitionKey() {
        return this.columnType == ColumnType.PARTITION_KEY;
    }

    public boolean isHidden() {
        return this.columnType == ColumnType.SYNTHESIZED;
    }

    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.getType()).setHidden(this.isHidden()).build();
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public ColumnType getColumnType() {
        return this.columnType;
    }

    public boolean isBaseColumn() {
        return this.hiveColumnProjectionInfo.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseColumnName, this.baseHiveColumnIndex, this.baseHiveType, this.baseType, this.hiveColumnProjectionInfo, this.columnType, this.comment});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)obj;
        return Objects.equals(this.baseColumnName, other.baseColumnName) && Objects.equals(this.baseHiveColumnIndex, other.baseHiveColumnIndex) && Objects.equals(this.baseHiveType, other.baseHiveType) && Objects.equals(this.baseType, other.baseType) && Objects.equals(this.hiveColumnProjectionInfo, other.hiveColumnProjectionInfo) && Objects.equals(this.name, other.name) && this.columnType == other.columnType && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return this.name + ":" + String.valueOf(this.getHiveType()) + ":" + String.valueOf((Object)this.columnType);
    }

    public Column toMetastoreColumn() {
        return new Column(this.name, this.getHiveType(), this.comment, (Map<String, String>)ImmutableMap.of());
    }

    public static HiveColumnHandle mergeRowIdColumnHandle() {
        return HiveColumnHandle.createBaseColumn(UPDATE_ROW_ID_COLUMN_NAME, -16, HiveType.toHiveType((Type)AcidSchema.ACID_ROW_ID_ROW_TYPE), (Type)AcidSchema.ACID_ROW_ID_ROW_TYPE, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static HiveColumnHandle pathColumnHandle() {
        return HiveColumnHandle.createBaseColumn(PATH_COLUMN_NAME, -11, PATH_HIVE_TYPE, PATH_TYPE, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static HiveColumnHandle bucketColumnHandle() {
        return HiveColumnHandle.createBaseColumn(BUCKET_COLUMN_NAME, -12, BUCKET_HIVE_TYPE, BUCKET_TYPE_SIGNATURE, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static HiveColumnHandle fileSizeColumnHandle() {
        return HiveColumnHandle.createBaseColumn(FILE_SIZE_COLUMN_NAME, -13, FILE_SIZE_TYPE, FILE_SIZE_TYPE_SIGNATURE, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static HiveColumnHandle fileModifiedTimeColumnHandle() {
        return HiveColumnHandle.createBaseColumn(FILE_MODIFIED_TIME_COLUMN_NAME, -14, FILE_MODIFIED_TIME_TYPE, FILE_MODIFIED_TIME_TYPE_SIGNATURE, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static HiveColumnHandle partitionColumnHandle() {
        return HiveColumnHandle.createBaseColumn(PARTITION_COLUMN_NAME, -15, PARTITION_HIVE_TYPE, PARTITION_TYPE_SIGNATURE, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static boolean isPathColumnHandle(HiveColumnHandle column) {
        return column.getBaseHiveColumnIndex() == -11;
    }

    public static boolean isBucketColumnHandle(HiveColumnHandle column) {
        return column.getBaseHiveColumnIndex() == -12;
    }

    public static boolean isFileSizeColumnHandle(HiveColumnHandle column) {
        return column.getBaseHiveColumnIndex() == -13;
    }

    public static boolean isFileModifiedTimeColumnHandle(HiveColumnHandle column) {
        return column.getBaseHiveColumnIndex() == -14;
    }

    public static boolean isPartitionColumnHandle(HiveColumnHandle column) {
        return column.getBaseHiveColumnIndex() == -15;
    }

    public static boolean isRowIdColumnHandle(HiveColumnHandle column) {
        return column.getBaseHiveColumnIndex() == -16;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.baseColumnName) + this.baseHiveType.getRetainedSizeInBytes() + SizeOf.sizeOf(this.comment, SizeOf::estimatedSizeOf) + SizeOf.sizeOf(this.hiveColumnProjectionInfo, HiveColumnProjectionInfo::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.name);
    }

    public static enum ColumnType {
        PARTITION_KEY,
        REGULAR,
        SYNTHESIZED;

    }
}

