/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.HiveBucketFunction;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveWritableTableHandle;
import io.trino.plugin.hive.HiveWriter;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.MergeFileWriter;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.PartitionUpdateAndMergeResults;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.IntegerType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HivePageSink
implements ConnectorPageSink,
ConnectorMergeSink {
    private static final Logger LOG = Logger.get(HivePageSink.class);
    private static final int MAX_PAGE_POSITIONS = 4096;
    private final HiveWriterFactory writerFactory;
    private final boolean isTransactional;
    private final int[] dataColumnInputIndex;
    private final int[] partitionColumnsInputIndex;
    private final int[] bucketColumns;
    private final HiveBucketFunction bucketFunction;
    private final HiveWriterPagePartitioner pagePartitioner;
    private final int maxOpenWriters;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final List<HiveWriter> writers = new ArrayList<HiveWriter>();
    private final long targetMaxFileSize;
    private final long idleWriterMinFileSize;
    private final List<Closeable> closedWriterRollbackActions = new ArrayList<Closeable>();
    private final List<Slice> partitionUpdates = new ArrayList<Slice>();
    private final List<Callable<Object>> verificationTasks = new ArrayList<Callable<Object>>();
    private final List<Boolean> activeWriters = new ArrayList<Boolean>();
    private final boolean isMergeSink;
    private long writtenBytes;
    private long memoryUsage;
    private long validationCpuNanos;

    public HivePageSink(HiveWritableTableHandle tableHandle, HiveWriterFactory writerFactory, List<HiveColumnHandle> inputColumns, boolean isTransactional, Optional<HiveBucketProperty> bucketProperty, PageIndexerFactory pageIndexerFactory, int maxOpenWriters, ListeningExecutorService writeVerificationExecutor, JsonCodec<PartitionUpdate> partitionUpdateCodec, ConnectorSession session) {
        this.writerFactory = Objects.requireNonNull(writerFactory, "writerFactory is null");
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.isTransactional = isTransactional;
        this.maxOpenWriters = maxOpenWriters;
        this.writeVerificationExecutor = Objects.requireNonNull(writeVerificationExecutor, "writeVerificationExecutor is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.isMergeSink = tableHandle.getTransaction().isMerge();
        Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.pagePartitioner = new HiveWriterPagePartitioner(inputColumns, bucketProperty.isPresent(), pageIndexerFactory);
        ImmutableList.Builder partitionColumns = ImmutableList.builder();
        ImmutableList.Builder dataColumnsInputIndex = ImmutableList.builder();
        Object2IntOpenHashMap dataColumnNameToIdMap = new Object2IntOpenHashMap();
        HashMap<String, HiveType> dataColumnNameToTypeMap = new HashMap<String, HiveType>();
        for (int inputIndex = 0; inputIndex < inputColumns.size(); ++inputIndex) {
            HiveColumnHandle column = inputColumns.get(inputIndex);
            if (column.isPartitionKey()) {
                partitionColumns.add((Object)inputIndex);
                continue;
            }
            dataColumnsInputIndex.add((Object)inputIndex);
            dataColumnNameToIdMap.put((Object)column.getName(), inputIndex);
            dataColumnNameToTypeMap.put(column.getName(), column.getHiveType());
        }
        this.partitionColumnsInputIndex = Ints.toArray((Collection)partitionColumns.build());
        this.dataColumnInputIndex = Ints.toArray((Collection)dataColumnsInputIndex.build());
        if (bucketProperty.isPresent()) {
            HiveBucketing.BucketingVersion bucketingVersion = bucketProperty.get().getBucketingVersion();
            int bucketCount = bucketProperty.get().getBucketCount();
            this.bucketColumns = bucketProperty.get().getBucketedBy().stream().mapToInt(arg_0 -> ((Object2IntMap)dataColumnNameToIdMap).get(arg_0)).toArray();
            List<HiveType> bucketColumnTypes = bucketProperty.get().getBucketedBy().stream().map(dataColumnNameToTypeMap::get).collect(Collectors.toList());
            this.bucketFunction = new HiveBucketFunction(bucketingVersion, bucketCount, bucketColumnTypes);
        } else {
            this.bucketColumns = null;
            this.bucketFunction = null;
        }
        this.targetMaxFileSize = HiveSessionProperties.getTargetMaxFileSize(session).toBytes();
        this.idleWriterMinFileSize = HiveSessionProperties.getIdleWriterMinFileSize(session).toBytes();
    }

    public long getCompletedBytes() {
        return this.writtenBytes;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return MoreFutures.toCompletableFuture(this.isMergeSink ? this.doMergeSinkFinish() : this.doInsertSinkFinish());
    }

    private ListenableFuture<Collection<Slice>> doMergeSinkFinish() {
        ImmutableList.Builder resultSlices = ImmutableList.builder();
        for (HiveWriter writer : this.writers) {
            if (writer == null) continue;
            writer.commit();
            MergeFileWriter mergeFileWriter = (MergeFileWriter)writer.getFileWriter();
            PartitionUpdateAndMergeResults results = mergeFileWriter.getPartitionUpdateAndMergeResults(writer.getPartitionUpdate());
            resultSlices.add((Object)Slices.wrappedBuffer((byte[])PartitionUpdateAndMergeResults.CODEC.toJsonBytes((Object)results)));
        }
        ImmutableList result = resultSlices.build();
        this.writtenBytes = this.writers.stream().filter(Objects::nonNull).mapToLong(HiveWriter::getWrittenBytes).sum();
        return Futures.immediateFuture((Object)result);
    }

    private ListenableFuture<Collection<Slice>> doInsertSinkFinish() {
        for (int writerIndex = 0; writerIndex < this.writers.size(); ++writerIndex) {
            this.closeWriter(writerIndex);
        }
        this.writers.clear();
        ImmutableList result = ImmutableList.copyOf(this.partitionUpdates);
        if (this.verificationTasks.isEmpty()) {
            return Futures.immediateFuture((Object)result);
        }
        try {
            List futures = this.writeVerificationExecutor.invokeAll(this.verificationTasks).stream().map(future -> (ListenableFuture)future).collect(Collectors.toList());
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), arg_0 -> HivePageSink.lambda$doInsertSinkFinish$1((List)result, arg_0), (Executor)MoreExecutors.directExecutor());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void abort() {
        List rollbackActions = (List)Streams.concat((Stream[])new Stream[]{this.writers.stream().filter(Objects::nonNull).map(writer -> writer::rollback), this.closedWriterRollbackActions.stream()}).collect(ImmutableList.toImmutableList());
        Throwable rollbackException = null;
        for (Closeable rollbackAction : rollbackActions) {
            try {
                rollbackAction.close();
            }
            catch (Throwable t) {
                if (rollbackException == null) {
                    rollbackException = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive");
                }
                rollbackException.addSuppressed(t);
            }
        }
        if (rollbackException != null) {
            throw rollbackException;
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        Page chunk;
        for (int writeOffset = 0; writeOffset < page.getPositionCount(); writeOffset += chunk.getPositionCount()) {
            chunk = page.getRegion(writeOffset, Math.min(page.getPositionCount() - writeOffset, 4096));
            this.writePage(chunk);
        }
        return NOT_BLOCKED;
    }

    private void writePage(Page page) {
        int index;
        int[] writerIndexes = this.getWriterIndexes(page);
        int[] sizes = new int[this.writers.size()];
        int[] nArray = writerIndexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = index = nArray[i];
            sizes[n2] = sizes[n2] + 1;
        }
        int[][] writerPositions = new int[this.writers.size()][];
        int[] counts = new int[this.writers.size()];
        int position = 0;
        while (position < page.getPositionCount()) {
            index = writerIndexes[position];
            int count = counts[index];
            if (count == 0) {
                writerPositions[index] = new int[sizes[index]];
            }
            writerPositions[index][count] = position++;
            counts[index] = count + 1;
        }
        Page dataPage = this.getDataPage(page);
        for (index = 0; index < writerPositions.length; ++index) {
            HiveWriter writer;
            int[] positions = writerPositions[index];
            if (positions == null) continue;
            Page pageForWriter = dataPage;
            if (positions.length != dataPage.getPositionCount()) {
                Verify.verify((positions.length == counts[index] ? 1 : 0) != 0);
                pageForWriter = pageForWriter.getPositions(positions, 0, positions.length);
            }
            Verify.verify(((writer = this.writers.get(index)) != null ? 1 : 0) != 0, (String)"Expected writer at index %s", (int)index);
            long currentWritten = writer.getWrittenBytes();
            long currentMemory = writer.getMemoryUsage();
            writer.append(pageForWriter);
            this.writtenBytes += writer.getWrittenBytes() - currentWritten;
            this.memoryUsage += writer.getMemoryUsage() - currentMemory;
            this.activeWriters.set(index, true);
        }
    }

    private void closeWriter(int writerIndex) {
        HiveWriter writer = this.writers.get(writerIndex);
        if (writer == null) {
            return;
        }
        long currentWritten = writer.getWrittenBytes();
        long currentMemory = writer.getMemoryUsage();
        this.closedWriterRollbackActions.add(writer.commit());
        this.writtenBytes += writer.getWrittenBytes() - currentWritten;
        this.memoryUsage -= currentMemory;
        this.validationCpuNanos += writer.getValidationCpuNanos();
        this.writers.set(writerIndex, null);
        PartitionUpdate partitionUpdate = writer.getPartitionUpdate();
        this.partitionUpdates.add(Slices.wrappedBuffer((byte[])this.partitionUpdateCodec.toJsonBytes((Object)partitionUpdate)));
    }

    public void closeIdleWriters() {
        if (this.bucketFunction != null || this.isTransactional) {
            return;
        }
        for (int writerIndex = 0; writerIndex < this.writers.size(); ++writerIndex) {
            HiveWriter writer = this.writers.get(writerIndex);
            if (this.activeWriters.get(writerIndex).booleanValue() || writer == null || writer.getWrittenBytes() <= this.idleWriterMinFileSize) {
                this.activeWriters.set(writerIndex, false);
                continue;
            }
            LOG.debug("Closing writer %s with %s bytes written", new Object[]{writerIndex, writer.getWrittenBytes()});
            this.closeWriter(writerIndex);
        }
    }

    private int[] getWriterIndexes(Page page) {
        Page partitionColumns = HivePageSink.extractColumns(page, this.partitionColumnsInputIndex);
        Block bucketBlock = this.buildBucketBlock(page);
        int[] writerIndexes = this.pagePartitioner.partitionPage(partitionColumns, bucketBlock);
        if (this.pagePartitioner.getMaxIndex() >= this.maxOpenWriters) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, String.format("Exceeded limit of %s open writers for partitions/buckets", this.maxOpenWriters));
        }
        while (this.writers.size() <= this.pagePartitioner.getMaxIndex()) {
            this.writers.add(null);
            this.activeWriters.add(false);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int writerIndex = writerIndexes[position];
            HiveWriter writer = this.writers.get(writerIndex);
            if (writer != null) {
                if (this.bucketFunction != null || this.isTransactional || writer.getWrittenBytes() <= this.targetMaxFileSize) continue;
                this.closeWriter(writerIndex);
            }
            OptionalInt bucketNumber = OptionalInt.empty();
            if (bucketBlock != null) {
                bucketNumber = OptionalInt.of(IntegerType.INTEGER.getInt(bucketBlock, position));
            }
            writer = this.writerFactory.createWriter(partitionColumns, position, bucketNumber);
            this.writers.set(writerIndex, writer);
            this.memoryUsage += writer.getMemoryUsage();
        }
        Verify.verify((this.writers.size() == this.pagePartitioner.getMaxIndex() + 1 ? 1 : 0) != 0);
        return writerIndexes;
    }

    private Page getDataPage(Page page) {
        if (this.isMergeSink) {
            return page;
        }
        Block[] blocks = new Block[this.dataColumnInputIndex.length];
        for (int i = 0; i < this.dataColumnInputIndex.length; ++i) {
            int dataColumn = this.dataColumnInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private Block buildBucketBlock(Page page) {
        if (this.bucketFunction == null) {
            return null;
        }
        IntArrayBlockBuilder bucketColumnBuilder = new IntArrayBlockBuilder(null, page.getPositionCount());
        Page bucketColumnsPage = HivePageSink.extractColumns(page, this.bucketColumns);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int bucket = this.bucketFunction.getBucket(bucketColumnsPage, position);
            IntegerType.INTEGER.writeInt((BlockBuilder)bucketColumnBuilder, bucket);
        }
        return bucketColumnBuilder.build();
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public void storeMergedRows(Page page) {
        Preconditions.checkArgument((boolean)this.isMergeSink, (Object)"isMergeSink is false");
        this.appendPage(page);
    }

    private static /* synthetic */ Collection lambda$doInsertSinkFinish$1(List result, List input) {
        return result;
    }

    private static class HiveWriterPagePartitioner {
        private final PageIndexer pageIndexer;

        public HiveWriterPagePartitioner(List<HiveColumnHandle> inputColumns, boolean bucketed, PageIndexerFactory pageIndexerFactory) {
            Objects.requireNonNull(inputColumns, "inputColumns is null");
            Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
            List partitionColumnTypes = inputColumns.stream().filter(HiveColumnHandle::isPartitionKey).map(HiveColumnHandle::getType).collect(Collectors.toList());
            if (bucketed) {
                partitionColumnTypes.add(IntegerType.INTEGER);
            }
            this.pageIndexer = pageIndexerFactory.createPageIndexer(partitionColumnTypes);
        }

        public int[] partitionPage(Page partitionColumns, Block bucketBlock) {
            if (bucketBlock != null) {
                Block[] blocks = new Block[partitionColumns.getChannelCount() + 1];
                for (int i = 0; i < partitionColumns.getChannelCount(); ++i) {
                    blocks[i] = partitionColumns.getBlock(i);
                }
                blocks[blocks.length - 1] = bucketBlock;
                partitionColumns = new Page(partitionColumns.getPositionCount(), blocks);
            }
            return this.pageIndexer.indexPage(partitionColumns);
        }

        public int getMaxIndex() {
            return this.pageIndexer.getMaxIndex();
        }
    }
}

