/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class HiveTransactionManager {
    private final TransactionalMetadataFactory metadataFactory;
    private final Map<ConnectorTransactionHandle, MemoizedMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, MemoizedMetadata>();

    @Inject
    public HiveTransactionManager(TransactionalMetadataFactory metadataFactory) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
    }

    public void begin(ConnectorTransactionHandle transactionHandle) {
        MemoizedMetadata previousValue = this.transactions.putIfAbsent(transactionHandle, new MemoizedMetadata());
        Preconditions.checkState((previousValue == null ? 1 : 0) != 0);
    }

    public TransactionalMetadata get(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity) {
        return this.transactions.get(transactionHandle).get(identity, ((HiveTransactionHandle)transactionHandle).isAutoCommit());
    }

    public void commit(ConnectorTransactionHandle transaction) {
        MemoizedMetadata transactionalMetadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((transactionalMetadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        transactionalMetadata.optionalGet().ifPresent(metadata -> {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
                metadata.commit();
            }
        });
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        MemoizedMetadata transactionalMetadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((transactionalMetadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        transactionalMetadata.optionalGet().ifPresent(metadata -> {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
                metadata.rollback();
            }
        });
    }

    private class MemoizedMetadata {
        @GuardedBy(value="this")
        private TransactionalMetadata metadata;

        private MemoizedMetadata() {
        }

        public synchronized Optional<TransactionalMetadata> optionalGet() {
            return Optional.ofNullable(this.metadata);
        }

        public synchronized TransactionalMetadata get(ConnectorIdentity identity, boolean autoCommit) {
            if (this.metadata == null) {
                try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
                    this.metadata = HiveTransactionManager.this.metadataFactory.create(identity, autoCommit);
                }
            }
            return this.metadata;
        }
    }
}

