/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateType;
import io.trino.spi.type.VarcharType;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class DateCoercer {
    private static final long START_OF_MODERN_ERA_DAYS = LocalDate.of(1900, 1, 1).toEpochDay();

    private DateCoercer() {
    }

    public static class DateToVarcharCoercer
    extends TypeCoercer<DateType, VarcharType> {
        public DateToVarcharCoercer(VarcharType toType) {
            super(DateType.DATE, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            int value = ((DateType)this.fromType).getInt(block, position);
            try {
                if ((long)value < START_OF_MODERN_ERA_DAYS) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_TIMESTAMP_COERCION, "Coercion on historical dates is not supported");
                }
                Slice converted = Slices.utf8Slice((String)DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.ofEpochDay(value)));
                if (!((VarcharType)this.toType).isUnbounded() && SliceUtf8.countCodePoints((Slice)converted) > ((VarcharType)this.toType).getBoundedLength()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Varchar representation of '%s' exceeds %s bounds", converted.toStringUtf8(), this.toType));
                }
                ((VarcharType)this.toType).writeSlice(blockBuilder, converted);
            }
            catch (DateTimeException ignored) {
                throw new IllegalArgumentException("Invalid date value: " + value + " is exceeding supported date range");
            }
        }
    }

    public static class VarcharToDateCoercer
    extends TypeCoercer<VarcharType, DateType> {
        public VarcharToDateCoercer(VarcharType fromType, DateType toType) {
            super(fromType, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            String value = ((VarcharType)this.fromType).getSlice(block, position).toStringUtf8();
            try {
                LocalDate localDate = DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)value, LocalDate::from);
                if (localDate.toEpochDay() < START_OF_MODERN_ERA_DAYS) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_TIMESTAMP_COERCION, "Coercion on historical dates is not supported");
                }
                ((DateType)this.toType).writeLong(blockBuilder, localDate.toEpochDay());
            }
            catch (DateTimeParseException ignored) {
                throw new IllegalArgumentException("Invalid date value: " + value + " is not a valid date");
            }
        }
    }
}

