/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.line;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.hive.formats.line.LineSerializerFactory;
import io.trino.hive.formats.line.LineWriter;
import io.trino.hive.formats.line.LineWriterFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.line.LineFileWriter;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public abstract class LineFileWriterFactory
implements HiveFileWriterFactory {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final LineSerializerFactory lineSerializerFactory;
    private final LineWriterFactory lineWriterFactory;
    private final boolean headerSupported;

    protected LineFileWriterFactory(TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, LineSerializerFactory lineSerializerFactory, LineWriterFactory lineWriterFactory, boolean headerSupported) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.lineSerializerFactory = Objects.requireNonNull(lineSerializerFactory, "lineSerializerFactory is null");
        this.lineWriterFactory = Objects.requireNonNull(lineWriterFactory, "lineWriterFactory is null");
        this.headerSupported = headerSupported;
    }

    @Override
    public Optional<FileWriter> createFileWriter(Location location, List<String> inputColumnNames, StorageFormat storageFormat, HiveCompressionCodec compressionCodec, Map<String, String> schema, ConnectorSession session, OptionalInt bucketNumber, AcidTransaction transaction, boolean useAcidSchema, WriterKind writerKind) {
        if (!this.lineWriterFactory.getHiveOutputFormatClassName().equals(storageFormat.getOutputFormat()) || !this.lineSerializerFactory.getHiveSerDeClassNames().contains(storageFormat.getSerde())) {
            return Optional.empty();
        }
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<Type> fileColumnTypes = HiveUtil.getColumnTypes(schema).stream().map(hiveType -> hiveType.getType(this.typeManager, HiveSessionProperties.getTimestampPrecision(session))).toList();
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        List<Column> columns = IntStream.range(0, fileColumnNames.size()).mapToObj(ordinal -> new Column((String)fileColumnNames.get(ordinal), (Type)fileColumnTypes.get(ordinal), ordinal)).toList();
        LineSerializer lineSerializer = this.lineSerializerFactory.create(columns, schema);
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            AggregatedMemoryContext outputStreamMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            OutputStream outputStream = fileSystem.newOutputFile(location).create(outputStreamMemoryContext);
            LineWriter lineWriter = this.lineWriterFactory.createLineWriter(session, outputStream, compressionCodec.getHiveCompressionKind());
            Optional<Slice> header = this.getFileHeader(schema, columns);
            if (header.isPresent()) {
                lineWriter.write(header.get());
            }
            return Optional.of(new LineFileWriter(lineWriter, lineSerializer, () -> fileSystem.deleteFile(location), fileInputColumnIndexes));
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating file", (Throwable)e);
        }
    }

    private Optional<Slice> getFileHeader(Map<String, String> schema, List<Column> columns) throws IOException {
        String skipHeaderCount = schema.getOrDefault("skip.header.line.count", "0");
        if (skipHeaderCount.equals("0")) {
            return Optional.empty();
        }
        if (!skipHeaderCount.equals("1") && !this.headerSupported) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "%s=%s not supported".formatted("skip.header.line.count", skipHeaderCount));
        }
        LineSerializer headerSerializer = this.lineSerializerFactory.create((List)columns.stream().map(column -> new Column(column.name(), (Type)VarcharType.VARCHAR, column.ordinal())).collect(ImmutableList.toImmutableList()), schema);
        PageBuilder pageBuilder = new PageBuilder(headerSerializer.getTypes());
        pageBuilder.declarePosition();
        for (int channel = 0; channel < columns.size(); ++channel) {
            VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(channel), Slices.utf8Slice((String)columns.get(channel).name()));
        }
        Page page = pageBuilder.build();
        DynamicSliceOutput output = new DynamicSliceOutput(1024);
        headerSerializer.write(page, 0, (SliceOutput)output);
        return Optional.of(output.slice());
    }
}

