/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.BinaryColumnStatisticsData;
import com.amazonaws.services.glue.model.BooleanColumnStatisticsData;
import com.amazonaws.services.glue.model.ColumnStatistics;
import com.amazonaws.services.glue.model.ColumnStatisticsData;
import com.amazonaws.services.glue.model.ColumnStatisticsType;
import com.amazonaws.services.glue.model.DateColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalNumber;
import com.amazonaws.services.glue.model.DoubleColumnStatisticsData;
import com.amazonaws.services.glue.model.LongColumnStatisticsData;
import com.amazonaws.services.glue.model.StringColumnStatisticsData;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.hive.thrift.metastore.Decimal;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;

public class GlueStatConverter {
    private static final long MILLIS_PER_DAY = TimeUnit.DAYS.toMillis(1L);

    private GlueStatConverter() {
    }

    public static List<ColumnStatistics> toGlueColumnStatistics(Partition partition, Map<String, HiveColumnStatistics> trinoColumnStats, OptionalLong rowCount) {
        return (List)partition.getColumns().stream().filter(column -> trinoColumnStats.containsKey(column.getName())).map(c -> GlueStatConverter.toColumnStatistics(c, (HiveColumnStatistics)trinoColumnStats.get(c.getName()), rowCount)).collect(ImmutableList.toImmutableList());
    }

    public static List<ColumnStatistics> toGlueColumnStatistics(Table table, Map<String, HiveColumnStatistics> trinoColumnStats, OptionalLong rowCount) {
        return (List)trinoColumnStats.entrySet().stream().map(e -> GlueStatConverter.toColumnStatistics(table.getColumn((String)e.getKey()).get(), (HiveColumnStatistics)e.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
    }

    private static ColumnStatistics toColumnStatistics(Column column, HiveColumnStatistics statistics, OptionalLong rowCount) {
        ColumnStatistics columnStatistics = new ColumnStatistics();
        HiveType columnType = column.getType();
        columnStatistics.setColumnName(column.getName());
        columnStatistics.setColumnType(columnType.toString());
        ColumnStatisticsData catalogColumnStatisticsData = GlueStatConverter.toGlueColumnStatisticsData(statistics, columnType, rowCount);
        columnStatistics.setStatisticsData(catalogColumnStatisticsData);
        columnStatistics.setAnalyzedTime(new Date());
        return columnStatistics;
    }

    public static HiveColumnStatistics fromGlueColumnStatistics(ColumnStatisticsData catalogColumnStatisticsData, OptionalLong rowCount) {
        ColumnStatisticsType type = ColumnStatisticsType.fromValue((String)catalogColumnStatisticsData.getType());
        switch (type) {
            case BINARY: {
                BinaryColumnStatisticsData data = catalogColumnStatisticsData.getBinaryColumnStatisticsData();
                OptionalLong max = OptionalLong.of(data.getMaximumLength());
                OptionalDouble avg = OptionalDouble.of(data.getAverageLength());
                OptionalLong nulls = ThriftMetastoreUtil.fromMetastoreNullsCount(data.getNumberOfNulls());
                return HiveColumnStatistics.createBinaryColumnStatistics(max, ThriftMetastoreUtil.getTotalSizeInBytes(avg, rowCount, nulls), nulls);
            }
            case BOOLEAN: {
                BooleanColumnStatisticsData catalogBooleanData = catalogColumnStatisticsData.getBooleanColumnStatisticsData();
                return HiveColumnStatistics.createBooleanColumnStatistics(OptionalLong.of(catalogBooleanData.getNumberOfTrues()), OptionalLong.of(catalogBooleanData.getNumberOfFalses()), ThriftMetastoreUtil.fromMetastoreNullsCount(catalogBooleanData.getNumberOfNulls()));
            }
            case DATE: {
                DateColumnStatisticsData data = catalogColumnStatisticsData.getDateColumnStatisticsData();
                Optional<LocalDate> min = GlueStatConverter.dateToLocalDate(data.getMinimumValue());
                Optional<LocalDate> max = GlueStatConverter.dateToLocalDate(data.getMaximumValue());
                OptionalLong nullsCount = ThriftMetastoreUtil.fromMetastoreNullsCount(data.getNumberOfNulls());
                OptionalLong distinctValues = OptionalLong.of(data.getNumberOfDistinctValues());
                return HiveColumnStatistics.createDateColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValues, nullsCount, rowCount));
            }
            case DECIMAL: {
                DecimalColumnStatisticsData data = catalogColumnStatisticsData.getDecimalColumnStatisticsData();
                Optional<BigDecimal> min = GlueStatConverter.glueDecimalToBigDecimal(data.getMinimumValue());
                Optional<BigDecimal> max = GlueStatConverter.glueDecimalToBigDecimal(data.getMaximumValue());
                OptionalLong distinctValues = OptionalLong.of(data.getNumberOfDistinctValues());
                OptionalLong nullsCount = ThriftMetastoreUtil.fromMetastoreNullsCount(data.getNumberOfNulls());
                return HiveColumnStatistics.createDecimalColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValues, nullsCount, rowCount));
            }
            case DOUBLE: {
                DoubleColumnStatisticsData data = catalogColumnStatisticsData.getDoubleColumnStatisticsData();
                OptionalDouble min = OptionalDouble.of(data.getMinimumValue());
                OptionalDouble max = OptionalDouble.of(data.getMaximumValue());
                OptionalLong nulls = ThriftMetastoreUtil.fromMetastoreNullsCount(data.getNumberOfNulls());
                OptionalLong distinctValues = OptionalLong.of(data.getNumberOfDistinctValues());
                return HiveColumnStatistics.createDoubleColumnStatistics(min, max, nulls, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValues, nulls, rowCount));
            }
            case LONG: {
                LongColumnStatisticsData data = catalogColumnStatisticsData.getLongColumnStatisticsData();
                OptionalLong min = OptionalLong.of(data.getMinimumValue());
                OptionalLong max = OptionalLong.of(data.getMaximumValue());
                OptionalLong nullsCount = ThriftMetastoreUtil.fromMetastoreNullsCount(data.getNumberOfNulls());
                OptionalLong distinctValues = OptionalLong.of(data.getNumberOfDistinctValues());
                return HiveColumnStatistics.createIntegerColumnStatistics(min, max, nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValues, nullsCount, rowCount));
            }
            case STRING: {
                StringColumnStatisticsData data = catalogColumnStatisticsData.getStringColumnStatisticsData();
                OptionalLong max = OptionalLong.of(data.getMaximumLength());
                OptionalDouble avg = OptionalDouble.of(data.getAverageLength());
                OptionalLong nullsCount = ThriftMetastoreUtil.fromMetastoreNullsCount(data.getNumberOfNulls());
                OptionalLong distinctValues = OptionalLong.of(data.getNumberOfDistinctValues());
                return HiveColumnStatistics.createStringColumnStatistics(max, ThriftMetastoreUtil.getTotalSizeInBytes(avg, rowCount, nullsCount), nullsCount, ThriftMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValues, nullsCount, rowCount));
            }
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics data: " + String.valueOf(catalogColumnStatisticsData));
    }

    private static ColumnStatisticsData toGlueColumnStatisticsData(HiveColumnStatistics statistics, HiveType columnType, OptionalLong rowCount) {
        TypeInfo typeInfo = columnType.getTypeInfo();
        Preconditions.checkArgument((typeInfo.getCategory() == Category.PRIMITIVE ? 1 : 0) != 0, (String)"Unsupported statistics type: %s", (Object)columnType);
        ColumnStatisticsData catalogColumnStatisticsData = new ColumnStatisticsData();
        switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            case BOOLEAN: {
                BooleanColumnStatisticsData data = new BooleanColumnStatisticsData();
                statistics.getNullsCount().ifPresent(arg_0 -> ((BooleanColumnStatisticsData)data).setNumberOfNulls(arg_0));
                statistics.getBooleanStatistics().ifPresent(booleanStatistics -> {
                    booleanStatistics.getFalseCount().ifPresent(arg_0 -> ((BooleanColumnStatisticsData)data).setNumberOfFalses(arg_0));
                    booleanStatistics.getTrueCount().ifPresent(arg_0 -> ((BooleanColumnStatisticsData)data).setNumberOfTrues(arg_0));
                });
                catalogColumnStatisticsData.setType(ColumnStatisticsType.BOOLEAN.toString());
                catalogColumnStatisticsData.setBooleanColumnStatisticsData(data);
                break;
            }
            case BINARY: {
                BinaryColumnStatisticsData data = new BinaryColumnStatisticsData();
                statistics.getNullsCount().ifPresent(arg_0 -> ((BinaryColumnStatisticsData)data).setNumberOfNulls(arg_0));
                data.setMaximumLength(Long.valueOf(statistics.getMaxValueSizeInBytes().orElse(0L)));
                data.setAverageLength(Double.valueOf(ThriftMetastoreUtil.getAverageColumnLength(statistics.getTotalSizeInBytes(), rowCount, statistics.getNullsCount()).orElse(0.0)));
                catalogColumnStatisticsData.setType(ColumnStatisticsType.BINARY.toString());
                catalogColumnStatisticsData.setBinaryColumnStatisticsData(data);
                break;
            }
            case DATE: {
                DateColumnStatisticsData data = new DateColumnStatisticsData();
                statistics.getDateStatistics().ifPresent(dateStatistics -> {
                    dateStatistics.getMin().ifPresent(value -> data.setMinimumValue(GlueStatConverter.localDateToDate(value)));
                    dateStatistics.getMax().ifPresent(value -> data.setMaximumValue(GlueStatConverter.localDateToDate(value)));
                });
                statistics.getNullsCount().ifPresent(arg_0 -> ((DateColumnStatisticsData)data).setNumberOfNulls(arg_0));
                ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DateColumnStatisticsData)data).setNumberOfDistinctValues(arg_0));
                catalogColumnStatisticsData.setType(ColumnStatisticsType.DATE.toString());
                catalogColumnStatisticsData.setDateColumnStatisticsData(data);
                break;
            }
            case DECIMAL: {
                DecimalColumnStatisticsData data = new DecimalColumnStatisticsData();
                statistics.getDecimalStatistics().ifPresent(decimalStatistics -> {
                    decimalStatistics.getMin().ifPresent(value -> data.setMinimumValue(GlueStatConverter.bigDecimalToGlueDecimal(value)));
                    decimalStatistics.getMax().ifPresent(value -> data.setMaximumValue(GlueStatConverter.bigDecimalToGlueDecimal(value)));
                });
                statistics.getNullsCount().ifPresent(arg_0 -> ((DecimalColumnStatisticsData)data).setNumberOfNulls(arg_0));
                ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DecimalColumnStatisticsData)data).setNumberOfDistinctValues(arg_0));
                catalogColumnStatisticsData.setType(ColumnStatisticsType.DECIMAL.toString());
                catalogColumnStatisticsData.setDecimalColumnStatisticsData(data);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                DoubleColumnStatisticsData data = new DoubleColumnStatisticsData();
                statistics.getDoubleStatistics().ifPresent(doubleStatistics -> {
                    doubleStatistics.getMin().ifPresent(arg_0 -> ((DoubleColumnStatisticsData)data).setMinimumValue(arg_0));
                    doubleStatistics.getMax().ifPresent(arg_0 -> ((DoubleColumnStatisticsData)data).setMaximumValue(arg_0));
                });
                statistics.getNullsCount().ifPresent(arg_0 -> ((DoubleColumnStatisticsData)data).setNumberOfNulls(arg_0));
                ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((DoubleColumnStatisticsData)data).setNumberOfDistinctValues(arg_0));
                catalogColumnStatisticsData.setType(ColumnStatisticsType.DOUBLE.toString());
                catalogColumnStatisticsData.setDoubleColumnStatisticsData(data);
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case TIMESTAMP: {
                LongColumnStatisticsData data = new LongColumnStatisticsData();
                statistics.getIntegerStatistics().ifPresent(stats -> {
                    stats.getMin().ifPresent(arg_0 -> ((LongColumnStatisticsData)data).setMinimumValue(arg_0));
                    stats.getMax().ifPresent(arg_0 -> ((LongColumnStatisticsData)data).setMaximumValue(arg_0));
                });
                statistics.getNullsCount().ifPresent(arg_0 -> ((LongColumnStatisticsData)data).setNumberOfNulls(arg_0));
                ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((LongColumnStatisticsData)data).setNumberOfDistinctValues(arg_0));
                catalogColumnStatisticsData.setType(ColumnStatisticsType.LONG.toString());
                catalogColumnStatisticsData.setLongColumnStatisticsData(data);
                break;
            }
            case VARCHAR: 
            case CHAR: 
            case STRING: {
                StringColumnStatisticsData data = new StringColumnStatisticsData();
                statistics.getNullsCount().ifPresent(arg_0 -> ((StringColumnStatisticsData)data).setNumberOfNulls(arg_0));
                ThriftMetastoreUtil.toMetastoreDistinctValuesCount(statistics.getDistinctValuesCount(), statistics.getNullsCount()).ifPresent(arg_0 -> ((StringColumnStatisticsData)data).setNumberOfDistinctValues(arg_0));
                data.setMaximumLength(Long.valueOf(statistics.getMaxValueSizeInBytes().orElse(0L)));
                data.setAverageLength(Double.valueOf(ThriftMetastoreUtil.getAverageColumnLength(statistics.getTotalSizeInBytes(), rowCount, statistics.getNullsCount()).orElse(0.0)));
                catalogColumnStatisticsData.setType(ColumnStatisticsType.STRING.toString());
                catalogColumnStatisticsData.setStringColumnStatisticsData(data);
                break;
            }
            default: {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics type: " + String.valueOf((Object)((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()));
            }
        }
        return catalogColumnStatisticsData;
    }

    private static DecimalNumber bigDecimalToGlueDecimal(BigDecimal decimal) {
        Decimal hiveDecimal = new Decimal((short)decimal.scale(), ByteBuffer.wrap(decimal.unscaledValue().toByteArray()));
        DecimalNumber catalogDecimal = new DecimalNumber();
        catalogDecimal.setUnscaledValue(ByteBuffer.wrap(hiveDecimal.getUnscaled()));
        catalogDecimal.setScale(Integer.valueOf(hiveDecimal.getScale()));
        return catalogDecimal;
    }

    private static Optional<BigDecimal> glueDecimalToBigDecimal(DecimalNumber catalogDecimal) {
        if (catalogDecimal == null) {
            return Optional.empty();
        }
        Decimal decimal = new Decimal();
        decimal.setUnscaled(catalogDecimal.getUnscaledValue());
        decimal.setScale(catalogDecimal.getScale().shortValue());
        return Optional.of(new BigDecimal(new BigInteger(decimal.getUnscaled()), decimal.getScale()));
    }

    private static Optional<LocalDate> dateToLocalDate(Date date) {
        if (date == null) {
            return Optional.empty();
        }
        long daysSinceEpoch = date.getTime() / MILLIS_PER_DAY;
        return Optional.of(LocalDate.ofEpochDay(daysSinceEpoch));
    }

    private static Date localDateToDate(LocalDate date) {
        long millisecondsSinceEpoch = date.toEpochDay() * MILLIS_PER_DAY;
        return new Date(millisecondsSinceEpoch);
    }
}

