/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.annotations.VisibleForTesting;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.EnvironmentContext;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Function;
import io.trino.hive.thrift.metastore.HiveObjectPrivilege;
import io.trino.hive.thrift.metastore.HiveObjectRef;
import io.trino.hive.thrift.metastore.LockRequest;
import io.trino.hive.thrift.metastore.LockResponse;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.PrincipalType;
import io.trino.hive.thrift.metastore.PrivilegeBag;
import io.trino.hive.thrift.metastore.Role;
import io.trino.hive.thrift.metastore.RolePrincipalGrant;
import io.trino.hive.thrift.metastore.Table;
import io.trino.hive.thrift.metastore.TxnToWriteId;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.thrift.TException;

public class FailureAwareThriftMetastoreClient
implements ThriftMetastoreClient {
    private final ThriftMetastoreClient delegate;
    private final Callback callback;

    public FailureAwareThriftMetastoreClient(ThriftMetastoreClient client, Callback callback) {
        this.delegate = Objects.requireNonNull(client, "client is null");
        this.callback = Objects.requireNonNull(callback, "callback is null");
    }

    @VisibleForTesting
    public ThriftMetastoreClient getDelegate() {
        return this.delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public List<String> getAllDatabases() throws TException {
        return this.runWithHandle(this.delegate::getAllDatabases);
    }

    @Override
    public Database getDatabase(String databaseName) throws TException {
        return this.runWithHandle(() -> this.delegate.getDatabase(databaseName));
    }

    @Override
    public List<String> getAllTables(String databaseName) throws TException {
        return this.runWithHandle(() -> this.delegate.getAllTables(databaseName));
    }

    @Override
    public Optional<List<SchemaTableName>> getAllTables() throws TException {
        return this.runWithHandle(() -> this.delegate.getAllTables());
    }

    @Override
    public List<String> getAllViews(String databaseName) throws TException {
        return this.runWithHandle(() -> this.delegate.getAllViews(databaseName));
    }

    @Override
    public Optional<List<SchemaTableName>> getAllViews() throws TException {
        return this.runWithHandle(() -> this.delegate.getAllViews());
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) throws TException {
        return this.runWithHandle(() -> this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue));
    }

    @Override
    public void createDatabase(Database database) throws TException {
        this.runWithHandle(() -> this.delegate.createDatabase(database));
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData, boolean cascade) throws TException {
        this.runWithHandle(() -> this.delegate.dropDatabase(databaseName, deleteData, cascade));
    }

    @Override
    public void alterDatabase(String databaseName, Database database) throws TException {
        this.runWithHandle(() -> this.delegate.alterDatabase(databaseName, database));
    }

    @Override
    public void createTable(Table table) throws TException {
        this.runWithHandle(() -> this.delegate.createTable(table));
    }

    @Override
    public void dropTable(String databaseName, String name, boolean deleteData) throws TException {
        this.runWithHandle(() -> this.delegate.dropTable(databaseName, name, deleteData));
    }

    @Override
    public void alterTableWithEnvironmentContext(String databaseName, String tableName, Table newTable, EnvironmentContext context) throws TException {
        this.runWithHandle(() -> this.delegate.alterTableWithEnvironmentContext(databaseName, tableName, newTable, context));
    }

    @Override
    public Table getTable(String databaseName, String tableName) throws TException {
        return this.runWithHandle(() -> this.delegate.getTable(databaseName, tableName));
    }

    @Override
    public List<FieldSchema> getFields(String databaseName, String tableName) throws TException {
        return this.runWithHandle(() -> this.delegate.getFields(databaseName, tableName));
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws TException {
        return this.runWithHandle(() -> this.delegate.getTableColumnStatistics(databaseName, tableName, columnNames));
    }

    @Override
    public void setTableColumnStatistics(String databaseName, String tableName, List<ColumnStatisticsObj> statistics) throws TException {
        this.runWithHandle(() -> this.delegate.setTableColumnStatistics(databaseName, tableName, statistics));
    }

    @Override
    public void deleteTableColumnStatistics(String databaseName, String tableName, String columnName) throws TException {
        this.runWithHandle(() -> this.delegate.deleteTableColumnStatistics(databaseName, tableName, columnName));
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        return this.runWithHandle(() -> this.delegate.getPartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames));
    }

    @Override
    public void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) throws TException {
        this.runWithHandle(() -> this.delegate.setPartitionColumnStatistics(databaseName, tableName, partitionName, statistics));
    }

    @Override
    public void deletePartitionColumnStatistics(String databaseName, String tableName, String partitionName, String columnName) throws TException {
        this.runWithHandle(() -> this.delegate.deletePartitionColumnStatistics(databaseName, tableName, partitionName, columnName));
    }

    @Override
    public List<String> getPartitionNames(String databaseName, String tableName) throws TException {
        return this.runWithHandle(() -> this.delegate.getPartitionNames(databaseName, tableName));
    }

    @Override
    public List<String> getPartitionNamesFiltered(String databaseName, String tableName, List<String> partitionValues) throws TException {
        return this.runWithHandle(() -> this.delegate.getPartitionNamesFiltered(databaseName, tableName, partitionValues));
    }

    @Override
    public int addPartitions(List<Partition> newPartitions) throws TException {
        return this.runWithHandle(() -> this.delegate.addPartitions(newPartitions));
    }

    @Override
    public boolean dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) throws TException {
        return this.runWithHandle(() -> this.delegate.dropPartition(databaseName, tableName, partitionValues, deleteData));
    }

    @Override
    public void alterPartition(String databaseName, String tableName, Partition partition) throws TException {
        this.runWithHandle(() -> this.delegate.alterPartition(databaseName, tableName, partition));
    }

    @Override
    public Partition getPartition(String databaseName, String tableName, List<String> partitionValues) throws TException {
        return this.runWithHandle(() -> this.delegate.getPartition(databaseName, tableName, partitionValues));
    }

    @Override
    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws TException {
        return this.runWithHandle(() -> this.delegate.getPartitionsByNames(databaseName, tableName, partitionNames));
    }

    @Override
    public List<Role> listRoles(String principalName, PrincipalType principalType) throws TException {
        return this.runWithHandle(() -> this.delegate.listRoles(principalName, principalType));
    }

    @Override
    public List<HiveObjectPrivilege> listPrivileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObjectRef) throws TException {
        return this.runWithHandle(() -> this.delegate.listPrivileges(principalName, principalType, hiveObjectRef));
    }

    @Override
    public List<String> getRoleNames() throws TException {
        return this.runWithHandle(this.delegate::getRoleNames);
    }

    @Override
    public void createRole(String role, String grantor) throws TException {
        this.runWithHandle(() -> this.delegate.createRole(role, grantor));
    }

    @Override
    public void dropRole(String role) throws TException {
        this.runWithHandle(() -> this.delegate.dropRole(role));
    }

    @Override
    public boolean grantPrivileges(PrivilegeBag privilegeBag) throws TException {
        return this.runWithHandle(() -> this.delegate.grantPrivileges(privilegeBag));
    }

    @Override
    public boolean revokePrivileges(PrivilegeBag privilegeBag, boolean grantOption) throws TException {
        return this.runWithHandle(() -> this.delegate.revokePrivileges(privilegeBag, grantOption));
    }

    @Override
    public void grantRole(String role, String granteeName, PrincipalType granteeType, String grantorName, PrincipalType grantorType, boolean grantOption) throws TException {
        this.runWithHandle(() -> this.delegate.grantRole(role, granteeName, granteeType, grantorName, grantorType, grantOption));
    }

    @Override
    public void revokeRole(String role, String granteeName, PrincipalType granteeType, boolean grantOption) throws TException {
        this.runWithHandle(() -> this.delegate.revokeRole(role, granteeName, granteeType, grantOption));
    }

    @Override
    public List<RolePrincipalGrant> listRoleGrants(String name, PrincipalType principalType) throws TException {
        return this.runWithHandle(() -> this.delegate.listRoleGrants(name, principalType));
    }

    @Override
    public void setUGI(String userName) throws TException {
        this.runWithHandle(() -> this.delegate.setUGI(userName));
    }

    @Override
    public long openTransaction(String user) throws TException {
        return this.runWithHandle(() -> this.delegate.openTransaction(user));
    }

    @Override
    public void commitTransaction(long transactionId) throws TException {
        this.runWithHandle(() -> this.delegate.commitTransaction(transactionId));
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) throws TException {
        this.runWithHandle(() -> this.delegate.sendTransactionHeartbeat(transactionId));
    }

    @Override
    public LockResponse acquireLock(LockRequest lockRequest) throws TException {
        return this.runWithHandle(() -> this.delegate.acquireLock(lockRequest));
    }

    @Override
    public LockResponse checkLock(long lockId) throws TException {
        return this.runWithHandle(() -> this.delegate.checkLock(lockId));
    }

    @Override
    public void unlock(long lockId) throws TException {
        this.runWithHandle(() -> this.delegate.unlock(lockId));
    }

    @Override
    public String getValidWriteIds(List<String> tableList, long currentTransactionId) throws TException {
        return this.runWithHandle(() -> this.delegate.getValidWriteIds(tableList, currentTransactionId));
    }

    @Override
    public String getConfigValue(String name, String defaultValue) throws TException {
        return this.runWithHandle(() -> this.delegate.getConfigValue(name, defaultValue));
    }

    @Override
    public String getDelegationToken(String userName) throws TException {
        return this.runWithHandle(() -> this.delegate.getDelegationToken(userName));
    }

    @Override
    public void abortTransaction(long transactionId) throws TException {
        this.runWithHandle(() -> this.delegate.abortTransaction(transactionId));
    }

    @Override
    public List<TxnToWriteId> allocateTableWriteIds(String database, String tableName, List<Long> transactionIds) throws TException {
        return this.runWithHandle(() -> this.delegate.allocateTableWriteIds(database, tableName, transactionIds));
    }

    @Override
    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) throws TException {
        this.runWithHandle(() -> this.delegate.alterPartitions(dbName, tableName, partitions, writeId));
    }

    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) throws TException {
        this.runWithHandle(() -> this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation));
    }

    @Override
    public void alterTransactionalTable(Table table, long transactionId, long writeId, EnvironmentContext context) throws TException {
        this.runWithHandle(() -> this.delegate.alterTransactionalTable(table, transactionId, writeId, context));
    }

    @Override
    public Function getFunction(String databaseName, String functionName) throws TException {
        return this.runWithHandle(() -> this.delegate.getFunction(databaseName, functionName));
    }

    @Override
    public Collection<String> getFunctions(String databaseName, String functionNamePattern) throws TException {
        return this.runWithHandle(() -> this.delegate.getFunctions(databaseName, functionNamePattern));
    }

    @Override
    public void createFunction(Function function) throws TException {
        this.runWithHandle(() -> this.delegate.createFunction(function));
    }

    @Override
    public void alterFunction(Function function) throws TException {
        this.runWithHandle(() -> this.delegate.alterFunction(function));
    }

    @Override
    public void dropFunction(String databaseName, String functionName) throws TException {
        this.runWithHandle(() -> this.delegate.dropFunction(databaseName, functionName));
    }

    private <T> T runWithHandle(ThrowingSupplier<T> supplier) throws TException {
        try {
            T result = supplier.get();
            this.callback.success();
            return result;
        }
        catch (TException thriftException) {
            try {
                this.callback.failed(thriftException);
            }
            catch (RuntimeException callbackException) {
                callbackException.addSuppressed(thriftException);
                throw callbackException;
            }
            throw thriftException;
        }
    }

    private void runWithHandle(ThrowingRunnable runnable) throws TException {
        try {
            runnable.run();
            this.callback.success();
        }
        catch (TException thriftException) {
            try {
                this.callback.failed(thriftException);
            }
            catch (RuntimeException callbackException) {
                callbackException.addSuppressed(thriftException);
                throw callbackException;
            }
            throw thriftException;
        }
    }

    public static interface Callback {
        public void success();

        public void failed(TException var1);
    }

    private static interface ThrowingSupplier<T> {
        public T get() throws TException;
    }

    private static interface ThrowingRunnable {
        public void run() throws TException;
    }
}

