/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SyncPartitionMetadataProcedure
implements Provider<Procedure> {
    private static final MethodHandle SYNC_PARTITION_METADATA;
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public SyncPartitionMetadataProcedure(TransactionalMetadataFactory hiveMetadataFactory, TrinoFileSystemFactory fileSystemFactory) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    public Procedure get() {
        return new Procedure("system", "sync_partition_metadata", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("MODE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("CASE_SENSITIVE", (Type)BooleanType.BOOLEAN, false, (Object)Boolean.TRUE)), SYNC_PARTITION_METADATA.bindTo(this));
    }

    public void syncPartitionMetadata(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, String mode, boolean caseSensitive) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doSyncPartitionMetadata(session, accessControl, schemaName, tableName, mode, caseSensitive);
        }
    }

    private void doSyncPartitionMetadata(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, String mode, boolean caseSensitive) {
        Procedures.checkProcedureArgument((schemaName != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((tableName != null ? 1 : 0) != 0, (String)"table_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((mode != null ? 1 : 0) != 0, (String)"mode cannot be null", (Object[])new Object[0]);
        SyncMode syncMode = SyncPartitionMetadataProcedure.toSyncMode(mode);
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.create(session.getIdentity(), true);
        hiveMetadata.beginQuery(session);
        try (UncheckedCloseable ignore = () -> hiveMetadata.cleanupQuery(session);){
            SemiTransactionalHiveMetastore metastore = hiveMetadata.getMetastore();
            SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
            Table table = metastore.getTable(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            if (table.getPartitionColumns().isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is not partitioned: " + String.valueOf(schemaTableName));
            }
            if (syncMode == SyncMode.ADD || syncMode == SyncMode.FULL) {
                accessControl.checkCanInsertIntoTable(null, new SchemaTableName(schemaName, tableName));
            }
            if (syncMode == SyncMode.DROP || syncMode == SyncMode.FULL) {
                accessControl.checkCanDeleteFromTable(null, new SchemaTableName(schemaName, tableName));
            }
            Location tableLocation = Location.of((String)table.getStorage().getLocation());
            Set partitionsInMetastore = (Set)metastore.getPartitionNames(schemaName, tableName).map(ImmutableSet::copyOf).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            Set<String> partitionsInFileSystem = SyncPartitionMetadataProcedure.listPartitions(this.fileSystemFactory.create(session), tableLocation, table.getPartitionColumns(), caseSensitive);
            Sets.SetView partitionsToAdd = Sets.difference(partitionsInFileSystem, (Set)partitionsInMetastore);
            Sets.SetView partitionsToDrop = Sets.difference((Set)partitionsInMetastore, partitionsInFileSystem);
            SyncPartitionMetadataProcedure.syncPartitions((Set<String>)partitionsToAdd, (Set<String>)partitionsToDrop, syncMode, metastore, session, table);
        }
    }

    private static Set<String> listPartitions(TrinoFileSystem fileSystem, Location directory, List<Column> partitionColumns, boolean caseSensitive) {
        return SyncPartitionMetadataProcedure.doListPartitions(fileSystem, directory, partitionColumns, partitionColumns.size(), caseSensitive, (List<String>)ImmutableList.of());
    }

    private static Set<String> doListPartitions(TrinoFileSystem fileSystem, Location directory, List<Column> partitionColumns, int depth, boolean caseSensitive, List<String> partitions) {
        if (depth == 0) {
            return ImmutableSet.of((Object)String.join((CharSequence)"/", partitions));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Location location : SyncPartitionMetadataProcedure.listDirectories(fileSystem, directory)) {
            Column column;
            String path = SyncPartitionMetadataProcedure.listedDirectoryName(directory, location);
            if (!SyncPartitionMetadataProcedure.isValidPartitionPath(path, column = partitionColumns.get(partitionColumns.size() - depth), caseSensitive)) continue;
            ImmutableList current = ImmutableList.builder().addAll(partitions).add((Object)path).build();
            result.addAll(SyncPartitionMetadataProcedure.doListPartitions(fileSystem, location, partitionColumns, depth - 1, caseSensitive, (List<String>)current));
        }
        return result.build();
    }

    private static Set<Location> listDirectories(TrinoFileSystem fileSystem, Location directory) {
        try {
            return fileSystem.listDirectories(directory);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    private static String listedDirectoryName(Location directory, Location location) {
        Object prefix = directory.path();
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        String path = location.path();
        Verify.verify((boolean)path.endsWith("/"), (String)"path does not end with slash: %s", (Object)location);
        Verify.verify((boolean)path.startsWith((String)prefix), (String)"path [%s] is not a child of directory [%s]", (Object)location, (Object)directory);
        return path.substring(((String)prefix).length(), path.length() - 1);
    }

    private static boolean isValidPartitionPath(String path, Column column, boolean caseSensitive) {
        if (!caseSensitive) {
            path = path.toLowerCase(Locale.ENGLISH);
        }
        return path.startsWith(column.getName() + "=");
    }

    private static void syncPartitions(Set<String> partitionsToAdd, Set<String> partitionsToDrop, SyncMode syncMode, SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        if (syncMode == SyncMode.ADD || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.addPartitions(metastore, session, table, partitionsToAdd);
        }
        if (syncMode == SyncMode.DROP || syncMode == SyncMode.FULL) {
            SyncPartitionMetadataProcedure.dropPartitions(metastore, session, table, partitionsToDrop);
        }
        metastore.commit();
    }

    private static void addPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.addPartition(session, table.getDatabaseName(), table.getTableName(), SyncPartitionMetadataProcedure.buildPartitionObject(session, table, name), Location.of((String)table.getStorage().getLocation()).appendPath(name), Optional.empty(), PartitionStatistics.empty(), false);
        }
    }

    private static void dropPartitions(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, Set<String> partitions) {
        for (String name : partitions) {
            metastore.dropPartition(session, table.getDatabaseName(), table.getTableName(), HivePartitionManager.extractPartitionValues(name), false);
        }
    }

    private static Partition buildPartitionObject(ConnectorSession session, Table table, String partitionName) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionName)).setParameters((Map<String, String>)ImmutableMap.of((Object)"trino_query_id", (Object)session.getQueryId())).withStorage(storage -> storage.setStorageFormat(table.getStorage().getStorageFormat()).setLocation(Location.of((String)table.getStorage().getLocation()).appendPath(partitionName).toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private static SyncMode toSyncMode(String mode) {
        try {
            return SyncMode.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Invalid partition metadata sync mode: " + mode);
        }
    }

    static {
        try {
            SYNC_PARTITION_METADATA = MethodHandles.lookup().unreflect(SyncPartitionMetadataProcedure.class.getMethod("syncPartitionMetadata", ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, String.class, Boolean.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum SyncMode {
        ADD,
        DROP,
        FULL;

    }
}

