/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.lang.reflect.Constructor;
import java.util.Objects;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.reflect.InstanceFactory;

class ConstructorInstanceFactory<T>
extends InstanceFactory<T> {
    private final Constructor<T> constructor;

    ConstructorInstanceFactory(Constructor<T> constructor) {
        super(constructor);
        this.constructor = Objects.requireNonNull(constructor, "constructor is null");
    }

    @Override
    T newInstance(Object ... params) {
        return (T)Unchecked.function(this.constructor::newInstance).apply(params);
    }

    @Override
    public String toString() {
        return this.constructor.toString();
    }
}

