/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.filesystem.gcs.GcsFileSystemConfig;
import io.trino.spi.security.ConnectorIdentity;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.threeten.bp.Duration;

public class GcsStorageFactory {
    public static final String GCS_OAUTH_KEY = "gcs.oauth";
    public static final List<String> DEFAULT_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private final String projectId;
    private final boolean useGcsAccessToken;
    private final Optional<GoogleCredentials> jsonGoogleCredential;
    private final int maxRetries;
    private final double backoffScaleFactor;
    private final Duration maxRetryTime;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;

    @Inject
    public GcsStorageFactory(GcsFileSystemConfig config) throws IOException {
        config.validate();
        this.projectId = config.getProjectId();
        this.useGcsAccessToken = config.isUseGcsAccessToken();
        String jsonKey = config.getJsonKey();
        String jsonKeyFilePath = config.getJsonKeyFilePath();
        if (jsonKey != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonKey.getBytes(StandardCharsets.UTF_8));){
                this.jsonGoogleCredential = Optional.of(GoogleCredentials.fromStream((InputStream)inputStream).createScoped(DEFAULT_SCOPES));
            }
        } else if (jsonKeyFilePath != null) {
            try (FileInputStream inputStream = new FileInputStream(jsonKeyFilePath);){
                this.jsonGoogleCredential = Optional.of(GoogleCredentials.fromStream((InputStream)inputStream).createScoped(DEFAULT_SCOPES));
            }
        } else {
            this.jsonGoogleCredential = Optional.empty();
        }
        this.maxRetries = config.getMaxRetries();
        this.backoffScaleFactor = config.getBackoffScaleFactor();
        this.maxRetryTime = Duration.ofMillis((long)config.getMaxRetryTime().toMillis());
        this.minBackoffDelay = Duration.ofMillis((long)config.getMinBackoffDelay().toMillis());
        this.maxBackoffDelay = Duration.ofMillis((long)config.getMaxBackoffDelay().toMillis());
    }

    public Storage create(ConnectorIdentity identity) {
        try {
            GoogleCredentials credentials;
            if (this.useGcsAccessToken) {
                String accessToken = Strings.nullToEmpty((String)((String)identity.getExtraCredentials().get(GCS_OAUTH_KEY)));
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(accessToken.getBytes(StandardCharsets.UTF_8));){
                    credentials = GoogleCredentials.fromStream((InputStream)inputStream).createScoped(DEFAULT_SCOPES);
                }
            } else {
                credentials = this.jsonGoogleCredential.orElseThrow(() -> new VerifyException("GCS credentials not configured"));
            }
            StorageOptions.Builder storageOptionsBuilder = StorageOptions.newBuilder();
            if (this.projectId != null) {
                storageOptionsBuilder.setProjectId(this.projectId);
            }
            return (Storage)((StorageOptions.Builder)((StorageOptions.Builder)storageOptionsBuilder.setCredentials((Credentials)credentials)).setStorageRetryStrategy(StorageRetryStrategy.getUniformStorageRetryStrategy()).setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(this.maxRetries + 1).setRetryDelayMultiplier(this.backoffScaleFactor).setTotalTimeout(this.maxRetryTime).setInitialRetryDelay(this.minBackoffDelay).setMaxRetryDelay(this.maxBackoffDelay).build())).build().getService();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

