/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.QualifiedName;
import com.linkedin.coral.$internal.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowColumns
extends Statement {
    private final QualifiedName table;
    private final Optional<String> likePattern;
    private final Optional<String> escape;

    public ShowColumns(QualifiedName table, Optional<String> likePattern, Optional<String> escape) {
        this(Optional.empty(), table, likePattern, escape);
    }

    public ShowColumns(NodeLocation location, QualifiedName table, Optional<String> likePattern, Optional<String> escape) {
        this(Optional.of(location), table, likePattern, escape);
    }

    private ShowColumns(Optional<NodeLocation> location, QualifiedName table, Optional<String> likePattern, Optional<String> escape) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.likePattern = Objects.requireNonNull(likePattern, "likePattern is null");
        this.escape = Objects.requireNonNull(escape, "escape is null");
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    public Optional<String> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowColumns(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.likePattern, this.escape);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowColumns o = (ShowColumns)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.likePattern, o.likePattern) && Objects.equals(this.escape, o.escape);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("table", this.table).add("likePattern", this.likePattern).add("escape", this.escape).toString();
    }
}

