/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.Deadline;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.MetaStoreInit;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.RawStore;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.utils.JavaUtils;
import com.linkedin.coral.calcite.$internal.org.apache.commons.lang.ClassUtils;
import com.linkedin.coral.hive.metastore.api.MetaException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@.InterfaceAudience.Private
@.InterfaceStability.Evolving
public class RawStoreProxy
implements InvocationHandler {
    private final RawStore base;
    private final MetaStoreInit.MetaStoreInitData metaStoreInitData = new MetaStoreInit.MetaStoreInitData();
    private final Configuration hiveConf;
    private final Configuration conf;
    private final long socketTimeout;

    protected RawStoreProxy(Configuration hiveConf, Configuration conf, Class<? extends RawStore> rawStoreClass, int id) throws MetaException {
        this.conf = conf;
        this.hiveConf = hiveConf;
        this.socketTimeout = .MetastoreConf.getTimeVar((Configuration)hiveConf, (.MetastoreConf.ConfVars).MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        this.init();
        this.base = (RawStore).ReflectionUtils.newInstance(rawStoreClass, (Configuration)conf);
    }

    public static RawStore getProxy(Configuration hiveConf, Configuration conf, String rawStoreClassName, int id) throws MetaException {
        Class<RawStore> baseClass = JavaUtils.getClass(rawStoreClassName, RawStore.class);
        RawStoreProxy handler = new RawStoreProxy(hiveConf, conf, baseClass, id);
        return (RawStore)Proxy.newProxyInstance(RawStoreProxy.class.getClassLoader(), RawStoreProxy.getAllInterfaces(baseClass), (InvocationHandler)handler);
    }

    private static Class<?>[] getAllInterfaces(Class<?> baseClass) {
        List interfaces = ClassUtils.getAllInterfaces(baseClass);
        Class[] result = new Class[interfaces.size()];
        int i = 0;
        for (Object o : interfaces) {
            result[i++] = (Class)o;
        }
        return result;
    }

    private void init() throws MetaException {
        MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), null, this.metaStoreInitData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        block7: {
            Deadline.registerIfNot(this.socketTimeout);
            boolean isTimerStarted = Deadline.startTimer(method.getName());
            try {
                object = method.invoke((Object)this.base, args);
                if (!isTimerStarted) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (isTimerStarted) {
                        Deadline.stopTimer();
                    }
                    throw throwable;
                }
                catch (UndeclaredThrowableException e) {
                    throw e.getCause();
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            Deadline.stopTimer();
        }
        return object;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

