/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ogc;

import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Geometry;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.GeometryEngine;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Operator;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.OperatorExportToGeoJson;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.OperatorExportToWkb;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.OperatorFactoryLocal;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Polygon;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.Polyline;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.SpatialReference;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ogc.OGCGeometry;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ogc.OGCMultiCurve;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ogc.OGCMultiSurface;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ogc.OGCPolygon;
import java.nio.ByteBuffer;

public class OGCMultiPolygon
extends OGCMultiSurface {
    public static String TYPE = "MultiPolygon";
    Polygon polygon;

    public OGCMultiPolygon(Polygon src, SpatialReference sr) {
        this.polygon = src;
        this.esriSR = sr;
    }

    public OGCMultiPolygon(SpatialReference sr) {
        this.polygon = new Polygon();
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 32);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(32, this.getEsriGeometry(), null);
    }

    @Override
    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(1, null, this.getEsriGeometry());
    }

    @Override
    public int numGeometries() {
        return this.polygon.getExteriorRingCount();
    }

    @Override
    public OGCGeometry geometryN(int n) {
        int exterior = 0;
        for (int i = 0; i < this.polygon.getPathCount(); ++i) {
            if (this.polygon.isExteriorRing(i)) {
                ++exterior;
            }
            if (exterior != n + 1) continue;
            return new OGCPolygon(this.polygon, i, this.esriSR);
        }
        throw new IllegalArgumentException("geometryN: n out of range");
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.polygon != null ? this.polygon.estimateMemorySize() : 0L);
    }

    @Override
    public OGCGeometry boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCGeometry.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        int n = this.numGeometries();
        if (n == 0) {
            return new OGCPolygon(new Polygon(this.polygon.getDescription()), 0, this.esriSR);
        }
        if (n == 1) {
            return this.geometryN(0);
        }
        return this;
    }
}

