/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUncollect
extends Uncollect {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveUncollect.class);

    public HiveUncollect(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean withOrdinality) {
        super(cluster, traitSet, input, withOrdinality);
    }

    public HiveUncollect(RelInput input) {
        super(input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        HiveUncollect result = new HiveUncollect(this.getCluster(), traitSet, input, this.withOrdinality);
        result.rowType = this.rowType;
        return result;
    }

    public RelNode copy(RelDataType rowType) {
        assert (this.traitSet.containsIfApplicable(Convention.NONE));
        HiveUncollect result = new HiveUncollect(this.getCluster(), this.traitSet, this.input, this.withOrdinality);
        result.rowType = rowType;
        return result;
    }

    @Override
    protected RelDataType deriveRowType() {
        if (this.rowType != null) {
            return this.rowType;
        }
        RelDataType inputType = this.input.getRowType();
        assert (inputType.isStruct()) : inputType + " is not a struct";
        List<RelDataTypeField> fields = inputType.getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.input.getCluster().getTypeFactory().builder();
        for (RelDataTypeField field : fields) {
            if (field.getType() instanceof MapSqlType) {
                ((RelDataTypeFactory.Builder)builder).add("KEY", field.getType().getKeyType());
                ((RelDataTypeFactory.Builder)builder).add("VALUE", field.getType().getValueType());
                continue;
            }
            RelDataType ret = field.getType().getComponentType();
            ((RelDataTypeFactory.Builder)builder).add(field.getName(), ret);
        }
        if (this.withOrdinality) {
            ((RelDataTypeFactory.Builder)builder).add("ORDINALITY", SqlTypeName.INTEGER);
        }
        return builder.build();
    }
}

