/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.StageInfo;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputStream;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.operator.OperatorStats;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTablePartitioning;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.security.AccessControl;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.testing.sql.TestTable;
import io.trino.transaction.TransactionManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.util.JsonUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class BaseIcebergConnectorTest
extends BaseConnectorTest {
    private static final Pattern WITH_CLAUSE_EXTRACTOR = Pattern.compile(".*(WITH\\s*\\([^)]*\\))\\s*$", 32);
    protected final IcebergFileFormat format;
    protected TrinoFileSystem fileSystem;
    protected TimeUnit storageTimePrecision;

    protected BaseIcebergConnectorTest(IcebergFileFormat format) {
        this.format = Objects.requireNonNull(format, "format is null");
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return this.createQueryRunnerBuilder().build();
    }

    protected IcebergQueryRunner.Builder createQueryRunnerBuilder() {
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.allowed-extra-properties", (Object)"extra.property.one,extra.property.two,extra.property.three,sorted_by").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").buildOrThrow()).setInitialTables(REQUIRED_TPCH_TABLES);
    }

    @BeforeAll
    public void initFileSystem() {
        this.fileSystem = IcebergTestUtils.getFileSystemFactory((QueryRunner)this.getDistributedQueryRunner()).create(TestingConnectorSession.SESSION);
    }

    @BeforeAll
    public void initStorageTimePrecision() {
        try (TestTable table = this.newTrinoTable("inspect_storage_precision", "(i int)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3)", 1L);
            long countWithSecondFraction = (Long)this.computeScalar("SELECT count(*) FILTER (WHERE \"$file_modified_time\" != date_trunc('second', \"$file_modified_time\")) FROM " + table.getName());
            this.storageTimePrecision = countWithSecondFraction == 0L ? TimeUnit.SECONDS : TimeUnit.MILLISECONDS;
        }
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE, TestingConnectorBehavior.SUPPORTS_REPORTING_WRITTEN_BYTES -> true;
            case TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_NOT_NULL_CONSTRAINT, TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW_ACROSS_SCHEMAS, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testAddRowFieldCaseInsensitivity() {
        try (TestTable table = this.newTrinoTable("test_add_row_field_case_insensitivity_", "AS SELECT CAST(row(row(2)) AS row(\"CHILD\" row(grandchild_1 integer))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(CHILD row(grandchild_1 integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.child.grandchild_2 integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(CHILD row(grandchild_1 integer, grandchild_2 integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.CHILD.grandchild_3 integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(CHILD row(grandchild_1 integer, grandchild_2 integer, grandchild_3 integer))");
        }
    }

    protected void verifyVersionedQueryFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Version pointer type is not supported: .*|Unsupported type for temporal table version: .*|Unsupported type for table version: .*|No version history table tpch.nation at or before .*|Iceberg snapshot ID does not exists: .*|Cannot find snapshot with reference name: .*");
    }

    protected void verifyConcurrentUpdateFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Failed to commit the transaction during write.*|Failed to commit during write.*");
    }

    protected void verifyConcurrentAddColumnFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessageStartingWith("Failed to add column: Failed to replace table due to concurrent updates").rootCause().hasMessageContaining("Cannot update Iceberg table: supplied previous location does not match current location");
    }

    @Test
    public void testDeleteOnV1Table() {
        try (TestTable table = this.newTrinoTable("test_delete_", "WITH (format_version = 1) AS SELECT * FROM orders");){
            this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE custkey <= 100", "Iceberg table updates require at least format version 2");
        }
    }

    @Test
    public void testDeleteOnV1TableWhenManifestFileIsNotExist() {
        try (TestTable table = this.newTrinoTable("test_delete_", "(a bigint, dt date) WITH (format_version = 1, partitioning = ARRAY['dt'])");){
            this.assertQuerySucceeds("DELETE FROM " + table.getName() + " WHERE dt = date '2025-02-17'");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
        }
    }

    @Test
    public void testCharVarcharComparison() {
        try (TestTable table = this.newTrinoTable("test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS CHAR(3))),    (3, CAST('   ' AS CHAR(3))),   (6, CAST('x  ' AS CHAR(3)))");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(2))"))).returnsEmptyResult();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('    ' AS varchar(4))"))).returnsEmptyResult();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))"))).returnsEmptyResult();
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('   ' AS varchar(3))", "VALUES (3, '   ')");
        }
    }

    @Test
    public void testShowCreateSchema() {
        Assertions.assertThat((String)this.computeActual("SHOW CREATE SCHEMA tpch").getOnlyValue().toString()).matches((CharSequence)"CREATE SCHEMA iceberg.tpch\nAUTHORIZATION USER user\nWITH \\(\n\\s+location = '.*/tpch'\n\\)");
    }

    protected MaterializedResult getDescribeOrdersResult() {
        return MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)("\\QCREATE TABLE iceberg.tpch.orders (\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar,\n   totalprice double,\n   orderdate date,\n   orderpriority varchar,\n   clerk varchar,\n   shippriority integer,\n   comment varchar\n)\nWITH (\n   format = '" + this.format.name() + "',\n   format_version = 2,\n   location = '\\E.*/tpch/orders-.*\\Q',\n   max_commit_retry = 4\n)\\E"));
    }

    @Test
    public void testPartitionedByRealWithNaN() {
        String tableName = "test_partitioned_by_real" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH(partitioning = ARRAY['part']) AS SELECT 1 AS id, real 'NaN' AS part", 1L);
        this.assertQuery("SELECT part FROM " + tableName, "VALUES cast('NaN' as real)");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE is_nan(part)", "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionedByDoubleWithNaN() {
        String tableName = "test_partitioned_by_double" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH(partitioning = ARRAY['part']) AS SELECT 1 AS id, double 'NaN' AS part", 1L);
        this.assertQuery("SELECT part FROM " + tableName, "VALUES cast('NaN' as double)");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE is_nan(part)", "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDecimal() {
        this.testDecimalWithPrecisionAndScale(1, 0);
        this.testDecimalWithPrecisionAndScale(8, 6);
        this.testDecimalWithPrecisionAndScale(9, 8);
        this.testDecimalWithPrecisionAndScale(10, 8);
        this.testDecimalWithPrecisionAndScale(18, 1);
        this.testDecimalWithPrecisionAndScale(18, 8);
        this.testDecimalWithPrecisionAndScale(18, 17);
        this.testDecimalWithPrecisionAndScale(17, 16);
        this.testDecimalWithPrecisionAndScale(18, 17);
        this.testDecimalWithPrecisionAndScale(24, 10);
        this.testDecimalWithPrecisionAndScale(30, 10);
        this.testDecimalWithPrecisionAndScale(37, 26);
        this.testDecimalWithPrecisionAndScale(38, 37);
        this.testDecimalWithPrecisionAndScale(38, 17);
        this.testDecimalWithPrecisionAndScale(38, 37);
    }

    private void testDecimalWithPrecisionAndScale(int precision, int scale) {
        Preconditions.checkArgument((precision >= 1 && precision <= 38 ? 1 : 0) != 0, (String)"Decimal precision (%s) must be between 1 and 38 inclusive", (int)precision);
        Preconditions.checkArgument((scale < precision && scale >= 0 ? 1 : 0) != 0, (String)"Decimal scale (%s) must be less than the precision (%s) and non-negative", (int)scale, (int)precision);
        String decimalType = String.format("DECIMAL(%d,%d)", precision, scale);
        String beforeTheDecimalPoint = "12345678901234567890123456789012345678".substring(0, precision - scale);
        String afterTheDecimalPoint = "09876543210987654321098765432109876543".substring(0, scale);
        String decimalValue = String.format("%s.%s", beforeTheDecimalPoint, afterTheDecimalPoint);
        this.assertUpdate(String.format("CREATE TABLE test_iceberg_decimal (x %s)", decimalType));
        this.assertUpdate(String.format("INSERT INTO test_iceberg_decimal (x) VALUES (CAST('%s' AS %s))", decimalValue, decimalType), 1L);
        this.assertQuery("SELECT * FROM test_iceberg_decimal", String.format("SELECT CAST('%s' AS %s)", decimalValue, decimalType));
        this.assertUpdate("DROP TABLE test_iceberg_decimal");
    }

    @Test
    public void testTime() {
        this.testSelectOrPartitionedByTime(false);
    }

    @Test
    public void testPartitionedByTime() {
        this.testSelectOrPartitionedByTime(true);
    }

    private void testSelectOrPartitionedByTime(boolean partitioned) {
        String tableName = String.format("test_%s_by_time", partitioned ? "partitioned" : "selected");
        String partitioning = partitioned ? "WITH(partitioning = ARRAY['x'])" : "";
        this.assertUpdate(String.format("CREATE TABLE %s (x TIME(6), y BIGINT) %s", tableName, partitioning));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (TIME '10:12:34', 12345)", tableName), 1L);
        this.assertQuery(String.format("SELECT COUNT(*) FROM %s", tableName), "SELECT 1");
        this.assertQuery(String.format("SELECT x FROM %s", tableName), "SELECT CAST('10:12:34' AS TIME)");
        this.assertUpdate(String.format("INSERT INTO %s VALUES (TIME '9:00:00', 67890)", tableName), 1L);
        this.assertQuery(String.format("SELECT COUNT(*) FROM %s", tableName), "SELECT 2");
        this.assertQuery(String.format("SELECT x FROM %s WHERE x = TIME '10:12:34'", tableName), "SELECT CAST('10:12:34' AS TIME)");
        this.assertQuery(String.format("SELECT x FROM %s WHERE x = TIME '9:00:00'", tableName), "SELECT CAST('9:00:00' AS TIME)");
        this.assertQuery(String.format("SELECT x FROM %s WHERE y = 12345", tableName), "SELECT CAST('10:12:34' AS TIME)");
        this.assertQuery(String.format("SELECT x FROM %s WHERE y = 67890", tableName), "SELECT CAST('9:00:00' AS TIME)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionByTimestamp() {
        this.testSelectOrPartitionedByTimestamp(true);
    }

    @Test
    public void testSelectByTimestamp() {
        this.testSelectOrPartitionedByTimestamp(false);
    }

    private void testSelectOrPartitionedByTimestamp(boolean partitioned) {
        String tableName = String.format("test_%s_by_timestamp", partitioned ? "partitioned" : "selected");
        this.assertUpdate(String.format("CREATE TABLE %s (_timestamp timestamp(6)) %s", tableName, partitioned ? "WITH (partitioning = ARRAY['_timestamp'])" : ""));
        String select1 = "SELECT TIMESTAMP '2017-05-01 10:12:34' _timestamp";
        String select2 = "SELECT TIMESTAMP '2017-10-01 10:12:34' _timestamp";
        String select3 = "SELECT TIMESTAMP '2018-05-01 10:12:34' _timestamp";
        this.assertUpdate(String.format("INSERT INTO %s %s", tableName, select1), 1L);
        this.assertUpdate(String.format("INSERT INTO %s %s", tableName, select2), 1L);
        this.assertUpdate(String.format("INSERT INTO %s %s", tableName, select3), 1L);
        this.assertQuery(String.format("SELECT COUNT(*) from %s", tableName), "SELECT 3");
        this.assertQuery(String.format("SELECT * from %s WHERE _timestamp = TIMESTAMP '2017-05-01 10:12:34'", tableName), select1);
        this.assertQuery(String.format("SELECT * from %s WHERE _timestamp < TIMESTAMP '2017-06-01 10:12:34'", tableName), select1);
        this.assertQuery(String.format("SELECT * from %s WHERE _timestamp = TIMESTAMP '2017-10-01 10:12:34'", tableName), select2);
        this.assertQuery(String.format("SELECT * from %s WHERE _timestamp > TIMESTAMP '2017-06-01 10:12:34' AND _timestamp < TIMESTAMP '2018-05-01 10:12:34'", tableName), select2);
        this.assertQuery(String.format("SELECT * from %s WHERE _timestamp = TIMESTAMP '2018-05-01 10:12:34'", tableName), select3);
        this.assertQuery(String.format("SELECT * from %s WHERE _timestamp > TIMESTAMP '2018-01-01 10:12:34'", tableName), select3);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionByTimestampWithTimeZone() {
        this.testSelectOrPartitionedByTimestampWithTimeZone(true);
    }

    @Test
    public void testSelectByTimestampWithTimeZone() {
        this.testSelectOrPartitionedByTimestampWithTimeZone(false);
    }

    private void testSelectOrPartitionedByTimestampWithTimeZone(boolean partitioned) {
        String tableName = String.format("test_%s_by_timestamptz", partitioned ? "partitioned" : "selected");
        this.assertUpdate(String.format("CREATE TABLE %s (_timestamptz timestamp(6) with time zone) %s", tableName, partitioned ? "WITH (partitioning = ARRAY['_timestamptz'])" : ""));
        String instant1Utc = "TIMESTAMP '2021-10-31 00:30:00.005000 UTC'";
        String instant1La = "TIMESTAMP '2021-10-30 17:30:00.005000 America/Los_Angeles'";
        String instant2Utc = "TIMESTAMP '2021-10-31 00:30:00.006000 UTC'";
        String instant2La = "TIMESTAMP '2021-10-30 17:30:00.006000 America/Los_Angeles'";
        String instant3Utc = "TIMESTAMP '2021-10-31 00:30:00.007000 UTC'";
        String instant3La = "TIMESTAMP '2021-10-30 17:30:00.007000 America/Los_Angeles'";
        String instant4Utc = "TIMESTAMP '1969-12-01 05:06:07.234567 UTC'";
        this.assertUpdate(String.format("INSERT INTO %s VALUES %s", tableName, instant1Utc), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES %s", tableName, instant2La), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES %s", tableName, instant3Utc), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES %s", tableName, instant4Utc), 1L);
        this.assertQuery(String.format("SELECT COUNT(*) from %s", tableName), "SELECT 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz = %s", tableName, instant1Utc)))).matches("VALUES " + instant1Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz = %s", tableName, instant1La)))).matches("VALUES " + instant1Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz = %s", tableName, instant2Utc)))).matches("VALUES " + instant2Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz = %s", tableName, instant2La)))).matches("VALUES " + instant2Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz = %s", tableName, instant3Utc)))).matches("VALUES " + instant3Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz = %s", tableName, instant3La)))).matches("VALUES " + instant3Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz = %s", tableName, instant4Utc)))).matches("VALUES " + instant4Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz < %s", tableName, instant2Utc)))).matches(String.format("VALUES %s, %s", instant1Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz < %s", tableName, instant2La)))).matches(String.format("VALUES %s, %s", instant1Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz < %s", tableName, instant3Utc)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant2Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz < %s", tableName, instant3La)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant2Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz <= %s", tableName, instant2Utc)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant2Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz <= %s", tableName, instant2La)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant2Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz > %s", tableName, instant2Utc)))).matches("VALUES " + instant3Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz > %s", tableName, instant2La)))).matches("VALUES " + instant3Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz > %s", tableName, instant1Utc)))).matches(String.format("VALUES %s, %s", instant2Utc, instant3Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz > %s", tableName, instant1La)))).matches(String.format("VALUES %s, %s", instant2Utc, instant3Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz >= %s", tableName, instant2Utc)))).matches(String.format("VALUES %s, %s", instant2Utc, instant3Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz >= %s", tableName, instant2La)))).matches(String.format("VALUES %s, %s", instant2Utc, instant3Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz > %s AND _timestamptz < %s", tableName, instant1Utc, instant3Utc)))).matches("VALUES " + instant2Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz > %s AND _timestamptz < %s", tableName, instant1La, instant3La)))).matches("VALUES " + instant2Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz BETWEEN %s AND %s", tableName, instant1Utc, instant2Utc)))).matches(String.format("VALUES %s, %s", instant1Utc, instant2Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz BETWEEN %s AND %s", tableName, instant1La, instant2La)))).matches(String.format("VALUES %s, %s", instant1Utc, instant2Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz != %s", tableName, instant1Utc)))).matches(String.format("VALUES %s, %s, %s", instant2Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz != %s", tableName, instant1La)))).matches(String.format("VALUES %s, %s, %s", instant2Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz != %s", tableName, instant2Utc)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz != %s", tableName, instant2La)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz != %s", tableName, instant4Utc)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant2Utc, instant3Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS DISTINCT FROM %s", tableName, instant1Utc)))).matches(String.format("VALUES %s, %s, %s", instant2Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS DISTINCT FROM %s", tableName, instant1La)))).matches(String.format("VALUES %s, %s, %s", instant2Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS DISTINCT FROM %s", tableName, instant2Utc)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS DISTINCT FROM %s", tableName, instant2La)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant3Utc, instant4Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS DISTINCT FROM %s", tableName, instant4Utc)))).matches(String.format("VALUES %s, %s, %s", instant1Utc, instant2Utc, instant3Utc));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS NOT DISTINCT FROM %s", tableName, instant1Utc)))).matches("VALUES " + instant1Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS NOT DISTINCT FROM %s", tableName, instant1La)))).matches("VALUES " + instant1Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS NOT DISTINCT FROM %s", tableName, instant2Utc)))).matches("VALUES " + instant2Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS NOT DISTINCT FROM %s", tableName, instant2La)))).matches("VALUES " + instant2Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS NOT DISTINCT FROM %s", tableName, instant3Utc)))).matches("VALUES " + instant3Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS NOT DISTINCT FROM %s", tableName, instant3La)))).matches("VALUES " + instant3Utc);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * from %s WHERE _timestamptz IS NOT DISTINCT FROM %s", tableName, instant4Utc)))).matches("VALUES " + instant4Utc);
        if (partitioned) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT record_count, file_count, partition._timestamptz FROM \"%s$partitions\"", tableName)))).matches(String.format("VALUES (BIGINT '1', BIGINT '1', %s), (BIGINT '1', BIGINT '1', %s), (BIGINT '1', BIGINT '1', %s), (BIGINT '1', BIGINT '1', %s)", instant1Utc, instant2Utc, instant3Utc, instant4Utc));
        } else if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT record_count, file_count, data._timestamptz FROM \"%s$partitions\"", tableName)))).matches(String.format("VALUES (BIGINT '4', BIGINT '4', CAST(ROW(%s, %s, 0, NULL) AS row(min timestamp(6) with time zone, max timestamp(6) with time zone, null_count bigint, nan_count bigint)))", this.format == IcebergFileFormat.ORC ? "TIMESTAMP '1969-12-01 05:06:07.234000 UTC'" : instant4Utc, this.format == IcebergFileFormat.ORC ? "TIMESTAMP '2021-10-31 00:30:00.007999 UTC'" : instant3Utc));
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT record_count, file_count, data._timestamptz FROM \"%s$partitions\"", tableName)))).skippingTypesCheck().matches("VALUES (BIGINT '4', BIGINT '4', CAST(NULL AS row(min timestamp(6) with time zone, max timestamp(6) with time zone, null_count bigint, nan_count bigint)))");
        }
        if (partitioned) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + tableName))).skippingTypesCheck().matches("VALUES ('_timestamptz', NULL, 4e0, 0e0, NULL, '1969-12-01 05:06:07.234 UTC', '2021-10-31 00:30:00.007 UTC'), (NULL, NULL, NULL, NULL, 4e0, NULL, NULL)");
        } else if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + tableName))).skippingTypesCheck().matches("VALUES ('_timestamptz', NULL, 4e0, 0e0, NULL, '1969-12-01 05:06:07.234 UTC', '2021-10-31 00:30:00.007 UTC'), (NULL, NULL, NULL, NULL, 4e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + tableName))).skippingTypesCheck().matches("VALUES ('_timestamptz', NULL, 4e0, 0e0, NULL, NULL, NULL), (NULL, NULL, NULL, NULL, 4e0, NULL, NULL)");
        }
        if (partitioned) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (SELECT * FROM " + tableName + " WHERE _timestamptz = " + instant1La + ")"))).skippingTypesCheck().matches("VALUES ('_timestamptz', NULL, 1e0, 0e0, NULL, '2021-10-31 00:30:00.005 UTC', '2021-10-31 00:30:00.005 UTC'), (NULL, NULL, NULL, NULL, 1e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (SELECT * FROM " + tableName + " WHERE _timestamptz = " + instant1La + ")"))).skippingTypesCheck().matches("VALUES ('_timestamptz', null, 1e0, 0e0, NULL, '2021-10-31 00:30:00.005 UTC', '2021-10-31 00:30:00.005 UTC'), (NULL, NULL, NULL, NULL, 1e0, NULL, NULL)");
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUuid() {
        this.testSelectOrPartitionedByUuid(false);
    }

    @Test
    public void testPartitionedByUuid() {
        this.testSelectOrPartitionedByUuid(true);
    }

    private void testSelectOrPartitionedByUuid(boolean partitioned) {
        String tableName = String.format("test_%s_by_uuid", partitioned ? "partitioned" : "selected");
        String partitioning = partitioned ? "WITH (partitioning = ARRAY['x'])" : "";
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s", tableName));
        this.assertUpdate(String.format("CREATE TABLE %s (x uuid, y bigint) %s", tableName, partitioning));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (UUID '406caec7-68b9-4778-81b2-a12ece70c8b1', 12345)", tableName), 1L);
        this.assertQuery(String.format("SELECT count(*) FROM %s", tableName), "SELECT 1");
        this.assertQuery(String.format("SELECT x FROM %s", tableName), "SELECT CAST('406caec7-68b9-4778-81b2-a12ece70c8b1' AS UUID)");
        this.assertUpdate(String.format("INSERT INTO %s VALUES (UUID 'f79c3e09-677c-4bbd-a479-3f349cb785e7', 67890)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL, 7531)", tableName), 1L);
        this.assertQuery(String.format("SELECT count(*) FROM %s", tableName), "SELECT 3");
        this.assertQuery(String.format("SELECT * FROM %s WHERE x = UUID '406caec7-68b9-4778-81b2-a12ece70c8b1'", tableName), "SELECT CAST('406caec7-68b9-4778-81b2-a12ece70c8b1' AS UUID), 12345");
        this.assertQuery(String.format("SELECT * FROM %s WHERE x = UUID 'f79c3e09-677c-4bbd-a479-3f349cb785e7'", tableName), "SELECT CAST('f79c3e09-677c-4bbd-a479-3f349cb785e7' AS UUID), 67890");
        this.assertQuery(String.format("SELECT * FROM %s WHERE x >= UUID '406caec7-68b9-4778-81b2-a12ece70c8b1'", tableName), "VALUES (CAST('f79c3e09-677c-4bbd-a479-3f349cb785e7' AS UUID), 67890), (CAST('406caec7-68b9-4778-81b2-a12ece70c8b1' AS UUID), 12345)");
        this.assertQuery(String.format("SELECT * FROM %s WHERE x >= UUID 'f79c3e09-677c-4bbd-a479-3f349cb785e7'", tableName), "SELECT CAST('f79c3e09-677c-4bbd-a479-3f349cb785e7' AS UUID), 67890");
        this.assertQuery(String.format("SELECT * FROM %s WHERE x IS NULL", tableName), "SELECT NULL, 7531");
        this.assertQuery(String.format("SELECT x FROM %s WHERE y = 12345", tableName), "SELECT CAST('406caec7-68b9-4778-81b2-a12ece70c8b1' AS UUID)");
        this.assertQuery(String.format("SELECT x FROM %s WHERE y = 67890", tableName), "SELECT CAST('f79c3e09-677c-4bbd-a479-3f349cb785e7' AS UUID)");
        this.assertQuery(String.format("SELECT x FROM %s WHERE y = 7531", tableName), "SELECT NULL");
        this.assertUpdate(String.format("INSERT INTO %s VALUES (UUID '206caec7-68b9-4778-81b2-a12ece70c8b1', 313), (UUID '906caec7-68b9-4778-81b2-a12ece70c8b1', 314)", tableName), 2L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT y FROM " + tableName + " WHERE x >= UUID '206caec7-68b9-4778-81b2-a12ece70c8b1'"))).matches("VALUES BIGINT '12345', 67890, 313, 314");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testNestedUuid() {
        this.assertUpdate("CREATE TABLE test_nested_uuid (int_t int, row_t row(uuid_t uuid, int_t int), map_t map(int, uuid), array_t array(uuid))");
        String uuid = "UUID '406caec7-68b9-4778-81b2-a12ece70c8b1'";
        String value = String.format("VALUES (2, row(%1$s, 1), map(array[1], array[%1$s]), array[%1$s, %1$s])", uuid);
        this.assertUpdate("INSERT INTO test_nested_uuid " + value, 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT row_t.int_t, row_t.uuid_t FROM test_nested_uuid"))).matches("VALUES (1, UUID '406caec7-68b9-4778-81b2-a12ece70c8b1')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT map_t[1] FROM test_nested_uuid"))).matches("VALUES UUID '406caec7-68b9-4778-81b2-a12ece70c8b1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT array_t FROM test_nested_uuid"))).matches("VALUES ARRAY[UUID '406caec7-68b9-4778-81b2-a12ece70c8b1', UUID '406caec7-68b9-4778-81b2-a12ece70c8b1']");
        this.assertQuery("SELECT row_t.int_t FROM test_nested_uuid WHERE row_t.uuid_t = UUID '406caec7-68b9-4778-81b2-a12ece70c8b1'", "VALUES 1");
        this.assertQuery("SELECT int_t FROM test_nested_uuid WHERE row_t.uuid_t = UUID '406caec7-68b9-4778-81b2-a12ece70c8b1'", "VALUES 2");
    }

    @Test
    public void testCreatePartitionedTable() {
        this.assertUpdate("CREATE TABLE test_partitioned_table (  a_boolean boolean,   an_integer integer,   a_bigint bigint,   a_real real,   a_double double,   a_short_decimal decimal(5,2),   a_long_decimal decimal(38,20),   a_varchar varchar,   a_varbinary varbinary,   a_date date,   a_time time(6),   a_timestamp timestamp(6),   a_timestamptz timestamp(6) with time zone,   a_uuid uuid,   a_row row(id integer, vc varchar),   an_array array(varchar),   a_map map(integer, varchar),   \"a quoted, field\" varchar) WITH (partitioning = ARRAY[  'a_boolean',   'an_integer',   'a_bigint',   'a_real',   'a_double',   'a_short_decimal',   'a_long_decimal',   'a_varchar',   'a_varbinary',   'a_date',   'a_time',   'a_timestamp',   'a_timestamptz',   'a_uuid',   '\"a quoted, field\"'   ])");
        this.assertQueryReturnsEmptyResult("SELECT * FROM test_partitioned_table");
        String values = "VALUES (true, 1, BIGINT '1', REAL '1.0', DOUBLE '1.0', CAST(1.0 AS decimal(5,2)), CAST(11.0 AS decimal(38,20)), VARCHAR 'onefsadfdsf', X'000102f0feff', DATE '2021-07-24',TIME '02:43:57.987654', TIMESTAMP '2021-07-24 03:43:57.987654',TIMESTAMP '2021-07-24 04:43:57.987654 UTC', UUID '20050910-1330-11e9-ffff-2a86e4085a59', CAST(ROW(42, 'this is a random value') AS ROW(id int, vc varchar)), ARRAY[VARCHAR 'uno', 'dos', 'tres'], map(ARRAY[1,2], ARRAY['ek', VARCHAR 'one']), VARCHAR 'tralala')";
        String nullValues = Collections.nCopies(18, "NULL").stream().collect(Collectors.joining(", ", "VALUES (", ")"));
        this.assertUpdate("INSERT INTO test_partitioned_table " + values, 1L);
        this.assertUpdate("INSERT INTO test_partitioned_table " + nullValues, 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_partitioned_table"))).matches(values + " UNION ALL " + nullValues);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_partitioned_table WHERE     a_boolean = true AND an_integer = 1 AND a_bigint = BIGINT '1' AND a_real = REAL '1.0' AND a_double = DOUBLE '1.0' AND a_short_decimal = CAST(1.0 AS decimal(5,2)) AND a_long_decimal = CAST(11.0 AS decimal(38,20)) AND a_varchar = VARCHAR 'onefsadfdsf' AND a_varbinary = X'000102f0feff' AND a_date = DATE '2021-07-24' AND a_time = TIME '02:43:57.987654' AND a_timestamp = TIMESTAMP '2021-07-24 03:43:57.987654' AND a_timestamptz = TIMESTAMP '2021-07-24 04:43:57.987654 UTC' AND a_uuid = UUID '20050910-1330-11e9-ffff-2a86e4085a59' AND a_row = CAST(ROW(42, 'this is a random value') AS ROW(id int, vc varchar)) AND an_array = ARRAY[VARCHAR 'uno', 'dos', 'tres'] AND a_map = map(ARRAY[1,2], ARRAY['ek', VARCHAR 'one']) AND \"a quoted, field\" = VARCHAR 'tralala' "))).matches(values);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_partitioned_table WHERE     a_boolean IS NULL AND an_integer IS NULL AND a_bigint IS NULL AND a_real IS NULL AND a_double IS NULL AND a_short_decimal IS NULL AND a_long_decimal IS NULL AND a_varchar IS NULL AND a_varbinary IS NULL AND a_date IS NULL AND a_time IS NULL AND a_timestamp IS NULL AND a_timestamptz IS NULL AND a_uuid IS NULL AND a_row IS NULL AND an_array IS NULL AND a_map IS NULL AND \"a quoted, field\" IS NULL "))).skippingTypesCheck().matches(nullValues);
        switch (this.format) {
            case ORC: {
                this.assertQuery("SHOW STATS FOR test_partitioned_table", "VALUES   ('a_boolean', NULL, 1e0, 0.5, NULL, 'true', 'true'),   ('an_integer', NULL, 1e0, 0.5, NULL, '1', '1'),   ('a_bigint', NULL, 1e0, 0.5, NULL, '1', '1'),   ('a_real', NULL, 1e0, 0.5, NULL, '1.0', '1.0'),   ('a_double', NULL, 1e0, 0.5, NULL, '1.0', '1.0'),   ('a_short_decimal', NULL, 1e0, 0.5, NULL, '1.0', '1.0'),   ('a_long_decimal', NULL, 1e0, 0.5, NULL, '11.0', '11.0'),   ('a_varchar', NULL, 1e0, 0.5, NULL, NULL, NULL),   ('a_varbinary', NULL, 1e0, 0.5, NULL, NULL, NULL),   ('a_date', NULL, 1e0, 0.5, NULL, '2021-07-24', '2021-07-24'),   ('a_time', NULL, 1e0, 0.5, NULL, NULL, NULL),   ('a_timestamp', NULL, 1e0, 0.5, NULL, '2021-07-24 03:43:57.987654', '2021-07-24 03:43:57.987654'),   ('a_timestamptz', NULL, 1e0, 0.5, NULL, '2021-07-24 04:43:57.987 UTC', '2021-07-24 04:43:57.987 UTC'),   ('a_uuid', NULL, 1e0, 0.5, NULL, NULL, NULL),   ('a_row', NULL, NULL, 0.5, NULL, NULL, NULL),   ('an_array', NULL, NULL, 0.5, NULL, NULL, NULL),   ('a_map', NULL, NULL, 0.5, NULL, NULL, NULL),   ('a quoted, field', NULL, 1e0, 0.5, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
                break;
            }
            case PARQUET: {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_partitioned_table"))).skippingTypesCheck().matches("VALUES   ('a_boolean', NULL, 1e0, 0.5e0, NULL, 'true', 'true'),   ('an_integer', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_bigint', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_real', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_double', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_short_decimal', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_long_decimal', NULL, 1e0, 0.5e0, NULL, '11.0', '11.0'),   ('a_varchar', 213e0, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_varbinary', 103e0, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_date', NULL, 1e0, 0.5e0, NULL, '2021-07-24', '2021-07-24'),   ('a_time', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_timestamp', NULL, 1e0, 0.5e0, NULL, '2021-07-24 03:43:57.987654', '2021-07-24 03:43:57.987654'),   ('a_timestamptz', NULL, 1e0, 0.5e0, NULL, '2021-07-24 04:43:57.987 UTC', '2021-07-24 04:43:57.987 UTC'),   ('a_uuid', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_row', NULL, NULL, NULL, NULL, NULL, NULL),   ('an_array', NULL, NULL, NULL, NULL, NULL, NULL),   ('a_map', NULL, NULL, NULL, NULL, NULL, NULL),   ('a quoted, field', 202e0, 1e0, 0.5e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
                break;
            }
            case AVRO: {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_partitioned_table"))).skippingTypesCheck().matches("VALUES   ('a_boolean', NULL, 1e0, 0.5e0, NULL, 'true', 'true'),   ('an_integer', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_bigint', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_real', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_double', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_short_decimal', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_long_decimal', NULL, 1e0, 0.5e0, NULL, '11.0', '11.0'),   ('a_varchar', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_varbinary', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_date', NULL, 1e0, 0.5e0, NULL, '2021-07-24', '2021-07-24'),   ('a_time', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_timestamp', NULL, 1e0, 0.5e0, NULL, '2021-07-24 03:43:57.987654', '2021-07-24 03:43:57.987654'),   ('a_timestamptz', NULL, 1e0, 0.5e0, NULL, '2021-07-24 04:43:57.987 UTC', '2021-07-24 04:43:57.987 UTC'),   ('a_uuid', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_row', NULL, NULL, NULL, NULL, NULL, NULL),   ('an_array', NULL, NULL, NULL, NULL, NULL, NULL),   ('a_map', NULL, NULL, NULL, NULL, NULL, NULL),   ('a quoted, field', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
            }
        }
        String schema = (String)this.getSession().getSchema().orElseThrow();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'test_partitioned_table$partitions' "))).skippingTypesCheck().matches("VALUES 'partition', 'record_count', 'file_count', 'total_size'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT   record_count,  file_count,   partition.a_boolean,   partition.an_integer,   partition.a_bigint,   partition.a_real,   partition.a_double,   partition.a_short_decimal,   partition.a_long_decimal,   partition.a_varchar,   partition.a_varbinary,   partition.a_date,   partition.a_time,   partition.a_timestamp,   partition.a_timestamptz,   partition.a_uuid,   partition.\"a quoted, field\"  FROM \"test_partitioned_table$partitions\" "))).matches("VALUES (  BIGINT '1',   BIGINT '1',   true,   1,   BIGINT '1',   REAL '1.0',   DOUBLE '1.0',   CAST(1.0 AS decimal(5,2)),   CAST(11.0 AS decimal(38,20)),   VARCHAR 'onefsadfdsf',   X'000102f0feff',   DATE '2021-07-24',  TIME '02:43:57.987654',   TIMESTAMP '2021-07-24 03:43:57.987654',  TIMESTAMP '2021-07-24 04:43:57.987654 UTC',   UUID '20050910-1330-11e9-ffff-2a86e4085a59',   VARCHAR 'tralala' )UNION ALL VALUES (  BIGINT '1',   BIGINT '1',   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL  )");
        this.assertUpdate("DROP TABLE test_partitioned_table");
    }

    @Test
    public void testCreatePartitionedTableWithNestedTypes() {
        this.assertUpdate("CREATE TABLE test_partitioned_table_nested_type (  _string VARCHAR, _struct ROW(_field1 INT, _field2 VARCHAR), _date DATE) WITH (  partitioning = ARRAY['_date'])");
        this.assertUpdate("DROP TABLE test_partitioned_table_nested_type");
    }

    @Test
    public void testCreateTableWithUnsupportedNestedFieldPartitioning() {
        this.assertQueryFails("CREATE TABLE test_partitioned_table_nested_field_3 (grandparent ROW(parent ROW(child VARCHAR))) WITH (partitioning = ARRAY['\"grandparent.parent\"'])", "\\QUnable to parse partitioning value: Cannot partition by non-primitive source field: struct<3: child: optional string>");
        this.assertQueryFails("CREATE TABLE test_partitioned_table_nested_field_inside_array (parent ARRAY(ROW(child VARCHAR))) WITH (partitioning = ARRAY['\"parent.child\"'])", "\\QPartitioning field [parent.element.child] cannot be contained in a array");
        this.assertQueryFails("CREATE TABLE test_partitioned_table_nested_field_inside_map (parent MAP(ROW(child INTEGER), ARRAY(VARCHAR))) WITH (partitioning = ARRAY['\"parent.key.child\"'])", "\\QPartitioning field [parent.key.child] cannot be contained in a map");
        this.assertQueryFails("CREATE TABLE test_partitioned_table_nested_field_year_transform_in_string (parent ROW(child VARCHAR)) WITH (partitioning = ARRAY['year(\"parent.child\")'])", "\\QUnable to parse partitioning value: Invalid source type string for transform: year");
    }

    @Test
    public void testNestedFieldPartitionedTable() {
        String tableName = "test_nested_field_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(id INTEGER, name VARCHAR, parent ROW(child VARCHAR, child2 VARCHAR)) WITH (partitioning = ARRAY['id', '\"parent.child\"', '\"parent.child2\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'presto', ROW('a', 'b'))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, name, parent.child, parent.child2 FROM " + tableName))).skippingTypesCheck().matches("VALUES (1, 'presto', 'a', 'b')");
        this.assertUpdate("UPDATE " + tableName + " SET name = 'trino' WHERE parent.child = 'a'", 1L);
        this.assertQuerySucceeds("DELETE FROM " + tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'trino', ROW('a', 'b'))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, name, parent.child, parent.child2 FROM " + tableName))).skippingTypesCheck().matches("VALUES (1, 'trino', 'a', 'b')");
        String newTableName = "test_nested_field_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("ALTER TABLE " + tableName + " RENAME TO " + newTableName);
        this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + newTableName + " EXECUTE OPTIMIZE");
        this.assertQuerySucceeds(this.prepareCleanUpSession(), "ALTER TABLE " + newTableName + " EXECUTE expire_snapshots(retention_threshold => '0s')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, name, parent.child, parent.child2 FROM " + newTableName))).skippingTypesCheck().matches("VALUES (1, 'trino', 'a', 'b')");
        this.assertUpdate("DROP TABLE " + newTableName);
    }

    @Test
    public void testMultipleLevelNestedFieldPartitionedTable() {
        String tableName = "test_multiple_level_nested_field_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(id INTEGER, gradparent ROW(parent ROW(child VARCHAR))) WITH (partitioning = ARRAY['\"gradparent.parent.child\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(ROW('trino')))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, gradparent.parent.child FROM " + tableName))).skippingTypesCheck().matches("VALUES (1, 'trino')");
        this.assertUpdate("UPDATE " + tableName + " SET id = 2 WHERE gradparent.parent.child = 'trino'", 1L);
        this.assertQuerySucceeds("DELETE FROM " + tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, ROW(ROW('trino')))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, gradparent.parent.child FROM " + tableName))).skippingTypesCheck().matches("VALUES (3, 'trino')");
        String newTableName = "test_multiple_level_nested_field_partitioned_table_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("ALTER TABLE " + tableName + " RENAME TO " + newTableName);
        this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + newTableName + " EXECUTE OPTIMIZE");
        this.assertQuerySucceeds(this.prepareCleanUpSession(), "ALTER TABLE " + newTableName + " EXECUTE expire_snapshots(retention_threshold => '0s')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, gradparent.parent.child FROM " + newTableName))).skippingTypesCheck().matches("VALUES (3, 'trino')");
        this.assertUpdate("DROP TABLE " + newTableName);
    }

    @Test
    public void testNestedFieldPartitionedTableHavingSameChildName() {
        String tableName = "test_nested_field_partitioned_table_having_same_child_name_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(id INTEGER, gradparent ROW(parent ROW(child VARCHAR)), parent ROW(child VARCHAR)) WITH (partitioning = ARRAY['\"gradparent.parent.child\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(ROW('trino')), ROW('trinodb'))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, gradparent.parent.child, parent.child FROM " + tableName))).skippingTypesCheck().matches("VALUES (1, 'trino', 'trinodb')");
        this.assertUpdate("UPDATE " + tableName + " SET id = 2 WHERE gradparent.parent.child = 'trino'", 1L);
        this.assertQuerySucceeds("DELETE FROM " + tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).returnsEmptyResult();
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, ROW(ROW('trino')), ROW('trinodb'))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, gradparent.parent.child, parent.child FROM " + tableName))).skippingTypesCheck().matches("VALUES (3, 'trino', 'trinodb')");
        String newTableName = "test_nested_field_partitioned_table_having_same_child_name_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("ALTER TABLE " + tableName + " RENAME TO " + newTableName);
        this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + newTableName + " EXECUTE OPTIMIZE");
        this.assertQuerySucceeds(this.prepareCleanUpSession(), "ALTER TABLE " + newTableName + " EXECUTE expire_snapshots(retention_threshold => '0s')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, gradparent.parent.child, parent.child FROM " + newTableName))).skippingTypesCheck().matches("VALUES (3, 'trino', 'trinodb')");
        this.assertUpdate("DROP TABLE " + newTableName);
    }

    @Test
    public void testMergeWithNestedFieldPartitionedTable() {
        String sourceTable = "test_merge_with_nested_field_partitioned_table_source_" + TestingNames.randomNameSuffix();
        String targetTable = "test_merge_with_nested_field_partitioned_table_target_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTable + " (customer VARCHAR, purchases INT, address ROW (city VARCHAR)) WITH (partitioning = ARRAY['\"address.city\"'])");
        this.assertUpdate("INSERT INTO " + sourceTable + " (customer, purchases, address) VALUES ('Aaron', 6, ROW('Arches')), ('Ed', 7, ROW('Etherville')), ('Carol', 9, ROW('Centreville')), ('Dave', 11, ROW('Darbyshire'))", 4L);
        this.assertUpdate("CREATE TABLE " + targetTable + " (customer VARCHAR, purchases INT, address ROW (city VARCHAR)) WITH (partitioning = ARRAY['\"address.city\"'])");
        this.assertUpdate("INSERT INTO " + targetTable + " (customer, purchases, address)  VALUES ('Aaron', 5, ROW('Antioch')), ('Bill', 7, ROW('Buena')), ('Carol', 3, ROW('Cambridge')), ('Dave', 11, ROW('Devon'))", 4L);
        String sql = "MERGE INTO " + targetTable + " t USING " + sourceTable + " s ON (t.customer = s.customer)    WHEN MATCHED AND s.address.city = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES (s.customer, s.purchases, s.address)";
        this.assertUpdate(sql, 4L);
        this.assertQuery("SELECT customer, purchases, address.city FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Ed', 7, 'Etherville'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Devon')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testSchemaEvolutionWithNestedFieldPartitioning() {
        String tableName = "test_schema_evolution_with_nested_field_partitioning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (c1 bigint, parent1 ROW(child VARCHAR), parent2 ROW(child VARCHAR)) WITH (partitioning = ARRAY['\"parent1.child\"'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW('BLR'), ROW('BLR'))", 1L);
        this.assertQuery("SELECT c1, parent1.child, parent2.child from " + tableName, "VALUES (1, 'BLR', 'BLR')");
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN parent2");
        this.assertQuery("SELECT c1, parent1.child FROM " + tableName, "VALUES (1, 'BLR')");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN parent3 ROW(child VARCHAR)");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN parent4 ROW(child VARCHAR)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, ROW('DEL'), ROW('DL'), ROW('IN'))", 1L);
        this.assertQuery("SELECT c1, parent1.child, parent3.child, parent4.child FROM " + tableName, "VALUES (1, 'BLR', NULL, NULL), (2, 'DEL', 'DL', 'IN')");
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN parent3");
        this.assertQuery("SELECT c1, parent1.child, parent4.child FROM " + tableName, "VALUES (1, 'BLR', NULL), (2, 'DEL', 'IN')");
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN parent4 TO renamed_parent");
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN parent1 TO renamed_partitioned_parent");
        this.assertQuery("SHOW COLUMNS FROM " + tableName, "VALUES ('c1', 'bigint', '', ''), ('renamed_partitioned_parent', 'row(child varchar)', '', ''), ('renamed_parent', 'row(child varchar)', '', '')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreatePartitionedTableAs() {
        File tempDir = this.getDistributedQueryRunner().getCoordinator().getBaseDataDir().toFile();
        String tempDirPath = tempDir.toURI().toASCIIString() + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE test_create_partitioned_table_as WITH (format_version = 2,location = '" + tempDirPath + "', partitioning = ARRAY['ORDER_STATUS', 'Ship_Priority', 'Bucket(\"order key\",9)']) AS SELECT orderkey AS \"order key\", shippriority AS ship_priority, orderstatus AS order_status FROM tpch.tiny.orders", "SELECT count(*) from orders");
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE test_create_partitioned_table_as")).isEqualTo((Object)String.format("CREATE TABLE %s.%s.%s (\n   \"order key\" bigint,\n   ship_priority integer,\n   order_status varchar\n)\nWITH (\n   format = '%s',\n   format_version = 2,\n   location = '%s',\n   max_commit_retry = 4,\n   partitioning = ARRAY['order_status','ship_priority','bucket(\"order key\", 9)']\n)", this.getSession().getCatalog().orElseThrow(), this.getSession().getSchema().orElseThrow(), "test_create_partitioned_table_as", this.format, tempDirPath));
        this.assertQuery("SELECT * from test_create_partitioned_table_as", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertUpdate("DROP TABLE test_create_partitioned_table_as");
    }

    @Test
    public void testCreatePartitionedTableWithQuotedIdentifierCasing() {
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("x", "x", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("X", "x", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"x\"", "x", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"X\"", "x", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("x", "\"x\"", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("X", "\"x\"", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"x\"", "\"x\"", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"X\"", "\"x\"", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("x", "X", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("X", "X", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"x\"", "X", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"X\"", "X", true);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("x", "\"X\"", false);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("X", "\"X\"", false);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"x\"", "\"X\"", false);
        this.testCreatePartitionedTableWithQuotedIdentifierCasing("\"X\"", "\"X\"", false);
    }

    private void testCreatePartitionedTableWithQuotedIdentifierCasing(String columnName, String partitioningField, boolean success) {
        String tableName = "partitioning_" + TestingNames.randomNameSuffix();
        String sql = String.format("CREATE TABLE %s (%s bigint) WITH (partitioning = ARRAY['%s'])", tableName, columnName, partitioningField);
        if (success) {
            this.assertUpdate(sql);
            this.assertUpdate("DROP TABLE " + tableName);
        } else {
            this.assertQueryFails(sql, "Unable to parse partitioning value: .*");
        }
    }

    @Test
    public void testPartitionColumnNameConflict() {
        try (TestTable table = this.newTrinoTable("test_conflict_partition", "(ts timestamp, ts_day int) WITH (partitioning = ARRAY['day(ts)'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (TIMESTAMP '2021-07-24 03:43:57.987654', 1)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (TIMESTAMP '2021-07-24 03:43:57.987654', 1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.ts_day_2 FROM \"" + table.getName() + "$partitions\""))).matches("VALUES DATE '2021-07-24'");
        }
        table = this.newTrinoTable("test_conflict_partition", "(ts timestamp, ts_day int)");
        try {
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES partitioning = ARRAY['day(ts)']");
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (TIMESTAMP '2021-07-24 03:43:57.987654', 1)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (TIMESTAMP '2021-07-24 03:43:57.987654', 1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.ts_day_2 FROM \"" + table.getName() + "$partitions\""))).matches("VALUES DATE '2021-07-24'");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testSortByAllTypes() {
        String tableName = "test_sort_by_all_types_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (  a_boolean boolean,   an_integer integer,   a_bigint bigint,   a_real real,   a_double double,   a_short_decimal decimal(5,2),   a_long_decimal decimal(38,20),   a_varchar varchar,   a_varbinary varbinary,   a_date date,   a_time time(6),   a_timestamp timestamp(6),   a_timestamptz timestamp(6) with time zone,   a_uuid uuid,   a_row row(id integer, vc varchar, t time(6), ts timestamp(6), tstz timestamp(6) with time zone),   an_array array(varchar),   a_map map(integer, varchar) ) WITH (sorted_by = ARRAY[  'a_boolean',   'an_integer',   'a_bigint',   'a_real',   'a_double',   'a_short_decimal',   'a_long_decimal',   'a_varchar',   'a_varbinary',   'a_date',   'a_time',   'a_timestamp',   'a_timestamptz',   'a_uuid'  ])");
        String values = "(true, 1, BIGINT '2', REAL '3.0', DOUBLE '4.0', DECIMAL '5.00', CAST(DECIMAL '6.00' AS decimal(38,20)), VARCHAR 'seven', X'88888888', DATE '2022-09-09', TIME '10:10:10.000000', TIMESTAMP '2022-11-11 11:11:11.000000', TIMESTAMP '2022-11-11 11:11:11.000000 UTC', UUID '12121212-1212-1212-1212-121212121212', CAST(ROW(13, 'thirteen', TIME '10:10:10.000000', TIMESTAMP '2022-11-11 11:11:11.000000', TIMESTAMP '2022-11-11 11:11:11.000000 UTC') AS row(id integer, vc varchar, t time(6), ts timestamp(6), tstz timestamp(6) with time zone)), ARRAY[VARCHAR 'four', 'teen'], MAP(ARRAY[15], ARRAY[VARCHAR 'fifteen']))";
        String highValues = "(true, 999999999, BIGINT '999999999', REAL '999.999', DOUBLE '999.999', DECIMAL '999.99', DECIMAL '6.00', 'zzzzzzzzzzzzzz', X'FFFFFFFF', DATE '2099-12-31', TIME '23:59:59.999999', TIMESTAMP '2099-12-31 23:59:59.000000', TIMESTAMP '2099-12-31 23:59:59.000000 UTC', UUID 'FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF', CAST(ROW(999, 'zzzzzzzz', TIME '23:59:59.999999', TIMESTAMP '2099-12-31 23:59:59.000000', TIMESTAMP '2099-12-31 23:59:59.000000 UTC') AS row(id integer, vc varchar, t time(6), ts timestamp(6), tstz timestamp(6) with time zone)), ARRAY['zzzz', 'zzzz'], MAP(ARRAY[999], ARRAY['zzzz']))";
        String lowValues = "(false, 0, BIGINT '0', REAL '0', DOUBLE '0', DECIMAL '0', DECIMAL '0', '', X'00000000', DATE '2000-01-01', TIME '00:00:00.000000', TIMESTAMP '2000-01-01 00:00:00.000000', TIMESTAMP '2000-01-01 00:00:00.000000 UTC', UUID '00000000-0000-0000-0000-000000000000', CAST(ROW(0, '', TIME '00:00:00.000000', TIMESTAMP '2000-01-01 00:00:00.000000', TIMESTAMP '2000-01-01 00:00:00.000000 UTC') AS row(id integer, vc varchar, t time(6), ts timestamp(6), tstz timestamp(6) with time zone)), ARRAY['', ''], MAP(ARRAY[0], ARRAY['']))";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + values + ", " + highValues + ", " + lowValues, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + tableName))).matches("VALUES " + values + ", " + highValues + ", " + lowValues);
        this.assertUpdate("INSERT INTO %s\nSELECT v.*\nFROM (VALUES %s, %s, %s) v\nCROSS JOIN UNNEST (sequence(1, 10_000)) a(i)\n".formatted(tableName, values, highValues, lowValues), 30000L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEmptySortedByList() {
        String tableName = "test_empty_sorted_by_list_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_boolean boolean, an_integer integer)   WITH (partitioning = ARRAY['an_integer'], sorted_by = ARRAY[])");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateSortedTableWithQuotedIdentifierCasing() {
        this.testCreateSortedTableWithQuotedIdentifierCasing("col", "col");
        this.testCreateSortedTableWithQuotedIdentifierCasing("COL", "col");
        this.testCreateSortedTableWithQuotedIdentifierCasing("\"col\"", "col");
        this.testCreateSortedTableWithQuotedIdentifierCasing("\"COL\"", "col");
        this.testCreateSortedTableWithQuotedIdentifierCasing("col", "\"col\"");
        this.testCreateSortedTableWithQuotedIdentifierCasing("COL", "\"col\"");
        this.testCreateSortedTableWithQuotedIdentifierCasing("\"col\"", "\"col\"");
        this.testCreateSortedTableWithQuotedIdentifierCasing("\"COL\"", "\"col\"");
    }

    private void testCreateSortedTableWithQuotedIdentifierCasing(String columnName, String sortField) {
        String tableName = "test_create_sorted_table_with_quotes_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (%s bigint) WITH (sorted_by = ARRAY['%s'])", tableName, columnName, sortField));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateSortedTableWithSortTransform() {
        this.testCreateSortedTableWithSortTransform("col", "bucket(col, 3)");
        this.testCreateSortedTableWithSortTransform("col", "bucket(\"col\", 3)");
        this.testCreateSortedTableWithSortTransform("col", "truncate(col, 3)");
        this.testCreateSortedTableWithSortTransform("col", "year(col)");
        this.testCreateSortedTableWithSortTransform("col", "month(col)");
        this.testCreateSortedTableWithSortTransform("col", "date(col)");
        this.testCreateSortedTableWithSortTransform("col", "hour(col)");
    }

    private void testCreateSortedTableWithSortTransform(String columnName, String sortField) {
        String tableName = "test_sort_with_transform_" + TestingNames.randomNameSuffix();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("CREATE TABLE %s (%s TIMESTAMP(6)) WITH (sorted_by = ARRAY['%s'])", tableName, columnName, sortField)))).failure().hasMessageContaining("Unable to parse sort field");
    }

    @Test
    public void testSortOrderChange() {
        Session withSmallRowGroups = IcebergTestUtils.withSmallRowGroups(this.getSession());
        try (TestTable table = this.newTrinoTable("test_sort_order_change", "WITH (sorted_by = ARRAY['comment']) AS SELECT * FROM nation WITH NO DATA");){
            this.assertUpdate(withSmallRowGroups, "INSERT INTO " + table.getName() + " SELECT * FROM nation", 25L);
            HashSet sortedByComment = new HashSet();
            this.computeActual("SELECT file_path from \"" + table.getName() + "$files\"").getOnlyColumnAsSet().forEach(fileName -> sortedByComment.add((String)fileName));
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES sorted_by = ARRAY['name']");
            this.assertUpdate(withSmallRowGroups, "INSERT INTO " + table.getName() + " SELECT * FROM nation", 25L);
            for (Object filePath : this.computeActual("SELECT file_path from \"" + table.getName() + "$files\"").getOnlyColumnAsSet()) {
                String path = (String)filePath;
                if (sortedByComment.contains(path)) {
                    Assertions.assertThat((boolean)this.isFileSorted(path, "comment")).isTrue();
                    continue;
                }
                Assertions.assertThat((boolean)this.isFileSorted(path, "name")).isTrue();
            }
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation UNION ALL SELECT * FROM nation");
        }
    }

    @Test
    public void testSortingDisabled() {
        Session withSortingDisabled = Session.builder((Session)IcebergTestUtils.withSmallRowGroups(this.getSession())).setCatalogSessionProperty("iceberg", "sorted_writing_enabled", "false").build();
        try (TestTable table = this.newTrinoTable("test_sorting_disabled", "WITH (sorted_by = ARRAY['comment']) AS SELECT * FROM nation WITH NO DATA");){
            this.assertUpdate(withSortingDisabled, "INSERT INTO " + table.getName() + " SELECT * FROM nation", 25L);
            for (Object filePath : this.computeActual("SELECT file_path from \"" + table.getName() + "$files\"").getOnlyColumnAsSet()) {
                Assertions.assertThat((boolean)this.isFileSorted((String)filePath, "comment")).isFalse();
            }
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation");
        }
    }

    @Test
    public void testOptimizeWithSortOrder() {
        Session withSmallRowGroups = IcebergTestUtils.withSmallRowGroups(this.getSession());
        try (TestTable table = this.newTrinoTable("test_optimize_with_sort_order", "WITH (sorted_by = ARRAY['comment']) AS SELECT * FROM nation WITH NO DATA");){
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM nation WHERE nationkey < 10", 10L);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM nation WHERE nationkey >= 10 AND nationkey < 20", 10L);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM nation WHERE nationkey >= 20", 5L);
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES sorted_by = ARRAY['comment']");
            this.assertUpdate(this.withSingleWriterPerTask(withSmallRowGroups), "ALTER TABLE " + table.getName() + " EXECUTE optimize");
            for (Object filePath : this.computeActual("SELECT file_path from \"" + table.getName() + "$files\"").getOnlyColumnAsSet()) {
                Assertions.assertThat((boolean)this.isFileSorted((String)filePath, "comment")).isTrue();
            }
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation");
        }
    }

    @Test
    public void testUpdateWithSortOrder() {
        Session withSmallRowGroups = IcebergTestUtils.withSmallRowGroups(this.getSession());
        try (TestTable table = this.newTrinoTable("test_sorted_update", "WITH (sorted_by = ARRAY['comment']) AS TABLE tpch.tiny.customer WITH NO DATA");){
            this.assertUpdate(withSmallRowGroups, "INSERT INTO " + table.getName() + " TABLE tpch.tiny.customer", "VALUES 1500");
            this.assertUpdate(withSmallRowGroups, "UPDATE " + table.getName() + " SET comment = substring(comment, 2)", 1500L);
            this.assertQuery("SELECT custkey, name, address, nationkey, phone, acctbal, mktsegment, comment FROM " + table.getName(), "SELECT custkey, name, address, nationkey, phone, acctbal, mktsegment, substring(comment, 2) FROM customer");
            for (Object filePath : this.computeActual("SELECT file_path from \"" + table.getName() + "$files\" WHERE content != 1").getOnlyColumnAsSet()) {
                Assertions.assertThat((boolean)this.isFileSorted((String)filePath, "comment")).isTrue();
            }
        }
    }

    protected abstract boolean isFileSorted(String var1, String var2);

    @Test
    public void testSortingOnNestedField() {
        String tableName = "test_sorting_on_nested_field" + TestingNames.randomNameSuffix();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE TABLE " + tableName + " (nationkey BIGINT, row_t ROW(name VARCHAR, regionkey BIGINT, comment VARCHAR)) WITH (sorted_by = ARRAY['row_t.comment'])"))).failure().hasMessageContaining("Unable to parse sort field: [row_t.comment]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE TABLE " + tableName + " (nationkey BIGINT, row_t ROW(name VARCHAR, regionkey BIGINT, comment VARCHAR)) WITH (sorted_by = ARRAY['\"row_t\".\"comment\"'])"))).failure().hasMessageContaining("Unable to parse sort field: [\"row_t\".\"comment\"]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE TABLE " + tableName + " (nationkey BIGINT, row_t ROW(name VARCHAR, regionkey BIGINT, comment VARCHAR)) WITH (sorted_by = ARRAY['\"row_t.comment\"'])"))).failure().hasMessageContaining("Column not found: row_t.comment");
    }

    @Test
    public void testDroppingSortColumn() {
        Session withSmallRowGroups = IcebergTestUtils.withSmallRowGroups(this.getSession());
        try (TestTable table = this.newTrinoTable("test_dropping_sort_column", "WITH (sorted_by = ARRAY['comment']) AS SELECT * FROM nation WITH NO DATA");){
            this.assertUpdate(withSmallRowGroups, "INSERT INTO " + table.getName() + " SELECT * FROM nation", 25L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE " + table.getName() + " DROP COLUMN comment"))).failure().hasMessageContaining("Cannot find source column for sort field");
        }
    }

    @Test
    public void testTableComments() {
        File tempDir = this.getDistributedQueryRunner().getCoordinator().getBaseDataDir().toFile();
        String tempDirPath = tempDir.toURI().toASCIIString() + TestingNames.randomNameSuffix();
        String createTableTemplate = "CREATE TABLE iceberg.tpch.test_table_comments (\n   _x bigint\n)\nCOMMENT '%s'\nWITH (\n" + String.format("   format = '%s',\n", this.format) + "   format_version = 2,\n" + String.format("   location = '%s',\n", tempDirPath) + "   max_commit_retry = 4\n)";
        String createTableWithoutComment = "CREATE TABLE iceberg.tpch.test_table_comments (\n   _x bigint\n)\nWITH (\n   format = '" + String.valueOf(this.format) + "',\n   format_version = 2,\n   location = '" + tempDirPath + "',\n   max_commit_retry = 4\n)";
        String createTableSql = String.format(createTableTemplate, "test table comment", this.format);
        this.assertUpdate(createTableSql);
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE test_table_comments")).isEqualTo((Object)createTableSql);
        this.assertUpdate("COMMENT ON TABLE test_table_comments IS 'different test table comment'");
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE test_table_comments")).isEqualTo((Object)String.format(createTableTemplate, "different test table comment", this.format));
        this.assertUpdate("COMMENT ON TABLE test_table_comments IS NULL");
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE test_table_comments")).isEqualTo((Object)createTableWithoutComment);
        this.assertUpdate("DROP TABLE iceberg.tpch.test_table_comments");
        this.assertUpdate(createTableWithoutComment);
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE test_table_comments")).isEqualTo((Object)createTableWithoutComment);
        this.assertUpdate("DROP TABLE iceberg.tpch.test_table_comments");
    }

    @Test
    public void testRollbackSnapshot() {
        this.testRollbackSnapshot("ALTER TABLE tpch.test_rollback EXECUTE rollback_to_snapshot(%s)");
        this.testRollbackSnapshot("ALTER TABLE tpch.test_rollback EXECUTE rollback_to_snapshot(snapshot_id => %s)");
        this.testRollbackSnapshot("CALL system.rollback_to_snapshot('tpch', 'test_rollback', %s)");
    }

    private void testRollbackSnapshot(String rollbackToSnapshotFormat) {
        this.assertUpdate("CREATE TABLE test_rollback (col0 INTEGER, col1 BIGINT)");
        long afterCreateTableId = this.getCurrentSnapshotId("test_rollback");
        this.assertUpdate("INSERT INTO test_rollback (col0, col1) VALUES (123, CAST(987 AS BIGINT))", 1L);
        long afterFirstInsertId = this.getCurrentSnapshotId("test_rollback");
        this.assertQuery("SELECT * FROM test_rollback ORDER BY col0", "VALUES (123, CAST(987 AS BIGINT))");
        this.assertUpdate(String.format(rollbackToSnapshotFormat, afterFirstInsertId));
        this.assertQuery("SELECT * FROM test_rollback ORDER BY col0", "VALUES (123, CAST(987 AS BIGINT))");
        this.assertUpdate("INSERT INTO test_rollback (col0, col1) VALUES (456, CAST(654 AS BIGINT))", 1L);
        this.assertQuery("SELECT * FROM test_rollback ORDER BY col0", "VALUES (123, CAST(987 AS BIGINT)), (456, CAST(654 AS BIGINT))");
        this.assertUpdate(String.format(rollbackToSnapshotFormat, afterFirstInsertId));
        this.assertQuery("SELECT * FROM test_rollback ORDER BY col0", "VALUES (123, CAST(987 AS BIGINT))");
        this.assertUpdate(String.format(rollbackToSnapshotFormat, afterCreateTableId));
        Assertions.assertThat((long)((Long)this.computeActual("SELECT COUNT(*) FROM test_rollback").getOnlyValue())).isEqualTo(0L);
        this.assertUpdate("INSERT INTO test_rollback (col0, col1) VALUES (789, CAST(987 AS BIGINT))", 1L);
        long afterSecondInsertId = this.getCurrentSnapshotId("test_rollback");
        this.assertUpdate("INSERT INTO test_rollback (col0, col1) VALUES (999, CAST(999 AS BIGINT))", 1L);
        this.assertUpdate(String.format(rollbackToSnapshotFormat, afterSecondInsertId));
        this.assertQuery("SELECT * FROM test_rollback ORDER BY col0", "VALUES (789, CAST(987 AS BIGINT))");
        this.assertUpdate("DROP TABLE test_rollback");
    }

    @Test
    void testRollbackToSnapshotWithNullArgument() {
        this.assertQueryFails("CALL system.rollback_to_snapshot(NULL, 'customer_orders', 8954597067493422955)", ".*schema cannot be null.*");
        this.assertQueryFails("CALL system.rollback_to_snapshot('testdb', NULL, 8954597067493422955)", ".*table cannot be null.*");
        this.assertQueryFails("CALL system.rollback_to_snapshot('testdb', 'customer_orders', NULL)", ".*snapshot_id cannot be null.*");
    }

    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        return "NULL value not allowed for NOT NULL column: " + columnName;
    }

    @Test
    public void testSchemaEvolution() {
        this.assertUpdate("CREATE TABLE test_schema_evolution_drop_end (col0 INTEGER, col1 INTEGER, col2 INTEGER)");
        this.assertUpdate("INSERT INTO test_schema_evolution_drop_end VALUES (0, 1, 2)", 1L);
        this.assertQuery("SELECT * FROM test_schema_evolution_drop_end", "VALUES(0, 1, 2)");
        this.assertUpdate("ALTER TABLE test_schema_evolution_drop_end DROP COLUMN col2");
        this.assertQuery("SELECT * FROM test_schema_evolution_drop_end", "VALUES(0, 1)");
        this.assertUpdate("ALTER TABLE test_schema_evolution_drop_end ADD COLUMN col2 INTEGER");
        this.assertQuery("SELECT * FROM test_schema_evolution_drop_end", "VALUES(0, 1, NULL)");
        this.assertUpdate("INSERT INTO test_schema_evolution_drop_end VALUES (3, 4, 5)", 1L);
        this.assertQuery("SELECT * FROM test_schema_evolution_drop_end", "VALUES(0, 1, NULL), (3, 4, 5)");
        this.assertUpdate("DROP TABLE test_schema_evolution_drop_end");
        this.assertUpdate("CREATE TABLE test_schema_evolution_drop_middle (col0 INTEGER, col1 INTEGER, col2 INTEGER)");
        this.assertUpdate("INSERT INTO test_schema_evolution_drop_middle VALUES (0, 1, 2)", 1L);
        this.assertQuery("SELECT * FROM test_schema_evolution_drop_middle", "VALUES(0, 1, 2)");
        this.assertUpdate("ALTER TABLE test_schema_evolution_drop_middle DROP COLUMN col1");
        this.assertQuery("SELECT * FROM test_schema_evolution_drop_middle", "VALUES(0, 2)");
        this.assertUpdate("ALTER TABLE test_schema_evolution_drop_middle ADD COLUMN col1 INTEGER");
        this.assertUpdate("INSERT INTO test_schema_evolution_drop_middle VALUES (3, 4, 5)", 1L);
        this.assertQuery("SELECT * FROM test_schema_evolution_drop_middle", "VALUES(0, 2, NULL), (3, 4, 5)");
        this.assertUpdate("DROP TABLE test_schema_evolution_drop_middle");
    }

    @Test
    public void testDropRowFieldWhenDuplicates() {
        Assertions.assertThatThrownBy(() -> super.testDropRowFieldWhenDuplicates()).hasMessage("Field name 'a' specified more than once");
    }

    @Test
    public void testDropAmbiguousRowFieldCaseSensitivity() {
        Assertions.assertThatThrownBy(() -> super.testDropAmbiguousRowFieldCaseSensitivity()).hasMessage("Field name 'some_field' specified more than once");
    }

    @Test
    public void testDuplicatedFieldNames() {
        String tableName = "test_duplicated_field_names" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(col row(x int, \"X\" int))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS row(x int, \"X\" int)) col", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + "(col array(row(x int, \"X\" int)))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS array(row(x int, \"X\" int))) col", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + "(col map(int, row(x int, \"X\" int)))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS map(int, row(x int, \"X\" int))) col", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + "(col row(a row(x int, \"X\" int)))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS row(a row(x int, \"X\" int))) col", "Field name 'x' specified more than once");
        try (TestTable table = this.newTrinoTable("test_duplicated_field_names_", "(id int)");){
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col row(x int, \"X\" int)", ".* Field name 'x' specified more than once");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col row(\"X\" int)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.x int", "line 1:1: Field 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE row(x int, \"X\" int)", "Field name 'x' specified more than once");
        }
    }

    @Test
    public void testDropPartitionColumn() {
        String tableName = "test_drop_partition_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INTEGER, name VARCHAR, age INTEGER, nested ROW(f1 integer, f2 integer)) WITH (partitioning = ARRAY['id', 'truncate(name, 5)', 'void(age)', '\"nested.f1\"'])");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN id", "Cannot drop partition field: id");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN name", "Cannot drop partition field: name");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN age", "Cannot drop partition field: age");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN nested", "Failed to drop column.*");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN nested.f1", "Cannot drop partition field: nested.f1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropColumnUsedInOlderPartitionSpecs() {
        String tableName = "test_drop_partition_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INTEGER, name VARCHAR, age INTEGER) WITH (partitioning = ARRAY['id', 'truncate(name, 5)', 'void(age)'])");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY[]");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN id", "Cannot drop column which is used by an old partition spec: id");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN name", "Cannot drop column which is used by an old partition spec: name");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN age", "Cannot drop column which is used by an old partition spec: age");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testShowStatsAfterAddColumn() {
        this.assertUpdate("CREATE TABLE test_show_stats_after_add_column (col0 INTEGER, col1 INTEGER, col2 INTEGER)");
        this.assertUpdate("INSERT INTO test_show_stats_after_add_column VALUES (1, 2, 3)", 1L);
        this.assertUpdate("INSERT INTO test_show_stats_after_add_column VALUES (4, 5, 6)", 1L);
        this.assertUpdate("INSERT INTO test_show_stats_after_add_column VALUES (NULL, NULL, NULL)", 1L);
        this.assertUpdate("INSERT INTO test_show_stats_after_add_column VALUES (7, 8, 9)", 1L);
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_show_stats_after_add_column"))).skippingTypesCheck().matches("VALUES   ('col0', NULL, 3e0, 25e-2, NULL, '1', '7'),  ('col1', NULL, 3e0, 25e-2, NULL, '2', '8'),   ('col2', NULL, 3e0, 25e-2, NULL, '3', '9'),   (NULL, NULL, NULL, NULL, 4e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_show_stats_after_add_column"))).skippingTypesCheck().matches("VALUES   ('col0', NULL, 3e0, 0.1e0, NULL, NULL, NULL),  ('col1', NULL, 3e0, 0.1e0, NULL, NULL, NULL),   ('col2', NULL, 3e0, 0.1e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 4e0, NULL, NULL)");
        }
        this.assertUpdate("ALTER TABLE test_show_stats_after_add_column ADD COLUMN col3 INTEGER");
        this.assertUpdate("INSERT INTO test_show_stats_after_add_column VALUES (10, 11, 12, 13)", 1L);
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_show_stats_after_add_column"))).skippingTypesCheck().matches("VALUES   ('col0', NULL, 4e0, 2e-1, NULL, '1', '10'),  ('col1', NULL, 4e0, 2e-1, NULL, '2', '11'),   ('col2', NULL, 4e0, 2e-1, NULL, '3', '12'),   ('col3', NULL, NULL, NULL, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 5e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_show_stats_after_add_column"))).skippingTypesCheck().matches("VALUES   ('col0', NULL, 4e0, 0.1e0, NULL, NULL, NULL),  ('col1', NULL, 4e0, 0.1e0, NULL, NULL, NULL),   ('col2', NULL, 4e0, 0.1e0, NULL, NULL, NULL),   ('col3', NULL, NULL, NULL, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 5e0, NULL, NULL)");
        }
    }

    @Test
    public void testLargeInOnPartitionedColumns() {
        this.assertUpdate("CREATE TABLE test_in_predicate_large_set (col1 BIGINT, col2 BIGINT) WITH (partitioning = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO test_in_predicate_large_set VALUES (1, 10)", 1L);
        this.assertUpdate("INSERT INTO test_in_predicate_large_set VALUES (2, 20)", 1L);
        List predicates = (List)IntStream.range(0, 25000).boxed().map(Object::toString).collect(ImmutableList.toImmutableList());
        String filter = String.format("col2 IN (%s)", String.join((CharSequence)",", predicates));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_in_predicate_large_set WHERE " + filter))).matches("TABLE test_in_predicate_large_set");
        this.assertUpdate("DROP TABLE test_in_predicate_large_set");
    }

    @Test
    public void testTableNameCollision() {
        String tableName = "test_rename_table_" + TestingNames.randomNameSuffix();
        String tmpName = "test_rename_table_tmp_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tmpName + " AS SELECT 1 as a", 1L);
            this.assertUpdate("ALTER TABLE " + tmpName + " RENAME TO " + tableName);
            this.assertUpdate("CREATE TABLE " + tmpName + " AS SELECT 2 as a", 1L);
            this.assertQuery("SELECT * FROM " + tmpName, "VALUES 2");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
            this.assertUpdate("DROP TABLE IF EXISTS " + tmpName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableSucceedsOnEmptyDirectory() {
        File tempDir = this.getDistributedQueryRunner().getCoordinator().getBaseDataDir().toFile();
        String tmpName = "test_rename_table_tmp_" + TestingNames.randomNameSuffix();
        Path newPath = tempDir.toPath().resolve(tmpName);
        File directory = newPath.toFile();
        Verify.verify((boolean)directory.mkdirs(), (String)"Could not make directory on filesystem", (Object[])new Object[0]);
        try {
            this.assertUpdate("CREATE TABLE " + tmpName + " WITH (location='" + String.valueOf(directory) + "') AS SELECT 1 as a", 1L);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tmpName);
        }
    }

    @Test
    public void testCreateTableLike() {
        IcebergFileFormat otherFormat = this.format == IcebergFileFormat.PARQUET ? IcebergFileFormat.ORC : IcebergFileFormat.PARQUET;
        this.testCreateTableLikeForFormat(otherFormat);
    }

    private void testCreateTableLikeForFormat(IcebergFileFormat otherFormat) {
        File tempDir = this.getDistributedQueryRunner().getCoordinator().getBaseDataDir().toFile();
        String tempDirPath = tempDir.toURI().toASCIIString() + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE test_create_table_like_original (col1 INTEGER, aDate DATE) WITH(format = '%s', location = '%s', partitioning = ARRAY['aDate'])", this.format, tempDirPath));
        Assertions.assertThat((String)this.getTablePropertiesString("test_create_table_like_original")).isEqualTo(String.format("WITH (\n   format = '%s',\n   format_version = 2,\n   location = '%s',\n   max_commit_retry = 4,\n   partitioning = ARRAY['adate']\n)", this.format, tempDirPath));
        this.assertUpdate("CREATE TABLE test_create_table_like_copy0 (LIKE test_create_table_like_original, col2 INTEGER)");
        this.assertUpdate("INSERT INTO test_create_table_like_copy0 (col1, aDate, col2) VALUES (1, CAST('1950-06-28' AS DATE), 3)", 1L);
        this.assertQuery("SELECT * from test_create_table_like_copy0", "VALUES(1, CAST('1950-06-28' AS DATE), 3)");
        this.assertUpdate("CREATE TABLE test_create_table_like_copy1 (LIKE test_create_table_like_original)");
        Assertions.assertThat((String)this.getTablePropertiesString("test_create_table_like_copy1")).isEqualTo(String.format("WITH (\n   format = '%s',\n   format_version = 2,\n   location = '%s',\n   max_commit_retry = 4\n)", this.format, this.getTableLocation("test_create_table_like_copy1")));
        this.assertUpdate("CREATE TABLE test_create_table_like_copy2 (LIKE test_create_table_like_original EXCLUDING PROPERTIES)");
        Assertions.assertThat((String)this.getTablePropertiesString("test_create_table_like_copy2")).isEqualTo(String.format("WITH (\n   format = '%s',\n   format_version = 2,\n   location = '%s',\n   max_commit_retry = 4\n)", this.format, this.getTableLocation("test_create_table_like_copy2")));
        this.assertUpdate("DROP TABLE test_create_table_like_copy2");
        this.assertQueryFails("CREATE TABLE test_create_table_like_copy3 (LIKE test_create_table_like_original INCLUDING PROPERTIES)", "Cannot create a table on a non-empty location.*");
        this.assertQueryFails(String.format("CREATE TABLE test_create_table_like_copy4 (LIKE test_create_table_like_original INCLUDING PROPERTIES) WITH (format = '%s')", otherFormat), "Cannot create a table on a non-empty location.*");
    }

    private String getTablePropertiesString(String tableName) {
        MaterializedResult showCreateTable = this.computeActual("SHOW CREATE TABLE " + tableName);
        String createTable = (String)Iterables.getOnlyElement((Iterable)showCreateTable.getOnlyColumnAsSet());
        Matcher matcher = WITH_CLAUSE_EXTRACTOR.matcher(createTable);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Test
    public void testPredicating() {
        this.assertUpdate("CREATE TABLE test_predicating_on_real (col REAL)");
        this.assertUpdate("INSERT INTO test_predicating_on_real VALUES 1.2", 1L);
        this.assertQuery("SELECT * FROM test_predicating_on_real WHERE col = 1.2", "VALUES 1.2");
        this.assertUpdate("DROP TABLE test_predicating_on_real");
    }

    @Test
    public void testHourTransformTimestamp() {
        this.assertUpdate("CREATE TABLE test_hour_transform_timestamp (d timestamp(6), b bigint) WITH (partitioning = ARRAY['hour(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1969-12-31 22:22:22.222222', 8),(TIMESTAMP '1969-12-31 23:33:11.456789', 9),(TIMESTAMP '1969-12-31 23:44:55.567890', 10),(TIMESTAMP '1970-01-01 00:55:44.765432', 11),(TIMESTAMP '2015-01-01 10:01:23.123456', 1),(TIMESTAMP '2015-01-01 10:10:02.987654', 2),(TIMESTAMP '2015-01-01 10:55:00.456789', 3),(TIMESTAMP '2015-05-15 12:05:01.234567', 4),(TIMESTAMP '2015-05-15 12:21:02.345678', 5),(TIMESTAMP '2020-02-21 13:11:11.876543', 6),(TIMESTAMP '2020-02-21 13:12:12.654321', 7)";
        this.assertUpdate("INSERT INTO test_hour_transform_timestamp " + values, 12L);
        this.assertQuery("SELECT * FROM test_hour_transform_timestamp", values);
        String expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 1, TIMESTAMP '1969-12-31 22:22:22.222222', TIMESTAMP '1969-12-31 22:22:22.222222', 8, 8), (-1, 2, TIMESTAMP '1969-12-31 23:33:11.456789', TIMESTAMP '1969-12-31 23:44:55.567890', 9, 10), (0, 1, TIMESTAMP '1970-01-01 00:55:44.765432', TIMESTAMP '1970-01-01 00:55:44.765432', 11, 11), (394474, 3, TIMESTAMP '2015-01-01 10:01:23.123456', TIMESTAMP '2015-01-01 10:55:00.456789', 1, 3), (397692, 2, TIMESTAMP '2015-05-15 12:05:01.234567', TIMESTAMP '2015-05-15 12:21:02.345678', 4, 5), (439525, 2, TIMESTAMP '2020-02-21 13:11:11.876543', TIMESTAMP '2020-02-21 13:12:12.654321', 6, 7)";
        String expectedTimestampStats = "NULL, 11e0, 0.0833333e0, NULL, '1969-12-31 22:22:22.222222', '2020-02-21 13:12:12.654321'";
        String expectedBigIntStats = "NULL, 12e0, 0e0, NULL, '1', '101'";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 1, TIMESTAMP '1969-12-31 22:22:22.222000', TIMESTAMP '1969-12-31 22:22:22.222999', 8, 8), (-1, 2, TIMESTAMP '1969-12-31 23:33:11.456000', TIMESTAMP '1969-12-31 23:44:55.567999', 9, 10), (0, 1, TIMESTAMP '1970-01-01 00:55:44.765000', TIMESTAMP '1970-01-01 00:55:44.765999', 11, 11), (394474, 3, TIMESTAMP '2015-01-01 10:01:23.123000', TIMESTAMP '2015-01-01 10:55:00.456999', 1, 3), (397692, 2, TIMESTAMP '2015-05-15 12:05:01.234000', TIMESTAMP '2015-05-15 12:21:02.345999', 4, 5), (439525, 2, TIMESTAMP '2020-02-21 13:11:11.876000', TIMESTAMP '2020-02-21 13:12:12.654999', 6, 7)";
            expectedTimestampStats = "NULL, 11e0, 0.0833333e0, NULL, '1969-12-31 22:22:22.222000', '2020-02-21 13:12:12.654999'";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, 1, NULL, NULL, NULL, NULL), (-2, 1, NULL, NULL, NULL, NULL), (-1, 2, NULL, NULL, NULL, NULL), (0, 1, NULL, NULL, NULL, NULL), (394474, 3, NULL, NULL, NULL, NULL), (397692, 2, NULL, NULL, NULL, NULL), (439525, 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "NULL, 11e0, 0.0833333e0, NULL, NULL, NULL";
            expectedBigIntStats = "NULL, 12e0, 0e0, NULL, NULL, NULL";
        }
        this.assertQuery("SELECT partition.d_hour, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_hour_transform_timestamp$partitions\"", expected);
        this.assertQuery("SELECT * FROM test_hour_transform_timestamp WHERE day_of_week(d) = 3 AND b % 7 = 3", "VALUES (TIMESTAMP '1969-12-31 23:44:55.567890', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_hour_transform_timestamp"))).skippingTypesCheck().matches("VALUES   ('d', " + expectedTimestampStats + "),   ('b', " + expectedBigIntStats + "),   (NULL, NULL, NULL, NULL, 12e0, NULL, NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE d >= DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE CAST(d AS date) >= DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE d >= TIMESTAMP '2015-05-15 12:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE d >= TIMESTAMP '2015-05-15 12:00:00.000001'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE date(d) = DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE date_trunc('hour', d) = TIMESTAMP '2015-05-15 12:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE date_trunc('day', d) = DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE date_trunc('month', d) = DATE '2015-05-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamp WHERE date_trunc('year', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_hour_transform_timestamp");
    }

    @Test
    public void testHourTransformTimestampWithTimeZone() {
        this.assertUpdate("CREATE TABLE test_hour_transform_timestamptz (d timestamp(6) with time zone, b integer) WITH (partitioning = ARRAY['hour(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1969-12-31 22:22:22.222222 UTC', 8),(TIMESTAMP '1969-12-31 23:33:11.456789 UTC', 9),(TIMESTAMP '1969-12-31 23:44:55.567890 UTC', 10),(TIMESTAMP '1970-01-01 00:55:44.765432 UTC', 11),(TIMESTAMP '2015-01-01 10:01:23.123456 UTC', 1),(TIMESTAMP '2015-01-01 10:10:02.987654 UTC', 2),(TIMESTAMP '2015-01-01 10:55:00.456789 UTC', 3),(TIMESTAMP '2015-05-15 12:05:01.234567 UTC', 4),(TIMESTAMP '2015-05-15 12:21:02.345678 UTC', 5),(TIMESTAMP '2020-02-21 13:11:11.876543 UTC', 6),(TIMESTAMP '2020-02-21 13:12:12.654321 UTC', 7)";
        this.assertUpdate("INSERT INTO test_hour_transform_timestamptz " + values, 12L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz"))).matches(values);
        String expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (-2, 1, TIMESTAMP '1969-12-31 22:22:22.222222 UTC', TIMESTAMP '1969-12-31 22:22:22.222222 UTC', 8, 8), (-1, 2, TIMESTAMP '1969-12-31 23:33:11.456789 UTC', TIMESTAMP '1969-12-31 23:44:55.567890 UTC', 9, 10), (0, 1, TIMESTAMP '1970-01-01 00:55:44.765432 UTC', TIMESTAMP '1970-01-01 00:55:44.765432 UTC', 11, 11), (394474, 3, TIMESTAMP '2015-01-01 10:01:23.123456 UTC', TIMESTAMP '2015-01-01 10:55:00.456789 UTC', 1, 3), (397692, 2, TIMESTAMP '2015-05-15 12:05:01.234567 UTC', TIMESTAMP '2015-05-15 12:21:02.345678 UTC', 4, 5), (439525, 2, TIMESTAMP '2020-02-21 13:11:11.876543 UTC', TIMESTAMP '2020-02-21 13:12:12.654321 UTC', 6, 7)";
        String expectedTimestampStats = "NULL, 11e0, 0.0833333e0, NULL, '1969-12-31 22:22:22.222 UTC', '2020-02-21 13:12:12.654 UTC'";
        String expectedBigIntStats = "NULL, 12e0, 0e0, NULL, '1', '101'";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (-2, 1, TIMESTAMP '1969-12-31 22:22:22.222000 UTC', TIMESTAMP '1969-12-31 22:22:22.222999 UTC', 8, 8), (-1, 2, TIMESTAMP '1969-12-31 23:33:11.456000 UTC', TIMESTAMP '1969-12-31 23:44:55.567999 UTC', 9, 10), (0, 1, TIMESTAMP '1970-01-01 00:55:44.765000 UTC', TIMESTAMP '1970-01-01 00:55:44.765999 UTC', 11, 11), (394474, 3, TIMESTAMP '2015-01-01 10:01:23.123000 UTC', TIMESTAMP '2015-01-01 10:55:00.456999 UTC', 1, 3), (397692, 2, TIMESTAMP '2015-05-15 12:05:01.234000 UTC', TIMESTAMP '2015-05-15 12:21:02.345999 UTC', 4, 5), (439525, 2, TIMESTAMP '2020-02-21 13:11:11.876000 UTC', TIMESTAMP '2020-02-21 13:12:12.654999 UTC', 6, 7)";
            expectedTimestampStats = "NULL, 11e0, 0.0833333e0, NULL, '1969-12-31 22:22:22.222 UTC', '2020-02-21 13:12:12.654 UTC'";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, BIGINT '1', CAST(NULL AS timestamp(6) with time zone), CAST(NULL AS timestamp(6) with time zone), CAST(NULL AS integer), CAST(NULL AS integer)), (-2, 1, NULL, NULL, NULL, NULL), (-1, 2, NULL, NULL, NULL, NULL), (0, 1, NULL, NULL, NULL, NULL), (394474, 3, NULL, NULL, NULL, NULL), (397692, 2, NULL, NULL, NULL, NULL), (439525, 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "NULL, 11e0, 0.0833333e0, NULL, NULL, NULL";
            expectedBigIntStats = "NULL, 12e0, 0e0, NULL, NULL, NULL";
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.d_hour, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_hour_transform_timestamptz$partitions\""))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE day_of_week(d) = 3 AND b % 7 = 3"))).matches("VALUES (TIMESTAMP '1969-12-31 23:44:55.567890 UTC', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_hour_transform_timestamptz"))).skippingTypesCheck().matches("VALUES   ('d', " + expectedTimestampStats + "),   ('b', " + expectedBigIntStats + "),   (NULL, NULL, NULL, NULL, 12e0, NULL, NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE d >= DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE d >= TIMESTAMP '2015-05-15 12:00:00 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE d >= TIMESTAMP '2015-05-15 12:00:00.000001 UTC'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE date(d) = DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE date_trunc('hour', d) = TIMESTAMP '2015-05-15 12:00:00.000000 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE date_trunc('day', d) = TIMESTAMP '2015-05-15 00:00:00.000000 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE date_trunc('month', d) = TIMESTAMP '2015-05-01 00:00:00.000000 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_hour_transform_timestamptz WHERE date_trunc('year', d) = TIMESTAMP '2015-01-01 00:00:00.000000 UTC'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_hour_transform_timestamptz");
    }

    @Test
    public void testPartitionPredicatePushdownWithHistoricalPartitionSpecs() {
        String tableName = "test_partition_predicate_pushdown_with_historical_partition_specs";
        this.assertUpdate("CREATE TABLE " + tableName + " (d TIMESTAMP(6), b INTEGER) WITH (partitioning = ARRAY['bucket(b, 3)'])");
        String selectQuery = "SELECT b FROM " + tableName + " WHERE CAST(d AS date) < DATE '2015-01-02'";
        String initialValues = "(TIMESTAMP '1969-12-31 22:22:22.222222', 8),(TIMESTAMP '1969-12-31 23:33:11.456789', 9),(TIMESTAMP '1969-12-31 23:44:55.567890', 10)";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + initialValues, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectQuery))).containsAll("VALUES 8, 9, 10").isNotFullyPushedDown(FilterNode.class, new Class[0]);
        String hourTransformValues = "(TIMESTAMP '2015-01-01 10:01:23.123456', 1),(TIMESTAMP '2015-01-02 10:10:02.987654', 2),(TIMESTAMP '2015-01-03 10:55:00.456789', 3)";
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['hour(d)']");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + hourTransformValues, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectQuery))).containsAll("VALUES 1, 8, 9, 10").isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE year(d) = 1969", 3L);
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE optimize");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + initialValues, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectQuery))).containsAll("VALUES 1, 8, 9, 10").isFullyPushedDown();
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionPredicatePushdownWithNestedFieldPartitioning() {
        String tableName = "test_partition_predicate_pushdown_with_nested_field_partitioning";
        this.assertUpdate("CREATE TABLE " + tableName + " (parent ROW(child1 TIMESTAMP(6), child2 INTEGER)) WITH (partitioning = ARRAY['bucket(\"parent.child2\", 3)'])");
        String selectQuery = "SELECT parent.child2 FROM " + tableName + " WHERE CAST(parent.child1 AS date) < DATE '2015-01-02'";
        String initialValues = "ROW(ROW(TIMESTAMP '1969-12-31 22:22:22.222222', 8)),ROW(ROW(TIMESTAMP '1969-12-31 23:33:11.456789', 9)),ROW(ROW(TIMESTAMP '1969-12-31 23:44:55.567890', 10))";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + initialValues, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectQuery))).containsAll("VALUES 8, 9, 10").isNotFullyPushedDown(FilterNode.class, new Class[0]);
        String hourTransformValues = "ROW(ROW(TIMESTAMP '2015-01-01 10:01:23.123456', 1)),ROW(ROW(TIMESTAMP '2015-01-02 10:10:02.987654', 2)),ROW(ROW(TIMESTAMP '2015-01-03 10:55:00.456789', 3))";
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['hour(\"parent.child1\")']");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + hourTransformValues, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectQuery))).containsAll("VALUES 1, 8, 9, 10").isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE year(parent.child1) = 1969", 3L);
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE optimize");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + initialValues, 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectQuery))).containsAll("VALUES 1, 8, 9, 10").isFullyPushedDown();
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDayTransformDate() {
        this.assertUpdate("CREATE TABLE test_day_transform_date (d DATE, b BIGINT) WITH (partitioning = ARRAY['day(d)'])");
        String values = "VALUES (NULL, 101),(DATE '1969-01-01', 10), (DATE '1969-12-31', 11), (DATE '1970-01-01', 1), (DATE '1970-03-04', 2), (DATE '2015-01-01', 3), (DATE '2015-01-13', 4), (DATE '2015-01-13', 5), (DATE '2015-05-15', 6), (DATE '2015-05-15', 7), (DATE '2020-02-21', 8), (DATE '2020-02-21', 9)";
        this.assertUpdate("INSERT INTO test_day_transform_date " + values, 12L);
        this.assertQuery("SELECT * FROM test_day_transform_date", values);
        String expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (DATE '1969-01-01', 1, DATE '1969-01-01', DATE '1969-01-01', 10, 10), (DATE '1969-12-31', 1, DATE '1969-12-31', DATE '1969-12-31', 11, 11), (DATE '1970-01-01', 1, DATE '1970-01-01', DATE '1970-01-01', 1, 1), (DATE '1970-03-04', 1, DATE '1970-03-04', DATE '1970-03-04', 2, 2), (DATE '2015-01-01', 1, DATE '2015-01-01', DATE '2015-01-01', 3, 3), (DATE '2015-01-13', 2, DATE '2015-01-13', DATE '2015-01-13', 4, 5), (DATE '2015-05-15', 2, DATE '2015-05-15', DATE '2015-05-15', 6, 7), (DATE '2020-02-21', 2, DATE '2020-02-21', DATE '2020-02-21', 8, 9)";
        if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, 1, NULL, NULL, NULL, NULL), (DATE '1969-01-01', 1, NULL, NULL, NULL, NULL), (DATE '1969-12-31', 1, NULL, NULL, NULL, NULL), (DATE '1970-01-01', 1, NULL, NULL, NULL, NULL), (DATE '1970-03-04', 1, NULL, NULL, NULL, NULL), (DATE '2015-01-01', 1, NULL, NULL, NULL, NULL), (DATE '2015-01-13', 2, NULL, NULL, NULL, NULL), (DATE '2015-05-15', 2, NULL, NULL, NULL, NULL), (DATE '2020-02-21', 2, NULL, NULL, NULL, NULL)";
        }
        this.assertQuery("SELECT partition.d_day, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_day_transform_date$partitions\"", expected);
        this.assertQuery("SELECT * FROM test_day_transform_date WHERE day_of_week(d) = 3 AND b % 7 = 3", "VALUES (DATE '1969-01-01', 10)");
        String expectedTransformed = "VALUES   ('d', NULL, 8e0, 0.0833333e0, NULL, '1969-01-01', '2020-02-21'),   ('b', NULL, 12e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 12e0, NULL, NULL)";
        if (this.format == IcebergFileFormat.AVRO) {
            expectedTransformed = "VALUES   ('d', NULL, 8e0, 0.1e0, NULL, NULL, NULL),   ('b', NULL, 12e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 12e0, NULL, NULL)";
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_day_transform_date"))).skippingTypesCheck().matches(expectedTransformed);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE d >= DATE '2015-01-13'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE CAST(d AS date) >= DATE '2015-01-13'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE d >= TIMESTAMP '2015-01-13 00:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE d >= TIMESTAMP '2015-01-13 00:00:00.000001'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE date(d) = DATE '2015-01-13'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE date_trunc('day', d) = DATE '2015-01-13'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE date_trunc('month', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_date WHERE date_trunc('year', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_day_transform_date");
    }

    @Test
    public void testDayTransformTimestamp() {
        this.assertUpdate("CREATE TABLE test_day_transform_timestamp (d TIMESTAMP(6), b BIGINT) WITH (partitioning = ARRAY['day(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1969-12-25 15:13:12.876543', 8),(TIMESTAMP '1969-12-30 18:47:33.345678', 9),(TIMESTAMP '1969-12-31 00:00:00.000000', 10),(TIMESTAMP '1969-12-31 05:06:07.234567', 11),(TIMESTAMP '1970-01-01 12:03:08.456789', 12),(TIMESTAMP '2015-01-01 10:01:23.123456', 1),(TIMESTAMP '2015-01-01 11:10:02.987654', 2),(TIMESTAMP '2015-01-01 12:55:00.456789', 3),(TIMESTAMP '2015-05-15 13:05:01.234567', 4),(TIMESTAMP '2015-05-15 14:21:02.345678', 5),(TIMESTAMP '2020-02-21 15:11:11.876543', 6),(TIMESTAMP '2020-02-21 16:12:12.654321', 7)";
        this.assertUpdate("INSERT INTO test_day_transform_timestamp " + values, 13L);
        this.assertQuery("SELECT * FROM test_day_transform_timestamp", values);
        String expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (DATE '1969-12-25', 1, TIMESTAMP '1969-12-25 15:13:12.876543', TIMESTAMP '1969-12-25 15:13:12.876543', 8, 8), (DATE '1969-12-30', 1, TIMESTAMP '1969-12-30 18:47:33.345678', TIMESTAMP '1969-12-30 18:47:33.345678', 9, 9), (DATE '1969-12-31', 2, TIMESTAMP '1969-12-31 00:00:00.000000', TIMESTAMP '1969-12-31 05:06:07.234567', 10, 11), (DATE '1970-01-01', 1, TIMESTAMP '1970-01-01 12:03:08.456789', TIMESTAMP '1970-01-01 12:03:08.456789', 12, 12), (DATE '2015-01-01', 3, TIMESTAMP '2015-01-01 10:01:23.123456', TIMESTAMP '2015-01-01 12:55:00.456789', 1, 3), (DATE '2015-05-15', 2, TIMESTAMP '2015-05-15 13:05:01.234567', TIMESTAMP '2015-05-15 14:21:02.345678', 4, 5), (DATE '2020-02-21', 2, TIMESTAMP '2020-02-21 15:11:11.876543', TIMESTAMP '2020-02-21 16:12:12.654321', 6, 7)";
        String expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1969-12-25 15:13:12.876543', '2020-02-21 16:12:12.654321'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (DATE '1969-12-25', 1, TIMESTAMP '1969-12-25 15:13:12.876000', TIMESTAMP '1969-12-25 15:13:12.876999', 8, 8), (DATE '1969-12-30', 1, TIMESTAMP '1969-12-30 18:47:33.345000', TIMESTAMP '1969-12-30 18:47:33.345999', 9, 9), (DATE '1969-12-31', 2, TIMESTAMP '1969-12-31 00:00:00.000000', TIMESTAMP '1969-12-31 05:06:07.234999', 10, 11), (DATE '1970-01-01', 1, TIMESTAMP '1970-01-01 12:03:08.456000', TIMESTAMP '1970-01-01 12:03:08.456999', 12, 12), (DATE '2015-01-01', 3, TIMESTAMP '2015-01-01 10:01:23.123000', TIMESTAMP '2015-01-01 12:55:00.456999', 1, 3), (DATE '2015-05-15', 2, TIMESTAMP '2015-05-15 13:05:01.234000', TIMESTAMP '2015-05-15 14:21:02.345999', 4, 5), (DATE '2020-02-21', 2, TIMESTAMP '2020-02-21 15:11:11.876000', TIMESTAMP '2020-02-21 16:12:12.654999', 6, 7)";
            expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1969-12-25 15:13:12.876000', '2020-02-21 16:12:12.654999'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, 1, NULL, NULL, NULL, NULL), (DATE '1969-12-25', 1, NULL, NULL, NULL, NULL), (DATE '1969-12-30', 1, NULL, NULL, NULL, NULL), (DATE '1969-12-31', 2, NULL, NULL, NULL, NULL), (DATE '1970-01-01', 1, NULL, NULL, NULL, NULL), (DATE '2015-01-01', 3, NULL, NULL, NULL, NULL), (DATE '2015-05-15', 2, NULL, NULL, NULL, NULL), (DATE '2020-02-21', 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.076923e0, NULL, NULL, NULL),   ('b', NULL, 13e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        }
        this.assertQuery("SELECT partition.d_day, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_day_transform_timestamp$partitions\"", expected);
        this.assertQuery("SELECT * FROM test_day_transform_timestamp WHERE day_of_week(d) = 3 AND b % 7 = 3", "VALUES (TIMESTAMP '1969-12-31 00:00:00.000000', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_day_transform_timestamp"))).skippingTypesCheck().matches(expectedTimestampStats);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE d >= DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE CAST(d AS date) >= DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE d >= TIMESTAMP '2015-05-15 00:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE d >= TIMESTAMP '2015-05-15 00:00:00.000001'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE date(d) = DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE date_trunc('day', d) = DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE date_trunc('month', d) = DATE '2015-05-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamp WHERE date_trunc('year', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_day_transform_timestamp");
    }

    @Test
    public void testDayTransformTimestampWithTimeZone() {
        this.assertUpdate("CREATE TABLE test_day_transform_timestamptz (d timestamp(6) with time zone, b integer) WITH (partitioning = ARRAY['day(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1969-12-25 15:13:12.876543 UTC', 8),(TIMESTAMP '1969-12-30 18:47:33.345678 UTC', 9),(TIMESTAMP '1969-12-31 00:00:00.000000 UTC', 10),(TIMESTAMP '1969-12-31 05:06:07.234567 UTC', 11),(TIMESTAMP '1970-01-01 12:03:08.456789 UTC', 12),(TIMESTAMP '2015-01-01 10:01:23.123456 UTC', 1),(TIMESTAMP '2015-01-01 11:10:02.987654 UTC', 2),(TIMESTAMP '2015-01-01 12:55:00.456789 UTC', 3),(TIMESTAMP '2015-05-15 13:05:01.234567 UTC', 4),(TIMESTAMP '2015-05-15 14:21:02.345678 UTC', 5),(TIMESTAMP '2020-02-21 15:11:11.876543 UTC', 6),(TIMESTAMP '2020-02-21 16:12:12.654321 UTC', 7)";
        this.assertUpdate("INSERT INTO test_day_transform_timestamptz " + values, 13L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz"))).matches(values);
        String expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (DATE '1969-12-25', 1, TIMESTAMP '1969-12-25 15:13:12.876543 UTC', TIMESTAMP '1969-12-25 15:13:12.876543 UTC', 8, 8), (DATE '1969-12-30', 1, TIMESTAMP '1969-12-30 18:47:33.345678 UTC', TIMESTAMP '1969-12-30 18:47:33.345678 UTC', 9, 9), (DATE '1969-12-31', 2, TIMESTAMP '1969-12-31 00:00:00.000000 UTC', TIMESTAMP '1969-12-31 05:06:07.234567 UTC', 10, 11), (DATE '1970-01-01', 1, TIMESTAMP '1970-01-01 12:03:08.456789 UTC', TIMESTAMP '1970-01-01 12:03:08.456789 UTC', 12, 12), (DATE '2015-01-01', 3, TIMESTAMP '2015-01-01 10:01:23.123456 UTC', TIMESTAMP '2015-01-01 12:55:00.456789 UTC', 1, 3), (DATE '2015-05-15', 2, TIMESTAMP '2015-05-15 13:05:01.234567 UTC', TIMESTAMP '2015-05-15 14:21:02.345678 UTC', 4, 5), (DATE '2020-02-21', 2, TIMESTAMP '2020-02-21 15:11:11.876543 UTC', TIMESTAMP '2020-02-21 16:12:12.654321 UTC', 6, 7)";
        String expectedTimestampStats = "NULL, 12e0, 0.0769231e0, NULL, '1969-12-25 15:13:12.876 UTC', '2020-02-21 16:12:12.654 UTC'";
        String expectedIntegerStats = "NULL, 13e0, 0e0, NULL, '1', '101'";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (DATE '1969-12-25', 1, TIMESTAMP '1969-12-25 15:13:12.876000 UTC', TIMESTAMP '1969-12-25 15:13:12.876999 UTC', 8, 8), (DATE '1969-12-30', 1, TIMESTAMP '1969-12-30 18:47:33.345000 UTC', TIMESTAMP '1969-12-30 18:47:33.345999 UTC', 9, 9), (DATE '1969-12-31', 2, TIMESTAMP '1969-12-31 00:00:00.000000 UTC', TIMESTAMP '1969-12-31 05:06:07.234999 UTC', 10, 11), (DATE '1970-01-01', 1, TIMESTAMP '1970-01-01 12:03:08.456000 UTC', TIMESTAMP '1970-01-01 12:03:08.456999 UTC', 12, 12), (DATE '2015-01-01', 3, TIMESTAMP '2015-01-01 10:01:23.123000 UTC', TIMESTAMP '2015-01-01 12:55:00.456999 UTC', 1, 3), (DATE '2015-05-15', 2, TIMESTAMP '2015-05-15 13:05:01.234000 UTC', TIMESTAMP '2015-05-15 14:21:02.345999 UTC', 4, 5), (DATE '2020-02-21', 2, TIMESTAMP '2020-02-21 15:11:11.876000 UTC', TIMESTAMP '2020-02-21 16:12:12.654999 UTC', 6, 7)";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, BIGINT '1', NULL, NULL, NULL, NULL), (DATE '1969-12-25', 1, NULL, NULL, NULL, NULL), (DATE '1969-12-30', 1, NULL, NULL, NULL, NULL), (DATE '1969-12-31', 2, NULL, NULL, NULL, NULL), (DATE '1970-01-01', 1, NULL, NULL, NULL, NULL), (DATE '2015-01-01', 3, NULL, NULL, NULL, NULL), (DATE '2015-05-15', 2, NULL, NULL, NULL, NULL), (DATE '2020-02-21', 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "NULL, 12e0, 0.0769231e0, NULL, NULL, NULL";
            expectedIntegerStats = "NULL, 13e0, 0e0, NULL, NULL, NULL";
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.d_day, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_day_transform_timestamptz$partitions\""))).skippingTypesCheck().matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE day_of_week(d) = 3 AND b % 7 = 3"))).matches("VALUES (TIMESTAMP '1969-12-31 00:00:00.000000 UTC', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_day_transform_timestamptz"))).skippingTypesCheck().matches("VALUES   ('d', " + expectedTimestampStats + "),   ('b', " + expectedIntegerStats + "),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE d >= with_timezone(DATE '2015-05-15', 'UTC')"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-05-15' AND d < TIMESTAMP '2015-05-15 02:00:00 Europe/Warsaw'"))).hasPlan(PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ValuesNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE d >= TIMESTAMP '2015-05-15 00:00:00 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE d >= TIMESTAMP '2015-05-15 00:00:00.000001 UTC'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE date(d) = DATE '2015-05-15'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE date_trunc('day', d) = TIMESTAMP '2015-05-15 00:00:00.000000 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE date_trunc('month', d) = TIMESTAMP '2015-05-01 00:00:00.000000 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_day_transform_timestamptz WHERE date_trunc('year', d) = TIMESTAMP '2015-01-01 00:00:00.000000 UTC'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_day_transform_timestamptz");
    }

    @Test
    public void testMonthTransformDate() {
        this.assertUpdate("CREATE TABLE test_month_transform_date (d DATE, b BIGINT) WITH (partitioning = ARRAY['month(d)'])");
        String values = "VALUES (NULL, 101),(DATE '1969-11-13', 1),(DATE '1969-12-01', 2),(DATE '1969-12-02', 3),(DATE '1969-12-31', 4),(DATE '1970-01-01', 5), (DATE '1970-05-13', 6), (DATE '1970-12-31', 7), (DATE '2020-01-01', 8), (DATE '2020-06-16', 9), (DATE '2020-06-28', 10), (DATE '2020-06-06', 11), (DATE '2020-07-18', 12), (DATE '2020-07-28', 13), (DATE '2020-12-31', 14)";
        this.assertUpdate("INSERT INTO test_month_transform_date " + values, 15L);
        this.assertQuery("SELECT * FROM test_month_transform_date", values);
        String expectedDateStats = "NULL, 14e0, 0.0666667e0, NULL, '1969-11-13', '2020-12-31'";
        String expectedBigIntStats = "NULL, 15e0, 0e0, NULL, '1', '101'";
        if (this.format != IcebergFileFormat.AVRO) {
            this.assertQuery("SELECT partition.d_month, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_month_transform_date$partitions\"", "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 1, DATE '1969-11-13', DATE '1969-11-13', 1, 1), (-1, 3, DATE '1969-12-01', DATE '1969-12-31', 2, 4), (0, 1, DATE '1970-01-01', DATE '1970-01-01', 5, 5), (4, 1, DATE '1970-05-13', DATE '1970-05-13', 6, 6), (11, 1, DATE '1970-12-31', DATE '1970-12-31', 7, 7), (600, 1, DATE '2020-01-01', DATE '2020-01-01', 8, 8), (605, 3, DATE '2020-06-06', DATE '2020-06-28', 9, 11), (606, 2, DATE '2020-07-18', DATE '2020-07-28', 12, 13), (611, 1, DATE '2020-12-31', DATE '2020-12-31', 14, 14)");
        } else {
            this.assertQuery("SELECT partition.d_month, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_month_transform_date$partitions\"", "VALUES (NULL, 1, NULL, NULL, NULL, NULL), (-2, 1, NULL, NULL, NULL, NULL), (-1, 3, NULL, NULL, NULL, NULL), (0, 1, NULL, NULL, NULL, NULL), (4, 1, NULL, NULL, NULL, NULL), (11, 1, NULL, NULL, NULL, NULL), (600, 1, NULL, NULL, NULL, NULL), (605, 3, NULL, NULL, NULL, NULL), (606, 2, NULL, NULL, NULL, NULL), (611, 1, NULL, NULL, NULL, NULL)");
            expectedDateStats = "NULL, 14e0, 0.0666667e0, NULL, NULL, NULL";
            expectedBigIntStats = "NULL, 15e0, 0e0, NULL, NULL, NULL";
        }
        this.assertQuery("SELECT * FROM test_month_transform_date WHERE day_of_week(d) = 7 AND b % 7 = 3", "VALUES (DATE '2020-06-28', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_month_transform_date"))).skippingTypesCheck().matches("VALUES   ('d', " + expectedDateStats + "),   ('b', " + expectedBigIntStats + "),   (NULL, NULL, NULL, NULL, 15e0, NULL, NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE d >= DATE '2020-06-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE d >= DATE '2020-06-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE CAST(d AS date) >= DATE '2020-06-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE CAST(d AS date) >= DATE '2020-06-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE d >= TIMESTAMP '2015-06-01 00:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE d >= TIMESTAMP '2015-05-01 00:00:00.000001'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE date_trunc('month', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_date WHERE date_trunc('year', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_month_transform_date"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 14e0, 0.0666667e0, NULL, '1969-11-13', '2020-12-31'),   ('b', NULL, 15e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 15e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_month_transform_date"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 14e0, 0.0666667e0, NULL, NULL, NULL),   ('b', NULL, 15e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 15e0, NULL, NULL)");
        }
        this.assertUpdate("DROP TABLE test_month_transform_date");
    }

    @Test
    public void testMonthTransformTimestamp() {
        this.assertUpdate("CREATE TABLE test_month_transform_timestamp (d TIMESTAMP(6), b BIGINT) WITH (partitioning = ARRAY['month(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1969-11-15 15:13:12.876543', 8),(TIMESTAMP '1969-11-19 18:47:33.345678', 9),(TIMESTAMP '1969-12-01 00:00:00.000000', 10),(TIMESTAMP '1969-12-01 05:06:07.234567', 11),(TIMESTAMP '1970-01-01 12:03:08.456789', 12),(TIMESTAMP '2015-01-01 10:01:23.123456', 1),(TIMESTAMP '2015-01-01 11:10:02.987654', 2),(TIMESTAMP '2015-01-01 12:55:00.456789', 3),(TIMESTAMP '2015-05-15 13:05:01.234567', 4),(TIMESTAMP '2015-05-15 14:21:02.345678', 5),(TIMESTAMP '2020-02-21 15:11:11.876543', 6),(TIMESTAMP '2020-02-21 16:12:12.654321', 7)";
        this.assertUpdate("INSERT INTO test_month_transform_timestamp " + values, 13L);
        this.assertQuery("SELECT * FROM test_month_transform_timestamp", values);
        String expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1969-11-15 15:13:12.876543', TIMESTAMP '1969-11-19 18:47:33.345678', 8, 9), (-1, 2, TIMESTAMP '1969-12-01 00:00:00.000000', TIMESTAMP '1969-12-01 05:06:07.234567', 10, 11), (0, 1, TIMESTAMP '1970-01-01 12:03:08.456789', TIMESTAMP '1970-01-01 12:03:08.456789', 12, 12), (540, 3, TIMESTAMP '2015-01-01 10:01:23.123456', TIMESTAMP '2015-01-01 12:55:00.456789', 1, 3), (544, 2, TIMESTAMP '2015-05-15 13:05:01.234567', TIMESTAMP '2015-05-15 14:21:02.345678', 4, 5), (601, 2, TIMESTAMP '2020-02-21 15:11:11.876543', TIMESTAMP '2020-02-21 16:12:12.654321', 6, 7)";
        String expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1969-11-15 15:13:12.876543', '2020-02-21 16:12:12.654321'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1969-11-15 15:13:12.876000', TIMESTAMP '1969-11-19 18:47:33.345999', 8, 9), (-1, 2, TIMESTAMP '1969-12-01 00:00:00.000000', TIMESTAMP '1969-12-01 05:06:07.234999', 10, 11), (0, 1, TIMESTAMP '1970-01-01 12:03:08.456000', TIMESTAMP '1970-01-01 12:03:08.456999', 12, 12), (540, 3, TIMESTAMP '2015-01-01 10:01:23.123000', TIMESTAMP '2015-01-01 12:55:00.456999', 1, 3), (544, 2, TIMESTAMP '2015-05-15 13:05:01.234000', TIMESTAMP '2015-05-15 14:21:02.345999', 4, 5), (601, 2, TIMESTAMP '2020-02-21 15:11:11.876000', TIMESTAMP '2020-02-21 16:12:12.654999', 6, 7)";
            expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1969-11-15 15:13:12.876000', '2020-02-21 16:12:12.654999'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, 1, NULL, NULL, NULL, NULL), (-2, 2, NULL, NULL, NULL, NULL), (-1, 2, NULL, NULL, NULL, NULL), (0, 1, NULL, NULL, NULL, NULL), (540, 3, NULL, NULL, NULL, NULL), (544, 2, NULL, NULL, NULL, NULL), (601, 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, NULL, NULL),   ('b', NULL, 13e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        }
        this.assertQuery("SELECT partition.d_month, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_month_transform_timestamp$partitions\"", expected);
        this.assertQuery("SELECT * FROM test_month_transform_timestamp WHERE day_of_week(d) = 1 AND b % 7 = 3", "VALUES (TIMESTAMP '1969-12-01 00:00:00.000000', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_month_transform_timestamp"))).skippingTypesCheck().matches(expectedTimestampStats);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE d >= DATE '2015-05-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE d >= DATE '2015-05-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE CAST(d AS date) >= DATE '2015-05-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE CAST(d AS date) >= DATE '2015-05-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE d >= TIMESTAMP '2015-05-01 00:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE d >= TIMESTAMP '2015-05-01 00:00:00.000001'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE date_trunc('month', d) = DATE '2015-05-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamp WHERE date_trunc('year', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_month_transform_timestamp");
    }

    @Test
    public void testMonthTransformTimestampWithTimeZone() {
        this.assertUpdate("CREATE TABLE test_month_transform_timestamptz (d timestamp(6) with time zone, b integer) WITH (partitioning = ARRAY['month(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1969-11-15 15:13:12.876543 UTC', 8),(TIMESTAMP '1969-11-19 18:47:33.345678 UTC', 9),(TIMESTAMP '1969-12-01 00:00:00.000000 UTC', 10),(TIMESTAMP '1969-12-01 05:06:07.234567 UTC', 11),(TIMESTAMP '1970-01-01 12:03:08.456789 UTC', 12),(TIMESTAMP '2015-01-01 10:01:23.123456 UTC', 1),(TIMESTAMP '2015-01-01 11:10:02.987654 UTC', 2),(TIMESTAMP '2015-01-01 12:55:00.456789 UTC', 3),(TIMESTAMP '2015-05-15 13:05:01.234567 UTC', 4),(TIMESTAMP '2015-05-15 14:21:02.345678 UTC', 5),(TIMESTAMP '2020-02-21 15:11:11.876543 UTC', 6),(TIMESTAMP '2020-02-21 16:12:12.654321 UTC', 7)";
        this.assertUpdate("INSERT INTO test_month_transform_timestamptz " + values, 13L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz"))).matches(values);
        String expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1969-11-15 15:13:12.876543 UTC', TIMESTAMP '1969-11-19 18:47:33.345678 UTC', 8, 9), (-1, 2, TIMESTAMP '1969-12-01 00:00:00.000000 UTC', TIMESTAMP '1969-12-01 05:06:07.234567 UTC', 10, 11), (0, 1, TIMESTAMP '1970-01-01 12:03:08.456789 UTC', TIMESTAMP '1970-01-01 12:03:08.456789 UTC', 12, 12), (540, 3, TIMESTAMP '2015-01-01 10:01:23.123456 UTC', TIMESTAMP '2015-01-01 12:55:00.456789 UTC', 1, 3), (544, 2, TIMESTAMP '2015-05-15 13:05:01.234567 UTC', TIMESTAMP '2015-05-15 14:21:02.345678 UTC', 4, 5), (601, 2, TIMESTAMP '2020-02-21 15:11:11.876543 UTC', TIMESTAMP '2020-02-21 16:12:12.654321 UTC', 6, 7)";
        String expectedTimestampStats = "NULL, 12e0, 0.0769231e0, NULL, '1969-11-15 15:13:12.876 UTC', '2020-02-21 16:12:12.654 UTC'";
        String expectedIntegerStats = "NULL, 13e0, 0e0, NULL, '1', '101'";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1969-11-15 15:13:12.876000 UTC', TIMESTAMP '1969-11-19 18:47:33.345999 UTC', 8, 9), (-1, 2, TIMESTAMP '1969-12-01 00:00:00.000000 UTC', TIMESTAMP '1969-12-01 05:06:07.234999 UTC', 10, 11), (0, 1, TIMESTAMP '1970-01-01 12:03:08.456000 UTC', TIMESTAMP '1970-01-01 12:03:08.456999 UTC', 12, 12), (540, 3, TIMESTAMP '2015-01-01 10:01:23.123000 UTC', TIMESTAMP '2015-01-01 12:55:00.456999 UTC', 1, 3), (544, 2, TIMESTAMP '2015-05-15 13:05:01.234000 UTC', TIMESTAMP '2015-05-15 14:21:02.345999 UTC', 4, 5), (601, 2, TIMESTAMP '2020-02-21 15:11:11.876000 UTC', TIMESTAMP '2020-02-21 16:12:12.654999 UTC', 6, 7)";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, BIGINT '1', NULL, NULL, NULL, NULL), (-2, 2, NULL, NULL, NULL, NULL), (-1, 2, NULL, NULL, NULL, NULL), (0, 1, NULL, NULL, NULL, NULL), (540, 3, NULL, NULL, NULL, NULL), (544, 2, NULL, NULL, NULL, NULL), (601, 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "NULL, 12e0, 0.0769231e0, NULL, NULL, NULL";
            expectedIntegerStats = "NULL, 13e0, 0e0, NULL, NULL, NULL";
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.d_month, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_month_transform_timestamptz$partitions\""))).skippingTypesCheck().matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE day_of_week(d) = 1 AND b % 7 = 3"))).matches("VALUES (TIMESTAMP '1969-12-01 00:00:00.000000 UTC', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_month_transform_timestamptz"))).skippingTypesCheck().matches("VALUES   ('d', " + expectedTimestampStats + "),   ('b', " + expectedIntegerStats + "),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE d >= with_timezone(DATE '2015-05-01', 'UTC')"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE d >= with_timezone(DATE '2015-05-02', 'UTC')"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-05-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-05-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-05-01' AND d < TIMESTAMP '2015-05-01 02:00:00 Europe/Warsaw'"))).hasPlan(PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ValuesNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE d >= TIMESTAMP '2015-05-01 00:00:00 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE d >= TIMESTAMP '2015-05-01 00:00:00.000001 UTC'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE date_trunc('month', d) = TIMESTAMP '2015-05-01 00:00:00.000000 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_month_transform_timestamptz WHERE date_trunc('year', d) = TIMESTAMP '2015-01-01 00:00:00.000000 UTC'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_month_transform_timestamptz");
    }

    @Test
    public void testYearTransformDate() {
        this.assertUpdate("CREATE TABLE test_year_transform_date (d DATE, b BIGINT) WITH (partitioning = ARRAY['year(d)'])");
        String values = "VALUES (NULL, 101),(DATE '1968-10-13', 1), (DATE '1969-01-01', 2), (DATE '1969-03-15', 3), (DATE '1970-01-01', 4), (DATE '1970-03-05', 5), (DATE '2015-01-01', 6), (DATE '2015-06-16', 7), (DATE '2015-07-28', 8), (DATE '2016-05-15', 9), (DATE '2016-06-06', 10), (DATE '2020-02-21', 11), (DATE '2020-11-10', 12)";
        this.assertUpdate("INSERT INTO test_year_transform_date " + values, 13L);
        this.assertQuery("SELECT * FROM test_year_transform_date", values);
        if (this.format != IcebergFileFormat.AVRO) {
            this.assertQuery("SELECT partition.d_year, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_year_transform_date$partitions\"", "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 1, DATE '1968-10-13', DATE '1968-10-13', 1, 1), (-1, 2, DATE '1969-01-01', DATE '1969-03-15', 2, 3), (0, 2, DATE '1970-01-01', DATE '1970-03-05', 4, 5), (45, 3, DATE '2015-01-01', DATE '2015-07-28', 6, 8), (46, 2, DATE '2016-05-15', DATE '2016-06-06', 9, 10), (50, 2, DATE '2020-02-21', DATE '2020-11-10', 11, 12)");
        } else {
            this.assertQuery("SELECT partition.d_year, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_year_transform_date$partitions\"", "VALUES (NULL, 1, NULL, NULL, NULL, NULL), (-2, 1, NULL, NULL, NULL, NULL), (-1, 2, NULL, NULL, NULL, NULL), (0, 2, NULL, NULL, NULL, NULl), (45, 3, NULL, NULL, NULL, NULL), (46, 2, NULL, NULL, NULL, NULL), (50, 2, NULL, NULL, NULL, NULL)");
        }
        this.assertQuery("SELECT * FROM test_year_transform_date WHERE day_of_week(d) = 1 AND b % 7 = 3", "VALUES (DATE '2016-06-06', 10)");
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_year_transform_date"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1968-10-13', '2020-11-10'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_year_transform_date"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, NULL, NULL),   ('b', NULL, 13e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)");
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE d >= DATE '2015-01-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE d >= DATE '2015-01-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE CAST(d AS date) >= DATE '2015-01-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE CAST(d AS date) >= DATE '2015-01-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE d >= TIMESTAMP '2015-01-01 00:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE d >= TIMESTAMP '2015-01-01 00:00:00.000001'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_date WHERE date_trunc('year', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_year_transform_date"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1968-10-13', '2020-11-10'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_year_transform_date"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, NULL, NULL),   ('b', NULL, 13e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)");
        }
        this.assertUpdate("DROP TABLE test_year_transform_date");
    }

    @Test
    public void testYearTransformTimestamp() {
        this.assertUpdate("CREATE TABLE test_year_transform_timestamp (d TIMESTAMP(6), b BIGINT) WITH (partitioning = ARRAY['year(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1968-03-15 15:13:12.876543', 1),(TIMESTAMP '1968-11-19 18:47:33.345678', 2),(TIMESTAMP '1969-01-01 00:00:00.000000', 3),(TIMESTAMP '1969-01-01 05:06:07.234567', 4),(TIMESTAMP '1970-01-18 12:03:08.456789', 5),(TIMESTAMP '1970-03-14 10:01:23.123456', 6),(TIMESTAMP '1970-08-19 11:10:02.987654', 7),(TIMESTAMP '1970-12-31 12:55:00.456789', 8),(TIMESTAMP '2015-05-15 13:05:01.234567', 9),(TIMESTAMP '2015-09-15 14:21:02.345678', 10),(TIMESTAMP '2020-02-21 15:11:11.876543', 11),(TIMESTAMP '2020-08-21 16:12:12.654321', 12)";
        this.assertUpdate("INSERT INTO test_year_transform_timestamp " + values, 13L);
        this.assertQuery("SELECT * FROM test_year_transform_timestamp", values);
        String expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1968-03-15 15:13:12.876543', TIMESTAMP '1968-11-19 18:47:33.345678', 1, 2), (-1, 2, TIMESTAMP '1969-01-01 00:00:00.000000', TIMESTAMP '1969-01-01 05:06:07.234567', 3, 4), (0, 4, TIMESTAMP '1970-01-18 12:03:08.456789', TIMESTAMP '1970-12-31 12:55:00.456789', 5, 8), (45, 2, TIMESTAMP '2015-05-15 13:05:01.234567', TIMESTAMP '2015-09-15 14:21:02.345678', 9, 10), (50, 2, TIMESTAMP '2020-02-21 15:11:11.876543', TIMESTAMP '2020-08-21 16:12:12.654321', 11, 12)";
        String expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1968-03-15 15:13:12.876543', '2020-08-21 16:12:12.654321'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, 1, NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1968-03-15 15:13:12.876000', TIMESTAMP '1968-11-19 18:47:33.345999', 1, 2), (-1, 2, TIMESTAMP '1969-01-01 00:00:00.000000', TIMESTAMP '1969-01-01 05:06:07.234999', 3, 4), (0, 4, TIMESTAMP '1970-01-18 12:03:08.456000', TIMESTAMP '1970-12-31 12:55:00.456999', 5, 8), (45, 2, TIMESTAMP '2015-05-15 13:05:01.234000', TIMESTAMP '2015-09-15 14:21:02.345999', 9, 10), (50, 2, TIMESTAMP '2020-02-21 15:11:11.876000', TIMESTAMP '2020-08-21 16:12:12.654999', 11, 12)";
            expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, '1968-03-15 15:13:12.876000', '2020-08-21 16:12:12.654999'),   ('b', NULL, 13e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, 1, NULL, NULL, NULL, NULL), (-2, 2, NULL, NULL, NULL, NULL), (-1, 2, NULL, NULL, NULL, NULL), (0, 4, NULL, NULL, NULL, NULL), (45, 2, NULL, NULL, NULL, NULL), (50, 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "VALUES   ('d', NULL, 12e0, 0.0769231e0, NULL, NULL, NULL),   ('b', NULL, 13e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)";
        }
        this.assertQuery("SELECT partition.d_year, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_year_transform_timestamp$partitions\"", expected);
        this.assertQuery("SELECT * FROM test_year_transform_timestamp WHERE day_of_week(d) = 2 AND b % 7 = 3", "VALUES (TIMESTAMP '2015-09-15 14:21:02.345678', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_year_transform_timestamp"))).skippingTypesCheck().matches(expectedTimestampStats);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE d >= DATE '2015-01-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE d >= DATE '2015-01-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE CAST(d AS date) >= DATE '2015-01-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE CAST(d AS date) >= DATE '2015-01-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE d >= TIMESTAMP '2015-01-01 00:00:00'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE d >= TIMESTAMP '2015-01-01 00:00:00.000001'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamp WHERE date_trunc('year', d) = DATE '2015-01-01'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_year_transform_timestamp");
    }

    @Test
    public void testYearTransformTimestampWithTimeZone() {
        this.assertUpdate("CREATE TABLE test_year_transform_timestamptz (d timestamp(6) with time zone, b integer) WITH (partitioning = ARRAY['year(d)'])");
        String values = "VALUES (NULL, 101),(TIMESTAMP '1968-03-15 15:13:12.876543 UTC', 1),(TIMESTAMP '1968-11-19 18:47:33.345678 UTC', 2),(TIMESTAMP '1969-01-01 00:00:00.000000 UTC', 3),(TIMESTAMP '1969-01-01 05:06:07.234567 UTC', 4),(TIMESTAMP '1970-01-18 12:03:08.456789 UTC', 5),(TIMESTAMP '1970-03-14 10:01:23.123456 UTC', 6),(TIMESTAMP '1970-08-19 11:10:02.987654 UTC', 7),(TIMESTAMP '1970-12-31 12:55:00.456789 UTC', 8),(TIMESTAMP '2015-05-15 13:05:01.234567 UTC', 9),(TIMESTAMP '2015-09-15 14:21:02.345678 UTC', 10),(TIMESTAMP '2020-02-21 15:11:11.876543 UTC', 11),(TIMESTAMP '2020-08-21 16:12:12.654321 UTC', 12)";
        this.assertUpdate("INSERT INTO test_year_transform_timestamptz " + values, 13L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz"))).matches(values);
        String expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1968-03-15 15:13:12.876543 UTC', TIMESTAMP '1968-11-19 18:47:33.345678 UTC', 1, 2), (-1, 2, TIMESTAMP '1969-01-01 00:00:00.000000 UTC', TIMESTAMP '1969-01-01 05:06:07.234567 UTC', 3, 4), (0, 4, TIMESTAMP '1970-01-18 12:03:08.456789 UTC', TIMESTAMP '1970-12-31 12:55:00.456789 UTC', 5, 8), (45, 2, TIMESTAMP '2015-05-15 13:05:01.234567 UTC', TIMESTAMP '2015-09-15 14:21:02.345678 UTC', 9, 10), (50, 2, TIMESTAMP '2020-02-21 15:11:11.876543 UTC', TIMESTAMP '2020-08-21 16:12:12.654321 UTC', 11, 12)";
        String expectedTimestampStats = "NULL, 12e0, 0.0769231e0, NULL, '1968-03-15 15:13:12.876 UTC', '2020-08-21 16:12:12.654 UTC'";
        String expectedIntegerStats = "NULL, 13e0, 0e0, NULL, '1', '101'";
        if (this.format == IcebergFileFormat.ORC) {
            expected = "VALUES (NULL, BIGINT '1', NULL, NULL, 101, 101), (-2, 2, TIMESTAMP '1968-03-15 15:13:12.876000 UTC', TIMESTAMP '1968-11-19 18:47:33.345999 UTC', 1, 2), (-1, 2, TIMESTAMP '1969-01-01 00:00:00.000000 UTC', TIMESTAMP '1969-01-01 05:06:07.234999 UTC', 3, 4), (0, 4, TIMESTAMP '1970-01-18 12:03:08.456000 UTC', TIMESTAMP '1970-12-31 12:55:00.456999 UTC', 5, 8), (45, 2, TIMESTAMP '2015-05-15 13:05:01.234000 UTC', TIMESTAMP '2015-09-15 14:21:02.345999 UTC', 9, 10), (50, 2, TIMESTAMP '2020-02-21 15:11:11.876000 UTC', TIMESTAMP '2020-08-21 16:12:12.654999 UTC', 11, 12)";
        } else if (this.format == IcebergFileFormat.AVRO) {
            expected = "VALUES (NULL, BIGINT '1', NULL, NULL, NULL, NULL), (-2, 2, NULL, NULL, NULL, NULL), (-1, 2, NULL, NULL, NULL, NULL), (0, 4, NULL, NULL, NULL, NULL), (45, 2, NULL, NULL, NULL, NULL), (50, 2, NULL, NULL, NULL, NULL)";
            expectedTimestampStats = "NULL, 12e0, 0.0769231e0, NULL, NULL, NULL";
            expectedIntegerStats = "NULL, 13e0, 0e0, NULL, NULL, NULL";
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.d_year, record_count, data.d.min, data.d.max, data.b.min, data.b.max FROM \"test_year_transform_timestamptz$partitions\""))).skippingTypesCheck().matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE day_of_week(d) = 2 AND b % 7 = 3"))).matches("VALUES (TIMESTAMP '2015-09-15 14:21:02.345678 UTC', 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_year_transform_timestamptz"))).skippingTypesCheck().matches("VALUES   ('d', " + expectedTimestampStats + "),   ('b', " + expectedIntegerStats + "),   (NULL, NULL, NULL, NULL, 13e0, NULL, NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE d >= with_timezone(DATE '2015-01-01', 'UTC')"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE d >= with_timezone(DATE '2015-01-02', 'UTC')"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-01-01'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-01-02'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE CAST(d AS date) >= DATE '2015-01-01' AND d < TIMESTAMP '2015-01-01 01:00:00 Europe/Warsaw'"))).hasPlan(PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ValuesNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE d >= TIMESTAMP '2015-01-01 00:00:00 UTC'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE d >= TIMESTAMP '2015-01-01 00:00:00.000001 UTC'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE year(d) = 2015"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_year_transform_timestamptz WHERE date_trunc('year', d) = TIMESTAMP '2015-01-01 00:00:00.000000 UTC'"))).isFullyPushedDown();
        this.assertUpdate("DROP TABLE test_year_transform_timestamptz");
    }

    @Test
    public void testTruncateTextTransform() {
        this.assertUpdate("CREATE TABLE test_truncate_text_transform (d VARCHAR, b BIGINT) WITH (partitioning = ARRAY['truncate(d, 2)'])");
        String select = "SELECT partition.d_trunc, record_count, data.d.min AS d_min, data.d.max AS d_max, data.b.min AS b_min, data.b.max AS b_max FROM \"test_truncate_text_transform$partitions\"";
        this.assertUpdate("INSERT INTO test_truncate_text_transform VALUES(NULL, 101),('abcd', 1),('abxy', 2),('ab598', 3),('Kielce', 4),('Kiev', 5),('Greece', 6),('Grozny', 7)", 8L);
        this.assertQuery("SELECT partition.d_trunc FROM \"test_truncate_text_transform$partitions\"", "VALUES NULL, 'ab', 'Ki', 'Gr'");
        this.assertQuery("SELECT b FROM test_truncate_text_transform WHERE substring(d, 1, 2) = 'ab'", "VALUES 1, 2, 3");
        this.assertQuery(select + " WHERE partition.d_trunc = 'ab'", this.format == IcebergFileFormat.AVRO ? "VALUES ('ab', 3, NULL, NULL, NULL, NULL)" : "VALUES ('ab', 3, 'ab598', 'abxy', 1, 3)");
        this.assertQuery("SELECT b FROM test_truncate_text_transform WHERE substring(d, 1, 2) = 'Ki'", "VALUES 4, 5");
        this.assertQuery(select + " WHERE partition.d_trunc = 'Ki'", this.format == IcebergFileFormat.AVRO ? "VALUES ('Ki', 2, NULL, NULL, NULL, NULL)" : "VALUES ('Ki', 2, 'Kielce', 'Kiev', 4, 5)");
        this.assertQuery("SELECT b FROM test_truncate_text_transform WHERE substring(d, 1, 2) = 'Gr'", "VALUES 6, 7");
        this.assertQuery(select + " WHERE partition.d_trunc = 'Gr'", this.format == IcebergFileFormat.AVRO ? "VALUES ('Gr', 2, NULL, NULL, NULL, NULL)" : "VALUES ('Gr', 2, 'Greece', 'Grozny', 6, 7)");
        this.assertQuery("SELECT * FROM test_truncate_text_transform WHERE length(d) = 4 AND b % 7 = 2", "VALUES ('abxy', 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_truncate_text_transform"))).skippingTypesCheck().matches("VALUES   ('d', " + (this.format == IcebergFileFormat.PARQUET ? "507e0" : "NULL") + ", 7e0, " + (this.format == IcebergFileFormat.AVRO ? "0.1e0" : "0.125e0") + ", NULL, NULL, NULL),   ('b', NULL, 8e0, 0e0, NULL, " + (this.format == IcebergFileFormat.AVRO ? "NULL, NULL" : "'1', '101'") + "),   (NULL, NULL, NULL, NULL, 8e0, NULL, NULL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_text_transform WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_text_transform WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_text_transform WHERE d >= 'ab'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_text_transform WHERE d LIKE 'ab%'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_text_transform WHERE d >= 'abc'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_text_transform WHERE d LIKE 'abc%'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertUpdate("DROP TABLE test_truncate_text_transform");
    }

    @Test
    public void testTruncateIntegerTransform() {
        this.testTruncateIntegerTransform("integer");
        this.testTruncateIntegerTransform("bigint");
    }

    public void testTruncateIntegerTransform(String dataType) {
        String table = String.format("test_truncate_%s_transform", dataType);
        this.assertUpdate(String.format("CREATE TABLE " + table + " (d %s, b BIGINT) WITH (partitioning = ARRAY['truncate(d, 10)'])", dataType));
        String select = "SELECT partition.d_trunc, record_count, data.d.min AS d_min, data.d.max AS d_max, data.b.min AS b_min, data.b.max AS b_max FROM \"" + table + "$partitions\"";
        this.assertUpdate("INSERT INTO " + table + " VALUES(NULL, 101),(0, 1),(1, 2),(5, 3),(9, 4),(10, 5),(11, 6),(120, 7),(121, 8),(123, 9),(-1, 10),(-5, 11),(-10, 12),(-11, 13),(-123, 14),(-130, 15)", 16L);
        this.assertQuery("SELECT partition.d_trunc FROM \"" + table + "$partitions\"", "VALUES NULL, 0, 10, 120, -10, -20, -130");
        this.assertQuery("SELECT b FROM " + table + " WHERE d IN (0, 1, 5, 9)", "VALUES 1, 2, 3, 4");
        this.assertQuery(select + " WHERE partition.d_trunc = 0", this.format == IcebergFileFormat.AVRO ? "VALUES (0, 4, NULL, NULL,NULL, NULL)" : "VALUES (0, 4, 0, 9, 1, 4)");
        this.assertQuery("SELECT b FROM " + table + " WHERE d IN (10, 11)", "VALUES 5, 6");
        this.assertQuery(select + " WHERE partition.d_trunc = 10", this.format == IcebergFileFormat.AVRO ? "VALUES (10, 2, NULL, NULL,NULL, NULL)" : "VALUES (10, 2, 10, 11, 5, 6)");
        this.assertQuery("SELECT b FROM " + table + " WHERE d IN (120, 121, 123)", "VALUES 7, 8, 9");
        this.assertQuery(select + " WHERE partition.d_trunc = 120", this.format == IcebergFileFormat.AVRO ? "VALUES (120, 3, NULL, NULL, NULL, NULL)" : "VALUES (120, 3, 120, 123, 7, 9)");
        this.assertQuery("SELECT b FROM " + table + " WHERE d IN (-1, -5, -10)", "VALUES 10, 11, 12");
        this.assertQuery(select + " WHERE partition.d_trunc = -10", this.format == IcebergFileFormat.AVRO ? "VALUES (-10, 3, NULL, NULL, NULL, NULL)" : "VALUES (-10, 3, -10, -1, 10, 12)");
        this.assertQuery("SELECT b FROM " + table + " WHERE d = -11", "VALUES 13");
        this.assertQuery(select + " WHERE partition.d_trunc = -20", this.format == IcebergFileFormat.AVRO ? "VALUES (-20, 1, NULL, NULL, NULL, NULL)" : "VALUES (-20, 1, -11, -11, 13, 13)");
        this.assertQuery("SELECT b FROM " + table + " WHERE d IN (-123, -130)", "VALUES 14, 15");
        this.assertQuery(select + " WHERE partition.d_trunc = -130", this.format == IcebergFileFormat.AVRO ? "VALUES (-130, 2, NULL, NULL, NULL, NULL)" : "VALUES (-130, 2, -130, -123, 14, 15)");
        this.assertQuery("SELECT * FROM " + table + " WHERE d % 10 = -1 AND b % 7 = 3", "VALUES (-1, 10)");
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + table))).skippingTypesCheck().matches("VALUES   ('d', NULL, 15e0, 0.0625e0, NULL, '-130', '123'),   ('b', NULL, 16e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 16e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + table))).skippingTypesCheck().matches("VALUES   ('d', NULL, 15e0, 0.0625e0, NULL, NULL, NULL),   ('b', NULL, 16e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 16e0, NULL, NULL)");
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table + " WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table + " WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table + " WHERE d >= 10"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table + " WHERE d > 10"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table + " WHERE d >= 11"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertUpdate("DROP TABLE " + table);
    }

    @Test
    public void testTruncateDecimalTransform() {
        this.assertUpdate("CREATE TABLE test_truncate_decimal_transform (d DECIMAL(9, 2), b BIGINT) WITH (partitioning = ARRAY['truncate(d, 10)'])");
        String select = "SELECT partition.d_trunc, record_count, data.d.min AS d_min, data.d.max AS d_max, data.b.min AS b_min, data.b.max AS b_max FROM \"test_truncate_decimal_transform$partitions\"";
        this.assertUpdate("INSERT INTO test_truncate_decimal_transform VALUES(NULL, 101),(12.34, 1),(12.30, 2),(12.29, 3),(0.05, 4),(-0.05, 5)", 6L);
        this.assertQuery("SELECT partition.d_trunc FROM \"test_truncate_decimal_transform$partitions\"", "VALUES NULL, 12.30, 12.20, 0.00, -0.10");
        this.assertQuery("SELECT b FROM test_truncate_decimal_transform WHERE d IN (12.34, 12.30)", "VALUES 1, 2");
        this.assertQuery(select + " WHERE partition.d_trunc = 12.30", this.format == IcebergFileFormat.AVRO ? "VALUES (12.30, 2, NULL, NULL, NULL, NULL)" : "VALUES (12.30, 2, 12.30, 12.34, 1, 2)");
        this.assertQuery("SELECT b FROM test_truncate_decimal_transform WHERE d = 12.29", "VALUES 3");
        this.assertQuery(select + " WHERE partition.d_trunc = 12.20", this.format == IcebergFileFormat.AVRO ? "VALUES (12.20, 1, NULL, NULL, NULL, NULL)" : "VALUES (12.20, 1, 12.29, 12.29, 3, 3)");
        this.assertQuery("SELECT b FROM test_truncate_decimal_transform WHERE d = 0.05", "VALUES 4");
        this.assertQuery(select + " WHERE partition.d_trunc = 0.00", this.format == IcebergFileFormat.AVRO ? "VALUES (0.00, 1, NULL, NULL, NULL, NULL)" : "VALUES (0.00, 1, 0.05, 0.05, 4, 4)");
        this.assertQuery("SELECT b FROM test_truncate_decimal_transform WHERE d = -0.05", "VALUES 5");
        this.assertQuery(select + " WHERE partition.d_trunc = -0.10", this.format == IcebergFileFormat.AVRO ? "VALUES (-0.10, 1, NULL, NULL, NULL, NULL)" : "VALUES (-0.10, 1, -0.05, -0.05, 5, 5)");
        this.assertQuery("SELECT * FROM test_truncate_decimal_transform WHERE d * 100 % 10 = 9 AND b % 7 = 3", "VALUES (12.29, 3)");
        if (this.format == IcebergFileFormat.ORC || this.format == IcebergFileFormat.PARQUET) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_truncate_decimal_transform"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 5e0, 0.166667e0, NULL, '-0.05', '12.34'),   ('b', NULL, 6e0, 0e0, NULL, '1', '101'),   (NULL, NULL, NULL, NULL, 6e0, NULL, NULL)");
        } else if (this.format == IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_truncate_decimal_transform"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 5e0, 0.1e0, NULL, NULL, NULL),   ('b', NULL, 6e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 6e0, NULL, NULL)");
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_decimal_transform WHERE d IS NOT NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_decimal_transform WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_decimal_transform WHERE d >= 12.20"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_decimal_transform WHERE d > 12.19"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_decimal_transform WHERE d > 12.20"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_decimal_transform WHERE d >= 12.21"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertUpdate("DROP TABLE test_truncate_decimal_transform");
    }

    @Test
    public void testBucketTransform() {
        this.testBucketTransformForType("DATE", "DATE '2020-05-19'", "DATE '2020-08-19'", "DATE '2020-11-19'");
        this.testBucketTransformForType("VARCHAR", "CAST('abcd' AS VARCHAR)", "CAST('mommy' AS VARCHAR)", "CAST('abxy' AS VARCHAR)");
        this.testBucketTransformForType("INTEGER", "10", "12", "20");
        this.testBucketTransformForType("BIGINT", "CAST(100000000 AS BIGINT)", "CAST(200000002 AS BIGINT)", "CAST(400000001 AS BIGINT)");
        this.testBucketTransformForType("UUID", "CAST('206caec7-68b9-4778-81b2-a12ece70c8b1' AS UUID)", "CAST('906caec7-68b9-4778-81b2-a12ece70c8b1' AS UUID)", "CAST('406caec7-68b9-4778-81b2-a12ece70c8b1' AS UUID)");
        this.testBucketTransformForType("VARBINARY", "x'04'", "x'21'", "x'02'");
    }

    protected void testBucketTransformForType(String type, String value, String greaterValueInSameBucket, String valueInOtherBucket) {
        String tableName = String.format("test_bucket_transform%s", type.toLowerCase(Locale.ENGLISH));
        this.assertUpdate(String.format("CREATE TABLE %s (d %s) WITH (partitioning = ARRAY['bucket(d, 2)'])", tableName, type));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (NULL), (%s), (%s), (%s)", tableName, value, greaterValueInSameBucket, valueInOtherBucket), 4L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s", tableName)))).matches(String.format("VALUES (NULL), (%s), (%s), (%s)", value, greaterValueInSameBucket, valueInOtherBucket));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE d <= %s AND (rand() = 42 OR d != %s)", tableName, value, valueInOtherBucket)))).matches("VALUES " + value);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE d >= %s AND (rand() = 42 OR d != %s)", tableName, greaterValueInSameBucket, valueInOtherBucket)))).matches("VALUES " + greaterValueInSameBucket);
        String selectFromPartitions = String.format("SELECT partition.d_bucket, record_count, data.d.min AS d_min, data.d.max AS d_max FROM \"%s$partitions\"", tableName);
        if (this.supportsIcebergFileStatistics(type)) {
            this.assertQuery(selectFromPartitions + " WHERE partition.d_bucket = 0", String.format("VALUES(0, %d, %s, %s)", 2, value, greaterValueInSameBucket));
            this.assertQuery(selectFromPartitions + " WHERE partition.d_bucket = 1", String.format("VALUES(1, %d, %s, %s)", 1, valueInOtherBucket, valueInOtherBucket));
        } else {
            this.assertQuery(selectFromPartitions + " WHERE partition.d_bucket = 0", String.format("VALUES(0, %d, null, null)", 2));
            this.assertQuery(selectFromPartitions + " WHERE partition.d_bucket = 1", String.format("VALUES(1, %d, null, null)", 1));
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + tableName))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES   ('d', 3e0, " + (this.format == IcebergFileFormat.AVRO ? "0.1e0" : "0.25e0") + ", NULL),   (NULL, NULL, NULL, 4e0)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE d IS NULL"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE d IS NOT NULL"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE d >= " + value))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE d >= " + greaterValueInSameBucket))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE d >= " + valueInOtherBucket))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testApplyFilterWithNonEmptyConstraintPredicate() {
        this.assertUpdate("CREATE TABLE test_apply_functional_constraint (d VARCHAR, b BIGINT) WITH (partitioning = ARRAY['bucket(d, 2)'])");
        this.assertUpdate("INSERT INTO test_apply_functional_constraint VALUES('abcd', 1),('abxy', 2),('ab598', 3),('Kielce', 4),('Kiev', 5),('Greece', 6),('Grozny', 7)", 7L);
        this.assertQuery("SELECT * FROM test_apply_functional_constraint WHERE length(d) = 4 AND b % 7 = 2", "VALUES ('abxy', 2)");
        String expected = switch (this.format) {
            default -> throw new MatchException(null, null);
            case IcebergFileFormat.ORC -> "VALUES   ('d', NULL, 7e0, 0e0, NULL, NULL, NULL),   ('b', NULL, 7e0, 0e0, NULL, '1', '7'),   (NULL, NULL, NULL, NULL, 7e0, NULL, NULL)";
            case IcebergFileFormat.PARQUET -> "VALUES   ('d', 342e0, 7e0, 0e0, NULL, NULL, NULL),   ('b', NULL, 7e0, 0e0, NULL, '1', '7'),   (NULL, NULL, NULL, NULL, 7e0, NULL, NULL)";
            case IcebergFileFormat.AVRO -> "VALUES   ('d', NULL, 7e0, 0e0, NULL, NULL, NULL),   ('b', NULL, 7e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 7e0, NULL, NULL)";
        };
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_apply_functional_constraint"))).skippingTypesCheck().matches(expected);
        this.assertUpdate("DROP TABLE test_apply_functional_constraint");
    }

    @Test
    public void testVoidTransform() {
        this.assertUpdate("CREATE TABLE test_void_transform (d VARCHAR, b BIGINT) WITH (partitioning = ARRAY['void(d)'])");
        String values = "VALUES ('abcd', 1),('abxy', 2),('ab598', 3),('mommy', 4),('Warsaw', 5),(NULL, 6),(NULL, 7)";
        this.assertUpdate("INSERT INTO test_void_transform " + values, 7L);
        this.assertQuery("SELECT * FROM test_void_transform", values);
        this.assertQuery("SELECT COUNT(*) FROM \"test_void_transform$partitions\"", "SELECT 1");
        if (this.format != IcebergFileFormat.AVRO) {
            this.assertQuery("SELECT partition.d_null, record_count, file_count, data.d.min, data.d.max, data.d.null_count, data.d.nan_count, data.b.min, data.b.max, data.b.null_count, data.b.nan_count FROM \"test_void_transform$partitions\"", "VALUES (NULL, 7, 1, 'Warsaw', 'mommy', 2, NULL, 1, 7, 0, NULL)");
        } else {
            this.assertQuery("SELECT partition.d_null, record_count, file_count, data.d.min, data.d.max, data.d.null_count, data.d.nan_count, data.b.min, data.b.max, data.b.null_count, data.b.nan_count FROM \"test_void_transform$partitions\"", "VALUES (NULL, 7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)");
        }
        this.assertQuery("SELECT d, b FROM test_void_transform WHERE d IS NOT NULL", "VALUES ('abcd', 1),('abxy', 2),('ab598', 3),('mommy', 4),('Warsaw', 5)");
        this.assertQuery("SELECT b FROM test_void_transform WHERE d IS NULL", "VALUES 6, 7");
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_void_transform"))).skippingTypesCheck().matches("VALUES   ('d', " + (this.format == IcebergFileFormat.PARQUET ? "194e0" : "NULL") + ", 5e0, 0.2857142857142857, NULL, NULL, NULL),   ('b', NULL, 7e0, 0e0, NULL, '1', '7'),   (NULL, NULL, NULL, NULL, 7e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_void_transform"))).skippingTypesCheck().matches("VALUES   ('d', NULL, 5e0, 0.1e0, NULL, NULL, NULL),   ('b', NULL, 7e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 7e0, NULL, NULL)");
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_void_transform WHERE d IS NULL"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_void_transform WHERE d IS NOT NULL"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_void_transform WHERE d >= 'abc'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertUpdate("DROP TABLE test_void_transform");
    }

    @Test
    public void testMetadataDeleteSimple() {
        this.assertUpdate("CREATE TABLE test_metadata_delete_simple (col1 BIGINT, col2 BIGINT) WITH (partitioning = ARRAY['col1'])");
        this.assertUpdate("INSERT INTO test_metadata_delete_simple VALUES(1, 100), (1, 101), (1, 102), (2, 200), (2, 201), (3, 300)", 6L);
        this.assertQuery("SELECT sum(col2) FROM test_metadata_delete_simple", "SELECT 1004");
        this.assertQuery("SELECT count(*) FROM \"test_metadata_delete_simple$partitions\"", "SELECT 3");
        this.assertUpdate("DELETE FROM test_metadata_delete_simple WHERE col1 = 1", 3L);
        this.assertQuery("SELECT sum(col2) FROM test_metadata_delete_simple", "SELECT 701");
        this.assertQuery("SELECT count(*) FROM \"test_metadata_delete_simple$partitions\"", "SELECT 2");
        this.assertUpdate("DROP TABLE test_metadata_delete_simple");
    }

    @Test
    public void testMetadataDelete() {
        this.assertUpdate("CREATE TABLE test_metadata_delete (  orderkey BIGINT,  linenumber INTEGER,  linestatus VARCHAR) WITH (  partitioning = ARRAY[ 'linenumber', 'linestatus' ])");
        this.assertUpdate("INSERT INTO test_metadata_delete SELECT orderkey, linenumber, linestatus FROM tpch.tiny.lineitem", "SELECT count(*) FROM lineitem");
        this.assertQuery("SELECT COUNT(*) FROM \"test_metadata_delete$partitions\"", "SELECT 14");
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE linestatus = 'F' AND linenumber = 3", 5378L);
        this.assertQuery("SELECT * FROM test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus <> 'F' or linenumber <> 3");
        this.assertQuery("SELECT count(*) FROM \"test_metadata_delete$partitions\"", "SELECT 13");
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE linestatus='O'", 30049L);
        this.assertQuery("SELECT count(*) FROM \"test_metadata_delete$partitions\"", "SELECT 6");
        this.assertQuery("SELECT * FROM test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus <> 'O' AND linenumber <> 3");
        this.assertUpdate("DROP TABLE test_metadata_delete");
    }

    @Test
    public void testInSet() {
        this.testInSet(31);
        this.testInSet(35);
    }

    private void testInSet(int inCount) {
        String values = IntStream.range(1, inCount + 1).mapToObj(n -> String.format("(%s, %s)", n, n + 10)).collect(Collectors.joining(", "));
        String inList = IntStream.range(1, inCount + 1).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertUpdate("CREATE TABLE test_in_set (col1 INTEGER, col2 BIGINT)");
        this.assertUpdate(String.format("INSERT INTO test_in_set VALUES %s", values), inCount);
        this.computeActual(String.format("SELECT col1 FROM test_in_set WHERE col1 IN (%s)", inList));
        this.assertUpdate("DROP TABLE test_in_set");
    }

    @Test
    public void testBasicTableStatistics() {
        String tableName = "test_basic_table_statistics";
        this.assertUpdate(String.format("CREATE TABLE %s (col REAL)", tableName));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + tableName))).skippingTypesCheck().matches("VALUES   ('col', 0e0, 0e0, 1e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 0e0, NULL, NULL)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES -10", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 100", 1L);
        MaterializedResult result = this.computeActual("SHOW STATS FOR " + tableName);
        MaterializedResult expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col", null, 2.0, 0.0, null, "-10.0", "100.0"}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col", null, 2.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)result).containsExactlyElementsOf((Iterable)expectedStatistics);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 200", 1L);
        result = this.computeActual("SHOW STATS FOR " + tableName);
        expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col", null, 3.0, 0.0, null, "-10.0", "200.0"}).row(new Object[]{null, null, null, null, 3.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col", null, 3.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 3.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)result).containsExactlyElementsOf((Iterable)expectedStatistics);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testBasicAnalyze() {
        String statsWithoutNdv;
        Session defaultSession = this.getSession();
        String catalog = (String)defaultSession.getCatalog().orElseThrow();
        Session extendedStatisticsDisabled = Session.builder((Session)defaultSession).setCatalogSessionProperty(catalog, "extended_statistics_enabled", "false").build();
        String tableName = "test_basic_analyze";
        this.assertUpdate(defaultSession, "CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.region", 5L);
        String string = this.format == IcebergFileFormat.AVRO ? "VALUES   ('regionkey', NULL, NULL, NULL, NULL, NULL, NULL),   ('name', NULL, NULL, NULL, NULL, NULL, NULL),   ('comment', NULL, NULL, NULL, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 5e0, NULL, NULL)" : (statsWithoutNdv = "VALUES   ('regionkey', NULL, NULL, 0e0, NULL, '0', '4'),   ('name', " + (this.format == IcebergFileFormat.PARQUET ? "224e0" : "NULL") + ", NULL, 0e0, NULL, NULL, NULL),   ('comment', " + (this.format == IcebergFileFormat.PARQUET ? "626e0" : "NULL") + ", NULL, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 5e0, NULL, NULL)");
        String statsWithNdv = this.format == IcebergFileFormat.AVRO ? "VALUES   ('regionkey', NULL, 5e0, 0e0, NULL, NULL, NULL),   ('name', NULL, 5e0, 0e0, NULL, NULL, NULL),   ('comment', NULL, 5e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 5e0, NULL, NULL)" : "VALUES   ('regionkey', NULL, 5e0, 0e0, NULL, '0', '4'),   ('name', " + (this.format == IcebergFileFormat.PARQUET ? "224e0" : "NULL") + ", 5e0, 0e0, NULL, NULL, NULL),   ('comment', " + (this.format == IcebergFileFormat.PARQUET ? "626e0" : "NULL") + ", 5e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 5e0, NULL, NULL)";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(defaultSession, "SHOW STATS FOR " + tableName))).skippingTypesCheck().matches(statsWithNdv);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(extendedStatisticsDisabled, "SHOW STATS FOR " + tableName))).skippingTypesCheck().matches(statsWithoutNdv);
        this.assertQueryFails(extendedStatisticsDisabled, "ANALYZE " + tableName, "\\QAnalyze is not enabled. You can enable analyze using iceberg.extended-statistics.enabled config or extended_statistics_enabled catalog session property");
        this.assertUpdate(defaultSession, "ANALYZE " + tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(defaultSession, "SHOW STATS FOR " + tableName))).skippingTypesCheck().matches(statsWithNdv);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(extendedStatisticsDisabled, "SHOW STATS FOR " + tableName))).skippingTypesCheck().matches(statsWithoutNdv);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMultipleColumnTableStatistics() {
        String tableName = "test_multiple_table_statistics";
        this.assertUpdate(String.format("CREATE TABLE %s (col1 REAL, col2 INTEGER, col3 DATE)", tableName));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (-10, -1, DATE '2019-06-28')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (100, 10, DATE '2020-01-01')", 1L);
        MaterializedResult result = this.computeActual("SHOW STATS FOR " + tableName);
        MaterializedResult expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col1", null, 2.0, 0.0, null, "-10.0", "100.0"}).row(new Object[]{"col2", null, 2.0, 0.0, null, "-1", "10"}).row(new Object[]{"col3", null, 2.0, 0.0, null, "2019-06-28", "2020-01-01"}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col1", null, 2.0, 0.0, null, null, null}).row(new Object[]{"col2", null, 2.0, 0.0, null, null, null}).row(new Object[]{"col3", null, 2.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)result).containsExactlyElementsOf((Iterable)expectedStatistics);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (200, 20, DATE '2020-06-28')", 1L);
        result = this.computeActual("SHOW STATS FOR " + tableName);
        expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col1", null, 3.0, 0.0, null, "-10.0", "200.0"}).row(new Object[]{"col2", null, 3.0, 0.0, null, "-1", "20"}).row(new Object[]{"col3", null, 3.0, 0.0, null, "2019-06-28", "2020-06-28"}).row(new Object[]{null, null, null, null, 3.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col1", null, 3.0, 0.0, null, null, null}).row(new Object[]{"col2", null, 3.0, 0.0, null, null, null}).row(new Object[]{"col3", null, 3.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 3.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)result).containsExactlyElementsOf((Iterable)expectedStatistics);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + IntStream.rangeClosed(21, 25).mapToObj(i -> String.format("(200, %d, DATE '2020-07-%d')", i, i)).collect(Collectors.joining(", ")), 5L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + IntStream.rangeClosed(26, 30).mapToObj(i -> String.format("(NULL, %d, DATE '2020-06-%d')", i, i)).collect(Collectors.joining(", ")), 5L);
        result = this.computeActual("SHOW STATS FOR " + tableName);
        expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col1", null, 3.0, 0.38461538461538464, null, "-10.0", "200.0"}).row(new Object[]{"col2", null, 13.0, 0.0, null, "-1", "30"}).row(new Object[]{"col3", null, 12.0, 0.0, null, "2019-06-28", "2020-07-25"}).row(new Object[]{null, null, null, null, 13.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedStatistics = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"col1", null, 3.0, 0.1, null, null, null}).row(new Object[]{"col2", null, 13.0, 0.0, null, null, null}).row(new Object[]{"col3", null, 12.0, 0.07692307692307693, null, null, null}).row(new Object[]{null, null, null, null, 13.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)result).containsExactlyElementsOf((Iterable)expectedStatistics);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionedTableStatistics() {
        this.assertUpdate("CREATE TABLE iceberg.tpch.test_partitioned_table_statistics (col1 REAL, col2 BIGINT) WITH (partitioning = ARRAY['col2'])");
        this.assertUpdate("INSERT INTO test_partitioned_table_statistics VALUES (-10, -1)", 1L);
        this.assertUpdate("INSERT INTO test_partitioned_table_statistics VALUES (100, 10)", 1L);
        MaterializedResult result = this.computeActual("SHOW STATS FOR iceberg.tpch.test_partitioned_table_statistics");
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        MaterializedRow row0 = (MaterializedRow)result.getMaterializedRows().get(0);
        Assertions.assertThat((Object)row0.getField(0)).isEqualTo((Object)"col1");
        Assertions.assertThat((Object)row0.getField(3)).isEqualTo((Object)0.0);
        if (this.format != IcebergFileFormat.AVRO) {
            Assertions.assertThat((Object)row0.getField(5)).isEqualTo((Object)"-10.0");
            Assertions.assertThat((Object)row0.getField(6)).isEqualTo((Object)"100.0");
        } else {
            Assertions.assertThat((Object)row0.getField(5)).isNull();
            Assertions.assertThat((Object)row0.getField(6)).isNull();
        }
        MaterializedRow row1 = (MaterializedRow)result.getMaterializedRows().get(1);
        Assertions.assertThat((Object)row1.getField(0)).isEqualTo((Object)"col2");
        Assertions.assertThat((Object)row1.getField(3)).isEqualTo((Object)0.0);
        if (this.format != IcebergFileFormat.AVRO) {
            Assertions.assertThat((Object)row1.getField(5)).isEqualTo((Object)"-1");
            Assertions.assertThat((Object)row1.getField(6)).isEqualTo((Object)"10");
        } else {
            Assertions.assertThat((Object)row0.getField(5)).isNull();
            Assertions.assertThat((Object)row0.getField(6)).isNull();
        }
        MaterializedRow row2 = (MaterializedRow)result.getMaterializedRows().get(2);
        Assertions.assertThat((Object)row2.getField(4)).isEqualTo((Object)2.0);
        this.assertUpdate("INSERT INTO test_partitioned_table_statistics VALUES " + IntStream.rangeClosed(1, 5).mapToObj(i -> String.format("(%d, 10)", i + 100)).collect(Collectors.joining(", ")), 5L);
        this.assertUpdate("INSERT INTO test_partitioned_table_statistics VALUES " + IntStream.rangeClosed(6, 10).mapToObj(i -> "(NULL, 10)").collect(Collectors.joining(", ")), 5L);
        result = this.computeActual("SHOW STATS FOR iceberg.tpch.test_partitioned_table_statistics");
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        row0 = (MaterializedRow)result.getMaterializedRows().get(0);
        Assertions.assertThat((Object)row0.getField(0)).isEqualTo((Object)"col1");
        if (this.format != IcebergFileFormat.AVRO) {
            Assertions.assertThat((double)((Double)row0.getField(3))).isCloseTo(0.4166666666666667, Assertions.offset((Double)1.0E-10));
            Assertions.assertThat((Object)row0.getField(5)).isEqualTo((Object)"-10.0");
            Assertions.assertThat((Object)row0.getField(6)).isEqualTo((Object)"105.0");
        } else {
            Assertions.assertThat((Object)row0.getField(3)).isEqualTo((Object)0.1);
            Assertions.assertThat((Object)row0.getField(5)).isNull();
            Assertions.assertThat((Object)row0.getField(6)).isNull();
        }
        row1 = (MaterializedRow)result.getMaterializedRows().get(1);
        Assertions.assertThat((Object)row1.getField(0)).isEqualTo((Object)"col2");
        if (this.format != IcebergFileFormat.AVRO) {
            Assertions.assertThat((Object)row1.getField(3)).isEqualTo((Object)0.0);
            Assertions.assertThat((Object)row1.getField(5)).isEqualTo((Object)"-1");
            Assertions.assertThat((Object)row1.getField(6)).isEqualTo((Object)"10");
        } else {
            Assertions.assertThat((Object)row0.getField(3)).isEqualTo((Object)0.1);
            Assertions.assertThat((Object)row0.getField(5)).isNull();
            Assertions.assertThat((Object)row0.getField(6)).isNull();
        }
        row2 = (MaterializedRow)result.getMaterializedRows().get(2);
        Assertions.assertThat((Object)row2.getField(4)).isEqualTo((Object)12.0);
        this.assertUpdate("INSERT INTO test_partitioned_table_statistics VALUES " + IntStream.rangeClosed(6, 10).mapToObj(i -> "(100, NULL)").collect(Collectors.joining(", ")), 5L);
        result = this.computeActual("SHOW STATS FOR iceberg.tpch.test_partitioned_table_statistics");
        row0 = (MaterializedRow)result.getMaterializedRows().get(0);
        Assertions.assertThat((Object)row0.getField(0)).isEqualTo((Object)"col1");
        if (this.format != IcebergFileFormat.AVRO) {
            Assertions.assertThat((Object)row0.getField(3)).isEqualTo((Object)0.29411764705882354);
            Assertions.assertThat((Object)row0.getField(5)).isEqualTo((Object)"-10.0");
            Assertions.assertThat((Object)row0.getField(6)).isEqualTo((Object)"105.0");
        } else {
            Assertions.assertThat((Object)row0.getField(3)).isEqualTo((Object)0.1);
            Assertions.assertThat((Object)row0.getField(5)).isNull();
            Assertions.assertThat((Object)row0.getField(6)).isNull();
        }
        row1 = (MaterializedRow)result.getMaterializedRows().get(1);
        Assertions.assertThat((Object)row1.getField(0)).isEqualTo((Object)"col2");
        if (this.format != IcebergFileFormat.AVRO) {
            Assertions.assertThat((Object)row1.getField(3)).isEqualTo((Object)0.29411764705882354);
            Assertions.assertThat((Object)row1.getField(5)).isEqualTo((Object)"-1");
            Assertions.assertThat((Object)row1.getField(6)).isEqualTo((Object)"10");
        } else {
            Assertions.assertThat((Object)row0.getField(3)).isEqualTo((Object)0.1);
            Assertions.assertThat((Object)row0.getField(5)).isNull();
            Assertions.assertThat((Object)row0.getField(6)).isNull();
        }
        row2 = (MaterializedRow)result.getMaterializedRows().get(2);
        Assertions.assertThat((Object)row2.getField(4)).isEqualTo((Object)17.0);
        this.assertUpdate("DROP TABLE iceberg.tpch.test_partitioned_table_statistics");
    }

    @Test
    public void testPredicatePushdown() {
        QualifiedObjectName tableName = new QualifiedObjectName("iceberg", "tpch", "test_predicate");
        this.assertUpdate(String.format("CREATE TABLE %s (col1 BIGINT, col2 BIGINT, col3 BIGINT) WITH (partitioning = ARRAY['col2', 'col3'])", tableName));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (1, 10, 100)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 20, 200)", tableName), 1L);
        this.assertQuery(String.format("SELECT * FROM %s WHERE col1 = 1", tableName), "VALUES (1, 10, 100)");
        this.assertFilterPushdown(tableName, (Map<String, Domain>)ImmutableMap.of((Object)"col1", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)), (Map<String, Domain>)ImmutableMap.of(), (Map<String, Domain>)ImmutableMap.of((Object)"col1", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        this.assertQuery(String.format("SELECT * FROM %s WHERE col2 = 10", tableName), "VALUES (1, 10, 100)");
        this.assertFilterPushdown(tableName, (Map<String, Domain>)ImmutableMap.of((Object)"col2", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L)), (Map<String, Domain>)ImmutableMap.of((Object)"col2", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L)), (Map<String, Domain>)ImmutableMap.of());
        this.assertQuery(String.format("SELECT * FROM %s WHERE col1 = 1 AND col2 = 10", tableName), "VALUES (1, 10, 100)");
        this.assertFilterPushdown(tableName, (Map<String, Domain>)ImmutableMap.of((Object)"col1", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)"col2", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L)), (Map<String, Domain>)ImmutableMap.of((Object)"col2", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)10L)), (Map<String, Domain>)ImmutableMap.of((Object)"col1", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        List values = (List)LongStream.range(1L, 1010L).boxed().filter(index -> index != 20L).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)values).hasSizeGreaterThan(1000);
        String valuesString = String.join((CharSequence)",", (Iterable)values.stream().map(Object::toString).collect(ImmutableList.toImmutableList()));
        String inPredicate = "%s IN (" + valuesString + ")";
        this.assertQuery(String.format("SELECT * FROM %s WHERE %s AND %s", tableName, String.format(inPredicate, "col1"), String.format(inPredicate, "col2")), "VALUES (1, 10, 100)");
        this.assertFilterPushdown(tableName, (Map<String, Domain>)ImmutableMap.of((Object)"col1", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)values), (Object)"col2", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)values)), (Map<String, Domain>)ImmutableMap.of((Object)"col2", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)values)), (Map<String, Domain>)ImmutableMap.of((Object)"col1", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)values)));
        this.assertUpdate("DROP TABLE " + tableName.objectName());
    }

    @Test
    public void testPredicateOnDataColumnIsNotPushedDown() {
        try (TestTable testTable = this.newTrinoTable("test_predicate_on_data_column_is_not_pushed_down", "(a integer)");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE a = 10"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES 10", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE a = 10"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        }
    }

    @Test
    public void testPredicateOnDataColumnForPartitionedTableIsNotPushedDown() {
        try (TestTable testTable = this.newTrinoTable("test_predicate_on_data_column_for_partitioned_table_is_not_pushed_down", "(a integer, dt date) WITH (partitioning = ARRAY['dt'])");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE a = 10"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (10, date '2025-02-18')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE a = 10"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        }
    }

    @Test
    public void testPredicatesWithStructuralTypes() {
        String tableName = "test_predicate_with_structural_types";
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, array_t ARRAY(BIGINT), map_t MAP(BIGINT, BIGINT), struct_t ROW(f1 BIGINT, f2 BIGINT))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ARRAY[1, 2, 3], MAP(ARRAY[1,3], ARRAY[2,4]), ROW(1, 2)), (11, ARRAY[11, 12, 13], MAP(ARRAY[11, 13], ARRAY[12, 14]), ROW(11, 12)), (11, ARRAY[111, 112, 113], MAP(ARRAY[111, 13], ARRAY[112, 114]), ROW(111, 112)), (21, ARRAY[21, 22, 23], MAP(ARRAY[21, 23], ARRAY[22, 24]), ROW(21, 22))", 4L);
        this.assertQuery("SELECT id FROM " + tableName + " WHERE array_t = ARRAY[1, 2, 3]", "VALUES 1");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE map_t = MAP(ARRAY[11, 13], ARRAY[12, 14])", "VALUES 11");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE struct_t = ROW(21, 22)", "VALUES 21");
        this.assertQuery("SELECT struct_t.f1  FROM " + tableName + " WHERE id = 11 AND map_t = MAP(ARRAY[11, 13], ARRAY[12, 14])", "VALUES 11");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPartitionsTableWithColumnNameConflict() {
        this.testPartitionsTableWithColumnNameConflict(true);
        this.testPartitionsTableWithColumnNameConflict(false);
    }

    private void testPartitionsTableWithColumnNameConflict(boolean partitioned) {
        this.assertUpdate("DROP TABLE IF EXISTS test_partitions_with_conflict");
        this.assertUpdate("CREATE TABLE test_partitions_with_conflict ( p integer,  row_count integer,  record_count integer,  file_count integer,  total_size integer ) " + (partitioned ? "WITH(partitioning = ARRAY['p'])" : ""));
        this.assertUpdate("INSERT INTO test_partitions_with_conflict VALUES (11, 12, 13, 14, 15)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_partitions_with_conflict"))).matches("VALUES (11, 12, 13, 14, 15)");
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"test_partitions_with_conflict$partitions\""))).matches("SELECT " + (partitioned ? "CAST(ROW(11) AS row(p integer)), " : "") + "BIGINT '1', BIGINT '1', (SELECT total_size FROM \"test_partitions_with_conflict$partitions\"), CAST(  ROW (" + (partitioned ? "" : "  ROW(11, 11, 0, NULL), ") + "    ROW(12, 12, 0, NULL),     ROW(13, 13, 0, NULL),     ROW(14, 14, 0, NULL),     ROW(15, 15, 0, NULL)   )   AS row(" + (partitioned ? "" : "    p row(min integer, max integer, null_count bigint, nan_count bigint), ") + "    row_count row(min integer, max integer, null_count bigint, nan_count bigint),     record_count row(min integer, max integer, null_count bigint, nan_count bigint),     file_count row(min integer, max integer, null_count bigint, nan_count bigint),     total_size row(min integer, max integer, null_count bigint, nan_count bigint)   ))");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"test_partitions_with_conflict$partitions\""))).matches("SELECT " + (partitioned ? "CAST(ROW(11) AS row(p integer)), " : "") + "BIGINT '1', BIGINT '1', (SELECT total_size FROM \"test_partitions_with_conflict$partitions\"), CAST(  ROW (" + (partitioned ? "" : "  NULL, ") + "    NULL,     NULL,     NULL,     NULL   )  AS row(" + (partitioned ? "" : "    p row(min integer, max integer, null_count bigint, nan_count bigint), ") + "    row_count row(min integer, max integer, null_count bigint, nan_count bigint),     record_count row(min integer, max integer, null_count bigint, nan_count bigint),     file_count row(min integer, max integer, null_count bigint, nan_count bigint),     total_size row(min integer, max integer, null_count bigint, nan_count bigint)   ))");
        }
        this.assertUpdate("DROP TABLE test_partitions_with_conflict");
    }

    private void assertFilterPushdown(QualifiedObjectName tableName, Map<String, Domain> filter, Map<String, Domain> expectedEnforcedPredicate, Map<String, Domain> expectedUnenforcedPredicate) {
        Metadata metadata = this.getQueryRunner().getPlannerContext().getMetadata();
        this.newTransaction().execute(this.getSession(), session -> {
            TableHandle table = (TableHandle)metadata.getTableHandle(session, tableName).orElseThrow(() -> new TableNotFoundException(tableName.asSchemaTableName()));
            Map columns = metadata.getColumnHandles(session, table);
            TupleDomain domains = TupleDomain.withColumnDomains((Map)((Map)filter.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (ColumnHandle)columns.get(entry.getKey()), Map.Entry::getValue))));
            Optional result = metadata.applyFilter(session, table, new Constraint(domains));
            Assertions.assertThat((expectedUnenforcedPredicate == null && expectedEnforcedPredicate == null ? 1 : 0) != 0).isEqualTo(result.isEmpty());
            if (result.isPresent()) {
                IcebergTableHandle newTable = (IcebergTableHandle)((TableHandle)((ConstraintApplicationResult)result.get()).getHandle()).connectorHandle();
                Assertions.assertThat((Object)newTable.getEnforcedPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)((Map)expectedEnforcedPredicate.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (ColumnHandle)columns.get(entry.getKey()), Map.Entry::getValue)))));
                Assertions.assertThat((Object)newTable.getUnenforcedPredicate()).isEqualTo((Object)TupleDomain.withColumnDomains((Map)((Map)expectedUnenforcedPredicate.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (ColumnHandle)columns.get(entry.getKey()), Map.Entry::getValue)))));
            }
        });
    }

    @Test
    public void testCreateExternalTableWithNonExistingSchemaLocation() throws Exception {
        String schemaName = "test_schema_without_location" + TestingNames.randomNameSuffix();
        String schemaLocation = "/tmp/" + schemaName;
        this.fileSystem.createDirectory(Location.of((String)schemaLocation));
        this.assertUpdate("CREATE SCHEMA iceberg." + schemaName + " WITH (location = '" + schemaLocation + "')");
        this.fileSystem.deleteDirectory(Location.of((String)schemaLocation));
        String tableName = "test_create_external" + TestingNames.randomNameSuffix();
        String tableLocation = "/tmp/" + tableName;
        String schemaAndTableName = String.format("%s.%s", schemaName, tableName);
        this.assertUpdate("CREATE TABLE " + schemaAndTableName + " (a bigint, b varchar) WITH (location = '" + tableLocation + "')");
        this.assertUpdate("INSERT INTO " + schemaAndTableName + "(a, b) VALUES(NULL, NULL),(-42, 'abc'),(9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + schemaAndTableName))).skippingTypesCheck().matches("VALUES(NULL, NULL),(-42, 'abc'),(9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')");
        this.assertUpdate("DROP TABLE " + schemaAndTableName);
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testCreateNestedPartitionedTable() {
        this.assertUpdate("CREATE TABLE test_nested_table_1 ( bool BOOLEAN, int INTEGER, arr ARRAY(VARCHAR), big BIGINT, rl REAL, dbl DOUBLE, mp MAP(INTEGER, VARCHAR), dec DECIMAL(5,2), vc VARCHAR, vb VARBINARY, ts TIMESTAMP(6), tstz TIMESTAMP(6) WITH TIME ZONE, str ROW(id INTEGER, vc VARCHAR), dt DATE) WITH (partitioning = ARRAY['int'])");
        this.assertUpdate("INSERT INTO test_nested_table_1  select true, 1, array['uno', 'dos', 'tres'], BIGINT '1', REAL '1.0', DOUBLE '1.0', map(array[1,2,3,4], array['ek','don','teen','char']), CAST(1.0 as DECIMAL(5,2)), 'one', VARBINARY 'binary0/1values',\n TIMESTAMP '2021-07-24 02:43:57.348000', TIMESTAMP '2021-07-24 02:43:57.348000 UTC', (CAST(ROW(null, 'this is a random value') AS ROW(int, varchar))),  DATE '2021-07-24'", 1L);
        Assertions.assertThat((int)this.computeActual("SELECT * from test_nested_table_1").getRowCount()).isEqualTo(1);
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_nested_table_1"))).skippingTypesCheck().matches("VALUES   ('bool', NULL, 1e0, 0e0, NULL, 'true', 'true'),   ('int', NULL, 1e0, 0e0, NULL, '1', '1'),   ('arr', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0e0" : "NULL") + ", NULL, NULL, NULL),   ('big', NULL, 1e0, 0e0, NULL, '1', '1'),   ('rl', NULL, 1e0, 0e0, NULL, '1.0', '1.0'),   ('dbl', NULL, 1e0, 0e0, NULL, '1.0', '1.0'),   ('mp', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0e0" : "NULL") + ", NULL, NULL, NULL),   ('dec', NULL, 1e0, 0e0, NULL, '1.0', '1.0'),   ('vc', " + (this.format == IcebergFileFormat.PARQUET ? "105e0" : "NULL") + ", 1e0, 0e0, NULL, NULL, NULL),   ('vb', " + (this.format == IcebergFileFormat.PARQUET ? "71e0" : "NULL") + ", 1e0, 0e0, NULL, NULL, NULL),   ('ts', NULL, 1e0, 0e0, NULL, '2021-07-24 02:43:57.348000', " + (this.format == IcebergFileFormat.ORC ? "'2021-07-24 02:43:57.348999'" : "'2021-07-24 02:43:57.348000'") + "),   ('tstz', NULL, 1e0, 0e0, NULL, '2021-07-24 02:43:57.348 UTC', '2021-07-24 02:43:57.348 UTC'),   ('str', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0e0" : "NULL") + ", NULL, NULL, NULL),   ('dt', NULL, 1e0, 0e0, NULL, '2021-07-24', '2021-07-24'),   (NULL, NULL, NULL, NULL, 1e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_nested_table_1"))).skippingTypesCheck().matches("VALUES   ('bool', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('int', NULL, 1e0, 0e0, NULL, '1', '1'),   ('arr', NULL, NULL, NULL, NULL, NULL, NULL),   ('big', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('rl', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('dbl', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('mp', NULL, NULL, NULL, NULL, NULL, NULL),   ('dec', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('vc', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('vb', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('ts', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('tstz', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('str', NULL, NULL, NULL, NULL, NULL, NULL),   ('dt', NULL, 1e0, 0e0, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 1e0, NULL, NULL)");
        }
        this.assertUpdate("DROP TABLE test_nested_table_1");
        this.assertUpdate("CREATE TABLE test_nested_table_2 ( int INTEGER, arr ARRAY(ROW(id INTEGER, vc VARCHAR)), big BIGINT, rl REAL, dbl DOUBLE, mp MAP(INTEGER, ARRAY(VARCHAR)), dec DECIMAL(5,2), str ROW(id INTEGER, vc VARCHAR, arr ARRAY(INTEGER)), vc VARCHAR) WITH (partitioning = ARRAY['int'])");
        this.assertUpdate("INSERT INTO test_nested_table_2  select 1, array[cast(row(1, null) as row(int, varchar)), cast(row(2, 'dos') as row(int, varchar))], BIGINT '1', REAL '1.0', DOUBLE '1.0', map(array[1,2], array[array['ek', 'one'], array['don', 'do', 'two']]), CAST(1.0 as DECIMAL(5,2)), CAST(ROW(1, 'this is a random value', null) AS ROW(int, varchar, array(int))), 'one'", 1L);
        Assertions.assertThat((int)this.computeActual("SELECT * from test_nested_table_2").getRowCount()).isEqualTo(1);
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_nested_table_2"))).skippingTypesCheck().matches("VALUES   ('int', NULL, 1e0, 0e0, NULL, '1', '1'),   ('arr', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0e0" : "NULL") + ", NULL, NULL, NULL),   ('big', NULL, 1e0, 0e0, NULL, '1', '1'),   ('rl', NULL, 1e0, 0e0, NULL, '1.0', '1.0'),   ('dbl', NULL, 1e0, 0e0, NULL, '1.0', '1.0'),   ('mp', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0e0" : "NULL") + ", NULL, NULL, NULL),   ('dec', NULL, 1e0, 0e0, NULL, '1.0', '1.0'),   ('vc', " + (this.format == IcebergFileFormat.PARQUET ? "105e0" : "NULL") + ", 1e0, 0e0, NULL, NULL, NULL),   ('str', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0e0" : "NULL") + ", NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 1e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_nested_table_2"))).skippingTypesCheck().matches("VALUES   ('int', NULL, 1e0, 0e0, NULL, '1', '1'),   ('arr', NULL, NULL, NULL, NULL, NULL, NULL),   ('big', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('rl', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('dbl', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('mp', NULL, NULL, NULL, NULL, NULL, NULL),   ('dec', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('vc', NULL, 1e0, 0e0, NULL, NULL, NULL),   ('str', NULL, NULL, NULL, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 1e0, NULL, NULL)");
        }
        this.assertUpdate("CREATE TABLE test_nested_table_3 WITH (partitioning = ARRAY['int']) AS SELECT * FROM test_nested_table_2", 1L);
        Assertions.assertThat((int)this.computeActual("SELECT * FROM test_nested_table_3").getRowCount()).isEqualTo(1);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_nested_table_3"))).matches("SHOW STATS FOR test_nested_table_2");
        this.assertUpdate("DROP TABLE test_nested_table_2");
        this.assertUpdate("DROP TABLE test_nested_table_3");
    }

    @Test
    public void testSerializableReadIsolation() {
        this.assertUpdate("CREATE TABLE test_read_isolation (x int)");
        this.assertUpdate("INSERT INTO test_read_isolation VALUES 123, 456", 2L);
        this.withTransaction(session -> {
            this.assertQuery((Session)session, "SELECT * FROM test_read_isolation", "VALUES 123, 456");
            this.assertUpdate("INSERT INTO test_read_isolation VALUES 789", 1L);
            this.assertQuery("SELECT * FROM test_read_isolation", "VALUES 123, 456, 789");
            this.assertQuery((Session)session, "SELECT * FROM test_read_isolation", "VALUES 123, 456");
        });
        this.assertQuery("SELECT * FROM test_read_isolation", "VALUES 123, 456, 789");
        this.assertUpdate("DROP TABLE test_read_isolation");
    }

    private void withTransaction(Consumer<Session> consumer) {
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (Metadata)this.getQueryRunner().getPlannerContext().getMetadata(), (AccessControl)this.getQueryRunner().getAccessControl()).readCommitted().execute(this.getSession(), consumer);
    }

    @Test
    public void testOptimizedMetadataQueries() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("optimize_metadata_queries", "true").build();
        this.assertUpdate("CREATE TABLE test_metadata_optimization (a BIGINT, b BIGINT, c BIGINT) WITH (PARTITIONING = ARRAY['b', 'c'])");
        this.assertUpdate("INSERT INTO test_metadata_optimization VALUES (5, 6, 7), (8, 9, 10)", 2L);
        this.assertQuery(session, "SELECT DISTINCT b FROM test_metadata_optimization", "VALUES (6), (9)");
        this.assertQuery(session, "SELECT DISTINCT b, c FROM test_metadata_optimization", "VALUES (6, 7), (9, 10)");
        this.assertQuery(session, "SELECT DISTINCT b FROM test_metadata_optimization WHERE b < 7", "VALUES (6)");
        this.assertQuery(session, "SELECT DISTINCT b FROM test_metadata_optimization WHERE c > 8", "VALUES (9)");
        this.assertUpdate("DELETE FROM test_metadata_optimization WHERE b = 6", 1L);
        this.assertQuery(session, "SELECT DISTINCT b FROM test_metadata_optimization", "VALUES (9)");
        this.assertUpdate("DROP TABLE test_metadata_optimization");
    }

    @Test
    public void testFileSizeInManifest() throws Exception {
        this.assertUpdate("CREATE TABLE test_file_size_in_manifest (a_bigint bigint, a_varchar varchar, a_long_decimal decimal(38,20), a_map map(varchar, integer))");
        this.assertUpdate("INSERT INTO test_file_size_in_manifest VALUES (NULL, NULL, NULL, NULL), (42, 'some varchar value', DECIMAL '123456789123456789.123456789123456789', map(ARRAY['abc', 'def'], ARRAY[113, -237843832]))", 2L);
        MaterializedResult files = this.computeActual("SELECT file_path, record_count, file_size_in_bytes FROM \"test_file_size_in_manifest$files\"");
        long totalRecordCount = 0L;
        for (MaterializedRow row : files.getMaterializedRows()) {
            String path = (String)row.getField(0);
            Long recordCount = (Long)row.getField(1);
            Long fileSizeInBytes = (Long)row.getField(2);
            totalRecordCount += recordCount.longValue();
            Assertions.assertThat((Long)fileSizeInBytes).isEqualTo(this.fileSize(path));
        }
        Assertions.assertThat((long)totalRecordCount).isEqualTo(2L);
    }

    @Test
    public void testIncorrectIcebergFileSizes() throws Exception {
        Schema schema;
        this.assertUpdate("CREATE TABLE test_iceberg_file_size (x BIGINT)");
        this.assertUpdate("INSERT INTO test_iceberg_file_size VALUES (123), (456), (758)", 3L);
        MaterializedResult result = this.computeActual("SELECT path FROM \"test_iceberg_file_size$manifests\"");
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        String manifestFile = (String)result.getOnlyValue();
        GenericData.Record entry = null;
        try (DataFileReader<GenericData.Record> dataFileReader = this.readManifestFile(manifestFile);){
            schema = dataFileReader.getSchema();
            int recordCount = 0;
            while (dataFileReader.hasNext()) {
                entry = (GenericData.Record)dataFileReader.next();
                ++recordCount;
            }
            Assertions.assertThat((int)recordCount).isEqualTo(1);
        }
        GenericData.Record dataFile = (GenericData.Record)entry.get("data_file");
        long alteredValue = 50L;
        Assertions.assertThat((Object)dataFile.get("file_size_in_bytes")).isNotEqualTo((Object)alteredValue);
        dataFile.put("file_size_in_bytes", (Object)alteredValue);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            dataFileWriter.create(schema, (OutputStream)out);
            dataFileWriter.append((Object)entry);
        }
        this.fileSystem.newOutputFile(Location.of((String)manifestFile)).createOrOverwrite(out.toByteArray());
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "use_file_size_from_metadata", "false").build();
        this.assertQuery(session, "SELECT * FROM test_iceberg_file_size", "VALUES (123), (456), (758)");
        this.assertQueryFails("SELECT * FROM test_iceberg_file_size", "(Malformed ORC file\\. Invalid file metadata.*)|(.*Malformed Parquet file.*)");
        this.assertUpdate("DROP TABLE test_iceberg_file_size");
    }

    protected DataFileReader<GenericData.Record> readManifestFile(String location) throws IOException {
        Path tempFile = this.getDistributedQueryRunner().getCoordinator().getBaseDataDir().resolve(String.valueOf(UUID.randomUUID()) + "-manifest-copy");
        try (TrinoInputStream inputStream = this.fileSystem.newInputFile(Location.of((String)location)).newStream();){
            Files.copy((InputStream)inputStream, tempFile, new CopyOption[0]);
        }
        return new DataFileReader(tempFile.toFile(), (DatumReader)new GenericDatumReader());
    }

    @Test
    public void testSplitPruningForFilterOnPartitionColumn() {
        String tableName = "nation_partitioned_pruning";
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        Session noRedistributeWrites = Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "false").build();
        this.assertUpdate(noRedistributeWrites, "CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey']) AS SELECT * FROM nation", 25L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM \"" + tableName + "$files\""))).matches("VALUES CAST(5 AS BIGINT)");
        this.verifySplitCount("SELECT * FROM " + tableName, 5);
        this.verifySplitCount("SELECT * FROM " + tableName + " WHERE regionkey = 3", 1);
        this.verifySplitCount("SELECT * FROM " + tableName + " WHERE regionkey < 2", 2);
        this.verifySplitCount("SELECT * FROM " + tableName + " WHERE regionkey < 0", 0);
        this.verifySplitCount("SELECT * FROM " + tableName + " WHERE regionkey > 1 AND regionkey < 4", 2);
        this.verifySplitCount("SELECT * FROM " + tableName + " WHERE regionkey % 5 = 3", 1);
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate(noRedistributeWrites, "CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey', 'nationkey']) AS SELECT * FROM nation", 25L);
        this.assertUpdate(noRedistributeWrites, "INSERT INTO " + tableName + " SELECT * FROM nation", 25L);
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM \"" + tableName + "$files\"")).isEqualTo((Object)50L);
        this.verifySplitCount("SELECT * FROM " + tableName + " WHERE regionkey % 5 = 3", 10);
        this.verifySplitCount("SELECT * FROM " + tableName + " WHERE (regionkey * 2) - nationkey = 0", 6);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAllAvailableTypes() {
        this.assertUpdate("CREATE TABLE test_all_types (  a_boolean boolean,   an_integer integer,   a_bigint bigint,   a_real real,   a_double double,   a_short_decimal decimal(5,2),   a_long_decimal decimal(38,20),   a_varchar varchar,   a_varbinary varbinary,   a_date date,   a_time time(6),   a_timestamp timestamp(6),   a_timestamptz timestamp(6) with time zone,   a_uuid uuid,   a_row row(id integer, vc varchar),   an_array array(varchar),   a_map map(integer, varchar) )");
        String values = "VALUES (true, 1, BIGINT '1', REAL '1.0', DOUBLE '1.0', CAST(1.0 AS decimal(5,2)), CAST(11.0 AS decimal(38,20)), VARCHAR 'onefsadfdsf', X'000102f0feff', DATE '2021-07-24',TIME '02:43:57.987654', TIMESTAMP '2021-07-24 03:43:57.987654',TIMESTAMP '2021-07-24 04:43:57.987654 UTC', UUID '20050910-1330-11e9-ffff-2a86e4085a59', CAST(ROW(42, 'this is a random value') AS ROW(id int, vc varchar)), ARRAY[VARCHAR 'uno', 'dos', 'tres'], map(ARRAY[1,2], ARRAY['ek', VARCHAR 'one'])) ";
        String nullValues = Collections.nCopies(17, "NULL").stream().collect(Collectors.joining(", ", "VALUES (", ")"));
        this.assertUpdate("INSERT INTO test_all_types " + values, 1L);
        this.assertUpdate("INSERT INTO test_all_types " + nullValues, 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_all_types"))).matches(values + " UNION ALL " + nullValues);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_all_types WHERE     a_boolean = true AND an_integer = 1 AND a_bigint = BIGINT '1' AND a_real = REAL '1.0' AND a_double = DOUBLE '1.0' AND a_short_decimal = CAST(1.0 AS decimal(5,2)) AND a_long_decimal = CAST(11.0 AS decimal(38,20)) AND a_varchar = VARCHAR 'onefsadfdsf' AND a_varbinary = X'000102f0feff' AND a_date = DATE '2021-07-24' AND a_time = TIME '02:43:57.987654' AND a_timestamp = TIMESTAMP '2021-07-24 03:43:57.987654' AND a_timestamptz = TIMESTAMP '2021-07-24 04:43:57.987654 UTC' AND a_uuid = UUID '20050910-1330-11e9-ffff-2a86e4085a59' AND a_row = CAST(ROW(42, 'this is a random value') AS ROW(id int, vc varchar)) AND an_array = ARRAY[VARCHAR 'uno', 'dos', 'tres'] AND a_map = map(ARRAY[1,2], ARRAY['ek', VARCHAR 'one']) "))).matches(values);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_all_types WHERE     a_boolean IS NULL AND an_integer IS NULL AND a_bigint IS NULL AND a_real IS NULL AND a_double IS NULL AND a_short_decimal IS NULL AND a_long_decimal IS NULL AND a_varchar IS NULL AND a_varbinary IS NULL AND a_date IS NULL AND a_time IS NULL AND a_timestamp IS NULL AND a_timestamptz IS NULL AND a_uuid IS NULL AND a_row IS NULL AND an_array IS NULL AND a_map IS NULL "))).skippingTypesCheck().matches(nullValues);
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_all_types"))).skippingTypesCheck().matches("VALUES   ('a_boolean', NULL, 1e0, 0.5e0, NULL, 'true', 'true'),   ('an_integer', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_bigint', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_real', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_double', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_short_decimal', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_long_decimal', NULL, 1e0, 0.5e0, NULL, '11.0', '11.0'),   ('a_varchar', " + (this.format == IcebergFileFormat.PARQUET ? "213e0" : "NULL") + ", 1e0, 0.5e0, NULL, NULL, NULL),   ('a_varbinary', " + (this.format == IcebergFileFormat.PARQUET ? "103e0" : "NULL") + ", 1e0, 0.5e0, NULL, NULL, NULL),   ('a_date', NULL, 1e0, 0.5e0, NULL, '2021-07-24', '2021-07-24'),   ('a_time', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_timestamp', NULL, 1e0, 0.5e0, NULL, " + (this.format == IcebergFileFormat.ORC ? "'2021-07-24 03:43:57.987000', '2021-07-24 03:43:57.987999'" : "'2021-07-24 03:43:57.987654', '2021-07-24 03:43:57.987654'") + "),   ('a_timestamptz', NULL, 1e0, 0.5e0, NULL, '2021-07-24 04:43:57.987 UTC', '2021-07-24 04:43:57.987 UTC'),   ('a_uuid', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_row', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0.5" : "NULL") + ", NULL, NULL, NULL),   ('an_array', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0.5" : "NULL") + ", NULL, NULL, NULL),   ('a_map', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0.5" : "NULL") + ", NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR test_all_types"))).skippingTypesCheck().matches("VALUES   ('a_boolean', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('an_integer', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_bigint', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_real', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_double', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_short_decimal', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_long_decimal', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_varchar', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_varbinary', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_date', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_time', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_timestamp', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_timestamptz', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_uuid', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_row', NULL, NULL, NULL, NULL, NULL, NULL),   ('an_array', NULL, NULL, NULL, NULL, NULL, NULL),   ('a_map', NULL, NULL, NULL, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
        }
        Session defaultSession = this.getSession();
        String catalog = (String)defaultSession.getCatalog().orElseThrow();
        Session extendedStatisticsEnabled = Session.builder((Session)defaultSession).setCatalogSessionProperty(catalog, "extended_statistics_enabled", "true").build();
        this.assertUpdate(extendedStatisticsEnabled, "ANALYZE test_all_types");
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(extendedStatisticsEnabled, "SHOW STATS FOR test_all_types"))).skippingTypesCheck().matches("VALUES   ('a_boolean', NULL, 1e0, 0.5e0, NULL, 'true', 'true'),   ('an_integer', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_bigint', NULL, 1e0, 0.5e0, NULL, '1', '1'),   ('a_real', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_double', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_short_decimal', NULL, 1e0, 0.5e0, NULL, '1.0', '1.0'),   ('a_long_decimal', NULL, 1e0, 0.5e0, NULL, '11.0', '11.0'),   ('a_varchar', " + (this.format == IcebergFileFormat.PARQUET ? "213e0" : "NULL") + ", 1e0, 0.5e0, NULL, NULL, NULL),   ('a_varbinary', " + (this.format == IcebergFileFormat.PARQUET ? "103e0" : "NULL") + ", 1e0, 0.5e0, NULL, NULL, NULL),   ('a_date', NULL, 1e0, 0.5e0, NULL, '2021-07-24', '2021-07-24'),   ('a_time', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_timestamp', NULL, 1e0, 0.5e0, NULL, " + (this.format == IcebergFileFormat.ORC ? "'2021-07-24 03:43:57.987000', '2021-07-24 03:43:57.987999'" : "'2021-07-24 03:43:57.987654', '2021-07-24 03:43:57.987654'") + "),   ('a_timestamptz', NULL, 1e0, 0.5e0, NULL, '2021-07-24 04:43:57.987 UTC', '2021-07-24 04:43:57.987 UTC'),   ('a_uuid', NULL, 1e0, 0.5e0, NULL, NULL, NULL),   ('a_row', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0.5" : "NULL") + ", NULL, NULL, NULL),   ('an_array', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0.5" : "NULL") + ", NULL, NULL, NULL),   ('a_map', NULL, NULL, " + (this.format == IcebergFileFormat.ORC ? "0.5" : "NULL") + ", NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(extendedStatisticsEnabled, "SHOW STATS FOR test_all_types"))).skippingTypesCheck().matches("VALUES   ('a_boolean', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('an_integer', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_bigint', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_real', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_double', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_short_decimal', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_long_decimal', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_varchar', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_varbinary', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_date', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_time', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_timestamp', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_timestamptz', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_uuid', NULL, 1e0, 0.1e0, NULL, NULL, NULL),   ('a_row', NULL, NULL, NULL, NULL, NULL, NULL),   ('an_array', NULL, NULL, NULL, NULL, NULL, NULL),   ('a_map', NULL, NULL, NULL, NULL, NULL, NULL),   (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
        }
        String schema = (String)this.getSession().getSchema().orElseThrow();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'test_all_types$partitions' "))).skippingTypesCheck().matches("VALUES 'record_count', 'file_count', 'total_size', 'data'");
        if (this.format != IcebergFileFormat.AVRO) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT   record_count,  file_count,   data.a_boolean,   data.an_integer,   data.a_bigint,   data.a_real,   data.a_double,   data.a_short_decimal,   data.a_long_decimal,   data.a_varchar,   data.a_varbinary,   data.a_date,   data.a_time,   data.a_timestamp,   data.a_timestamptz,   data.a_uuid  FROM \"test_all_types$partitions\" "))).matches("VALUES (  BIGINT '2',   BIGINT '2',   CAST(ROW(true, true, 1, NULL) AS ROW(min boolean, max boolean, null_count bigint, nan_count bigint)),   CAST(ROW(1, 1, 1, NULL) AS ROW(min integer, max integer, null_count bigint, nan_count bigint)),   CAST(ROW(1, 1, 1, NULL) AS ROW(min bigint, max bigint, null_count bigint, nan_count bigint)),   CAST(ROW(1, 1, 1, NULL) AS ROW(min real, max real, null_count bigint, nan_count bigint)),   CAST(ROW(1, 1, 1, NULL) AS ROW(min double, max double, null_count bigint, nan_count bigint)),   CAST(ROW(1, 1, 1, NULL) AS ROW(min decimal(5,2), max decimal(5,2), null_count bigint, nan_count bigint)),   CAST(ROW(11, 11, 1, NULL) AS ROW(min decimal(38,20), max decimal(38,20), null_count bigint, nan_count bigint)),   CAST(ROW('onefsadfdsf', 'onefsadfdsf', 1, NULL) AS ROW(min varchar, max varchar, null_count bigint, nan_count bigint)), " + (this.format == IcebergFileFormat.ORC ? "  CAST(ROW(NULL, NULL, 1, NULL) AS ROW(min varbinary, max varbinary, null_count bigint, nan_count bigint)), " : "  CAST(ROW(X'000102f0feff', X'000102f0feff', 1, NULL) AS ROW(min varbinary, max varbinary, null_count bigint, nan_count bigint)), ") + "  CAST(ROW(DATE '2021-07-24', DATE '2021-07-24', 1, NULL) AS ROW(min date, max date, null_count bigint, nan_count bigint)),   CAST(ROW(TIME '02:43:57.987654', TIME '02:43:57.987654', 1, NULL) AS ROW(min time(6), max time(6), null_count bigint, nan_count bigint)), " + (this.format == IcebergFileFormat.ORC ? "  CAST(ROW(TIMESTAMP '2021-07-24 03:43:57.987000', TIMESTAMP '2021-07-24 03:43:57.987999', 1, NULL) AS ROW(min timestamp(6), max timestamp(6), null_count bigint, nan_count bigint)), " : "  CAST(ROW(TIMESTAMP '2021-07-24 03:43:57.987654', TIMESTAMP '2021-07-24 03:43:57.987654', 1, NULL) AS ROW(min timestamp(6), max timestamp(6), null_count bigint, nan_count bigint)), ") + (this.format == IcebergFileFormat.ORC ? "  CAST(ROW(TIMESTAMP '2021-07-24 04:43:57.987000 UTC', TIMESTAMP '2021-07-24 04:43:57.987999 UTC', 1, NULL) AS ROW(min timestamp(6) with time zone, max timestamp(6) with time zone, null_count bigint, nan_count bigint)), " : "  CAST(ROW(TIMESTAMP '2021-07-24 04:43:57.987654 UTC', TIMESTAMP '2021-07-24 04:43:57.987654 UTC', 1, NULL) AS ROW(min timestamp(6) with time zone, max timestamp(6) with time zone, null_count bigint, nan_count bigint)), ") + (this.format == IcebergFileFormat.ORC ? "  CAST(ROW(NULL, NULL, 1, NULL) AS ROW(min uuid, max uuid, null_count bigint, nan_count bigint)) " : "  CAST(ROW(UUID '20050910-1330-11e9-ffff-2a86e4085a59', UUID '20050910-1330-11e9-ffff-2a86e4085a59', 1, NULL) AS ROW(min uuid, max uuid, null_count bigint, nan_count bigint)) ") + ")");
        } else {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT   record_count,  file_count,   data.a_boolean,   data.an_integer,   data.a_bigint,   data.a_real,   data.a_double,   data.a_short_decimal,   data.a_long_decimal,   data.a_varchar,   data.a_varbinary,   data.a_date,   data.a_time,   data.a_timestamp,   data.a_timestamptz,   data.a_uuid  FROM \"test_all_types$partitions\" "))).matches("VALUES (  BIGINT '2',   BIGINT '2',   CAST(NULL AS ROW(min boolean, max boolean, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min integer, max integer, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min bigint, max bigint, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min real, max real, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min double, max double, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min decimal(5,2), max decimal(5,2), null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min decimal(38,20), max decimal(38,20), null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min varchar, max varchar, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min varbinary, max varbinary, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min date, max date, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min time(6), max time(6), null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min timestamp(6), max timestamp(6), null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min timestamp(6) with time zone, max timestamp(6) with time zone, null_count bigint, nan_count bigint)),   CAST(NULL AS ROW(min uuid, max uuid, null_count bigint, nan_count bigint)) )");
        }
        this.assertUpdate("DROP TABLE test_all_types");
    }

    @Test
    public void testRepartitionDataOnCtas() {
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", true, "'orderstatus'", 3);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", true, "'bucket(custkey, 13)'", 13);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", true, "'truncate(comment, 1)'", 35);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", true, "'bucket(custkey, 4)', 'truncate(comment, 1)'", 131);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", true, "'truncate(comment, 1)', 'orderstatus', 'bucket(comment, 2)'", 180);
    }

    @Test
    public void testRepartitionDataOnInsert() {
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", false, "'orderstatus'", 3);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", false, "'bucket(custkey, 13)'", 13);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", false, "'truncate(comment, 1)'", 35);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", false, "'bucket(custkey, 4)', 'truncate(comment, 1)'", 131);
        this.testRepartitionData(this.getSession(), "tpch.tiny.orders", false, "'truncate(comment, 1)', 'orderstatus', 'bucket(comment, 2)'", 180);
    }

    @Test
    public void testStatsBasedRepartitionDataOnCtas() {
        this.testStatsBasedRepartitionData(true);
    }

    @Test
    public void testStatsBasedRepartitionDataOnInsert() {
        this.testStatsBasedRepartitionData(false);
    }

    private void testStatsBasedRepartitionData(boolean ctas) {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        try (TestTable sourceTable = new TestTable(sql -> this.assertQuerySucceeds(Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "collect_extended_statistics_on_write", "true").build(), sql), "temp_table_analyzed", "AS SELECT orderkey, custkey, orderstatus FROM tpch.\"sf0.03\".orders");){
            Session sessionRepartitionMany = Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "false").setSystemProperty("use_preferred_write_partitioning", "false").build();
            String sourceRelation = "(SELECT DISTINCT orderkey, custkey, orderstatus FROM " + sourceTable.getName() + ")";
            this.testRepartitionData(this.getSession(), sourceRelation, ctas, "'orderstatus'", 3);
            Assert.assertEventually((Duration)new Duration(3.0, TimeUnit.MINUTES), () -> this.testRepartitionData(sessionRepartitionMany, sourceRelation, ctas, "'orderstatus'", 9));
        }
    }

    private void testRepartitionData(Session session, String sourceRelation, boolean ctas, String partitioning, int expectedFiles) {
        String tableName = "repartition_" + sourceRelation.replaceAll("[^a-zA-Z0-9]", "") + (ctas ? "ctas" : "insert") + "_" + partitioning.replaceAll("[^a-zA-Z0-9]", "") + "_" + TestingNames.randomNameSuffix();
        long rowCount = (Long)this.computeScalar(session, "SELECT count(*) FROM " + sourceRelation);
        if (ctas) {
            this.assertUpdate(session, "CREATE TABLE " + tableName + " WITH (partitioning = ARRAY[" + partitioning + "]) AS SELECT * FROM " + sourceRelation, rowCount);
        } else {
            this.assertUpdate(session, "CREATE TABLE " + tableName + " WITH (partitioning = ARRAY[" + partitioning + "]) AS SELECT * FROM " + sourceRelation + " WITH NO DATA", 0L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " SELECT * FROM " + sourceRelation, rowCount);
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "TABLE " + tableName))).skippingTypesCheck().matches("SELECT * FROM " + sourceRelation);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT count(*) FROM \"" + tableName + "$files\""))).matches("VALUES BIGINT '" + expectedFiles + "'");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testSplitPruningForFilterOnNonPartitionColumn() {
        for (BaseConnectorTest.DataMappingTestSetup testSetup : this.testDataMappingSmokeTestDataProvider()) {
            if (testSetup.isUnsupportedType()) {
                return;
            }
            TestTable table = this.newTrinoTable("test_split_pruning_non_partitioned", "(row_id int, col " + testSetup.getTrinoTypeName() + ")");
            try {
                String tableName = table.getName();
                String sampleValue = testSetup.getSampleValueLiteral();
                String highValue = testSetup.getHighValueLiteral();
                this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, " + sampleValue + ")", 1L);
                this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, " + highValue + ")", 1L);
                this.assertQuery("select count(*) from \"" + tableName + "$files\"", "VALUES 2");
                int expectedSplitCount = this.supportsIcebergFileStatistics(testSetup.getTrinoTypeName()) ? 1 : 2;
                this.verifySplitCount("SELECT row_id FROM " + tableName, 2);
                this.verifySplitCount("SELECT row_id FROM " + tableName + " WHERE col = " + sampleValue, expectedSplitCount);
                this.verifySplitCount("SELECT row_id FROM " + tableName + " WHERE col = " + highValue, expectedSplitCount);
                this.verifySplitCount("SELECT row_id FROM " + tableName + " WHERE col > " + sampleValue, this.format == IcebergFileFormat.ORC && testSetup.getTrinoTypeName().contains("timestamp") ? 2 : expectedSplitCount);
                this.verifySplitCount("SELECT row_id FROM " + tableName + " WHERE col < " + highValue, this.format == IcebergFileFormat.ORC && testSetup.getTrinoTypeName().contains("timestamp(6)") ? 2 : expectedSplitCount);
            }
            finally {
                if (table == null) continue;
                table.close();
            }
        }
    }

    @Test
    public void testGetIcebergTableWithLegacyOrcBloomFilterProperties() throws IOException {
        String tableName = "test_get_table_with_legacy_orc_bloom_filter_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String metadataLocation = IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)tableLocation);
        TableMetadata tableMetadata = TableMetadataParser.read((FileIO)new ForwardingFileIo(this.fileSystem), (String)metadataLocation);
        ImmutableMap newProperties = ImmutableMap.builder().putAll(tableMetadata.properties()).put((Object)"orc.bloom.filter.columns", (Object)"x,y").put((Object)"orc.bloom.filter.fpp", (Object)"0.2").buildOrThrow();
        TableMetadata newTableMetadata = TableMetadata.newTableMetadata((org.apache.iceberg.Schema)tableMetadata.schema(), (PartitionSpec)tableMetadata.spec(), (SortOrder)tableMetadata.sortOrder(), (String)tableMetadata.location(), (Map)newProperties);
        byte[] metadataJson = TableMetadataParser.toJson((TableMetadata)newTableMetadata).getBytes(StandardCharsets.UTF_8);
        this.fileSystem.newOutputFile(Location.of((String)metadataLocation)).createOrOverwrite(metadataJson);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"orc_bloom_filter_columns", "orc_bloom_filter_fpp"});
    }

    protected abstract boolean supportsIcebergFileStatistics(String var1);

    @Test
    public void testSplitPruningFromDataFileStatistics() {
        for (BaseConnectorTest.DataMappingTestSetup testSetup : this.testDataMappingSmokeTestDataProvider()) {
            if (testSetup.isUnsupportedType()) {
                return;
            }
            TestTable table = this.newTrinoTable("test_split_pruning_data_file_statistics", "(col " + testSetup.getTrinoTypeName() + ", r double)");
            try {
                String tableName = table.getName();
                String values = Stream.concat(Collections.nCopies(100, testSetup.getSampleValueLiteral()).stream(), Collections.nCopies(100, testSetup.getHighValueLiteral()).stream()).map(value -> "(" + value + ", rand())").collect(Collectors.joining(", "));
                this.assertUpdate(IcebergTestUtils.withSmallRowGroups(this.getSession()), "INSERT INTO " + tableName + " VALUES " + values, 200L);
                String query = "SELECT * FROM " + tableName + " WHERE col = " + testSetup.getSampleValueLiteral();
                this.verifyPredicatePushdownDataRead(query, this.supportsRowGroupStatistics(testSetup.getTrinoTypeName()));
            }
            finally {
                if (table == null) continue;
                table.close();
            }
        }
    }

    protected abstract boolean supportsRowGroupStatistics(String var1);

    private void verifySplitCount(String query, int expectedSplitCount) {
        QueryRunner.MaterializedResultWithPlan selectAllPartitionsResult = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), query);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)selectAllPartitionsResult.result().getMaterializedRows(), (Iterable)this.computeActual(this.withoutPredicatePushdown(this.getSession()), query).getMaterializedRows());
        this.verifySplitCount(selectAllPartitionsResult.queryId(), (long)expectedSplitCount);
    }

    private void verifyPredicatePushdownDataRead(@Language(value="SQL") String query, boolean supportsPushdown) {
        QueryRunner.MaterializedResultWithPlan resultWithPredicatePushdown = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), query);
        QueryRunner.MaterializedResultWithPlan resultWithoutPredicatePushdown = this.getDistributedQueryRunner().executeWithPlan(this.withoutPredicatePushdown(this.getSession()), query);
        DataSize withPushdownDataSize = this.getOperatorStats(resultWithPredicatePushdown.queryId()).getInputDataSize();
        DataSize withoutPushdownDataSize = this.getOperatorStats(resultWithoutPredicatePushdown.queryId()).getInputDataSize();
        if (supportsPushdown) {
            Assertions.assertThat((Comparable)withPushdownDataSize).isLessThan((Comparable)withoutPushdownDataSize);
        } else {
            Assertions.assertThat((Comparable)withPushdownDataSize).isEqualTo((Object)withoutPushdownDataSize);
        }
    }

    private Session withoutPredicatePushdown(Session session) {
        return Session.builder((Session)session).setSystemProperty("allow_pushdown_into_connectors", "false").build();
    }

    private void verifySplitCount(QueryId queryId, long expectedSplitCount) {
        Preconditions.checkArgument((expectedSplitCount >= 0L ? 1 : 0) != 0);
        OperatorStats operatorStats = this.getOperatorStats(queryId);
        if (expectedSplitCount > 0L) {
            Assertions.assertThat((long)operatorStats.getTotalDrivers()).isEqualTo(expectedSplitCount);
            Assertions.assertThat((long)operatorStats.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((double)operatorStats.getPhysicalInputReadTime().getValue()).isGreaterThan(0.0);
        } else {
            Assertions.assertThat((long)operatorStats.getTotalDrivers()).isEqualTo(1L);
            Assertions.assertThat((long)operatorStats.getPhysicalInputPositions()).isEqualTo(0L);
            Assertions.assertThat((long)operatorStats.getPhysicalInputReadTime().toMillis()).isEqualTo(0L);
        }
    }

    protected OperatorStats getOperatorStats(QueryId queryId) {
        try {
            return (OperatorStats)this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getOperatorSummaries().stream().filter(summary -> summary.getOperatorType().startsWith("TableScan") || summary.getOperatorType().startsWith("Scan")).collect(MoreCollectors.onlyElement());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Couldn't find operator summary, probably due to query statistic collection error", e);
        }
    }

    protected TestTable createTableWithDefaultColumns() {
        return (TestTable)Assumptions.abort((String)"Iceberg connector does not support column default values");
    }

    protected Optional<BaseConnectorTest.DataMappingTestSetup> filterDataMappingSmokeTestData(BaseConnectorTest.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getTrinoTypeName();
        if (typeName.equals("char(3)")) {
            return Optional.of(new BaseConnectorTest.DataMappingTestSetup(typeName, "'ab '", dataMappingTestSetup.getHighValueLiteral()));
        }
        return Optional.of(dataMappingTestSetup);
    }

    @Test
    public void testAmbiguousColumnsWithDots() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE ambiguous (\"a.cow\" BIGINT, a ROW(cow BIGINT))")).hasMessage("Invalid schema: multiple fields for name a.cow: 1 and 3");
        this.assertUpdate("CREATE TABLE ambiguous (\"a.cow\" BIGINT, b ROW(cow BIGINT))");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE ambiguous RENAME COLUMN b TO a")).hasMessage("Failed to rename column: Invalid schema: multiple fields for name a.cow: 1 and 3");
        this.assertUpdate("DROP TABLE ambiguous");
        this.assertUpdate("CREATE TABLE ambiguous (a ROW(cow BIGINT))");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE ambiguous ADD COLUMN \"a.cow\" BIGINT")).hasMessage("Failed to add column: Cannot add column, name already exists: a.cow");
        this.assertUpdate("DROP TABLE ambiguous");
    }

    @Test
    public void testSchemaEvolutionWithDereferenceProjections() {
        String tableName = "evolve_test_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (dummy BIGINT, a row(b BIGINT, c VARCHAR))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(1, 'abc'))", 1L);
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN a");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN a ROW(b VARCHAR, c BIGINT)");
        this.assertQuery("SELECT a.b FROM " + tableName, "VALUES NULL");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (dummy BIGINT, a ROW(b BIGINT, c VARCHAR), d BIGINT) with (partitioning = ARRAY['d'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(2, 'abc'), 3)", 1L);
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN a");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN a ROW(c VARCHAR, b BIGINT)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (4, 5, ROW('def', 6))", 1L);
        this.assertQuery("SELECT a.b FROM " + tableName + " WHERE d = 3", "VALUES NULL");
        this.assertQuery("SELECT a.b FROM " + tableName + " WHERE d = 5", "VALUES 6");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testProjectionPushdownAfterRename() {
        this.assertUpdate("CREATE TABLE projection_pushdown_after_rename (id INT, a ROW(b INT, c ROW (d INT)))");
        this.assertUpdate("INSERT INTO projection_pushdown_after_rename VALUES (1, ROW(2, ROW(3))), (11, ROW(12, ROW(13)))", 2L);
        this.assertUpdate("INSERT INTO projection_pushdown_after_rename VALUES (21, ROW(22, ROW(23)))", 1L);
        String expected = "VALUES (11, JSON '{\"b\":12,\"c\":{\"d\":13}}', 13)";
        this.assertQuery("SELECT id, CAST(a AS JSON), a.c.d FROM projection_pushdown_after_rename WHERE a.b = 12", expected);
        this.assertUpdate("ALTER TABLE projection_pushdown_after_rename RENAME COLUMN a TO row_t");
        this.assertQuery("SELECT id, CAST(row_t AS JSON), row_t.c.d FROM projection_pushdown_after_rename WHERE row_t.b = 12", expected);
        this.assertUpdate("DROP TABLE IF EXISTS projection_pushdown_after_rename");
    }

    @Test
    public void testProjectionPushdownOnPartitionedTables() {
        this.assertUpdate("CREATE TABLE table_with_partition_at_beginning (id BIGINT, root ROW(f1 BIGINT, f2 BIGINT)) WITH (partitioning = ARRAY['id'])");
        this.assertUpdate("INSERT INTO table_with_partition_at_beginning VALUES (1, ROW(1, 2)), (1, ROW(2, 3)), (1, ROW(3, 4))", 3L);
        this.assertQuery("SELECT id, root.f2 FROM table_with_partition_at_beginning", "VALUES (1, 2), (1, 3), (1, 4)");
        this.assertUpdate("DROP TABLE table_with_partition_at_beginning");
        this.assertUpdate("CREATE TABLE table_with_partition_at_end (root ROW(f1 BIGINT, f2 BIGINT), id BIGINT) WITH (partitioning = ARRAY['id'])");
        this.assertUpdate("INSERT INTO table_with_partition_at_end VALUES (ROW(1, 2), 1), (ROW(2, 3), 1), (ROW(3, 4), 1)", 3L);
        this.assertQuery("SELECT root.f2, id FROM table_with_partition_at_end", "VALUES (2, 1), (3, 1), (4, 1)");
        this.assertUpdate("DROP TABLE table_with_partition_at_end");
    }

    @Test
    public void testProjectionPushdownOnPartitionedTableWithComments() {
        this.assertUpdate("CREATE TABLE test_projection_pushdown_comments (id BIGINT COMMENT 'id', qid BIGINT COMMENT 'QID', root ROW(f1 BIGINT, f2 BIGINT) COMMENT 'root') WITH (partitioning = ARRAY['id'])");
        this.assertUpdate("INSERT INTO test_projection_pushdown_comments VALUES (1, 1, ROW(1, 2)), (1, 2, ROW(2, 3)), (1, 3, ROW(3, 4))", 3L);
        this.assertQuery("SELECT id, root.f2 FROM test_projection_pushdown_comments", "VALUES (1, 2), (1, 3), (1, 4)");
        this.assertQuery("SELECT id, root.f2 FROM test_projection_pushdown_comments WHERE id = 1 AND qid = 1 AND root.f1 = 1", "VALUES (1, 2)");
        this.assertQuery("SELECT id, root.f2 FROM test_projection_pushdown_comments WHERE qid = 2 AND root.f1 = 2", "VALUES (1, 3)");
        this.assertQuery("SELECT id, root.f2 FROM test_projection_pushdown_comments WHERE id = 1 AND qid = 1", "VALUES (1, 2)");
        this.assertQuery("SELECT id, root.f2 FROM test_projection_pushdown_comments WHERE root.f1 = 2", "VALUES (1, 3)");
        this.assertUpdate("DROP TABLE IF EXISTS test_projection_pushdown_comments");
    }

    @Test
    public void testMaxWriterTaskCount() {
        int workerCount = this.getQueryRunner().getNodeCount();
        Preconditions.checkState((workerCount > 1 ? 1 : 0) != 0, (Object)"testMaxWriterTaskCount requires multiple workers");
        this.assertUpdate("CREATE TABLE test_max_writer_task_count_insert (id BIGINT) WITH (partitioning = ARRAY['id'])");
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "false").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("max_writer_task_count", "1").setSystemProperty("max_hash_partition_count", Integer.toString(workerCount)).build();
        QueryId id = this.getDistributedQueryRunner().executeWithPlan(session, "INSERT INTO test_max_writer_task_count_insert\nSELECT * FROM TABLE(sequence(start => 0, stop => 100, step => 1))\n").queryId();
        StageInfo writerStage = (StageInfo)((StageInfo)this.getDistributedQueryRunner().getCoordinator().getFullQueryInfo(id).getOutputStage().orElseThrow()).getSubStages().getFirst();
        Assertions.assertThat((boolean)PlanNodeSearcher.searchFrom((PlanNode)writerStage.getPlan().getRoot()).whereIsInstanceOfAny(new Class[]{TableWriterNode.class}).matches()).isTrue();
        Assertions.assertThat((int)writerStage.getTasks().size()).isEqualTo(1);
        this.assertUpdate("DROP TABLE IF EXISTS test_max_writer_task_count_insert");
    }

    @Test
    public void testOptimize() throws Exception {
        for (int formatVersion = 1; formatVersion < 2; ++formatVersion) {
            String tableName = "test_optimize_" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE " + tableName + " (key integer, value varchar) WITH (format_version = " + formatVersion + ")");
            int workerCount = this.getQueryRunner().getNodeCount();
            this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEmpty();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (11, 'eleven')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (12, 'zw\u00f6lf')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (13, 'trzyna\u015bcie')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (14, 'quatorze')", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (15, '\u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c')", 1L);
            List<String> initialFiles = this.getActiveFiles(tableName);
            ((ListAssert)Assertions.assertThat(initialFiles).hasSize(5)).hasSizeGreaterThan(workerCount);
            this.computeActual(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(key), listagg(value, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '65', VARCHAR 'eleven zw\u00f6lf trzyna\u015bcie quatorze \u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c')");
            List<String> updatedFiles = this.getActiveFiles(tableName);
            ((ListAssert)Assertions.assertThat(updatedFiles).hasSizeBetween(1, workerCount)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).containsExactlyInAnyOrderElementsOf(Iterables.concat(initialFiles, updatedFiles));
            this.computeActual(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE (file_size_threshold => '33B')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(key), listagg(value, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '65', VARCHAR 'eleven zw\u00f6lf trzyna\u015bcie quatorze \u043f\u02bc\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c')");
            Assertions.assertThat(this.getActiveFiles(tableName)).isEqualTo(updatedFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).containsExactlyInAnyOrderElementsOf(Iterables.concat(initialFiles, updatedFiles));
            this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE \"optimize\"", "Table procedure not registered: optimize");
            this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE \"OPTIMIZE\"");
            this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE \"OPTIMIZE\" (\"file_size_threshold\" => '33B')");
            this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE \"OPTIMIZE\" (\"FILE_SIZE_THRESHOLD\" => '33B')");
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testOptimizeForPartitionedTable() throws IOException {
        for (int formatVersion = 1; formatVersion < 2; ++formatVersion) {
            Session session = TestingSession.testSessionBuilder().setCatalog(this.getQueryRunner().getDefaultSession().getCatalog()).setSchema(this.getQueryRunner().getDefaultSession().getSchema()).setSystemProperty("use_preferred_write_partitioning", "true").build();
            String tableName = "test_repartitiong_during_optimize_" + TestingNames.randomNameSuffix();
            this.assertUpdate(session, "CREATE TABLE " + tableName + " (key varchar, value integer) WITH (format_version = " + formatVersion + ", partitioning = ARRAY['key'])");
            this.assertQuerySucceeds(this.withSingleWriterPerTask(session), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('one', 2)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('one', 3)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('one', 4)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('one', 5)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('one', 6)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('one', 7)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('two', 8)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('two', 9)", 1L);
            this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('three', 10)", 1L);
            List<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(10);
            this.computeActual(this.withSingleWriterPerTask(session), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT sum(value), listagg(key, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '55', VARCHAR 'one one one one one one one three two two')");
            List<String> updatedFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(updatedFiles).hasSize(3);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).containsExactlyInAnyOrderElementsOf((Iterable)ImmutableSet.copyOf((Iterable)Iterables.concat(initialFiles, updatedFiles)));
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testOptimizeTimePartitionedTable() {
        this.testOptimizeTimePartitionedTable("date", "%s", 15);
        this.testOptimizeTimePartitionedTable("date", "day(%s)", 15);
        this.testOptimizeTimePartitionedTable("date", "month(%s)", 3);
        this.testOptimizeTimePartitionedTable("timestamp(6)", "day(%s)", 15);
        this.testOptimizeTimePartitionedTable("timestamp(6)", "month(%s)", 3);
        this.testOptimizeTimePartitionedTable("timestamp(6) with time zone", "day(%s)", 15);
        this.testOptimizeTimePartitionedTable("timestamp(6) with time zone", "month(%s)", 3);
    }

    private void testOptimizeTimePartitionedTable(String dataType, String partitioningFormat, int expectedFilesAfterOptimize) {
        String tableName = "test_optimize_time_partitioned_" + (dataType + "_" + partitioningFormat).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9_]", "");
        this.assertUpdate(String.format("CREATE TABLE %s(p %s, val varchar) WITH (partitioning = ARRAY['%s'])", tableName, dataType, String.format(partitioningFormat, "p")));
        for (int hour = 0; hour < 5; ++hour) {
            this.assertUpdate("INSERT INTO " + tableName + " SELECT CAST(t AS " + dataType + "), CAST(t AS varchar) FROM (    SELECT         TIMESTAMP '2022-01-16 10:05:06.123456 UTC'            + month * INTERVAL '1' MONTH             + day * INTERVAL '1' DAY             + " + hour + " * INTERVAL '1' HOUR             AS t    FROM UNNEST(sequence(1, 5)) AS _(month)    CROSS JOIN UNNEST(sequence(1, 5)) AS _(day))", 25L);
        }
        String optimizeDate = "DATE '2022-04-01'";
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName))).as("total file count", new Object[0])).isGreaterThanOrEqualTo(5L);
        long filesBeforeOptimizeDate = (Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName + " WHERE p < " + optimizeDate);
        ((AbstractLongAssert)Assertions.assertThat((long)filesBeforeOptimizeDate).as("file count before optimize date", new Object[0])).isGreaterThanOrEqualTo(5L);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName + " WHERE p >= " + optimizeDate))).as("file count after optimize date", new Object[0])).isGreaterThanOrEqualTo(5L);
        this.assertUpdate(this.withSingleWriterPerTask(Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.UTC_KEY).build()), "ALTER TABLE " + tableName + " EXECUTE optimize WHERE p >= " + optimizeDate);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName + " WHERE p < " + optimizeDate))).as("file count before optimize date, after the optimize", new Object[0])).isEqualTo(filesBeforeOptimizeDate);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName + " WHERE p >= " + optimizeDate))).as("file count after optimize date, after the optimize", new Object[0])).isEqualTo((long)expectedFilesAfterOptimize);
        this.assertUpdate(this.withSingleWriterPerTask(Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")).build()), "ALTER TABLE " + tableName + " EXECUTE optimize WHERE CAST(p AS date) >= " + optimizeDate);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName + " WHERE p < " + optimizeDate))).as("file count before optimize date, after the second optimize", new Object[0])).isEqualTo(filesBeforeOptimizeDate);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM " + tableName + " WHERE p >= " + optimizeDate))).as("file count after optimize date, after the second optimize", new Object[0])).isEqualTo((long)expectedFilesAfterOptimize);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeTableAfterDeleteWithFormatVersion2() {
        String tableName = "test_optimize_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", 25L);
        List<String> initialFiles = this.getActiveFiles(tableName);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE nationkey = 7", 1L);
        this.assertQuery("SELECT summary['total-delete-files'] FROM \"" + tableName + "$snapshots\" WHERE snapshot_id = " + this.getCurrentSnapshotId(tableName), "VALUES '1'");
        this.computeActual(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        ((ListAssert)Assertions.assertThat(updatedFiles).hasSize(1)).isNotEqualTo(initialFiles);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT * FROM nation WHERE nationkey != 7");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeCleansUpDeleteFiles() throws IOException {
        String tableName = "test_optimize_" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey']) AS SELECT * FROM nation", 25L);
        List<String> allDataFilesInitially = this.getAllDataFilesFromTableDirectory(tableName);
        Assertions.assertThat(allDataFilesInitially).hasSize(5);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE nationkey = 7", 1L);
        this.assertQuery("SELECT summary['total-delete-files'] FROM \"" + tableName + "$snapshots\" WHERE snapshot_id = " + this.getCurrentSnapshotId(tableName), "VALUES '1'");
        List<String> allDataFilesAfterDelete = this.getAllDataFilesFromTableDirectory(tableName);
        Assertions.assertThat(allDataFilesAfterDelete).hasSize(6);
        this.computeActual(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE regionkey = 3");
        this.computeActual(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        this.computeActual(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')");
        this.assertQuery("SELECT summary['total-delete-files'] FROM \"" + tableName + "$snapshots\" WHERE snapshot_id = " + this.getCurrentSnapshotId(tableName), "VALUES '0'");
        List<String> allDataFilesAfterOptimizeWithWhere = this.getAllDataFilesFromTableDirectory(tableName);
        ((ListAssert)((ListAssert)Assertions.assertThat(allDataFilesAfterOptimizeWithWhere).hasSize(5)).doesNotContain((Object[])((String[])allDataFilesInitially.stream().filter(file -> file.contains("regionkey=3")).toArray(String[]::new)))).contains((Object[])((String[])allDataFilesInitially.stream().filter(file -> !file.contains("regionkey=3")).toArray(String[]::new)));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT * FROM nation WHERE nationkey != 7");
        this.computeActual(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        this.computeActual(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        this.computeActual(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')");
        this.assertQuery("SELECT summary['total-delete-files'] FROM \"" + tableName + "$snapshots\" WHERE snapshot_id = " + this.getCurrentSnapshotId(tableName), "VALUES '0'");
        List<String> allDataFilesAfterFullOptimize = this.getAllDataFilesFromTableDirectory(tableName);
        ((ListAssert)Assertions.assertThat(allDataFilesAfterFullOptimize).hasSize(5)).contains((Object[])allDataFilesAfterOptimizeWithWhere.toArray(new String[0]));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT * FROM nation WHERE nationkey != 7");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeFilesDoNotInheritSequenceNumber() throws IOException {
        String tableName = "test_optimize_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", 25L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE nationkey = 7", 1L);
        this.assertQuery("SELECT summary['total-delete-files'] FROM \"" + tableName + "$snapshots\" WHERE snapshot_id = " + this.getCurrentSnapshotId(tableName), "VALUES '1'");
        this.computeActual(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        List<IcebergEntry> activeEntries = this.getIcebergEntries(tableName);
        Assertions.assertThat(activeEntries).hasSize(3);
        ((ListAssert)Assertions.assertThat(activeEntries.stream().filter(entry -> entry.status() == 1)).hasSize(1)).allMatch(entry -> entry.sequenceNumber() == 2L && entry.fileSequenceNumber() == 3L);
        ((ListAssert)Assertions.assertThat(activeEntries.stream().filter(entry -> entry.status() == 2)).hasSize(2)).allMatch(entry -> entry.sequenceNumber().equals(entry.fileSequenceNumber()));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("SELECT * FROM nation WHERE nationkey != 7");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeSnapshot() {
        String tableName = "test_optimize_snapshot_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a) AS VALUES 11", 1L);
        long snapshotId = this.getCurrentSnapshotId(tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 22", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"%s@%d\" EXECUTE OPTIMIZE".formatted(tableName, snapshotId)))).failure().hasMessage(String.format("line 1:7: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, snapshotId));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 11, 22");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeSystemTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"nation$files\" EXECUTE OPTIMIZE"))).failure().hasMessage("This connector does not support table procedures");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"nation$snapshots\" EXECUTE OPTIMIZE"))).failure().hasMessage("This connector does not support table procedures");
    }

    @Test
    void testOptimizeOnlyOneFileShouldHaveNoEffect() {
        String tableName = "test_optimize_one_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 1, 2", 2L);
        List<String> initialFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(initialFiles).hasSize(1);
        this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a FROM " + tableName))).matches("VALUES 1, 2");
        Assertions.assertThat(this.getActiveFiles(tableName)).containsExactlyInAnyOrderElementsOf(initialFiles);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a = 1", 1L);
        this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a FROM " + tableName))).matches("VALUES 2");
        ((ListAssert)Assertions.assertThat(this.getActiveFiles(tableName)).hasSize(1)).doesNotContainAnyElementsOf(initialFiles);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testOptimizeAfterChangeInPartitioning() {
        String tableName = "test_optimize_after_change_in_partitioning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['bucket(nationkey, 5)']) AS SELECT * FROM tpch.tiny.supplier", 100L);
        List<String> initialFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(initialFiles).hasSize(5);
        this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT COUNT(*) FROM " + tableName))).matches("VALUES BIGINT '100'");
        Assertions.assertThat(this.getActiveFiles(tableName)).containsExactlyInAnyOrderElementsOf(initialFiles);
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['nationkey']");
        this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT COUNT(*) FROM " + tableName))).matches("VALUES BIGINT '100'");
        List<String> filesAfterPartioningChange = this.getActiveFiles(tableName);
        ((ListAssert)Assertions.assertThat(filesAfterPartioningChange).hasSize(25)).doesNotContainAnyElementsOf(initialFiles);
        this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT COUNT(*) FROM " + tableName))).matches("VALUES BIGINT '100'");
        ((ListAssert)Assertions.assertThat(this.getActiveFiles(tableName)).hasSize(25)).containsExactlyInAnyOrderElementsOf(filesAfterPartioningChange);
    }

    private List<String> getActiveFiles(String tableName) {
        return (List)this.computeActual(String.format("SELECT file_path FROM \"%s$files\"", tableName)).getOnlyColumn().map(String.class::cast).collect(ImmutableList.toImmutableList());
    }

    private List<IcebergEntry> getIcebergEntries(String tableName) {
        return (List)this.computeActual(String.format("SELECT status, data_file.file_path, sequence_number, file_sequence_number FROM \"%s$entries\"", tableName)).getMaterializedRows().stream().map(row -> new IcebergEntry((Integer)row.getField(0), (String)row.getField(1), (Long)row.getField(2), (Long)row.getField(3))).collect(ImmutableList.toImmutableList());
    }

    protected String getTableLocation(String tableName) {
        Pattern locationPattern = Pattern.compile(".*location = '(.*?)'.*", 32);
        Matcher m = locationPattern.matcher((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue());
        if (m.find()) {
            String location = m.group(1);
            Verify.verify((!m.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in SHOW CREATE TABLE result");
    }

    protected List<String> getAllDataFilesFromTableDirectory(String tableName) throws IOException {
        return this.listFiles(this.getIcebergTableDataPath(this.getTableLocation(tableName)));
    }

    @Test
    public void testOptimizeParameterValidation() {
        this.assertQueryFails("ALTER TABLE no_such_table_exists EXECUTE OPTIMIZE", "\\Qline 1:7: Table 'iceberg.tpch.no_such_table_exists' does not exist");
        this.assertQueryFails("ALTER TABLE nation EXECUTE OPTIMIZE (file_size_threshold => '33')", "\\Qline 1:38: Unable to set catalog 'iceberg' table procedure 'OPTIMIZE' property 'file_size_threshold' to ['33']: size is not a valid data size string: 33");
        this.assertQueryFails("ALTER TABLE nation EXECUTE OPTIMIZE (file_size_threshold => '33s')", "\\Qline 1:38: Unable to set catalog 'iceberg' table procedure 'OPTIMIZE' property 'file_size_threshold' to ['33s']: Unknown unit: s");
    }

    @Test
    public void testTargetMaxFileSize() {
        String tableName = "test_default_max_file_size" + TestingNames.randomNameSuffix();
        String createTableSql = String.format("CREATE TABLE %s AS SELECT * FROM tpch.sf1.lineitem LIMIT 100000", tableName);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").setSystemProperty("task_scale_writers_enabled", "false").build();
        this.assertUpdate(session, createTableSql, 100000L);
        List<String> initialFiles = this.getActiveFiles(tableName);
        Assertions.assertThat((int)initialFiles.size()).isLessThanOrEqualTo(3);
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
        DataSize maxSize = DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").setSystemProperty("task_scale_writers_enabled", "false").setCatalogSessionProperty("iceberg", "target_max_file_size", maxSize.toString()).build();
        this.assertUpdate(session, createTableSql, 100000L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT count(*) FROM %s", tableName)))).matches("VALUES BIGINT '100000'");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat((int)updatedFiles.size()).isGreaterThan(10);
        this.computeActual(String.format("SELECT file_size_in_bytes FROM \"%s$files\"", tableName)).getMaterializedRows().forEach(row -> Assertions.assertThat((Long)((Long)row.getField(0))).isBetween(Long.valueOf(1L), Long.valueOf(maxSize.toBytes() * 6L)));
    }

    @Test
    public void testTargetMaxFileSizeOnSortedTable() {
        String tableName = "test_default_max_file_size_sorted_" + TestingNames.randomNameSuffix();
        String createTableSql = String.format("CREATE TABLE %s WITH (sorted_by = ARRAY['shipdate']) AS SELECT * FROM tpch.sf1.lineitem LIMIT 100000", tableName);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").setSystemProperty("task_scale_writers_enabled", "false").build();
        this.assertUpdate(session, createTableSql, 100000L);
        List<String> initialFiles = this.getActiveFiles(tableName);
        Assertions.assertThat((int)initialFiles.size()).isLessThanOrEqualTo(3);
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
        DataSize maxSize = DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").setSystemProperty("task_scale_writers_enabled", "false").setCatalogSessionProperty("iceberg", "target_max_file_size", maxSize.toString()).build();
        this.assertUpdate(session, createTableSql, 100000L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT count(*) FROM %s", tableName)))).matches("VALUES BIGINT '100000'");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat((int)updatedFiles.size()).isGreaterThan(5);
        this.computeActual(String.format("SELECT file_size_in_bytes FROM \"%s$files\"", tableName)).getMaterializedRows().forEach(row -> Assertions.assertThat((Long)((Long)row.getField(0))).isBetween(Long.valueOf(1L), Long.valueOf(maxSize.toBytes() * 20L)));
    }

    @Test
    public void testDroppingIcebergAndCreatingANewTableWithTheSameNameShouldBePossible() {
        this.assertUpdate("CREATE TABLE test_iceberg_recreate (a_int) AS VALUES (1)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(a_int) FROM test_iceberg_recreate"))).matches("VALUES 1");
        this.assertUpdate("DROP TABLE test_iceberg_recreate");
        this.assertUpdate("CREATE TABLE test_iceberg_recreate (a_varchar) AS VALUES ('Trino')", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(a_varchar) FROM test_iceberg_recreate"))).matches("VALUES CAST('Trino' AS varchar)");
        this.assertUpdate("DROP TABLE test_iceberg_recreate");
    }

    @Test
    public void testDropTableDeleteData() {
        String tableName = "test_drop_table_delete_data" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_int) AS VALUES (1)", 1L);
        String tableLocation = this.getTableLocation(tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + "(a_int INTEGER) WITH (location = '" + tableLocation + "')");
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + tableName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testPartitionHiddenColumn() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        String createTable = "CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['zip']) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(userid, zip)";
        this.assertUpdate(createTable, 8L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE " + tableName))).skippingTypesCheck().matches("VALUES ('userid', 'integer', '', ''), ('zip', 'integer', '', '')");
        String somePath = (String)this.computeScalar("SELECT \"$partition\" FROM " + tableName + " WHERE userid = 2");
        String anotherPath = (String)this.computeScalar("SELECT \"$partition\" FROM " + tableName + " WHERE userid = 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$partition\" = '" + somePath + "'"))).matches("VALUES 2, 5").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$partition\" IN ('" + somePath + "', '" + anotherPath + "')"))).matches("VALUES 0, 2, 3, 5, 6").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$partition\" <> '" + somePath + "'"))).matches("VALUES 0, 1, 3, 4, 6, 7").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$partition\" = '" + somePath + "' AND userid > 0"))).matches("VALUES 2, 5");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$partition\" IS NOT NULL"))).matches("VALUES 0, 1, 2, 3, 4, 5, 6, 7").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$partition\" IS NULL"))).returnsEmptyResult().isFullyPushedDown();
        String min = this.format == IcebergFileFormat.AVRO ? "NULL" : "'2'";
        String max = this.format == IcebergFileFormat.AVRO ? "NULL" : "'5'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (SELECT userid FROM " + tableName + " WHERE \"$partition\" = '" + somePath + "')"))).skippingTypesCheck().matches("VALUES ('userid', NULL, 2e0, 0e0, NULL, " + min + ", " + max + "), (NULL, NULL, NULL, NULL, 2e0, NULL, NULL)");
        this.assertQuerySucceeds("EXPLAIN SELECT userid FROM " + tableName + " WHERE \"$partition\" = '" + somePath + "'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testPartitionHiddenNestedField() {
        try (TestTable table = this.newTrinoTable("test_nested_partition", "WITH (partitioning = ARRAY['\"part.f\"']) AS SELECT 1 id, CAST(ROW(10) AS ROW(f int)) part");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'part.f=10')");
        }
    }

    @Test
    void testPartitionHiddenColumnNull() {
        try (TestTable table = this.newTrinoTable("test_null_partition", "WITH (partitioning = ARRAY['part']) AS SELECT 1 id, CAST(NULL AS integer) part");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'part=null')");
        }
    }

    @Test
    void testPartitionHiddenColumnWithNonPartitionTable() {
        try (TestTable table = this.newTrinoTable("test_non_partition", " AS SELECT 1 id");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR '')");
        }
    }

    @Test
    void testPartitionHiddenColumnMultiplePartitions() {
        try (TestTable table = this.newTrinoTable("test_multiple_partition", "WITH (partitioning = ARRAY['p1', 'p2']) AS SELECT 1 id, 10 p1, 100 p2");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'p1=10/p2=100')");
        }
    }

    @Test
    void testPartitionHiddenColumnTransform() {
        this.testPartitionHiddenColumnTransform("year(part)", "timestamp '2017-05-01 10:12:34'", "part_year=2017", "timestamp '2018-05-01 10:12:34'", "part_year=2018");
        this.testPartitionHiddenColumnTransform("month(part)", "timestamp '2017-05-01 10:12:34'", "part_month=2017-05", "timestamp '2018-05-01 10:12:34'", "part_month=2018-05");
        this.testPartitionHiddenColumnTransform("day(part)", "timestamp '2017-05-01 10:12:34'", "part_day=2017-05-01", "timestamp '2018-05-01 10:12:34'", "part_day=2018-05-01");
        this.testPartitionHiddenColumnTransform("hour(part)", "timestamp '2017-05-01 10:12:34'", "part_hour=2017-05-01-10", "timestamp '2018-05-01 10:12:34'", "part_hour=2018-05-01-10");
        this.testPartitionHiddenColumnTransform("bucket(part, 10)", "1", "part_bucket=6", "2", "part_bucket=2");
        this.testPartitionHiddenColumnTransform("truncate(part, 3)", "'abcde'", "part_trunc=abc", "'vwxyz'", "part_trunc=vwx");
    }

    private void testPartitionHiddenColumnTransform(String partitioning, String firstInput, String firstPartition, String secondInput, String secondPartition) {
        try (TestTable table = this.newTrinoTable("test_transform_partition", "WITH (partitioning = ARRAY['" + partitioning + "']) AS SELECT 1 id, " + firstInput + " part");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, " + secondInput + ")", 1L);
            Assertions.assertThat((Collection)this.computeActual("SELECT \"$partition\" FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{firstPartition, secondPartition});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE \"$partition\" = '" + firstPartition + "'"))).isFullyPushedDown().matches("VALUES 1");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE \"$partition\" = '" + secondPartition + "'"))).isFullyPushedDown().matches("VALUES 2");
        }
    }

    @Test
    void testPartitionHiddenColumnRenameColumn() {
        try (TestTable table = this.newTrinoTable("test_rename_partition", "WITH (partitioning = ARRAY['part']) AS SELECT 1 id, 10 part");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'part=10')");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN part TO renamed_part");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'part=10')");
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 20)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'part=10'), (2, VARCHAR 'part=20')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE \"$partition\" = 'part=10'"))).isFullyPushedDown().matches("VALUES 1");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE \"$partition\" = 'part=20'"))).isFullyPushedDown().matches("VALUES 2");
        }
    }

    @Test
    void testPartitionHiddenColumnChangePartition() {
        try (TestTable table = this.newTrinoTable("test_change_partition", "WITH (partitioning = ARRAY['y']) AS SELECT 1 x, 10 y");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'y=10')");
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES partitioning = ARRAY['x']");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'y=10')");
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 20)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x, \"$partition\" FROM " + table.getName()))).matches("VALUES (1, VARCHAR 'y=10'), (2, VARCHAR 'x=2')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x FROM " + table.getName() + " WHERE \"$partition\" = 'y=10'"))).isFullyPushedDown().matches("VALUES 1");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x FROM " + table.getName() + " WHERE \"$partition\" = 'x=2'"))).isFullyPushedDown().matches("VALUES 2");
        }
    }

    @Test
    void testOptimizeWithPartitionHiddenColumn() {
        try (TestTable table = this.newTrinoTable("test_optimize_partition", "(id int, part int) WITH (partitioning = ARRAY['bucket(part, 3)'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 10), (2, 20), (3, 30)", 3L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (4, 10), (5, 20), (6, 30)", 3L);
            Set filesInBucket0Before = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=0'").getOnlyColumnAsSet();
            Set filesInBucket1Before = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=1'").getOnlyColumnAsSet();
            Set filesInBucket2Before = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=2'").getOnlyColumnAsSet();
            Assertions.assertThat((Collection)filesInBucket0Before).hasSize(2);
            Assertions.assertThat((Collection)filesInBucket1Before).hasSize(2);
            Assertions.assertThat((Collection)filesInBucket2Before).hasSize(2);
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE WHERE \"$partition\" = 'part_bucket=0'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (1, 10), (2, 20), (3, 30), (4, 10), (5, 20), (6, 30)");
            Set filesInBucket0After = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=0'").getOnlyColumnAsSet();
            Set filesInBucket1After = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=1'").getOnlyColumnAsSet();
            Set filesInBucket2After = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=2'").getOnlyColumnAsSet();
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)filesInBucket0After).hasSize(1)).doesNotContain(new Object[]{filesInBucket0Before});
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)filesInBucket1After).hasSize(2)).isEqualTo((Object)filesInBucket1Before);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)filesInBucket2After).hasSize(2)).isEqualTo((Object)filesInBucket2Before);
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE WHERE \"$partition\" = 'part_bucket=0'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (1, 10), (2, 20), (3, 30), (4, 10), (5, 20), (6, 30)");
            Set filesInBucket0Repeat = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=0'").getOnlyColumnAsSet();
            Set filesInBucket1Repeat = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=1'").getOnlyColumnAsSet();
            Set filesInBucket2Repeat = this.computeActual("SELECT \"$path\" FROM " + table.getName() + " WHERE \"$partition\" = 'part_bucket=2'").getOnlyColumnAsSet();
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)filesInBucket0Repeat).hasSize(1)).isEqualTo((Object)filesInBucket0After);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)filesInBucket1Repeat).hasSize(2)).isEqualTo((Object)filesInBucket1After);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)filesInBucket2Repeat).hasSize(2)).isEqualTo((Object)filesInBucket2After);
        }
    }

    @Test
    public void testPathHiddenColumn() {
        String tableName = "test_path_" + TestingNames.randomNameSuffix();
        String createTable = "CREATE TABLE " + tableName + " WITH ( partitioning = ARRAY['zip'] ) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(userid, zip)";
        this.assertUpdate(createTable, 8L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE " + tableName))).skippingTypesCheck().matches("VALUES ('userid', 'integer', '', ''), ('zip', 'integer', '', '')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT file_path FROM \"" + tableName + "$files\""))).matches("SELECT DISTINCT \"$path\" as file_path FROM " + tableName);
        String somePath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE userid = 2");
        String anotherPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE userid = 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$path\" = '" + somePath + "'"))).matches("VALUES 2, 5").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$path\" IN ('" + somePath + "', '" + anotherPath + "')"))).matches("VALUES 0, 2, 3, 5, 6").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$path\" <> '" + somePath + "'"))).matches("VALUES 0, 1, 3, 4, 6, 7").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$path\" = '" + somePath + "' AND userid > 0"))).matches("VALUES 2, 5");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$path\" IS NOT NULL"))).matches("VALUES 0, 1, 2, 3, 4, 5, 6, 7").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT userid FROM " + tableName + " WHERE \"$path\" IS NULL"))).returnsEmptyResult().isFullyPushedDown();
        this.assertQuerySucceeds("SHOW STATS FOR (SELECT userid FROM " + tableName + " WHERE \"$path\" = '" + somePath + "')");
        this.assertQuerySucceeds("EXPLAIN SELECT userid FROM " + tableName + " WHERE \"$path\" = '" + somePath + "'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeWithPathColumn() {
        String tableName = "test_optimize_with_path_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (4)", 1L);
        String firstPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 1");
        String secondPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 2");
        String thirdPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 3");
        String fourthPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 4");
        List<String> initialFiles = this.getActiveFiles(tableName);
        Assertions.assertThat(initialFiles).hasSize(4);
        this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$path\" = '" + firstPath + "' OR \"$path\" = '" + secondPath + "'");
        this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$path\" = '" + thirdPath + "' OR \"$path\" = '" + fourthPath + "'");
        List<String> updatedFiles = this.getActiveFiles(tableName);
        ((ListAssert)Assertions.assertThat(updatedFiles).hasSize(2)).doesNotContainAnyElementsOf(initialFiles);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCollectingStatisticsWithPathColumnPredicate() {
        this.assertQuerySucceeds("EXPLAIN SELECT * FROM region WHERE \"$path\" = ''");
        Session collectingStatisticsSession = Session.builder((Session)this.getSession()).setSystemProperty("collect_plan_statistics_for_all_queries", "true").build();
        String tableName = "test_collect_statistics_with_path_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(id integer, value integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 2)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, null)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (4, 4)", 1L);
        MaterializedResult tableStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (SELECT * FROM %s WHERE \"$path\" IS NOT NULL)".formatted(tableName));
        MaterializedResult expectedTableStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 4.0, 0.0, null, "1", "4"}).row(new Object[]{"value", null, 3.0, 0.25, null, "1", "4"}).row(new Object[]{null, null, null, null, 4.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedTableStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 4.0, 0.0, null, null, null}).row(new Object[]{"value", null, 3.0, 0.1, null, null, null}).row(new Object[]{null, null, null, null, 4.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)tableStatistics).containsExactlyElementsOf((Iterable)expectedTableStatistics);
        String firstPath = (String)this.computeScalar(collectingStatisticsSession, "SELECT \"$path\" FROM " + tableName + " WHERE id = 1");
        String secondPath = (String)this.computeScalar(collectingStatisticsSession, "SELECT \"$path\" FROM " + tableName + " WHERE id = 2");
        String thirdPath = (String)this.computeScalar(collectingStatisticsSession, "SELECT \"$path\" FROM " + tableName + " WHERE id = 3");
        String fourthPath = (String)this.computeScalar(collectingStatisticsSession, "SELECT \"$path\" FROM " + tableName + " WHERE id = 4");
        String pathPredicateSql = "SELECT * FROM " + tableName + " WHERE \"$path\" = '%s'";
        this.assertQuery(collectingStatisticsSession, pathPredicateSql.formatted(firstPath), "VALUES (1, 1)");
        this.assertQuery(collectingStatisticsSession, pathPredicateSql.formatted(secondPath), "VALUES (2, 2)");
        this.assertQuery(collectingStatisticsSession, "SELECT COUNT(*) FROM %s WHERE \"$path\" = '%s' OR \"$path\" = '%s'".formatted(tableName, thirdPath, fourthPath), "VALUES 2");
        MaterializedResult firstPathStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (" + pathPredicateSql.formatted(firstPath) + ")");
        MaterializedResult expectedFirstPathStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, "1", "1"}).row(new Object[]{"value", null, 1.0, 0.0, null, "1", "1"}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedFirstPathStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, null, null}).row(new Object[]{"value", null, 1.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)firstPathStatistics).containsExactlyElementsOf((Iterable)expectedFirstPathStatistics);
        MaterializedResult secondThirdPathStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (SELECT * FROM %s WHERE \"$path\" IN ('%s', '%s'))".formatted(tableName, secondPath, thirdPath));
        MaterializedResult expectedSecondThirdPathStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 2.0, 0.0, null, "2", "3"}).row(new Object[]{"value", null, 1.0, 0.5, null, "2", "2"}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedSecondThirdPathStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 2.0, 0.0, null, null, null}).row(new Object[]{"value", null, 2.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)secondThirdPathStatistics).containsExactlyElementsOf((Iterable)expectedSecondThirdPathStatistics);
        MaterializedResult fourthPathStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (" + pathPredicateSql.formatted(fourthPath) + ")");
        MaterializedResult expectedFourthPathStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, "4", "4"}).row(new Object[]{"value", null, 1.0, 0.0, null, "4", "4"}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedFourthPathStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, null, null}).row(new Object[]{"value", null, 1.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)fourthPathStatistics).containsExactlyElementsOf((Iterable)expectedFourthPathStatistics);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCollectingStatisticsWithFileModifiedTimeColumnPredicate() throws InterruptedException {
        this.assertQuerySucceeds("EXPLAIN SELECT * FROM region WHERE \"$file_modified_time\" = TIMESTAMP '2001-08-22 03:04:05.321 UTC'");
        Session collectingStatisticsSession = Session.builder((Session)this.getSession()).setSystemProperty("collect_plan_statistics_for_all_queries", "true").build();
        String tableName = "test_collect_statistics_with_file_modified_time_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(id integer, value integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1)", 1L);
        this.storageTimePrecision.sleep(1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 2)", 1L);
        this.storageTimePrecision.sleep(1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, null)", 1L);
        this.storageTimePrecision.sleep(1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (4, 4)", 1L);
        MaterializedResult tableStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (SELECT * FROM %s WHERE \"$file_modified_time\" IS NOT NULL)".formatted(tableName));
        MaterializedResult expectedTableStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 4.0, 0.0, null, "1", "4"}).row(new Object[]{"value", null, 3.0, 0.25, null, "1", "4"}).row(new Object[]{null, null, null, null, 4.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedTableStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 4.0, 0.0, null, null, null}).row(new Object[]{"value", null, 3.0, 0.1, null, null, null}).row(new Object[]{null, null, null, null, 4.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)tableStatistics).containsExactlyElementsOf((Iterable)expectedTableStatistics);
        ZonedDateTime firstFileModifiedTime = (ZonedDateTime)this.computeScalar(collectingStatisticsSession, "SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 1");
        ZonedDateTime secondFileModifiedTime = (ZonedDateTime)this.computeScalar(collectingStatisticsSession, "SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 2");
        ZonedDateTime thirdFileModifiedTime = (ZonedDateTime)this.computeScalar(collectingStatisticsSession, "SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 3");
        ZonedDateTime fourthFileModifiedTime = (ZonedDateTime)this.computeScalar(collectingStatisticsSession, "SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 4");
        String fileModifiedTimePredicateSql = "SELECT * FROM " + tableName + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('%s')";
        this.assertQuery(collectingStatisticsSession, fileModifiedTimePredicateSql.formatted(firstFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)), "SELECT 1, 1");
        this.assertQuery(collectingStatisticsSession, fileModifiedTimePredicateSql.formatted(secondFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)), "SELECT 2, 2");
        this.assertQuery(collectingStatisticsSession, "SELECT COUNT(*) FROM %s WHERE \"$file_modified_time\" = from_iso8601_timestamp('%s') OR \"$file_modified_time\" = from_iso8601_timestamp('%s')".formatted(tableName, thirdFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME), fourthFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)), "VALUES 2");
        MaterializedResult firstFileModifiedTimeStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (" + fileModifiedTimePredicateSql.formatted(firstFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)) + ")");
        MaterializedResult expectedFirstFileModifiedTimeStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, "1", "1"}).row(new Object[]{"value", null, 1.0, 0.0, null, "1", "1"}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedFirstFileModifiedTimeStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, null, null}).row(new Object[]{"value", null, 1.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)firstFileModifiedTimeStatistics).containsExactlyElementsOf((Iterable)expectedFirstFileModifiedTimeStatistics);
        MaterializedResult secondThirdFileModifiedTimeStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (SELECT * FROM %s WHERE \"$file_modified_time\" IN (from_iso8601_timestamp('%s'), from_iso8601_timestamp('%s')))".formatted(tableName, secondFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME), thirdFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        MaterializedResult expectedSecondThirdFileModifiedTimetatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 2.0, 0.0, null, "2", "3"}).row(new Object[]{"value", null, 1.0, 0.5, null, "2", "2"}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedSecondThirdFileModifiedTimetatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 2.0, 0.0, null, null, null}).row(new Object[]{"value", null, 2.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 2.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)secondThirdFileModifiedTimeStatistics).containsExactlyElementsOf((Iterable)expectedSecondThirdFileModifiedTimetatistics);
        MaterializedResult fourthFileModifiedTimeStatistics = this.computeActual(collectingStatisticsSession, "SHOW STATS FOR (" + fileModifiedTimePredicateSql.formatted(fourthFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)) + ")");
        MaterializedResult expectedFourthFileModifiedTimeStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, "4", "4"}).row(new Object[]{"value", null, 1.0, 0.0, null, "4", "4"}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        if (this.format == IcebergFileFormat.AVRO) {
            expectedFourthFileModifiedTimeStatistics = MaterializedResult.resultBuilder((Session)collectingStatisticsSession, (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"id", null, 1.0, 0.0, null, null, null}).row(new Object[]{"value", null, 1.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 1.0, null, null}).build();
        }
        Assertions.assertThat((Iterable)fourthFileModifiedTimeStatistics).containsExactlyElementsOf((Iterable)expectedFourthFileModifiedTimeStatistics);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWithPathColumn() {
        try (TestTable table = this.newTrinoTable("test_delete_with_path_", "(key int)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1)", 1L);
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2)", 1L);
            String firstFilePath = (String)this.computeScalar("SELECT \"$path\" FROM " + table.getName() + " WHERE key = 1");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$path\" = '" + firstFilePath + "'", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 2");
        }
    }

    @Test
    public void testFileModifiedTimeHiddenColumn() throws Exception {
        ZonedDateTime beforeTime = (ZonedDateTime)this.computeScalar("SELECT current_timestamp(3)");
        if (this.storageTimePrecision.toMillis(1L) > 1L) {
            this.storageTimePrecision.sleep(1L);
        }
        try (TestTable table = this.newTrinoTable("test_file_modified_time_", "(col) AS VALUES (1)");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE " + table.getName()))).skippingTypesCheck().matches("VALUES ('col', 'integer', '', '')");
            ZonedDateTime fileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + table.getName());
            ZonedDateTime afterTime = (ZonedDateTime)this.computeScalar("SELECT current_timestamp(3)");
            Assertions.assertThat((ZonedDateTime)fileModifiedTime).isBetween(beforeTime, afterTime);
            this.storageTimePrecision.sleep(1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2)", 1L);
            ZonedDateTime anotherFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT max(\"$file_modified_time\") FROM " + table.getName());
            Assertions.assertThat((ZonedDateTime)fileModifiedTime).isNotEqualTo((Object)anotherFileModifiedTime);
            Assertions.assertThat((ZonedDateTime)anotherFileModifiedTime).isAfter(fileModifiedTime);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')"))).matches("VALUES 1").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" IN (from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "'), from_iso8601_timestamp('" + anotherFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "'))"))).matches("VALUES 1, 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" <> from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')"))).matches("VALUES 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" IS NOT NULL"))).matches("VALUES 1, 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" IS NULL"))).returnsEmptyResult().isFullyPushedDown();
            this.assertQuerySucceeds("SHOW STATS FOR (SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "'))");
            this.assertQuerySucceeds("EXPLAIN SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')");
        }
    }

    @Test
    public void testOptimizeWithFileModifiedTimeColumn() throws Exception {
        try (TestTable table = this.newTrinoTable("test_optimize_with_file_modified_time_", "(id INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1)", 1L);
            this.storageTimePrecision.sleep(1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (2)", 1L);
            this.storageTimePrecision.sleep(1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3)", 1L);
            this.storageTimePrecision.sleep(1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (4)", 1L);
            ZonedDateTime firstFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 1");
            ZonedDateTime secondFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 2");
            ZonedDateTime thirdFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 3");
            ZonedDateTime fourthFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 4");
            Assertions.assertThat(List.of(firstFileModifiedTime, secondFileModifiedTime, thirdFileModifiedTime, fourthFileModifiedTime)).doesNotHaveDuplicates();
            List<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(4);
            this.storageTimePrecision.sleep(1L);
            this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + firstFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "') OR \"$file_modified_time\" = from_iso8601_timestamp('" + secondFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')");
            this.assertQuerySucceeds(this.withSingleWriterPerTask(this.getSession()), "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + thirdFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "') OR \"$file_modified_time\" = from_iso8601_timestamp('" + fourthFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')");
            List<String> updatedFiles = this.getActiveFiles(tableName);
            ((ListAssert)Assertions.assertThat(updatedFiles).hasSize(2)).doesNotContainAnyElementsOf(initialFiles);
        }
    }

    @Test
    public void testDeleteWithFileModifiedTimeColumn() throws Exception {
        try (TestTable table = this.newTrinoTable("test_delete_with_file_modified_time_", "(key int)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1)", 1L);
            this.storageTimePrecision.sleep(1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2)", 1L);
            ZonedDateTime oldModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + table.getName() + " WHERE key = 1");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + oldModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 2");
        }
    }

    @Test
    public void testExpireSnapshots() throws Exception {
        String tableName = "test_expiring_snapshots_" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(value), listagg(key, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '3', VARCHAR 'one two')");
        List<Long> initialSnapshots = this.getSnapshotIds(tableName);
        String tableLocation = this.getTableLocation(tableName);
        List<String> initialFiles = this.getAllMetadataFilesFromTableDirectory(tableLocation);
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(value), listagg(key, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '3', VARCHAR 'one two')");
        List<String> updatedFiles = this.getAllMetadataFilesFromTableDirectory(tableLocation);
        List<Long> updatedSnapshots = this.getSnapshotIds(tableName);
        Assertions.assertThat(updatedFiles).hasSize(initialFiles.size() - 2);
        Assertions.assertThat((int)updatedSnapshots.size()).isLessThan(initialSnapshots.size());
        Assertions.assertThat(updatedSnapshots).hasSize(1);
        Assertions.assertThat(initialSnapshots).containsAll(updatedSnapshots);
    }

    @Test
    public void testExpireSnapshotsPartitionedTable() throws Exception {
        String tableName = "test_expiring_snapshots_partitioned_table" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertUpdate("CREATE TABLE " + tableName + " (col1 BIGINT, col2 BIGINT) WITH (partitioning = ARRAY['col1'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(1, 100), (1, 101), (1, 102), (2, 200), (2, 201), (3, 300)", 6L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE col1 = 1", 3L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(4, 400)", 1L);
        this.assertQuery("SELECT sum(col2) FROM " + tableName, "SELECT 1101");
        List<String> initialDataFiles = this.getAllDataFilesFromTableDirectory(tableName);
        List<Long> initialSnapshots = this.getSnapshotIds(tableName);
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        List<String> updatedDataFiles = this.getAllDataFilesFromTableDirectory(tableName);
        List<Long> updatedSnapshots = this.getSnapshotIds(tableName);
        this.assertQuery("SELECT sum(col2) FROM " + tableName, "SELECT 1101");
        Assertions.assertThat((int)updatedDataFiles.size()).isLessThan(initialDataFiles.size());
        Assertions.assertThat((int)updatedSnapshots.size()).isLessThan(initialSnapshots.size());
    }

    @Test
    public void testExpireSnapshotsOnSnapshot() {
        String tableName = "test_expire_snapshots_on_snapshot_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a) AS VALUES 11", 1L);
        long snapshotId = this.getCurrentSnapshotId(tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 22", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"%s@%d\" EXECUTE EXPIRE_SNAPSHOTS".formatted(tableName, snapshotId)))).failure().hasMessage(String.format("line 1:7: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, snapshotId));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 11, 22");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testExpireSnapshotsSystemTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"nation$files\" EXECUTE EXPIRE_SNAPSHOTS"))).failure().hasMessage("This connector does not support table procedures");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"nation$snapshots\" EXECUTE EXPIRE_SNAPSHOTS"))).failure().hasMessage("This connector does not support table procedures");
    }

    @Test
    public void testExplainExpireSnapshotOutput() {
        String tableName = "test_expiring_snapshots_output" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer) WITH (partitioning = ARRAY['key'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        this.assertExplain("EXPLAIN ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')", new String[]{"SimpleTableExecute\\[table = iceberg:schemaTableName:tpch.test_expiring_snapshots.*\\[retentionThreshold=0\\.00s].*"});
    }

    @Test
    public void testExpireSnapshotsParameterValidation() {
        this.assertQueryFails("ALTER TABLE no_such_table_exists EXECUTE EXPIRE_SNAPSHOTS", "\\Qline 1:7: Table 'iceberg.tpch.no_such_table_exists' does not exist");
        this.assertQueryFails("ALTER TABLE nation EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '33')", "\\Qline 1:46: Unable to set catalog 'iceberg' table procedure 'EXPIRE_SNAPSHOTS' property 'retention_threshold' to ['33']: duration is not a valid data duration string: 33");
        this.assertQueryFails("ALTER TABLE nation EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '33mb')", "\\Qline 1:46: Unable to set catalog 'iceberg' table procedure 'EXPIRE_SNAPSHOTS' property 'retention_threshold' to ['33mb']: Unknown time unit: mb");
        this.assertQueryFails("ALTER TABLE nation EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '33s')", "\\QRetention specified (33.00s) is shorter than the minimum retention configured in the system (7.00d). Minimum retention can be changed with iceberg.expire-snapshots.min-retention configuration property or iceberg.expire_snapshots_min_retention session property");
    }

    @Test
    public void testRemoveOrphanFilesWithUnexpectedMissingManifest() throws Exception {
        String tableName = "test_remove_orphan_files_with_missing_manifest_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        String manifestFileToRemove = (String)this.computeScalar("SELECT path FROM \"" + tableName + "$manifests\"");
        this.fileSystem.deleteFile(Location.of((String)manifestFileToRemove));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES"))).failure().hasErrorCode(new ErrorCodeSupplier[]{IcebergErrorCode.ICEBERG_INVALID_METADATA}).hasMessage("Manifest file does not exist: " + manifestFileToRemove);
    }

    @Test
    public void testRemoveOrphanFiles() throws Exception {
        String tableName = "test_deleting_orphan_files_unnecessary_files" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2), ('three', 3)", 2L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE key = 'two'", 1L);
        String location = this.getTableLocation(tableName);
        String orphanFile = this.getIcebergTableDataPath(location) + "/invalidData." + String.valueOf(this.format);
        this.createFile(orphanFile);
        List<String> initialDataFiles = this.getAllDataFilesFromTableDirectory(tableName);
        Assertions.assertThat(initialDataFiles).contains((Object[])new String[]{orphanFile});
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('one', 1), ('three', 3)");
        List<String> updatedDataFiles = this.getAllDataFilesFromTableDirectory(tableName);
        Assertions.assertThat((int)updatedDataFiles.size()).isLessThan(initialDataFiles.size());
        Assertions.assertThat(updatedDataFiles).doesNotContain((Object[])new String[]{orphanFile});
    }

    @Test
    public void testIfRemoveOrphanFilesCleansUnnecessaryDataFilesInPartitionedTable() throws Exception {
        String tableName = "test_deleting_orphan_files_unnecessary_files" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer) WITH (partitioning = ARRAY['key'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String orphanFile = this.getIcebergTableDataPath(tableLocation) + "/key=one/invalidData." + String.valueOf(this.format);
        this.createFile(orphanFile);
        List<String> initialDataFiles = this.getAllDataFilesFromTableDirectory(tableName);
        Assertions.assertThat(initialDataFiles).contains((Object[])new String[]{orphanFile});
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')");
        List<String> updatedDataFiles = this.getAllDataFilesFromTableDirectory(tableName);
        Assertions.assertThat((int)updatedDataFiles.size()).isLessThan(initialDataFiles.size());
        Assertions.assertThat(updatedDataFiles).doesNotContain((Object[])new String[]{orphanFile});
    }

    @Test
    public void testIfRemoveOrphanFilesCleansUnnecessaryMetadataFilesInPartitionedTable() throws Exception {
        String tableName = "test_deleting_orphan_files_unnecessary_files" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer) WITH (partitioning = ARRAY['key'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String orphanMetadataFile = this.getIcebergTableMetadataPath(tableLocation) + "/invalidData." + String.valueOf(this.format);
        this.createFile(orphanMetadataFile);
        List<String> initialMetadataFiles = this.getAllMetadataFilesFromTableDirectory(tableLocation);
        Assertions.assertThat(initialMetadataFiles).contains((Object[])new String[]{orphanMetadataFile});
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')");
        List<String> updatedMetadataFiles = this.getAllMetadataFilesFromTableDirectory(tableLocation);
        Assertions.assertThat((int)updatedMetadataFiles.size()).isLessThan(initialMetadataFiles.size());
        Assertions.assertThat(updatedMetadataFiles).doesNotContain((Object[])new String[]{orphanMetadataFile});
    }

    @Test
    public void testCleaningUpWithTableWithSpecifiedLocation() throws IOException {
        this.testCleaningUpWithTableWithSpecifiedLocation("");
        this.testCleaningUpWithTableWithSpecifiedLocation("/");
        this.testCleaningUpWithTableWithSpecifiedLocation("//");
        this.testCleaningUpWithTableWithSpecifiedLocation("///");
    }

    private void testCleaningUpWithTableWithSpecifiedLocation(String suffix) throws IOException {
        String tableName = "test_table_cleaning_up_with_location" + TestingNames.randomNameSuffix();
        String tableLocation = this.getDistributedQueryRunner().getCoordinator().getBaseDataDir().toUri().toASCIIString() + TestingNames.randomNameSuffix() + suffix;
        String tableDirectory = new File(URI.create(tableLocation)).getPath();
        this.assertUpdate(String.format("CREATE TABLE %s (key varchar, value integer) WITH(location = '%s')", tableName, tableLocation));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        List<String> initialMetadataFiles = this.getAllMetadataFilesFromTableDirectory(tableDirectory);
        List<Long> initialSnapshots = this.getSnapshotIds(tableName);
        ((ListAssert)Assertions.assertThat(initialSnapshots).as("initialSnapshots", new Object[0])).hasSize(3);
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')");
        List<String> prunedMetadataFiles = this.getAllMetadataFilesFromTableDirectory(tableDirectory);
        List<Long> prunedSnapshots = this.getSnapshotIds(tableName);
        ((ListAssert)Assertions.assertThat(prunedMetadataFiles).as("prunedMetadataFiles", new Object[0])).hasSize(initialMetadataFiles.size() - 2);
        ((ListAssert)((ListAssert)Assertions.assertThat(prunedSnapshots).as("prunedSnapshots", new Object[0])).hasSizeLessThan(initialSnapshots.size())).hasSize(1);
        Assertions.assertThat(initialSnapshots).containsAll(prunedSnapshots);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testExplainRemoveOrphanFilesOutput() {
        String tableName = "test_remove_orphan_files_output" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer) WITH (partitioning = ARRAY['key'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        this.assertExplain("EXPLAIN ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')", new String[]{"SimpleTableExecute\\[table = iceberg:schemaTableName:tpch.test_remove_orphan_files.*\\[retentionThreshold=0\\.00s].*"});
    }

    @Test
    public void testRemoveOrphanFilesParameterValidation() {
        this.assertQueryFails("ALTER TABLE no_such_table_exists EXECUTE REMOVE_ORPHAN_FILES", "\\Qline 1:7: Table 'iceberg.tpch.no_such_table_exists' does not exist");
        this.assertQueryFails("ALTER TABLE nation EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '33')", "\\Qline 1:49: Unable to set catalog 'iceberg' table procedure 'REMOVE_ORPHAN_FILES' property 'retention_threshold' to ['33']: duration is not a valid data duration string: 33");
        this.assertQueryFails("ALTER TABLE nation EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '33mb')", "\\Qline 1:49: Unable to set catalog 'iceberg' table procedure 'REMOVE_ORPHAN_FILES' property 'retention_threshold' to ['33mb']: Unknown time unit: mb");
        this.assertQueryFails("ALTER TABLE nation EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '33s')", "\\QRetention specified (33.00s) is shorter than the minimum retention configured in the system (7.00d). Minimum retention can be changed with iceberg.remove-orphan-files.min-retention configuration property or iceberg.remove_orphan_files_min_retention session property");
    }

    @Test
    public void testRemoveOrphanFilesOnSnapshot() {
        String tableName = "test_remove_orphan_files_on_snapshot_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a) AS VALUES 11", 1L);
        long snapshotId = this.getCurrentSnapshotId(tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 22", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"%s@%d\" EXECUTE REMOVE_ORPHAN_FILES".formatted(tableName, snapshotId)))).failure().hasMessage(String.format("line 1:7: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, snapshotId));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES 11, 22");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRemoveOrphanFilesSystemTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"nation$files\" EXECUTE REMOVE_ORPHAN_FILES"))).failure().hasMessage("This connector does not support table procedures");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE \"nation$snapshots\" EXECUTE REMOVE_ORPHAN_FILES"))).failure().hasMessage("This connector does not support table procedures");
    }

    @Test
    public void testIfDeletesReturnsNumberOfRemovedRows() {
        String tableName = "test_delete_returns_number_of_rows_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer) WITH (partitioning = ARRAY['key'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 2)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 3)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE key = 'one'", 3L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE key = 'one'");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE key = 'three'");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE key = 'two'", 2L);
    }

    @Test
    public void testUpdatingFileFormat() {
        String tableName = "test_updating_file_format_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format = 'orc') AS SELECT * FROM nation WHERE nationkey < 10", "SELECT count(*) FROM nation WHERE nationkey < 10");
        this.assertQuery("SELECT value FROM \"" + tableName + "$properties\" WHERE key = 'write.format.default'", "VALUES 'ORC'");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES format = 'parquet'");
        this.assertQuery("SELECT value FROM \"" + tableName + "$properties\" WHERE key = 'write.format.default'", "VALUES 'PARQUET'");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM nation WHERE nationkey >= 10", "SELECT count(*) FROM nation WHERE nationkey >= 10");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
        this.assertQuery("SELECT count(*) FROM \"" + tableName + "$files\" WHERE file_path LIKE '%.orc'", "VALUES 1");
        this.assertQuery("SELECT count(*) FROM \"" + tableName + "$files\" WHERE file_path LIKE '%.parquet'", "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUpdatingMaxCommitRetry() {
        try (TestTable table = this.newTrinoTable("test_max_commit_retry", "(x int) WITH (max_commit_retry = 1)");){
            Assertions.assertThat((Object)this.computeScalar("SELECT value FROM \"" + table.getName() + "$properties\" WHERE key = 'commit.retry.num-retries'")).isEqualTo((Object)"1");
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES max_commit_retry = 100");
            Assertions.assertThat((Object)this.computeScalar("SELECT value FROM \"" + table.getName() + "$properties\" WHERE key = 'commit.retry.num-retries'")).isEqualTo((Object)"100");
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES max_commit_retry = 0");
            Assertions.assertThat((Object)this.computeScalar("SELECT value FROM \"" + table.getName() + "$properties\" WHERE key = 'commit.retry.num-retries'")).isEqualTo((Object)"0");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES max_commit_retry = -1", ".* max_commit_retry must be greater than or equal to 0");
            Assertions.assertThat((Object)this.computeScalar("SELECT value FROM \"" + table.getName() + "$properties\" WHERE key = 'commit.retry.num-retries'")).isEqualTo((Object)"0");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES max_commit_retry = NULL", ".* \\QInvalid null value for catalog 'iceberg' table property 'max_commit_retry' from [null]");
            Assertions.assertThat((Object)this.computeScalar("SELECT value FROM \"" + table.getName() + "$properties\" WHERE key = 'commit.retry.num-retries'")).isEqualTo((Object)"0");
        }
    }

    @Test
    public void testUpdatingInvalidTableProperty() {
        String tableName = "test_updating_invalid_table_property_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a INT, b INT)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER TABLE " + tableName + " SET PROPERTIES not_a_valid_table_property = 'a value'"))).failure().hasMessage("line 1:76: Catalog 'iceberg' table property 'not_a_valid_table_property' does not exist");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEmptyCreateTableAsSelect() {
        String tableName = "test_empty_ctas_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation WHERE false", 0L);
        List<Long> initialTableSnapshots = this.getSnapshotIds(tableName);
        ((AbstractIntegerAssert)Assertions.assertThat((int)initialTableSnapshots.size()).withFailMessage("CTAS operations must create Iceberg snapshot independently whether the selection is empty or not", new Object[0])).isEqualTo(1);
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + tableName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEmptyInsert() {
        String tableName = "test_empty_insert_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", "SELECT count(*) FROM nation");
        List<Long> initialTableSnapshots = this.getSnapshotIds(tableName);
        this.assertUpdate("INSERT INTO " + tableName + " SELECT * FROM nation WHERE false", 0L);
        List<Long> updatedTableSnapshots = this.getSnapshotIds(tableName);
        ((ListAssert)((ListAssert)Assertions.assertThat(initialTableSnapshots).withFailMessage("INSERT operations that are not changing the state of the table must not cause the creation of a new Iceberg snapshot", new Object[0])).hasSize(1)).isEqualTo(updatedTableSnapshots);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEmptyUpdate() {
        String tableName = "test_empty_update_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", "SELECT count(*) FROM nation");
        List<Long> initialTableSnapshots = this.getSnapshotIds(tableName);
        this.assertUpdate("UPDATE " + tableName + " SET comment = 'new comment' WHERE nationkey IS NULL", 0L);
        List<Long> updatedTableSnapshots = this.getSnapshotIds(tableName);
        ((ListAssert)((ListAssert)Assertions.assertThat(initialTableSnapshots).withFailMessage("UPDATE operations that are not changing the state of the table must not cause the creation of a new Iceberg snapshot", new Object[0])).hasSize(1)).isEqualTo(updatedTableSnapshots);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEmptyDelete() {
        String tableName = "test_empty_delete_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format = '" + this.format.name() + "') AS SELECT * FROM nation", "SELECT count(*) FROM nation");
        List<Long> initialTableSnapshots = this.getSnapshotIds(tableName);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE nationkey IS NULL", 0L);
        List<Long> updatedTableSnapshots = this.getSnapshotIds(tableName);
        ((ListAssert)((ListAssert)Assertions.assertThat(initialTableSnapshots).withFailMessage("DELETE operations that are not changing the state of the table must not cause the creation of a new Iceberg snapshot", new Object[0])).hasSize(1)).isEqualTo(updatedTableSnapshots);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testEmptyFilesTruncate() {
        try (TestTable table = this.newTrinoTable("test_empty_files_truncate_", "AS SELECT 1 AS id");){
            this.assertUpdate("TRUNCATE TABLE " + table.getName());
            this.assertQueryReturnsEmptyResult("SELECT * FROM \"" + table.getName() + "$files\"");
        }
    }

    @Test
    public void testModifyingOldSnapshotIsNotPossible() {
        String tableName = "test_modifying_old_snapshot_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (col int)", tableName));
        this.assertUpdate(String.format("INSERT INTO %s VALUES 1,2,3", tableName), 3L);
        long oldSnapshotId = this.getCurrentSnapshotId(tableName);
        this.assertUpdate(String.format("INSERT INTO %s VALUES 4,5,6", tableName), 3L);
        this.assertQuery(String.format("SELECT * FROM %s FOR VERSION AS OF %d", tableName, oldSnapshotId), "VALUES 1,2,3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("INSERT INTO \"%s@%d\" VALUES 7,8,9", tableName, oldSnapshotId)))).failure().hasMessage(String.format("line 1:1: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, oldSnapshotId));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("DELETE FROM \"%s@%d\" WHERE col = 5", tableName, oldSnapshotId)))).failure().hasMessage(String.format("line 1:1: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, oldSnapshotId));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("UPDATE \"%s@%d\" SET col = 50 WHERE col = 5", tableName, oldSnapshotId)))).failure().hasMessage(String.format("line 1:1: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, oldSnapshotId));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("INSERT INTO \"%s@%d\" VALUES 7,8,9", tableName, this.getCurrentSnapshotId(tableName))))).failure().hasMessage(String.format("line 1:1: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, this.getCurrentSnapshotId(tableName)));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("DELETE FROM \"%s@%d\" WHERE col = 9", tableName, this.getCurrentSnapshotId(tableName))))).failure().hasMessage(String.format("line 1:1: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, this.getCurrentSnapshotId(tableName)));
        Assertions.assertThatThrownBy(() -> this.assertUpdate(String.format("UPDATE \"%s@%d\" set col = 50 WHERE col = 5", tableName, this.getCurrentSnapshotId(tableName)))).hasMessage(String.format("line 1:1: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, this.getCurrentSnapshotId(tableName)));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("ALTER TABLE \"%s@%d\" EXECUTE OPTIMIZE", tableName, oldSnapshotId)))).failure().hasMessage(String.format("line 1:7: Table 'iceberg.tpch.\"%s@%s\"' does not exist", tableName, oldSnapshotId));
        this.assertQuery(String.format("SELECT * FROM %s", tableName), "VALUES 1,2,3,4,5,6");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectFromVersionedTable() throws Exception {
        String sourceTableName = "test_ctas_versioned_source_" + TestingNames.randomNameSuffix();
        String snapshotVersionedSinkTableName = "test_ctas_snapshot_versioned_sink_" + TestingNames.randomNameSuffix();
        String timestampVersionedSinkTableName = "test_ctas_timestamp_versioned_sink_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTableName + "(an_integer integer)");
        Thread.sleep(1L);
        this.assertUpdate("INSERT INTO " + sourceTableName + " VALUES 1, 2, 3", 3L);
        long afterInsert123SnapshotId = this.getCurrentSnapshotId(sourceTableName);
        long afterInsert123EpochMillis = this.getCommittedAtInEpochMilliseconds(sourceTableName, afterInsert123SnapshotId);
        Thread.sleep(1L);
        this.assertUpdate("INSERT INTO " + sourceTableName + " VALUES 4, 5, 6", 3L);
        long afterInsert456SnapshotId = this.getCurrentSnapshotId(sourceTableName);
        this.assertUpdate("INSERT INTO " + sourceTableName + " VALUES 7, 8, 9", 3L);
        this.assertUpdate("CREATE TABLE " + snapshotVersionedSinkTableName + " AS SELECT * FROM " + sourceTableName + " FOR VERSION AS OF " + afterInsert456SnapshotId, 6L);
        this.assertUpdate("CREATE TABLE " + timestampVersionedSinkTableName + " AS SELECT * FROM " + sourceTableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(afterInsert123EpochMillis, 9), 3L);
        this.assertQuery("SELECT * FROM " + sourceTableName, "VALUES 1, 2, 3, 4, 5, 6, 7, 8, 9");
        this.assertQuery("SELECT * FROM " + snapshotVersionedSinkTableName, "VALUES 1, 2, 3, 4, 5, 6");
        this.assertQuery("SELECT * FROM " + timestampVersionedSinkTableName, "VALUES 1, 2, 3");
        this.assertUpdate("DROP TABLE " + sourceTableName);
        this.assertUpdate("DROP TABLE " + snapshotVersionedSinkTableName);
        this.assertUpdate("DROP TABLE " + timestampVersionedSinkTableName);
    }

    @Test
    public void testSubqueryContainVersionedTable() {
        String tableName = "test_subquery_versioned" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 id", 1L);
        long snapshotId = this.getCurrentSnapshotId(tableName);
        String timestamp = BaseIcebergConnectorTest.timestampLiteral(this.getCommittedAtInEpochMilliseconds(tableName, snapshotId), 9);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
        this.assertQuery("SELECT * FROM " + tableName + " WHERE id = (SELECT id FROM " + tableName + " FOR VERSION AS OF " + snapshotId + ")", "VALUES 1");
        this.assertQuery("SELECT * FROM " + tableName + " WHERE id = (SELECT id FROM " + tableName + " FOR TIMESTAMP AS OF " + timestamp + ")", "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testReadingFromSpecificSnapshot() {
        String tableName = "test_reading_snapshot" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a bigint, b bigint)", tableName));
        this.assertUpdate(String.format("INSERT INTO %s VALUES(1, 1)", tableName), 1L);
        List<Long> ids = this.getSnapshotsIdsByCreationOrder(tableName);
        this.assertQuery(String.format("SELECT count(*) FROM %s FOR VERSION AS OF %d", tableName, ids.get(0)), "VALUES(0)");
        this.assertQuery(String.format("SELECT * FROM %s FOR VERSION AS OF %d", tableName, ids.get(1)), "VALUES(1,1)");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testSelectWithMoreThanOneSnapshotOfTheSameTable() {
        String tableName = "test_reading_snapshot" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a bigint, b bigint)", tableName));
        this.assertUpdate(String.format("INSERT INTO %s VALUES(1, 1)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES(2, 2)", tableName), 1L);
        this.assertUpdate(String.format("INSERT INTO %s VALUES(3, 3)", tableName), 1L);
        List<Long> ids = this.getSnapshotsIdsByCreationOrder(tableName);
        this.assertQuery(String.format("SELECT * FROM %s", tableName), "SELECT * FROM (VALUES(1,1), (2,2), (3,3))");
        this.assertQuery(String.format("SELECT * FROM %1$s EXCEPT (SELECT * FROM %1$s FOR VERSION AS OF %2$d EXCEPT SELECT * FROM %1$s FOR VERSION AS OF %3$d)", tableName, ids.get(2), ids.get(1)), "SELECT * FROM (VALUES(1,1), (3,3))");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testInsertingIntoTablesWithColumnsWithQuotesInName() {
        String tableName = "test_inserting_into_tables_with_quotes_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (\"an identifier with \"\"quotes\"\" \" INTEGER, x row (\"another identifier\" INTEGER))", tableName));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (1, row(11))", tableName), 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s", tableName)))).matches("VALUES (INTEGER '1', CAST(ROW(11) AS ROW(\"another identifier\"INTEGER)))");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsertIntoBucketedColumnTaskWriterCount() {
        int taskWriterCount = 4;
        Assertions.assertThat((int)taskWriterCount).isGreaterThan(this.getQueryRunner().getNodeCount());
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", String.valueOf(taskWriterCount)).setSystemProperty("task_max_writer_count", String.valueOf(taskWriterCount)).build();
        String tableName = "test_inserting_into_bucketed_column_task_writer_count_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (x INT) WITH (partitioning = ARRAY['bucket(x, 7)'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " SELECT nationkey FROM nation", 25L);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT nationkey FROM nation");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testReadFromVersionedTableWithSchemaEvolution() {
        String tableName = "test_versioned_table_schema_evolution_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(col1 varchar)");
        long v1SnapshotId = this.getCurrentSnapshotId(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v1SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR)).isEmpty();
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN  col2 integer");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).isEmpty();
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a', 11)", 1L);
        long v2SnapshotId = this.getCurrentSnapshotId(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).matches("VALUES (VARCHAR 'a', 11)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).matches("VALUES (VARCHAR 'a', 11)");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN  col3 bigint");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).matches("VALUES (VARCHAR 'a', 11)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT)).matches("VALUES (VARCHAR 'a', 11, CAST(NULL AS bigint))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('b', 22, 32)", 1L);
        long v3SnapshotId = this.getCurrentSnapshotId(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v1SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR)).isEmpty();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).matches("VALUES (VARCHAR 'a', 11)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT)).matches("VALUES (VARCHAR 'a', 11, NULL), (VARCHAR 'b', 22, BIGINT '32')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT)).matches("VALUES (VARCHAR 'a', 11, NULL), (VARCHAR 'b', 22, BIGINT '32')");
    }

    @Test
    public void testReadFromVersionedTableWithSchemaEvolutionDropColumn() {
        String tableName = "test_versioned_table_schema_evolution_drop_column_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + "(col1 varchar, col2 integer, col3 boolean)");
        long v1SnapshotId = this.getCurrentSnapshotId(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v1SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)).isEmpty();
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a', 1, true)", 1L);
        long v2SnapshotId = this.getCurrentSnapshotId(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)).matches("VALUES (VARCHAR 'a', 1, true)");
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN  col3");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('b', 2)", 1L);
        long v3SnapshotId = this.getCurrentSnapshotId(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).matches("VALUES (VARCHAR 'a', 1), (VARCHAR 'b', 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).matches("VALUES (VARCHAR 'a', 1), (VARCHAR 'b', 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)).matches("VALUES (VARCHAR 'a', 1, true)");
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN  col2");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('c')", 1L);
        long v4SnapshotId = this.getCurrentSnapshotId(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v4SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR)).matches("VALUES (VARCHAR 'a'), (VARCHAR 'b'), (VARCHAR 'c')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR)).matches("VALUES (VARCHAR 'a'), (VARCHAR 'b'), (VARCHAR 'c')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)).matches("VALUES (VARCHAR 'a', 1), (VARCHAR 'b', 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)).matches("VALUES (VARCHAR 'a', 1, true)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testReadFromVersionedTableWithPartitionSpecEvolution() throws Exception {
        String tableName = "test_version_table_with_partition_spec_evolution_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (day varchar, views bigint) WITH(partitioning = ARRAY['day'])");
        long v1SnapshotId = this.getCurrentSnapshotId(tableName);
        long v1EpochMillis = this.getCommittedAtInEpochMilliseconds(tableName, v1SnapshotId);
        Thread.sleep(1L);
        this.assertUpdate("INSERT INTO " + tableName + " (day, views) VALUES ('2022-06-01', 1)", 1L);
        long v2SnapshotId = this.getCurrentSnapshotId(tableName);
        long v2EpochMillis = this.getCommittedAtInEpochMilliseconds(tableName, v2SnapshotId);
        Thread.sleep(1L);
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN hour varchar");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES partitioning = ARRAY['day', 'hour']");
        this.assertUpdate("INSERT INTO " + tableName + " (day, hour, views) VALUES ('2022-06-02', '10', 2), ('2022-06-02', '10', 3), ('2022-06-02', '11', 10)", 3L);
        long v3SnapshotId = this.getCurrentSnapshotId(tableName);
        long v3EpochMillis = this.getCommittedAtInEpochMilliseconds(tableName, v3SnapshotId);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day  FROM " + tableName + " GROUP BY day"))).matches("VALUES ROW(BIGINT '1', VARCHAR '2022-06-01'), ROW(BIGINT '15', VARCHAR '2022-06-02')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day  FROM " + tableName + " FOR VERSION AS OF " + v1SnapshotId + " GROUP BY day"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day  FROM " + tableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(v1EpochMillis, 9) + " GROUP BY day"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day  FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId + " GROUP BY day"))).matches("VALUES ROW(BIGINT '1', VARCHAR '2022-06-01')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day  FROM " + tableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(v2EpochMillis, 9) + " GROUP BY day"))).matches("VALUES ROW(BIGINT '1', VARCHAR '2022-06-01')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day  FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId + " GROUP BY day"))).matches("VALUES ROW(BIGINT '1', VARCHAR '2022-06-01'), ROW(BIGINT '15', VARCHAR '2022-06-02')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day  FROM " + tableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(v3EpochMillis, 9) + " GROUP BY day"))).matches("VALUES ROW(BIGINT '1', VARCHAR '2022-06-01'), ROW(BIGINT '15', VARCHAR '2022-06-02')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day, hour  FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId + " WHERE day = '2022-06-02' GROUP BY day, hour"))).matches("VALUES ROW(BIGINT '5', VARCHAR '2022-06-02', VARCHAR '10'), ROW(BIGINT '10', VARCHAR '2022-06-02', VARCHAR '11')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(views), day, hour  FROM " + tableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(v3EpochMillis, 9) + " WHERE day = '2022-06-02' GROUP BY day, hour"))).matches("VALUES ROW(BIGINT '5', VARCHAR '2022-06-02', VARCHAR '10'), ROW(BIGINT '10', VARCHAR '2022-06-02', VARCHAR '11')");
    }

    @Test
    public void testReadFromVersionedTableWithExpiredHistory() throws Exception {
        String tableName = "test_version_table_with_expired_snapshots_" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer)");
        long v1SnapshotId = this.getCurrentSnapshotId(tableName);
        long v1EpochMillis = this.getCommittedAtInEpochMilliseconds(tableName, v1SnapshotId);
        Thread.sleep(1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        long v2SnapshotId = this.getCurrentSnapshotId(tableName);
        long v2EpochMillis = this.getCommittedAtInEpochMilliseconds(tableName, v2SnapshotId);
        Thread.sleep(1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        long v3SnapshotId = this.getCurrentSnapshotId(tableName);
        long v3EpochMillis = this.getCommittedAtInEpochMilliseconds(tableName, v3SnapshotId);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(value), listagg(key, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName))).matches("VALUES (BIGINT '3', VARCHAR 'one two')");
        List<Long> initialSnapshots = this.getSnapshotIds(tableName);
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        List<Long> updatedSnapshots = this.getSnapshotIds(tableName);
        Assertions.assertThat((int)updatedSnapshots.size()).isLessThan(initialSnapshots.size());
        Assertions.assertThat(updatedSnapshots).hasSize(1);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(value), listagg(key, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId))).matches("VALUES (BIGINT '3', VARCHAR 'one two')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(value), listagg(key, ' ') WITHIN GROUP (ORDER BY key) FROM " + tableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(v3EpochMillis, 9)))).matches("VALUES (BIGINT '3', VARCHAR 'one two')");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId, "Iceberg snapshot ID does not exists\\: " + v2SnapshotId);
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(v2EpochMillis, 9), "No version history table .* at or before .*");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v1SnapshotId, "Iceberg snapshot ID does not exists\\: " + v1SnapshotId);
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF " + BaseIcebergConnectorTest.timestampLiteral(v1EpochMillis, 9), "No version history table .* at or before .*");
    }

    @Test
    public void testDeleteRetainsTableHistory() {
        String tableName = "test_delete_retains_table_history_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(c1 INT, c2 INT)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1), (2, 2), (3, 3)", 3L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, 3), (4, 4), (5, 5)", 3L);
        List<Long> snapshots = this.getTableHistory(tableName);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE c1 < 4", 4L);
        List<Long> snapshotsAfterDelete = this.getTableHistory(tableName);
        Assertions.assertThat((int)snapshotsAfterDelete.size()).isGreaterThan(snapshots.size());
        Assertions.assertThat(snapshotsAfterDelete).containsAll(snapshots);
    }

    @Test
    public void testDeleteRetainsMetadataFile() {
        String tableName = "test_delete_retains_metadata_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(c1 INT, c2 INT)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1), (2, 2), (3, 3)", 3L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, 3), (4, 4), (5, 5)", 3L);
        List<Long> metadataLogEntries = this.getLatestSequenceNumbersInMetadataLogEntries(tableName);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE c1 < 4", 4L);
        List<Long> metadataLogEntriesAfterDelete = this.getLatestSequenceNumbersInMetadataLogEntries(tableName);
        ((ListAssert)Assertions.assertThat(metadataLogEntriesAfterDelete).hasSizeGreaterThan(metadataLogEntries.size())).containsAll(metadataLogEntries);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateOrReplaceTableSnapshots() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b");){
            long v1SnapshotId = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT BIGINT '-42' a, DOUBLE '38.5' b", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(a AS bigint), b FROM " + table.getName()))).matches("VALUES (BIGINT '-42', 385e-1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, b  FROM " + table.getName() + " FOR VERSION AS OF " + v1SnapshotId))).matches("VALUES (BIGINT '42', -385e-1)");
        }
    }

    @Test
    public void testCreateOrReplaceTableChangeColumnNamesAndTypes() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b");){
            long v1SnapshotId = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT CAST(ARRAY[ROW('test')] AS ARRAY(ROW(field VARCHAR))) a, VARCHAR 'test2' b", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (CAST(ARRAY[ROW('test')] AS ARRAY(ROW(field VARCHAR))), VARCHAR 'test2')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR VERSION AS OF " + v1SnapshotId))).matches("VALUES (BIGINT '42', -385e-1)");
        }
    }

    @Test
    public void testCreateOrReplaceTableChangePartitionedTableIntoUnpartitioned() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", " WITH (partitioning=ARRAY['a']) AS SELECT BIGINT '42' a, 'some data' b UNION ALL SELECT BIGINT '43' a, 'another data' b");){
            long v1SnapshotId = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (sorted_by=ARRAY['a']) AS SELECT BIGINT '22' a, 'new data' b", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (BIGINT '22', CAST('new data' AS VARCHAR))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM \"" + table.getName() + "$partitions\""))).matches("VALUES (ROW(CAST (ROW(NULL) AS ROW(a BIGINT))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR VERSION AS OF " + v1SnapshotId))).matches("VALUES (BIGINT '42', CAST('some data' AS VARCHAR)), (BIGINT '43', CAST('another data' AS VARCHAR))");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"sorted_by = ARRAY['a ASC NULLS FIRST']"});
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).doesNotContain(new CharSequence[]{"partitioning = ARRAY['a']"});
        }
    }

    @Test
    public void testCreateOrReplaceTableChangeUnpartitionedTableIntoPartitioned() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", " WITH (sorted_by=ARRAY['a']) AS SELECT BIGINT '22' a, CAST('some data' AS VARCHAR) b");){
            long v1SnapshotId = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (partitioning=ARRAY['a']) AS SELECT BIGINT '42' a, 'some data' b UNION ALL SELECT BIGINT '43' a, 'another data' b", 2L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (BIGINT '42', CAST('some data' AS VARCHAR)), (BIGINT '43', CAST('another data' AS VARCHAR))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM \"" + table.getName() + "$partitions\""))).matches("VALUES (ROW(CAST (ROW(BIGINT '42') AS ROW(a BIGINT)))), (ROW(CAST (ROW(BIGINT '43') AS ROW(a BIGINT))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR VERSION AS OF " + v1SnapshotId))).matches("VALUES (BIGINT '22', CAST('some data' AS VARCHAR))");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"partitioning = ARRAY['a']"});
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).doesNotContain(new CharSequence[]{"sorted_by = ARRAY['a ASC NULLS FIRST']"});
        }
    }

    @Test
    public void testCreateOrReplaceTableWithComments() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", " (a BIGINT COMMENT 'This is a column') COMMENT 'This is a table'");){
            long v1SnapshotId = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT 1 a", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 1");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR VERSION AS OF " + v1SnapshotId))).returnsEmptyResult();
            Assertions.assertThat((String)this.getTableComment(table.getName())).isNull();
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isNull();
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (a BIGINT COMMENT 'This is a column') COMMENT 'This is a table'");
            Assertions.assertThat((String)this.getTableComment(table.getName())).isEqualTo("This is a table");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("This is a column");
        }
    }

    @Test
    public void testCreateOrReplaceTableWithSameLocation() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_same_location_", "(a integer)");){
            String initialTableLocation = this.getTableLocation(table.getName());
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 1");
            long v1SnapshotId = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (a integer)");
            Assertions.assertThat((String)this.getTableLocation(table.getName())).isEqualTo(initialTableLocation);
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (a integer) WITH (location = '" + initialTableLocation + "')");
            Object initialTableLocationWithTrailingSlash = initialTableLocation.endsWith("/") ? initialTableLocation : initialTableLocation + "/";
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (a integer) WITH (location = '" + (String)initialTableLocationWithTrailingSlash + "')");
            Assertions.assertThat((String)this.getTableLocation(table.getName())).isEqualTo(initialTableLocation);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).returnsEmptyResult();
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (location = '" + initialTableLocation + "') AS SELECT 2 as a", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 2");
            Assertions.assertThat((String)this.getTableLocation(table.getName())).isEqualTo(initialTableLocation);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *  FROM " + table.getName() + " FOR VERSION AS OF " + v1SnapshotId))).matches("VALUES 1");
        }
    }

    @Test
    public void testCreateOrReplaceTableWithChangeInLocation() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_change_location_", "(a integer) ");){
            String initialTableLocation = this.getTableLocation(table.getName()) + TestingNames.randomNameSuffix();
            long v1SnapshotId = this.getCurrentSnapshotId(table.getName());
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " (a integer) WITH (location = '%s')".formatted(initialTableLocation), "The provided location '%s' does not match the existing table location '.*'".formatted(initialTableLocation));
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " WITH (location = '%s') AS SELECT 1 AS a".formatted(initialTableLocation), "The provided location '%s' does not match the existing table location '.*'".formatted(initialTableLocation));
            Assertions.assertThat((long)this.getCurrentSnapshotId(table.getName())).isEqualTo(v1SnapshotId);
        }
    }

    @Test
    public void testMergeSimpleSelectPartitioned() {
        String targetTable = "merge_simple_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_simple_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['address'])", targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
        this.assertUpdate(sql, 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Ed', 7, 'Etherville'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeUpdateWithVariousLayouts() {
        this.testMergeUpdateWithVariousLayouts(1, "");
        this.testMergeUpdateWithVariousLayouts(4, "");
        this.testMergeUpdateWithVariousLayouts(1, "WITH (partitioning = ARRAY['customer'])");
        this.testMergeUpdateWithVariousLayouts(4, "WITH (partitioning = ARRAY['customer'])");
        this.testMergeUpdateWithVariousLayouts(1, "WITH (partitioning = ARRAY['purchase'])");
        this.testMergeUpdateWithVariousLayouts(4, "WITH (partitioning = ARRAY['purchase'])");
        this.testMergeUpdateWithVariousLayouts(1, "WITH (partitioning = ARRAY['bucket(customer, 3)'])");
        this.testMergeUpdateWithVariousLayouts(4, "WITH (partitioning = ARRAY['bucket(customer, 3)'])");
        this.testMergeUpdateWithVariousLayouts(1, "WITH (partitioning = ARRAY['bucket(purchase, 4)'])");
        this.testMergeUpdateWithVariousLayouts(4, "WITH (partitioning = ARRAY['bucket(purchase, 4)'])");
    }

    private void testMergeUpdateWithVariousLayouts(int writers, String partitioning) {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", String.valueOf(writers)).build();
        String targetTable = "merge_formats_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_formats_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR) %s", targetTable, partitioning));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')", targetTable), 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')");
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR)", sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Craig', 'candles'), ('Len', 'limes'), ('Joe', 'jellybeans')", sourceTable), 3L);
        String sql = String.format("MERGE INTO %s t USING %s s ON (t.purchase = s.purchase)", targetTable, sourceTable) + "    WHEN MATCHED AND s.purchase = 'limes' THEN DELETE    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_', s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchase) VALUES(s.customer, s.purchase)";
        this.assertUpdate(session, sql, 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave', 'dates'), ('Carol_Craig', 'candles'), ('Joe', 'jellybeans')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleOperations() {
        this.testMergeMultipleOperations(1, "", false);
        this.testMergeMultipleOperations(4, "", false);
        this.testMergeMultipleOperations(1, "WITH (partitioning = ARRAY['customer'])", false);
        this.testMergeMultipleOperations(4, "WITH (partitioning = ARRAY['customer'])", false);
        this.testMergeMultipleOperations(1, "WITH (partitioning = ARRAY['purchase'])", false);
        this.testMergeMultipleOperations(4, "WITH (partitioning = ARRAY['purchase'])", false);
        this.testMergeMultipleOperations(1, "WITH (partitioning = ARRAY['bucket(customer, 3)'])", false);
        this.testMergeMultipleOperations(4, "WITH (partitioning = ARRAY['bucket(customer, 3)'])", false);
        this.testMergeMultipleOperations(1, "WITH (partitioning = ARRAY['bucket(purchase, 4)'])", false);
        this.testMergeMultipleOperations(4, "WITH (partitioning = ARRAY['bucket(purchase, 4)'])", false);
        this.testMergeMultipleOperations(1, "", true);
        this.testMergeMultipleOperations(4, "WITH (partitioning = ARRAY['customer'])", true);
        this.testMergeMultipleOperations(1, "WITH (partitioning = ARRAY['bucket(customer, 3)'])", true);
        this.testMergeMultipleOperations(4, "WITH (partitioning = ARRAY['bucket(purchase, 4)'])", true);
    }

    private void testMergeMultipleOperations(int writers, String partitioning, boolean determinePartitionCountForWrite) {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", String.valueOf(writers)).setSystemProperty("task_max_writer_count", String.valueOf(writers)).setSystemProperty("determine_partition_count_for_write_enabled", Boolean.toString(determinePartitionCountForWrite)).build();
        int targetCustomerCount = 32;
        String targetTable = "merge_multiple_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (purchase INT, zipcode INT, spouse VARCHAR, address VARCHAR, customer VARCHAR) %s", targetTable, partitioning));
        String originalInsertFirstHalf = IntStream.range(1, targetCustomerCount / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 1000, 91000, intValue, intValue)).collect(Collectors.joining(", "));
        String originalInsertSecondHalf = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 2000, 92000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase, zipcode, spouse, address) VALUES %s, %s", targetTable, originalInsertFirstHalf, originalInsertSecondHalf), targetCustomerCount - 1);
        String firstMergeSource = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 83000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(session, String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchase, zipcode, spouse, address)", targetTable, firstMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED THEN UPDATE SET purchase = s.purchase, zipcode = s.zipcode, spouse = s.spouse, address = s.address", targetCustomerCount / 2);
        this.assertQuery("SELECT customer, purchase, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s", originalInsertFirstHalf, firstMergeSource));
        String nextInsert = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase, zipcode, spouse, address) VALUES %s", targetTable, nextInsert), targetCustomerCount / 2);
        String secondMergeSource = IntStream.range(1, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(session, String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchase, zipcode, spouse, address)", targetTable, secondMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED AND t.zipcode = 91000 THEN DELETE    WHEN MATCHED AND s.zipcode = 85000 THEN UPDATE SET zipcode = 60000    WHEN MATCHED THEN UPDATE SET zipcode = s.zipcode, spouse = s.spouse, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchase, zipcode, spouse, address) VALUES(s.customer, s.purchase, s.zipcode, s.spouse, s.address)", targetCustomerCount * 3 / 2 - 1);
        String updatedBeginning = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 60000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedMiddle = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedEnd = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT customer, purchase, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s, %s", updatedBeginning, updatedMiddle, updatedEnd));
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeSimpleQueryPartitioned() {
        String targetTable = "merge_simple_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['address'])", targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        String query = String.format("MERGE INTO %s t USING ", targetTable) + "(SELECT * FROM (VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville'))) AS s(customer, purchases, address)    ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
        this.assertUpdate(query, 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleRowsMatchFails() {
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['bucket(customer, 3)'])");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['customer'])");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (customer VARCHAR, address VARCHAR, purchases INT) WITH (partitioning = ARRAY['address'])");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (purchases INT, customer VARCHAR, address VARCHAR) WITH (partitioning = ARRAY['address', 'customer'])");
    }

    private void testMergeMultipleRowsMatchFails(String createTableSql) {
        String targetTable = "merge_multiple_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_multiple_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format(createTableSql, targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Antioch')", targetTable), 2L);
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Adelphi'), ('Aaron', 8, 'Ashland')", sourceTable), 2L);
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET address = s.address")).hasMessage("One MERGE target table row matched more than one source row");
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Adelphi' THEN UPDATE SET address = s.address", 1L);
        this.assertQuery("SELECT customer, purchases, address FROM " + targetTable, "VALUES ('Aaron', 5, 'Adelphi'), ('Bill', 7, 'Antioch')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithDifferentPartitioning() {
        this.testMergeWithDifferentPartitioning("target_partitioned_source_and_target_partitioned_and_bucketed", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['address', 'bucket(customer, 3)'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['address', 'bucket(customer, 3)'])");
        this.testMergeWithDifferentPartitioning("target_flat_source_partitioned_by_customer", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", "CREATE TABLE %s (purchases INT, address VARCHAR, customer VARCHAR) WITH (partitioning = ARRAY['customer'])");
        this.testMergeWithDifferentPartitioning("target_partitioned_by_customer_source_flat", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['customer'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)");
        this.testMergeWithDifferentPartitioning("target_bucketed_by_customer_source_flat", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['bucket(customer, 3)'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)");
        this.testMergeWithDifferentPartitioning("target_partitioned_source_partitioned_and_bucketed", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['customer'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['address', 'bucket(customer, 3)'])");
        this.testMergeWithDifferentPartitioning("target_partitioned_target_partitioned_and_bucketed", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['address', 'bucket(customer, 3)'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (partitioning = ARRAY['customer'])");
    }

    private void testMergeWithDifferentPartitioning(String testDescription, String createTargetTableSql, String createSourceTableSql) {
        String targetTable = String.format("%s_target_%s", testDescription, TestingNames.randomNameSuffix());
        String sourceTable = String.format("%s_source_%s", testDescription, TestingNames.randomNameSuffix());
        this.assertUpdate(String.format(createTargetTableSql, targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format(createSourceTableSql, sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
        this.assertUpdate(sql, 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    protected OptionalInt maxSchemaNameLength() {
        return OptionalInt.of(128);
    }

    protected void verifySchemaNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Schema name must be shorter than or equal to '128' characters but got '129'");
    }

    @Test
    public void testSnapshotSummariesHaveTrinoQueryIdFormatV1() {
        String tableName = "test_snapshot_query_ids_v1" + TestingNames.randomNameSuffix();
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("CREATE TABLE %s (a bigint, b bigint) WITH (format_version = 1, partitioning = ARRAY['a'])", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("INSERT INTO %s VALUES (1, 100), (2, 300), (2, 350), (3, 250)", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("DELETE FROM %s WHERE a = 2", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("INSERT INTO %s VALUES (1, 400)", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("ALTER TABLE %s EXECUTE OPTIMIZE", tableName)));
    }

    @Test
    public void testSnapshotSummariesHaveTrinoQueryIdFormatV2() {
        String tableName = "test_snapshot_query_ids_v2" + TestingNames.randomNameSuffix();
        String sourceTableName = "test_source_table_for_ctas" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a bigint, b bigint)", sourceTableName));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (1, 1), (1, 4), (1, 20), (2, 2)", sourceTableName), 4L);
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("CREATE TABLE %s WITH (format_version = 2, partitioning = ARRAY['a']) AS SELECT * FROM %s", tableName, sourceTableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("INSERT INTO %s VALUES (1, 100), (2, 300), (3, 250)", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("DELETE FROM %s WHERE a = 2", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("DELETE FROM %s WHERE a = 1 AND b = 4", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("UPDATE %s SET b = 900 WHERE a = 1 AND b = 1", tableName)));
        this.assertQueryIdAndUserStored(tableName, this.executeWithQueryId(String.format("MERGE INTO %s t USING %s s ON t.a = s.a AND t.b = s.b WHEN MATCHED THEN UPDATE SET b = t.b * 50", tableName, sourceTableName)));
    }

    protected OptionalInt maxTableNameLength() {
        return OptionalInt.of(128);
    }

    protected OptionalInt maxTableRenameLength() {
        return OptionalInt.of(128);
    }

    @Test
    public void testSetPartitionedColumnType() {
        try (TestTable table = this.newTrinoTable("test_set_partitioned_column_type_", "WITH (partitioning = ARRAY['part']) AS SELECT 1 AS id, CAST(123 AS integer) AS part");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN part SET DATA TYPE bigint");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT part FROM " + table.getName()))).matches("VALUES bigint '123'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT id FROM " + table.getName() + " WHERE part = 123"))).isFullyPushedDown();
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"partitioning = ARRAY['part']"});
        }
    }

    @Test
    public void testSetTransformPartitionedColumnType() {
        try (TestTable table = this.newTrinoTable("test_set_partitioned_column_type_", "WITH (partitioning = ARRAY['bucket(part, 10)']) AS SELECT CAST(123 AS integer) AS part");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN part SET DATA TYPE bigint");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES bigint '123'");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"partitioning = ARRAY['bucket(part, 10)']"});
        }
    }

    @Test
    public void testAlterTableWithUnsupportedProperties() {
        String tableName = "test_alter_table_with_unsupported_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint)");
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES location = '/var/data/table/', orc_bloom_filter_fpp = 0.5", "The following properties cannot be updated: location, orc_bloom_filter_fpp");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropTableWithMissingMetadataFile() throws Exception {
        String tableName = "test_drop_table_with_missing_metadata_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        String tableLocation = this.getTableLocation(tableName);
        Location metadataLocation = Location.of((String)IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)tableLocation));
        this.fileSystem.deleteFile(metadataLocation);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(metadataLocation).exists()).describedAs("Current metadata file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(Location.of((String)tableLocation)).hasNext()).describedAs("Table location should not exist", new Object[0])).isFalse();
    }

    @Test
    public void testDropTableWithMissingSnapshotFile() throws Exception {
        String tableName = "test_drop_table_with_missing_snapshot_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String metadataLocation = IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)tableLocation);
        TableMetadata tableMetadata = TableMetadataParser.read((FileIO)new ForwardingFileIo(this.fileSystem), (String)metadataLocation);
        Location currentSnapshotFile = Location.of((String)tableMetadata.currentSnapshot().manifestListLocation());
        this.fileSystem.deleteFile(currentSnapshotFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(currentSnapshotFile).exists()).describedAs("Current snapshot file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(Location.of((String)tableLocation)).hasNext()).describedAs("Table location should not exist", new Object[0])).isFalse();
    }

    @Test
    public void testDropTableWithMissingManifestListFile() throws Exception {
        String tableName = "test_drop_table_with_missing_manifest_list_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String metadataLocation = IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)tableLocation);
        ForwardingFileIo fileIo = new ForwardingFileIo(this.fileSystem);
        TableMetadata tableMetadata = TableMetadataParser.read((FileIO)fileIo, (String)metadataLocation);
        Location manifestListFile = Location.of((String)((ManifestFile)tableMetadata.currentSnapshot().allManifests((FileIO)fileIo).get(0)).path());
        this.fileSystem.deleteFile(manifestListFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(manifestListFile).exists()).describedAs("Manifest list file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(Location.of((String)tableLocation)).hasNext()).describedAs("Table location should not exist", new Object[0])).isFalse();
    }

    @Test
    public void testDropTableWithMissingDataFile() throws Exception {
        String tableName = "test_drop_table_with_missing_data_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 'POLAND')", 1L);
        Location tableLocation = Location.of((String)this.getTableLocation(tableName));
        Location tableDataPath = tableLocation.appendPath("data");
        FileIterator fileIterator = this.fileSystem.listFiles(tableDataPath);
        Assertions.assertThat((boolean)fileIterator.hasNext()).isTrue();
        Location dataFile = fileIterator.next().location();
        this.fileSystem.deleteFile(dataFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFile).exists()).describedAs("Data file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should not exist", new Object[0])).isFalse();
    }

    @Test
    public void testDropTableWithNonExistentTableLocation() throws Exception {
        String tableName = "test_drop_table_with_non_existent_table_location_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 'POLAND')", 1L);
        Location tableLocation = Location.of((String)this.getTableLocation(tableName));
        this.fileSystem.deleteDirectory(tableLocation);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
    }

    @Test
    public void testCorruptedTableLocation() throws Exception {
        String tableName = "test_corrupted_table_location_" + TestingNames.randomNameSuffix();
        SchemaTableName schemaTableName = SchemaTableName.schemaTableName((String)((String)this.getSession().getSchema().orElseThrow()), (String)tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, country VARCHAR, independence ROW(month VARCHAR, year INT))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'INDIA', ROW ('Aug', 1947)), (2, 'POLAND', ROW ('Nov', 1918)), (3, 'USA', ROW ('Jul', 1776))", 3L);
        Location tableLocation = Location.of((String)this.getTableLocation(tableName));
        Location metadataLocation = tableLocation.appendPath("metadata");
        this.fileSystem.deleteDirectory(metadataLocation);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(metadataLocation).hasNext()).describedAs("Metadata location should not exist", new Object[0])).isFalse();
        this.assertQueryFails("TABLE " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("SELECT * FROM " + tableName + " WHERE false", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("SELECT 1 FROM " + tableName + " WHERE false", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("SHOW CREATE TABLE " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("CREATE TABLE a_new_table (LIKE " + tableName + " EXCLUDING PROPERTIES)", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("CREATE OR REPLACE TABLE " + tableName + " (id INT, country VARCHAR, independence ROW(month VARCHAR, year INT))", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("CREATE OR REPLACE TABLE " + tableName + " AS SELECT 1 x, 'IRELAND' y", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("DESCRIBE " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("SHOW COLUMNS FROM " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("SHOW STATS FOR " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ANALYZE " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE optimize", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE vacuum", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " RENAME TO bad_person_some_new_name", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " ADD COLUMN foo int", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " ADD COLUMN independence.month int", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN country", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN independence.month", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES format = 'PARQUET'", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("INSERT INTO " + tableName + " VALUES (NULL, NULL, ROW(NULL, NULL))", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("UPDATE " + tableName + " SET country = 'AUSTRIA'", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("DELETE FROM " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("MERGE INTO  " + tableName + " USING (SELECT 1 a) input ON true WHEN MATCHED THEN DELETE", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("TRUNCATE TABLE " + tableName, "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("COMMENT ON TABLE " + tableName + " IS NULL", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("COMMENT ON COLUMN " + tableName + ".foo IS NULL", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE rollback_to_snapshot(8954597067493422955)", "Metadata not found in metadata location for table " + String.valueOf(schemaTableName));
        this.assertQuery("SHOW TABLES LIKE 'test_corrupted_table_location_%' ESCAPE '\\'", "VALUES '" + tableName + "'");
        this.assertQueryReturnsEmptyResult("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name LIKE 'test_corrupted_table_location_%' ESCAPE '\\'");
        this.assertQueryReturnsEmptyResult("SELECT column_name, data_type FROM system.jdbc.columns WHERE table_cat = CURRENT_CATALOG AND table_schem = CURRENT_SCHEMA AND table_name LIKE 'test_corrupted_table_location_%' ESCAPE '\\'");
        this.assertQuerySucceeds("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should not exist", new Object[0])).isFalse();
    }

    @Test
    public void testDropCorruptedTableWithHiveRedirection() throws Exception {
        String hiveRedirectionCatalog = "hive_with_redirections";
        String icebergCatalog = "iceberg_test";
        String schema = "default";
        String tableName = "test_drop_corrupted_table_with_hive_redirection_" + TestingNames.randomNameSuffix();
        String hiveTableName = "%s.%s.%s".formatted(hiveRedirectionCatalog, schema, tableName);
        String icebergTableName = "%s.%s.%s".formatted(icebergCatalog, schema, tableName);
        File dataDirectory = Files.createTempDirectory("test_corrupted_iceberg_table", new FileAttribute[0]).toFile();
        dataDirectory.deleteOnExit();
        Session icebergSession = TestingSession.testSessionBuilder().setCatalog(icebergCatalog).setSchema(schema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)icebergSession).build();
        queryRunner.installPlugin((Plugin)new IcebergPlugin());
        queryRunner.createCatalog(icebergCatalog, "iceberg", (Map)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)"TESTING_FILE_METASTORE", (Object)"hive.metastore.catalog.dir", (Object)dataDirectory.getPath(), (Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(dataDirectory.toPath()));
        queryRunner.createCatalog(hiveRedirectionCatalog, "hive", (Map)ImmutableMap.of((Object)"hive.iceberg-catalog-name", (Object)icebergCatalog));
        queryRunner.execute("CREATE SCHEMA " + schema);
        queryRunner.execute("CREATE TABLE " + icebergTableName + " (id INT, country VARCHAR, independence ROW(month VARCHAR, year INT))");
        queryRunner.execute("INSERT INTO " + icebergTableName + " VALUES (1, 'INDIA', ROW ('Aug', 1947)), (2, 'POLAND', ROW ('Nov', 1918)), (3, 'USA', ROW ('Jul', 1776))");
        Assertions.assertThat((Iterable)queryRunner.execute("TABLE " + hiveTableName)).containsAll((Iterable)queryRunner.execute("TABLE " + icebergTableName));
        Location tableLocation = Location.of((String)((String)queryRunner.execute("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*/[^/]*$', '') FROM " + tableName).getOnlyValue()));
        Location metadataLocation = tableLocation.appendPath("metadata");
        this.fileSystem.deleteDirectory(metadataLocation);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(metadataLocation).hasNext()).describedAs("Metadata location should not exist", new Object[0])).isFalse();
        queryRunner.execute("DROP TABLE " + hiveTableName);
        Assertions.assertThat((boolean)queryRunner.tableExists(this.getSession(), icebergTableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should not exist", new Object[0])).isFalse();
    }

    @Test
    @Timeout(value=10L)
    public void testNoRetryWhenMetadataFileInvalid() throws Exception {
        String tableName = "test_no_retry_when_metadata_file_invalid_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 id", 1L);
        String tableLocation = this.getTableLocation(tableName);
        String metadataFileLocation = IcebergUtil.getLatestMetadataLocation((TrinoFileSystem)this.fileSystem, (String)tableLocation);
        ObjectMapper mapper = JsonUtil.mapper();
        JsonNode jsonNode = (JsonNode)mapper.readValue((InputStream)this.fileSystem.newInputFile(Location.of((String)metadataFileLocation)).newStream(), JsonNode.class);
        ArrayNode fieldsNode = (ArrayNode)jsonNode.get("schemas").get(0).get("fields");
        ObjectNode newFieldNode = (ObjectNode)fieldsNode.get(0).deepCopy();
        fieldsNode.add((JsonNode)newFieldNode);
        byte[] modifiedJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)jsonNode);
        this.fileSystem.newOutputFile(Location.of((String)metadataFileLocation)).createOrOverwrite(modifiedJson);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).failure().hasMessage("Invalid metadata file for table tpch.%s".formatted(tableName));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTableChangesFunctionAfterSchemaChange() {
        try (TestTable table = this.newTrinoTable("test_table_changes_function_", "AS SELECT nationkey, name FROM tpch.tiny.nation WITH NO DATA");){
            long initialSnapshot = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT nationkey, name FROM nation WHERE nationkey < 5", 5L);
            long snapshotAfterInsert = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN name");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT nationkey FROM nation WHERE nationkey >= 5 AND nationkey < 10", 5L);
            long snapshotAfterDropColumn = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN comment VARCHAR");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT nationkey, comment FROM nation WHERE nationkey >= 10 AND nationkey < 15", 5L);
            long snapshotAfterAddColumn = this.getCurrentSnapshotId(table.getName());
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN name VARCHAR");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT nationkey, comment, name FROM nation WHERE nationkey >= 15", 10L);
            long snapshotAfterReaddingNameColumn = this.getCurrentSnapshotId(table.getName());
            this.assertQuery("SELECT nationkey, name, _change_type, _change_version_id, _change_ordinal " + "FROM TABLE(system.table_changes(CURRENT_SCHEMA, '%s', %s, %s))".formatted(table.getName(), initialSnapshot, snapshotAfterInsert), "SELECT nationkey, name, 'insert', %s, 0 FROM nation WHERE nationkey < 5".formatted(snapshotAfterInsert));
            this.assertQuery("SELECT nationkey, _change_type, _change_version_id, _change_ordinal " + "FROM TABLE(system.table_changes(CURRENT_SCHEMA, '%s', %s, %s))".formatted(table.getName(), initialSnapshot, snapshotAfterDropColumn), "SELECT nationkey, 'insert', %s, 0 FROM nation WHERE nationkey < 5 UNION SELECT nationkey, 'insert', %s, 1 FROM nation WHERE nationkey >= 5 AND nationkey < 10 ".formatted(snapshotAfterInsert, snapshotAfterDropColumn));
            this.assertQuery("SELECT nationkey, comment, _change_type, _change_version_id, _change_ordinal " + "FROM TABLE(system.table_changes(CURRENT_SCHEMA, '%s', %s, %s))".formatted(table.getName(), initialSnapshot, snapshotAfterAddColumn), "SELECT nationkey, NULL, 'insert', %s, 0 FROM nation WHERE nationkey < 5 UNION SELECT nationkey, NULL, 'insert', %s, 1 FROM nation WHERE nationkey >= 5 AND nationkey < 10 UNION SELECT nationkey, comment, 'insert', %s, 2 FROM nation WHERE nationkey >= 10 AND nationkey < 15".formatted(snapshotAfterInsert, snapshotAfterDropColumn, snapshotAfterAddColumn));
            this.assertQuery("SELECT nationkey, comment, name, _change_type, _change_version_id, _change_ordinal " + "FROM TABLE(system.table_changes(CURRENT_SCHEMA, '%s', %s, %s))".formatted(table.getName(), initialSnapshot, snapshotAfterReaddingNameColumn), "SELECT nationkey, NULL, NULL, 'insert', %s, 0 FROM nation WHERE nationkey < 5 UNION SELECT nationkey, NULL, NULL, 'insert', %s, 1 FROM nation WHERE nationkey >= 5 AND nationkey < 10 UNION SELECT nationkey, comment, NULL, 'insert', %s, 2 FROM nation WHERE nationkey >= 10 AND nationkey < 15UNION SELECT nationkey, comment, name, 'insert', %s, 3 FROM nation WHERE nationkey >= 15".formatted(snapshotAfterInsert, snapshotAfterDropColumn, snapshotAfterAddColumn, snapshotAfterReaddingNameColumn));
        }
    }

    @Test
    public void testTableChangesFunctionInvalidArguments() {
        this.assertQueryFails("SELECT * FROM TABLE(system.table_changes(start_snapshot_id => 1, end_snapshot_id => 2))", ".*: Missing argument: SCHEMA_NAME");
        this.assertQueryFails("SELECT * FROM TABLE(system.table_changes(schema_name => 'tpch', start_snapshot_id => 1, end_snapshot_id => 2))", ".* Missing argument: TABLE_NAME");
    }

    @Test
    public void testIdentityPartitionFilterMissing() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertQueryFails(session, "SELECT id FROM " + tableName + " WHERE ds IS NOT null OR true", "Filter required for tpch\\." + tableName + " on at least one of the partition columns: ds");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testBucketPartitionFilterMissing() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['bucket(ds, 16)'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertQueryFails(session, "SELECT id FROM " + tableName + " WHERE ds IS NOT null OR true", "Filter required for tpch\\." + tableName + " on at least one of the partition columns: ds");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testIdentityPartitionFilterIncluded() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        String query = "SELECT id FROM " + tableName + " WHERE ds = 'a'";
        this.assertQuery(session, query, "VALUES 1");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBucketedSelect() {
        try {
            this.assertUpdate("CREATE TABLE test_bucketed_select WITH (partitioning = ARRAY['bucket(key1, 13)', 'bucket(key2, 17)']) AS SELECT orderkey key1, custkey key2, comment value1 FROM orders", 15000L);
            Session planWithTableNodePartitioning = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "bucket_execution_enabled", "true").build();
            Session planWithoutTableNodePartitioning = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "bucket_execution_enabled", "false").build();
            String query = "SELECT value1 FROM test_bucketed_select WHERE key1 < 10";
            String expectedQuery = "SELECT comment FROM orders WHERE orderkey < 10";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertNoReadPartitioning("key1", "key2"));
            query = "SELECT count(value1) FROM test_bucketed_select GROUP BY key1";
            expectedQuery = "SELECT count(comment) FROM orders GROUP BY orderkey";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(0));
            this.assertQuery(planWithoutTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(1));
            query = "SELECT count(value1) FROM test_bucketed_select GROUP BY key2";
            expectedQuery = "SELECT count(comment) FROM orders GROUP BY custkey";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(0));
            this.assertQuery(planWithoutTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(1));
            query = "SELECT count(value1) FROM test_bucketed_select GROUP BY key2, key1";
            expectedQuery = "SELECT count(comment) FROM orders GROUP BY custkey, orderkey";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(0));
            this.assertQuery(planWithoutTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(1));
            query = "SELECT key1 FROM test_bucketed_select JOIN test_bucketed_select USING (key1)";
            expectedQuery = "SELECT a.orderkey FROM orders a JOIN orders USING (orderkey)";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(0));
            this.assertQuery(planWithoutTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(2));
            query = "SELECT key2 FROM test_bucketed_select JOIN test_bucketed_select USING (key2)";
            expectedQuery = "SELECT a.custkey FROM orders a JOIN orders USING (custkey)";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(0));
            this.assertQuery(planWithoutTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(2));
            query = "SELECT key2, key1 FROM test_bucketed_select JOIN test_bucketed_select USING (key2, key1)";
            expectedQuery = "SELECT a.custkey, a.orderkey FROM orders a JOIN orders USING (custkey, orderkey)";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(0));
            this.assertQuery(planWithoutTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(2));
            query = "SELECT a.key2, b.key1 FROM test_bucketed_select a JOIN test_bucketed_select b on a.key1 = b.key2";
            expectedQuery = "SELECT a.custkey, b.orderkey FROM orders a JOIN orders b on a.orderkey = b.custkey";
            this.assertQuery(planWithTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(planWithoutTableNodePartitioning, query, expectedQuery, this.assertRemoteExchangesCount(2));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_bucketed_select");
        }
    }

    @Test
    public void testBucketPartitionFilterIncluded() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['bucket(ds, 16)'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, 'a', 'a'), (2, 'b', 'b')", 2L);
        String query = "SELECT id FROM " + tableName + " WHERE ds = 'a'";
        this.assertQuery(session, query, "VALUES 1");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testMultiPartitionedTableFilterIncluded() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['id', 'bucket(ds, 16)'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, 'a', 'a'), (2, 'b', 'b')", 2L);
        String query = "SELECT id, ds FROM " + tableName + " WHERE id = 2";
        this.assertQuery(session, query, "VALUES (2, 'b')");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testIdentityPartitionIsNotNullFilter() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertQuery(session, "SELECT id FROM " + tableName + " WHERE ds IS NOT null", "VALUES 1");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testJoinPartitionFilterIncluded() {
        String tableName1 = "test_partition_" + TestingNames.randomNameSuffix();
        String tableName2 = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName1 + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName1 + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertUpdate(session, "CREATE TABLE " + tableName2 + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName2 + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertQuery(session, "SELECT a.id, b.id FROM " + tableName1 + " a JOIN " + tableName2 + " b ON (a.ds = b.ds) WHERE a.ds = 'a'", "VALUES (1, 1)");
        this.assertUpdate(session, "DROP TABLE " + tableName1);
        this.assertUpdate(session, "DROP TABLE " + tableName2);
    }

    @Test
    public void testJoinWithMissingPartitionFilter() {
        String tableName1 = "test_partition_" + TestingNames.randomNameSuffix();
        String tableName2 = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName1 + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName1 + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertUpdate(session, "CREATE TABLE " + tableName2 + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName2 + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertQueryFails(session, "SELECT a.id, b.id FROM " + tableName1 + " a JOIN " + tableName2 + " b ON (a.id = b.id) WHERE a.ds = 'a'", "Filter required for tpch\\." + tableName2 + " on at least one of the partition columns: ds");
        this.assertUpdate(session, "DROP TABLE " + tableName1);
        this.assertUpdate(session, "DROP TABLE " + tableName2);
    }

    @Test
    public void testJoinWithPartitionFilterOnPartitionedTable() {
        String tableName1 = "test_partition_" + TestingNames.randomNameSuffix();
        String tableName2 = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName1 + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName1 + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertUpdate(session, "CREATE TABLE " + tableName2 + " (id integer, a varchar, b varchar, ds varchar)");
        this.assertUpdate(session, "INSERT INTO " + tableName2 + " (id, a, ds) VALUES (1, 'a', 'a')", 1L);
        this.assertQuery(session, "SELECT a.id, b.id FROM " + tableName1 + " a JOIN " + tableName2 + " b ON (a.id = b.id) WHERE a.ds = 'a'", "VALUES (1, 1)");
        this.assertUpdate(session, "DROP TABLE " + tableName1);
        this.assertUpdate(session, "DROP TABLE " + tableName2);
    }

    @Test
    public void testPartitionPredicateWithCasting() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, '1', '1')", 1L);
        String query = "SELECT id FROM " + tableName + " WHERE cast(ds as integer) = 1";
        this.assertQuery(session, query, "VALUES 1");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testNestedQueryWithInnerPartitionPredicate() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, '1', '1')", 1L);
        String query = "SELECT id FROM (SELECT * FROM " + tableName + " WHERE cast(ds as integer) = 1) WHERE cast(a as integer) = 1";
        this.assertQuery(session, query, "VALUES 1");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testPredicateOnNonPartitionColumn() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName + " (id, a, ds) VALUES (1, '1', '1')", 1L);
        String query = "SELECT id FROM " + tableName + " WHERE cast(b as integer) = 1";
        this.assertQueryFails(session, query, "Filter required for tpch\\." + tableName + " on at least one of the partition columns: ds");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testNonSelectStatementsWithPartitionFilterRequired() {
        String tableName1 = "test_partition_" + TestingNames.randomNameSuffix();
        String tableName2 = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession());
        this.assertUpdate(session, "CREATE TABLE " + tableName1 + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "CREATE TABLE " + tableName2 + " (id integer, a varchar, b varchar, ds varchar) WITH (partitioning = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO " + tableName1 + " (id, a, ds) VALUES (1, '1', '1'), (2, '2', '2')", 2L);
        this.assertUpdate(session, "INSERT INTO " + tableName2 + " (id, a, ds) VALUES (1, '1', '1'), (3, '3', '3')", 2L);
        String errorMessage = "Filter required for tpch\\." + tableName1 + " on at least one of the partition columns: ds";
        this.assertQueryFails(session, "ALTER TABLE " + tableName1 + " EXECUTE optimize", errorMessage);
        this.assertQueryFails(session, "UPDATE " + tableName1 + " SET a = 'New'", errorMessage);
        this.assertQueryFails(session, "MERGE INTO " + tableName1 + " AS a USING " + tableName2 + " AS b ON (a.ds = b.ds) WHEN MATCHED THEN UPDATE SET a = 'New'", errorMessage);
        this.assertQueryFails(session, "DELETE FROM " + tableName1 + " WHERE a = '1'", errorMessage);
        this.assertQuerySucceeds(session, "ALTER TABLE " + tableName1 + " EXECUTE optimize WHERE ds in ('2', '4')");
        this.assertQuerySucceeds(session, "UPDATE " + tableName1 + " SET a = 'New' WHERE ds = '2'");
        this.assertQuerySucceeds(session, "MERGE INTO " + tableName1 + " AS a USING (SELECT * FROM " + tableName2 + " WHERE ds = '1') AS b ON (a.ds = b.ds) WHEN MATCHED THEN UPDATE SET a = 'New'");
        this.assertQuerySucceeds(session, "DELETE FROM " + tableName1 + " WHERE ds = '1'");
        this.assertQuerySucceeds(session, "ANALYZE " + tableName1);
        this.assertQuerySucceeds(session, "ANALYZE " + tableName2 + " WITH (columns = ARRAY['id', 'a'])");
        this.assertUpdate(session, "DROP TABLE " + tableName1);
        this.assertUpdate(session, "DROP TABLE " + tableName2);
    }

    @Test
    public void testPartitionFilterRequiredSchemas() {
        String schemaName = "test_unenforced_schema_" + TestingNames.randomNameSuffix();
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)BaseIcebergConnectorTest.withPartitionFilterRequired(this.getSession())).setCatalogSessionProperty("iceberg", "query_partition_filter_required_schemas", "[\"tpch\"]").build();
        this.assertUpdate(session, "CREATE SCHEMA " + schemaName);
        this.assertUpdate(session, String.format("CREATE TABLE %s.%s (id, a, ds) WITH (partitioning = ARRAY['ds']) AS SELECT 1, '1', '1'", schemaName, tableName), 1L);
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id, a, ds) WITH (partitioning = ARRAY['ds']) AS SELECT 1, '1', '1'", 1L);
        String enforcedQuery = "SELECT id FROM tpch." + tableName + " WHERE a = '1'";
        this.assertQueryFails(session, enforcedQuery, "Filter required for tpch\\." + tableName + " on at least one of the partition columns: ds");
        String unenforcedQuery = String.format("SELECT id FROM %s.%s WHERE a = '1'", schemaName, tableName);
        this.assertQuerySucceeds(session, unenforcedQuery);
        this.assertUpdate(session, "DROP TABLE " + tableName);
        this.assertUpdate(session, "DROP SCHEMA " + schemaName + " CASCADE");
    }

    @Test
    public void testIgnorePartitionFilterRequiredSchemas() {
        String tableName = "test_partition_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "query_partition_filter_required_schemas", "[\"tpch\"]").build();
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (id, a, ds) WITH (partitioning = ARRAY['ds']) AS SELECT 1, '1', '1'", 1L);
        this.assertQuerySucceeds(session, "SELECT id FROM " + tableName + " WHERE a = '1'");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    private static Session withPartitionFilterRequired(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty("iceberg", "query_partition_filter_required", "true").build();
    }

    @Test
    public void testUuidDynamicFilter() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        try (TestTable dataTable = this.newTrinoTable("data_table", "(value uuid)");
             TestTable filteringTable = this.newTrinoTable("filtering_table", "(filtering_value uuid)");){
            this.assertUpdate("INSERT INTO " + dataTable.getName() + " VALUES UUID 'f73894f0-5447-41c5-a727-436d04c7f8ab', UUID '4f676658-67c9-4e80-83be-ec75f0b9d0c9'", 2L);
            this.assertUpdate("INSERT INTO " + filteringTable.getName() + " VALUES UUID 'f73894f0-5447-41c5-a727-436d04c7f8ab'", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "dynamic_filtering_wait_timeout", "10s").build(), "SELECT value FROM " + dataTable.getName() + " WHERE EXISTS (SELECT 1 FROM " + filteringTable.getName() + " WHERE filtering_value = value)"))).matches("VALUES UUID 'f73894f0-5447-41c5-a727-436d04c7f8ab'");
        }
    }

    @Test
    public void testDynamicFilterWithExplicitPartitionFilter() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        try (TestTable salesTable = this.newTrinoTable("sales_table", "(date date, receipt_id varchar, amount decimal(10,2)) with (partitioning=array['date'])");
             TestTable dimensionTable = this.newTrinoTable("dimension_table", "(date date, following_holiday boolean, year int)");){
            this.assertUpdate("INSERT INTO %s\nVALUES\n    (DATE '2023-01-01' , false, 2023),\n    (DATE '2023-01-02' , true, 2023),\n    (DATE '2023-01-03' , false, 2023)".formatted(dimensionTable.getName()), 3L);
            this.assertUpdate("INSERT INTO %s\nVALUES\n    (DATE '2023-01-02' , '#2023#1', DECIMAL '122.12'),\n    (DATE '2023-01-02' , '#2023#2', DECIMAL '124.12'),\n    (DATE '2023-01-02' , '#2023#3', DECIMAL '99.99'),\n    (DATE '2023-01-02' , '#2023#4', DECIMAL '95.12'),\n    (DATE '2023-01-03' , '#2023#5', DECIMAL '199.12'),\n    (DATE '2023-01-04' , '#2023#6', DECIMAL '99.55'),\n    (DATE '2023-01-05' , '#2023#7', DECIMAL '50.11'),\n    (DATE '2023-01-05' , '#2023#8', DECIMAL '60.20'),\n    (DATE '2023-01-05' , '#2023#9', DECIMAL '70.75'),\n    (DATE '2023-01-05' , '#2023#10', DECIMAL '80.12')".formatted(salesTable.getName()), 10L);
            String selectQuery = "SELECT receipt_id\nFROM %s s\nJOIN %s d\n    ON  s.date = d.date\nWHERE\n    d.following_holiday = true AND\n    d.date BETWEEN DATE '2023-01-01' AND DATE '2024-01-01'".formatted(salesTable.getName(), dimensionTable.getName());
            QueryRunner.MaterializedResultWithPlan result = this.getDistributedQueryRunner().executeWithPlan(Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "dynamic_filtering_wait_timeout", "10s").build(), selectQuery);
            MaterializedResult expected = this.computeActual(Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "false").build(), selectQuery);
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.result(), (Iterable)expected);
            DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(result.queryId()).getQueryStats().getDynamicFiltersStats();
            Assertions.assertThat((int)dynamicFiltersStats.getTotalDynamicFilters()).isEqualTo(1L);
            Assertions.assertThat((int)dynamicFiltersStats.getLazyDynamicFilters()).isEqualTo(1L);
            Assertions.assertThat((int)dynamicFiltersStats.getReplicatedDynamicFilters()).isEqualTo(0L);
            Assertions.assertThat((int)dynamicFiltersStats.getDynamicFiltersCompleted()).isEqualTo(1L);
        }
    }

    protected void verifyTableNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching(".*Table name must be shorter than or equal to '128' characters but got .*");
    }

    @Test
    public void testCreateTableWithCompressionCodec() {
        for (HiveCompressionCodec compressionCodec : HiveCompressionCodec.values()) {
            this.testCreateTableWithCompressionCodec(compressionCodec);
        }
    }

    private void testCreateTableWithCompressionCodec(HiveCompressionCodec compressionCodec) {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "compression_codec", compressionCodec.name()).build();
        String tableName = "test_table_with_compression_" + String.valueOf(compressionCodec);
        String createTableSql = String.format("CREATE TABLE %s AS SELECT * FROM tpch.tiny.nation WITH NO DATA", tableName);
        if (this.format == IcebergFileFormat.AVRO && compressionCodec == HiveCompressionCodec.LZ4) {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.computeActual(session, createTableSql)).hasMessage("Compression codec LZ4 not supported for " + this.format.humanName());
            return;
        }
        this.assertUpdate(session, createTableSql, 0L);
        this.verifyCodecInIcebergTableProperties(tableName, compressionCodec);
        String insertIntoSql = String.format("INSERT INTO %s SELECT * FROM tpch.tiny.nation", tableName);
        if (this.format == IcebergFileFormat.PARQUET && compressionCodec == HiveCompressionCodec.LZ4) {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.computeActual(session, insertIntoSql)).hasMessage("Compression codec LZ4 not supported for " + this.format.humanName());
            return;
        }
        this.assertUpdate(session, insertIntoSql, 25L);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 25");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected void verifyCodecInIcebergTableProperties(String tableName, HiveCompressionCodec codec) {
        Assertions.assertThat((String)tableName).isNotNull();
        Optional<Object> codecName = switch (this.format) {
            default -> throw new MatchException(null, null);
            case IcebergFileFormat.AVRO -> {
                switch (codec) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NONE: {
                        yield Optional.of("uncompressed");
                    }
                    case SNAPPY: {
                        yield Optional.of("snappy");
                    }
                    case LZ4: {
                        yield Optional.empty();
                    }
                    case ZSTD: {
                        yield Optional.of("zstd");
                    }
                    case GZIP: 
                }
                yield Optional.of("gzip");
            }
            case IcebergFileFormat.ORC -> {
                switch (codec) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NONE: {
                        yield Optional.of("none");
                    }
                    case SNAPPY: {
                        yield Optional.of("snappy");
                    }
                    case LZ4: {
                        yield Optional.of("lz4");
                    }
                    case ZSTD: {
                        yield Optional.of("zstd");
                    }
                    case GZIP: 
                }
                yield Optional.of("zlib");
            }
            case IcebergFileFormat.PARQUET -> {
                switch (codec) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NONE: {
                        yield Optional.of("uncompressed");
                    }
                    case SNAPPY: {
                        yield Optional.of("snappy");
                    }
                    case LZ4: {
                        yield Optional.of("lz4");
                    }
                    case ZSTD: {
                        yield Optional.of("zstd");
                    }
                    case GZIP: 
                }
                yield Optional.of("gzip");
            }
        };
        Map<String, String> actual = this.getTableProperties(tableName);
        Assertions.assertThat(actual).contains(new Map.Entry[]{Map.entry("write.format.default", this.format.name())});
        codecName.ifPresent(name -> Assertions.assertThat((Map)actual).contains(new Map.Entry[]{Map.entry("write.%s.compression-codec".formatted(this.format.name().toLowerCase(Locale.ENGLISH)), name)}));
        if (this.format != IcebergFileFormat.PARQUET) {
            Assertions.assertThat(actual).contains(new Map.Entry[]{Map.entry("write.parquet.compression-codec", "zstd")});
        }
    }

    private Map<String, String> getTableProperties(String tableName) {
        return (Map)this.computeActual("SELECT key, value FROM \"" + tableName + "$properties\"").getMaterializedRows().stream().collect(ImmutableMap.toImmutableMap(row -> (String)row.getField(0), row -> (String)row.getField(1)));
    }

    @Test
    public void testTypeCoercionOnCreateTableAsSelect() {
        for (TypeCoercionTestSetup setup : this.typeCoercionOnCreateTableAsSelectProvider()) {
            TestTable testTable = this.newTrinoTable("test_coercion_show_create_table", String.format("AS SELECT %s a", setup.sourceValueLiteral));
            try {
                Assertions.assertThat((String)this.getColumnType(testTable.getName(), "a")).isEqualTo(setup.newColumnType);
                ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName()))).as("source value: %s, new type: %s, new value: %s", new Object[]{setup.sourceValueLiteral, setup.newColumnType, setup.newValueLiteral})).skippingTypesCheck().matches("SELECT " + setup.newValueLiteral);
            }
            finally {
                if (testTable == null) continue;
                testTable.close();
            }
        }
    }

    @Test
    public void testTypeCoercionOnCreateTableAsSelectWithNoData() {
        for (TypeCoercionTestSetup setup : this.typeCoercionOnCreateTableAsSelectProvider()) {
            TestTable testTable = this.newTrinoTable("test_coercion_show_create_table", String.format("AS SELECT %s a WITH NO DATA", setup.sourceValueLiteral));
            try {
                Assertions.assertThat((String)this.getColumnType(testTable.getName(), "a")).isEqualTo(setup.newColumnType);
            }
            finally {
                if (testTable == null) continue;
                testTable.close();
            }
        }
    }

    private List<TypeCoercionTestSetup> typeCoercionOnCreateTableAsSelectProvider() {
        return this.typeCoercionOnCreateTableAsSelectData().stream().map(this::filterTypeCoercionOnCreateTableAsSelectProvider).flatMap(Optional::stream).collect(Collectors.toList());
    }

    protected Optional<TypeCoercionTestSetup> filterTypeCoercionOnCreateTableAsSelectProvider(TypeCoercionTestSetup setup) {
        return Optional.of(setup);
    }

    private List<TypeCoercionTestSetup> typeCoercionOnCreateTableAsSelectData() {
        return ImmutableList.builder().add((Object)new TypeCoercionTestSetup("TINYINT '127'", "integer", "INTEGER '127'")).add((Object)new TypeCoercionTestSetup("SMALLINT '32767'", "integer", "INTEGER '32767'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.000000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.9'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.900000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.56'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.560000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.123'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.4896'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.489600'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.89356'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.893560'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.123000'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.999'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.999000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.123456'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '2020-09-27 12:34:56.1'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.100000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '2020-09-27 12:34:56.9'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.900000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '2020-09-27 12:34:56.123'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.123000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '2020-09-27 12:34:56.123000'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.123000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '2020-09-27 12:34:56.999'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.999000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '2020-09-27 12:34:56.123456'", "timestamp(6)", "TIMESTAMP '2020-09-27 12:34:56.123456'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.1234561'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.123456499'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.1234565'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123457'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.111222'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 00:00:00.9999995'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:01.000000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1970-01-01 23:59:59.9999995'", "timestamp(6)", "TIMESTAMP '1970-01-02 00:00:00.000000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1969-12-31 23:59:59.9999995'", "timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.000000'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.999999'")).add((Object)new TypeCoercionTestSetup("TIMESTAMP '1969-12-31 23:59:59.9999994'", "timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.999999'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00'", "time(6)", "TIME '00:00:00.000000'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.9'", "time(6)", "TIME '00:00:00.900000'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.56'", "time(6)", "TIME '00:00:00.560000'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.123'", "time(6)", "TIME '00:00:00.123000'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.4896'", "time(6)", "TIME '00:00:00.489600'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.89356'", "time(6)", "TIME '00:00:00.893560'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.123000'", "time(6)", "TIME '00:00:00.123000'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.999'", "time(6)", "TIME '00:00:00.999000'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.123456'", "time(6)", "TIME '00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIME '12:34:56.1'", "time(6)", "TIME '12:34:56.100000'")).add((Object)new TypeCoercionTestSetup("TIME '12:34:56.9'", "time(6)", "TIME '12:34:56.900000'")).add((Object)new TypeCoercionTestSetup("TIME '12:34:56.123'", "time(6)", "TIME '12:34:56.123000'")).add((Object)new TypeCoercionTestSetup("TIME '12:34:56.123000'", "time(6)", "TIME '12:34:56.123000'")).add((Object)new TypeCoercionTestSetup("TIME '12:34:56.999'", "time(6)", "TIME '12:34:56.999000'")).add((Object)new TypeCoercionTestSetup("TIME '12:34:56.123456'", "time(6)", "TIME '12:34:56.123456'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.1234561'", "time(6)", "TIME '00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.123456499'", "time(6)", "TIME '00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.123456499999'", "time(6)", "TIME '00:00:00.123456'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.1234565'", "time(6)", "TIME '00:00:00.123457'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.111222333444'", "time(6)", "TIME '00:00:00.111222'")).add((Object)new TypeCoercionTestSetup("TIME '00:00:00.9999995'", "time(6)", "TIME '00:00:01.000000'")).add((Object)new TypeCoercionTestSetup("TIME '23:59:59.9999995'", "time(6)", "TIME '00:00:00.000000'")).add((Object)new TypeCoercionTestSetup("TIME '23:59:59.999999499999'", "time(6)", "TIME '23:59:59.999999'")).add((Object)new TypeCoercionTestSetup("TIME '23:59:59.9999994'", "time(6)", "TIME '23:59:59.999999'")).add((Object)new TypeCoercionTestSetup("CHAR 'A'", "varchar", "'A'")).add((Object)new TypeCoercionTestSetup("CHAR '\u00e9'", "varchar", "'\u00e9'")).add((Object)new TypeCoercionTestSetup("CHAR 'A '", "varchar", "'A '")).add((Object)new TypeCoercionTestSetup("CHAR ' A'", "varchar", "' A'")).add((Object)new TypeCoercionTestSetup("CHAR 'ABc'", "varchar", "'ABc'")).add((Object)new TypeCoercionTestSetup("ARRAY[CHAR 'A']", "array(varchar)", "ARRAY['A']")).add((Object)new TypeCoercionTestSetup("ARRAY[ARRAY[CHAR 'nested']]", "array(array(varchar))", "ARRAY[ARRAY['nested']]")).add((Object)new TypeCoercionTestSetup("MAP(ARRAY[CHAR 'key'], ARRAY[CHAR 'value'])", "map(varchar, varchar)", "MAP(ARRAY['key'], ARRAY['value'])")).add((Object)new TypeCoercionTestSetup("MAP(ARRAY[CHAR 'key'], ARRAY[ARRAY[CHAR 'value']])", "map(varchar, array(varchar))", "MAP(ARRAY['key'], ARRAY[ARRAY['value']])")).add((Object)new TypeCoercionTestSetup("CAST(ROW('a') AS ROW(x CHAR))", "row(x varchar)", "CAST(ROW('a') AS ROW(x VARCHAR))")).add((Object)new TypeCoercionTestSetup("CAST(ROW(ROW('a')) AS ROW(x ROW(y CHAR)))", "row(x row(y varchar))", "CAST(ROW(ROW('a')) AS ROW(x ROW(y VARCHAR)))")).add((Object)new TypeCoercionTestSetup("ARRAY[TINYINT '127']", "array(integer)", "ARRAY[127]")).add((Object)new TypeCoercionTestSetup("ARRAY[ARRAY[TINYINT '127']]", "array(array(integer))", "ARRAY[ARRAY[127]]")).add((Object)new TypeCoercionTestSetup("MAP(ARRAY[TINYINT '1'], ARRAY[TINYINT '10'])", "map(integer, integer)", "MAP(ARRAY[1], ARRAY[10])")).add((Object)new TypeCoercionTestSetup("MAP(ARRAY[TINYINT '1'], ARRAY[ARRAY[TINYINT '10']])", "map(integer, array(integer))", "MAP(ARRAY[1], ARRAY[ARRAY[10]])")).add((Object)new TypeCoercionTestSetup("CAST(ROW(127) AS ROW(x TINYINT))", "row(x integer)", "CAST(ROW(127) AS ROW(x INTEGER))")).add((Object)new TypeCoercionTestSetup("CAST(ROW(ROW(127)) AS ROW(x ROW(y TINYINT)))", "row(x row(y integer))", "CAST(ROW(ROW(127)) AS ROW(x ROW(y INTEGER)))")).add((Object)new TypeCoercionTestSetup("ARRAY[SMALLINT '32767']", "array(integer)", "ARRAY[32767]")).add((Object)new TypeCoercionTestSetup("ARRAY[ARRAY[SMALLINT '32767']]", "array(array(integer))", "ARRAY[ARRAY[32767]]")).add((Object)new TypeCoercionTestSetup("MAP(ARRAY[SMALLINT '1'], ARRAY[SMALLINT '10'])", "map(integer, integer)", "MAP(ARRAY[1], ARRAY[10])")).add((Object)new TypeCoercionTestSetup("MAP(ARRAY[SMALLINT '1'], ARRAY[ARRAY[SMALLINT '10']])", "map(integer, array(integer))", "MAP(ARRAY[1], ARRAY[ARRAY[10]])")).add((Object)new TypeCoercionTestSetup("CAST(ROW(32767) AS ROW(x SMALLINT))", "row(x integer)", "CAST(ROW(32767) AS ROW(x INTEGER))")).add((Object)new TypeCoercionTestSetup("CAST(ROW(ROW(32767)) AS ROW(x ROW(y SMALLINT)))", "row(x row(y integer))", "CAST(ROW(ROW(32767)) AS ROW(x ROW(y INTEGER)))")).build();
    }

    @Test
    public void testAddColumnWithTypeCoercion() {
        this.testAddColumnWithTypeCoercion("tinyint", "integer");
        this.testAddColumnWithTypeCoercion("smallint", "integer");
        this.testAddColumnWithTypeCoercion("timestamp with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(0) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(1) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(2) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(3) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(4) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(5) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(6) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(7) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(8) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(9) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(10) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(11) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp(12) with time zone", "timestamp(6) with time zone");
        this.testAddColumnWithTypeCoercion("timestamp", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(0)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(1)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(2)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(3)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(4)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(5)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(6)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(7)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(8)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(9)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(10)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(11)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(12)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("time", "time(6)");
        this.testAddColumnWithTypeCoercion("time(0)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(1)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(2)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(3)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(4)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(5)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(6)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(7)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(8)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(9)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(10)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(11)", "time(6)");
        this.testAddColumnWithTypeCoercion("time(12)", "time(6)");
        this.testAddColumnWithTypeCoercion("char(1)", "varchar");
        this.testAddColumnWithTypeCoercion("array(char(10))", "array(varchar)");
        this.testAddColumnWithTypeCoercion("map(char(20), char(30))", "map(varchar, varchar)");
        this.testAddColumnWithTypeCoercion("row(x char(40))", "row(x varchar)");
        this.testAddColumnWithTypeCoercion("array(tinyint)", "array(integer)");
        this.testAddColumnWithTypeCoercion("map(tinyint, tinyint)", "map(integer, integer)");
        this.testAddColumnWithTypeCoercion("row(x tinyint)", "row(x integer)");
        this.testAddColumnWithTypeCoercion("array(smallint)", "array(integer)");
        this.testAddColumnWithTypeCoercion("map(smallint, smallint)", "map(integer, integer)");
        this.testAddColumnWithTypeCoercion("row(x smallint)", "row(x integer)");
    }

    private void testAddColumnWithTypeCoercion(String columnType, String expectedColumnType) {
        try (TestTable testTable = this.newTrinoTable("test_coercion_add_column", "(a varchar, b row(x integer))");){
            this.assertUpdate("ALTER TABLE " + testTable.getName() + " ADD COLUMN b.y " + columnType);
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "b")).isEqualTo("row(x integer, y %s)".formatted(expectedColumnType));
            this.assertUpdate("ALTER TABLE " + testTable.getName() + " ADD COLUMN c " + columnType);
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "c")).isEqualTo(expectedColumnType);
        }
    }

    @Test
    public void testSystemTables() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        for (TableType tableType : TableType.values()) {
            if (tableType == TableType.DATA) continue;
            this.assertQueryFails("TABLE \"$%s\"".formatted(tableType.name().toLowerCase(Locale.ENGLISH)), "\\Qline 1:1: Table '%s.%s.\"$%s\"' does not exist".formatted(catalog, schema, tableType.name().toLowerCase(Locale.ENGLISH)));
        }
        this.assertQuerySucceeds("TABLE nation");
        this.assertQueryFails("TABLE \"nation$foo\"", "\\Qline 1:1: Table '%s.%s.\"nation$foo\"' does not exist".formatted(catalog, schema));
    }

    @Test
    public void testExtraProperties() {
        String tableName = "test_create_table_with_multiple_extra_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (c1 integer) WITH (extra_properties = MAP(ARRAY['extra.property.one', 'extra.property.TWO'], ARRAY['one', 'two']))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT key, value FROM \"" + tableName + "$properties\" WHERE key IN ('extra.property.one', 'extra.property.two')"))).skippingTypesCheck().matches("VALUES ('extra.property.one', 'one'), ('extra.property.two', 'two')");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES extra_properties = MAP(ARRAY['extra.property.one'], ARRAY['updated'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT key, value FROM \"" + tableName + "$properties\" WHERE key IN ('extra.property.one', 'extra.property.two')"))).skippingTypesCheck().matches("VALUES ('extra.property.one', 'updated'), ('extra.property.two', 'two')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testReplaceTableExtraProperties() {
        String tableName = "test_replace_table_with_multiple_extra_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (c1 integer) WITH (extra_properties = MAP(ARRAY['extra.property.one', 'extra.property.two'], ARRAY['one', 'two']))");
        this.assertUpdate("CREATE OR REPLACE TABLE " + tableName + " (c1 integer) WITH (extra_properties = MAP(ARRAY['extra.property.three'], ARRAY['three']))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT key, value FROM \"" + tableName + "$properties\" WHERE key IN ('extra.property.one', 'extra.property.two', 'extra.property.three')"))).skippingTypesCheck().matches("VALUES ('extra.property.three', 'three')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectWithExtraProperties() {
        String tableName = "test_ctas_with_extra_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (extra_properties = MAP(ARRAY['extra.property.one', 'extra.property.two'], ARRAY['one', 'two'])) AS SELECT 1 as c1", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT key, value FROM \"" + tableName + "$properties\" WHERE key IN ('extra.property.one', 'extra.property.two')"))).skippingTypesCheck().matches("VALUES ('extra.property.one', 'one'), ('extra.property.two', 'two')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testShowCreateNotContainExtraProperties() {
        String tableName = "test_show_create_table_with_extra_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (c1 integer) WITH (extra_properties = MAP(ARRAY['extra.property.one', 'extra.property.two'], ARRAY['one', 'two']))");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).doesNotContain(new CharSequence[]{"extra_properties =", "extra.property.one", "extra.property.two"});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testNullExtraProperty() {
        this.assertQueryFails("CREATE TABLE test_create_table_with_null_extra_properties (c1 integer) WITH (extra_properties = MAP(ARRAY['null.property'], ARRAY[null]))", ".*\\QUnable to set catalog 'iceberg' table property 'extra_properties' to [MAP(ARRAY['null.property'], ARRAY[null])]: Extra table property value cannot be null '{null.property=null}'\\E");
        this.assertQueryFails("CREATE TABLE test_create_table_with_as_null_extra_properties WITH (extra_properties = MAP(ARRAY['null.property'], ARRAY[null])) AS SELECT 1 as c1", ".*\\QUnable to set catalog 'iceberg' table property 'extra_properties' to [MAP(ARRAY['null.property'], ARRAY[null])]: Extra table property value cannot be null '{null.property=null}'\\E");
    }

    @Test
    public void testIllegalExtraPropertyKey() {
        this.assertQueryFails("CREATE TABLE test_create_table_with_illegal_extra_properties (c1 integer) WITH (extra_properties = MAP(ARRAY['sorted_by'], ARRAY['id']))", "\\QIllegal keys in extra_properties: [sorted_by]");
        this.assertQueryFails("CREATE TABLE test_create_table_as_with_illegal_extra_properties WITH (extra_properties = MAP(ARRAY['extra_properties'], ARRAY['some_value'])) AS SELECT 1 as c1", "\\QIllegal keys in extra_properties: [extra_properties]");
        this.assertQueryFails("CREATE TABLE test_create_table_with_as_illegal_extra_properties WITH (extra_properties = MAP(ARRAY['write.format.default'], ARRAY['ORC'])) AS SELECT 1 as c1", "\\QIllegal keys in extra_properties: [write.format.default]");
        this.assertQueryFails("CREATE TABLE test_create_table_with_as_illegal_extra_properties WITH (extra_properties = MAP(ARRAY['comment'], ARRAY['some comment'])) AS SELECT 1 as c1", "\\QIllegal keys in extra_properties: [comment]");
        this.assertQueryFails("CREATE TABLE test_create_table_with_as_illegal_extra_properties WITH (extra_properties = MAP(ARRAY['not_allowed_property'], ARRAY['foo'])) AS SELECT 1 as c1", "\\QIllegal keys in extra_properties: [not_allowed_property]");
    }

    @Test
    public void testSetIllegalExtraPropertyKey() {
        try (TestTable table = this.newTrinoTable("test_set_illegal_table_properties", "(x int)");){
            this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES extra_properties = MAP(ARRAY['sorted_by'], ARRAY['id'])", "\\QIllegal keys in extra_properties: [sorted_by]");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES extra_properties = MAP(ARRAY['comment'], ARRAY['some comment'])", "\\QIllegal keys in extra_properties: [comment]");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES extra_properties = MAP(ARRAY['not_allowed_property'], ARRAY['foo'])", "\\QIllegal keys in extra_properties: [not_allowed_property]");
        }
    }

    @Test
    void testExplainAnalyzeSplitSourceMetrics() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM nation a", new String[]{"splits generation metrics"});
    }

    @Test
    void testArrayElementChange() {
        try (TestTable table = this.newTrinoTable("test_array_schema_change", "(col array(row(a varchar, b varchar)))", List.of("CAST(array[row('a', 'b')] AS array(row(a varchar, b varchar)))"));){
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.a");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.c varchar");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.b");
            String expected = this.format == IcebergFileFormat.ORC || this.format == IcebergFileFormat.AVRO ? "CAST(array[row(NULL)] AS array(row(c varchar)))" : "CAST(NULL AS array(row(c varchar)))";
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES " + expected);
        }
    }

    @Test
    void testRowFieldChange() {
        try (TestTable table = this.newTrinoTable("test_row_schema_change", "(col row(a varchar, b varchar))");){
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT CAST(row('a', 'b') AS row(a varchar, b varchar))", 1L);
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.a");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.c varchar");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.b");
            String expected = this.format == IcebergFileFormat.ORC || this.format == IcebergFileFormat.AVRO ? "CAST(row(NULL) AS row(c varchar))" : "CAST(NULL AS row(c varchar))";
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("SELECT " + expected);
        }
    }

    @Test
    public void testObjectStoreLayoutEnabledAndDataLocation() throws Exception {
        String tableName = "test_object_store_layout_enabled_data_location" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (object_store_layout_enabled = true, data_location = 'local:///data-location/xyz') AS SELECT 1 AS val", 1L);
        Location tableLocation = Location.of((String)this.getTableLocation(tableName));
        Assertions.assertThat((Boolean)((Boolean)this.fileSystem.directoryExists(tableLocation).get())).isTrue();
        String filePath = (String)this.computeScalar("SELECT file_path FROM \"" + tableName + "$files\"");
        Location dataFileLocation = Location.of((String)filePath);
        Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).isTrue();
        Assertions.assertThat((String)filePath).matches((CharSequence)"local:///data-location/xyz/.{6}/tpch/%s.*".formatted(tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFileLocation).exists()).isFalse();
        Assertions.assertThat((boolean)this.fileSystem.newInputFile(tableLocation).exists()).isFalse();
    }

    @Test
    public void testCreateTableWithDataLocationButObjectStoreLayoutDisabled() {
        this.assertQueryFails("CREATE TABLE test_data_location WITH (data_location = 'local:///data-location/xyz') AS SELECT 1 AS val", "Data location can only be set when object store layout is enabled");
    }

    @Test
    public void testSetFieldMapKeyType() {
        Assertions.assertThatThrownBy(() -> super.testSetFieldMapKeyType()).hasMessageContaining("Failed to set field type: Cannot alter map keys");
    }

    @Test
    public void testSetNestedFieldMapKeyType() {
        Assertions.assertThatThrownBy(() -> super.testSetNestedFieldMapKeyType()).hasMessageContaining("Failed to set field type: Cannot alter map keys");
    }

    protected Optional<BaseConnectorTest.SetColumnTypeSetup> filterSetColumnTypesDataProvider(BaseConnectorTest.SetColumnTypeSetup setup) {
        if (setup.sourceColumnType().equals("timestamp(3) with time zone")) {
            return Optional.of(setup.withNewValueLiteral("TIMESTAMP '2020-02-12 14:03:00.123000 +00:00'"));
        }
        switch ("%s -> %s".formatted(setup.sourceColumnType(), setup.newColumnType())) {
            case "tinyint -> smallint": 
            case "bigint -> integer": 
            case "decimal(5,3) -> decimal(5,2)": 
            case "varchar -> char(20)": 
            case "time(6) -> time(3)": 
            case "timestamp(6) -> timestamp(3)": 
            case "array(integer) -> array(bigint)": {
                return Optional.of(setup.asUnsupported());
            }
            case "varchar(100) -> varchar(50)": {
                return Optional.empty();
            }
        }
        return Optional.of(setup);
    }

    protected void verifySetColumnTypeFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching(".*(Failed to set column type: Cannot change (column type:|type from .* to )|Time(stamp)? precision \\(3\\) not supported for Iceberg. Use \"time(stamp)?\\(6\\)\" instead|Type not supported for Iceberg: smallint|char\\(20\\)).*");
    }

    protected Optional<BaseConnectorTest.SetColumnTypeSetup> filterSetFieldTypesDataProvider(BaseConnectorTest.SetColumnTypeSetup setup) {
        switch ("%s -> %s".formatted(setup.sourceColumnType(), setup.newColumnType())) {
            case "tinyint -> smallint": 
            case "bigint -> integer": 
            case "decimal(5,3) -> decimal(5,2)": 
            case "varchar -> char(20)": 
            case "time(6) -> time(3)": 
            case "timestamp(6) -> timestamp(3)": 
            case "array(integer) -> array(bigint)": 
            case "row(x integer) -> row(x bigint)": 
            case "row(x integer) -> row(y integer)": 
            case "row(x integer, y integer) -> row(x integer, z integer)": 
            case "row(x integer) -> row(x integer, y integer)": 
            case "row(x integer, y integer) -> row(x integer)": 
            case "row(x integer, y integer) -> row(y integer, x integer)": 
            case "row(x integer, y integer) -> row(z integer, y integer, x integer)": 
            case "row(x row(nested integer)) -> row(x row(nested bigint))": 
            case "row(x row(a integer, b integer)) -> row(x row(b integer, a integer))": {
                return Optional.of(setup.asUnsupported());
            }
            case "varchar(100) -> varchar(50)": {
                return Optional.empty();
            }
        }
        return Optional.of(setup);
    }

    protected void verifySetFieldTypeFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching(".*(Failed to set field type: Cannot change (column type:|type from .* to )|Time(stamp)? precision \\(3\\) not supported for Iceberg. Use \"time(stamp)?\\(6\\)\" instead|Type not supported for Iceberg: smallint|char\\(20\\)|Iceberg doesn't support changing field type (from|to) non-primitive types).*");
    }

    protected Session withoutSmallFileThreshold(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "parquet_small_file_threshold", "0B").setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "orc_tiny_stripe_threshold", "0B").build();
    }

    private Session withSingleWriterPerTask(Session session) {
        return Session.builder((Session)session).setSystemProperty("task_min_writer_count", "1").build();
    }

    private Session prepareCleanUpSession() {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "expire_snapshots_min_retention", "0s").setCatalogSessionProperty("iceberg", "remove_orphan_files_min_retention", "0s").build();
    }

    private List<String> getAllMetadataFilesFromTableDirectory(String tableLocation) throws IOException {
        return this.listFiles(this.getIcebergTableMetadataPath(tableLocation));
    }

    protected List<String> listFiles(String directory) throws IOException {
        ImmutableList.Builder files = ImmutableList.builder();
        FileIterator listing = this.fileSystem.listFiles(Location.of((String)directory));
        while (listing.hasNext()) {
            String location = listing.next().location().toString();
            if (location.matches(".*/\\..*\\.crc")) continue;
            files.add((Object)location);
        }
        return files.build();
    }

    protected long fileSize(String location) throws IOException {
        return this.fileSystem.newInputFile(Location.of((String)location)).length();
    }

    protected void createFile(String location) throws IOException {
        this.fileSystem.newOutputFile(Location.of((String)location)).create().close();
    }

    private List<Long> getSnapshotIds(String tableName) {
        return (List)this.getQueryRunner().execute(String.format("SELECT snapshot_id FROM \"%s$snapshots\"", tableName)).getOnlyColumn().map(Long.class::cast).collect(ImmutableList.toImmutableList());
    }

    private List<Long> getTableHistory(String tableName) {
        return (List)this.getQueryRunner().execute(String.format("SELECT snapshot_id FROM \"%s$history\"", tableName)).getOnlyColumn().map(Long.class::cast).collect(ImmutableList.toImmutableList());
    }

    private List<Long> getLatestSequenceNumbersInMetadataLogEntries(String tableName) {
        return (List)this.getQueryRunner().execute(String.format("SELECT latest_sequence_number FROM \"%s$metadata_log_entries\"", tableName)).getOnlyColumn().map(Long.class::cast).collect(ImmutableList.toImmutableList());
    }

    private long getCurrentSnapshotId(String tableName) {
        return (Long)this.computeScalar("SELECT snapshot_id FROM \"" + tableName + "$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES");
    }

    private String getIcebergTableDataPath(String tableLocation) {
        return tableLocation + "/data";
    }

    private String getIcebergTableMetadataPath(String tableLocation) {
        return tableLocation + "/metadata";
    }

    private long getCommittedAtInEpochMilliseconds(String tableName, long snapshotId) {
        return ((ZonedDateTime)this.computeActual(String.format("SELECT committed_at FROM \"%s$snapshots\" WHERE snapshot_id=%s LIMIT 1", tableName, snapshotId)).getOnlyValue()).toInstant().toEpochMilli();
    }

    private static String timestampLiteral(long epochMilliSeconds, int precision) {
        return DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss." + "S".repeat(precision) + " VV''").format(Instant.ofEpochMilli(epochMilliSeconds).atZone(ZoneOffset.UTC));
    }

    private List<Long> getSnapshotsIdsByCreationOrder(String tableName) {
        int idField = 0;
        return this.getQueryRunner().execute(String.format("SELECT snapshot_id FROM \"%s$snapshots\" ORDER BY committed_at", tableName)).getMaterializedRows().stream().map(row -> (Long)row.getField(idField)).collect(Collectors.toList());
    }

    private String getFieldFromLatestSnapshotSummary(String tableName, String summaryFieldName) {
        return this.getQueryRunner().execute(String.format("SELECT json_extract_scalar(CAST(SUMMARY AS JSON), '$.%s') FROM \"%s$snapshots\" ORDER BY committed_at DESC LIMIT 1", summaryFieldName, tableName)).getOnlyColumn().map(String.class::cast).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Table '%s' has zero snapshots or does not have the '%s' field in its snapshot summary.", tableName, summaryFieldName)));
    }

    private QueryId executeWithQueryId(String sql) {
        return this.getDistributedQueryRunner().executeWithPlan(this.getSession(), sql).queryId();
    }

    private void assertQueryIdAndUserStored(String tableName, QueryId queryId) {
        Assertions.assertThat((String)this.getFieldFromLatestSnapshotSummary(tableName, "trino_query_id")).isEqualTo(queryId.toString());
        Assertions.assertThat((String)this.getFieldFromLatestSnapshotSummary(tableName, "trino_user")).isEqualTo("user");
    }

    private Consumer<Plan> assertRemoteExchangesCount(int expectedRemoteExchangesCount) {
        return plan -> {
            int actualRemoteExchangesCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> {
                ExchangeNode exchangeNode;
                return node instanceof ExchangeNode && (exchangeNode = (ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE;
            }).count();
            Assertions.assertThat((int)actualRemoteExchangesCount).isEqualTo(expectedRemoteExchangesCount);
        };
    }

    private Consumer<Plan> assertNoReadPartitioning(String ... columnNames) {
        return plan -> {
            List tableScanNodes = (List)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof TableScanNode).findAll().stream().map(TableScanNode.class::cast).collect(ImmutableList.toImmutableList());
            for (TableScanNode tableScanNode : tableScanNodes) {
                Assertions.assertThat((Boolean)((Boolean)tableScanNode.getUseConnectorNodePartitioning().orElseThrow())).isFalse();
                IcebergTableHandle connectorTableHandle = (IcebergTableHandle)tableScanNode.getTable().connectorHandle();
                Assertions.assertThat((Optional)connectorTableHandle.getTablePartitioning()).isPresent();
                IcebergTablePartitioning tablePartitioning = (IcebergTablePartitioning)connectorTableHandle.getTablePartitioning().orElseThrow();
                Set actualPartitionColumns = tablePartitioning.partitioningColumns().stream().map(IcebergColumnHandle::getName).collect(Collectors.toSet());
                Assertions.assertThat(actualPartitionColumns).containsExactlyInAnyOrder((Object[])columnNames);
                Assertions.assertThat((boolean)tablePartitioning.active()).isFalse();
            }
        };
    }

    public record TypeCoercionTestSetup(@Language(value="SQL") String sourceValueLiteral, String newColumnType, @Language(value="SQL") String newValueLiteral) {
        public TypeCoercionTestSetup {
            Objects.requireNonNull(sourceValueLiteral, "sourceValueLiteral is null");
            Objects.requireNonNull(newColumnType, "newColumnType is null");
            Objects.requireNonNull(newValueLiteral, "newValueLiteral is null");
        }

        public TypeCoercionTestSetup withNewValueLiteral(String newValueLiteral) {
            return new TypeCoercionTestSetup(this.sourceValueLiteral, this.newColumnType, newValueLiteral);
        }
    }

    private record IcebergEntry(int status, String filePath, Long sequenceNumber, Long fileSequenceNumber) {
    }
}

