/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.execution.FailureInjector;
import io.trino.operator.RetryPolicy;
import io.trino.spi.ErrorType;
import io.trino.testing.BaseFailureRecoveryTest;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public abstract class BaseIcebergFailureRecoveryTest
extends BaseFailureRecoveryTest {
    protected BaseIcebergFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    protected boolean areWriteRetriesSupported() {
        return true;
    }

    @Test
    protected void testCreatePartitionedTable() {
        this.testTableModification(Optional.empty(), "CREATE TABLE <table> WITH (partitioning = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test
    protected void testDelete() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        String deleteQuery = "DELETE FROM <table> WHERE orderkey = 1";
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.boundaryCoordinatorStage()).finishesSuccessfully().cleansUpTemporaryTables();
        } else {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.boundaryCoordinatorStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).cleansUpTemporaryTables();
        }
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.rootStage()).finishesSuccessfully().cleansUpTemporaryTables();
        } else {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.rootStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).cleansUpTemporaryTables();
        }
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully().cleansUpTemporaryTables();
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully().cleansUpTemporaryTables();
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully().cleansUpTemporaryTables();
        this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully().cleansUpTemporaryTables();
        if (this.getRetryPolicy() == RetryPolicy.QUERY) {
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully().cleansUpTemporaryTables();
            this.assertThatQuery(deleteQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully().cleansUpTemporaryTables();
        }
    }

    @Test
    protected void testUpdate() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        String updateQuery = "UPDATE <table> SET shippriority = 101 WHERE custkey = 1";
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.boundaryCoordinatorStage()).finishesSuccessfully().cleansUpTemporaryTables();
        } else {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.boundaryCoordinatorStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).cleansUpTemporaryTables();
        }
        if (this.getRetryPolicy() == RetryPolicy.TASK) {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.rootStage()).finishesSuccessfully().cleansUpTemporaryTables();
        } else {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.rootStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).cleansUpTemporaryTables();
        }
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully().cleansUpTemporaryTables();
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully().cleansUpTemporaryTables();
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully().cleansUpTemporaryTables();
        this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully();
        if (this.getRetryPolicy() == RetryPolicy.QUERY) {
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully().cleansUpTemporaryTables();
            this.assertThatQuery(updateQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(BaseIcebergFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully().cleansUpTemporaryTables();
        }
    }

    @Test
    protected void testInsertIntoNewPartition() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioning = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition2' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test
    protected void testInsertIntoExistingPartition() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioning = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test
    protected void testMergePartitionedTable() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioning = ARRAY['bucket(orderkey, 10)']) AS SELECT * FROM orders"), "MERGE INTO <table> t\nUSING (SELECT orderkey, 'X' clerk FROM <table>) s\nON t.orderkey = s.orderkey\nWHEN MATCHED AND s.orderkey > 1000\n    THEN UPDATE SET clerk = t.clerk || s.clerk\nWHEN MATCHED AND s.orderkey <= 1000\n    THEN DELETE\n", Optional.of("DROP TABLE <table>"));
    }
}

