/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.SizeOf;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.SplitWeight;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.IntegerType;
import io.trino.sql.query.QueryAssertions;
import io.trino.sql.tree.ExplainType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public abstract class BaseIcebergMaterializedViewTest
extends AbstractTestQueryFramework {
    protected abstract String getSchemaDirectory();

    protected abstract String getStorageMetadataLocation(String var1);

    protected static MockConnectorPlugin createMockConnectorPlugin() {
        return new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withTableFunctions((Iterable)ImmutableSet.of((Object)((Object)new SequenceTableFunction()))).withFunctionProvider(Optional.of(new FunctionProvider(){

            public TableFunctionProcessorProvider getTableFunctionProcessorProvider(ConnectorTableFunctionHandle functionHandle) {
                if (functionHandle instanceof SequenceTableFunctionHandle) {
                    return new SequenceTableFunctionProcessorProvider();
                }
                throw new IllegalArgumentException("This ConnectorTableFunctionHandle is not supported");
            }
        })).withTableFunctionSplitSources(functionHandle -> {
            if (functionHandle instanceof SequenceTableFunctionHandle) {
                return new FixedSplitSource((Iterable)ImmutableList.of((Object)new SequenceConnectorSplit()));
            }
            throw new IllegalArgumentException("This ConnectorTableFunctionHandle is not supported");
        }).build());
    }

    @BeforeAll
    public void setUp() {
        this.assertUpdate("CREATE TABLE base_table1(_bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO base_table1 VALUES (0, DATE '2019-09-08'), (1, DATE '2019-09-09'), (2, DATE '2019-09-09')", 3L);
        this.assertUpdate("INSERT INTO base_table1 VALUES (3, DATE '2019-09-09'), (4, DATE '2019-09-10'), (5, DATE '2019-09-10')", 3L);
        this.assertUpdate("CREATE TABLE base_table2 (_varchar VARCHAR, _bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_bigint', '_date'])");
        this.assertUpdate("INSERT INTO base_table2 VALUES ('a', 0, DATE '2019-09-08'), ('a', 1, DATE '2019-09-08'), ('a', 0, DATE '2019-09-09')", 3L);
    }

    @Test
    public void testShowTables() {
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_show_tables_test AS SELECT * FROM base_table1");
        ImmutableSet expectedTables = ImmutableSet.of((Object)"base_table1", (Object)"base_table2", (Object)"materialized_view_show_tables_test");
        Set actualTables = (Set)this.computeActual("SHOW TABLES").getOnlyColumnAsSet().stream().map(String.class::cast).collect(ImmutableSet.toImmutableSet());
        Assertions.assertThat((Collection)actualTables).containsAll((Iterable)expectedTables);
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_show_tables_test");
    }

    @Test
    public void testCommentColumnMaterializedView() {
        String viewColumnName = "_bigint";
        String materializedViewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s AS SELECT * FROM base_table1", materializedViewName));
        this.assertUpdate(String.format("COMMENT ON COLUMN %s.%s IS 'new comment'", materializedViewName, viewColumnName));
        Assertions.assertThat((String)this.getColumnComment(materializedViewName, viewColumnName)).isEqualTo("new comment");
        this.assertQuery(String.format("SELECT count(*) FROM %s", materializedViewName), "VALUES 6");
        this.assertUpdate(String.format("DROP MATERIALIZED VIEW %s", materializedViewName));
    }

    @Test
    public void testMaterializedViewsMetadata() {
        String materializedViewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        this.computeActual("CREATE TABLE small_region AS SELECT * FROM tpch.tiny.region LIMIT 1");
        this.computeActual(String.format("CREATE MATERIALIZED VIEW %s AS SELECT * FROM small_region LIMIT 1", materializedViewName));
        this.assertQuery(String.format("SELECT freshness FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '%s'", materializedViewName), "VALUES 'STALE'");
        this.computeActual(String.format("REFRESH MATERIALIZED VIEW %s", materializedViewName));
        this.assertQuery(String.format("SELECT freshness FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '%s'", materializedViewName), "VALUES 'FRESH'");
        this.assertUpdate("DROP TABLE small_region");
        this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
    }

    @Test
    public void testCreateWithInvalidPropertyFails() {
        Assertions.assertThatThrownBy(() -> this.computeActual("CREATE MATERIALIZED VIEW materialized_view_with_property WITH (invalid_property = ARRAY['_date']) AS SELECT _bigint, _date FROM base_table1")).hasMessage("line 1:64: Catalog 'iceberg' materialized view property 'invalid_property' does not exist");
    }

    @Test
    public void testCreateWithDuplicateSourceTableSucceeds() {
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_with_duplicate_source AS SELECT _bigint, _date FROM base_table1 UNION ALL SELECT _bigint, _date FROM base_table1 ");
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_with_duplicate_source", 12L);
        this.assertQuery("SELECT count(*) FROM materialized_view_with_duplicate_source", "VALUES 12");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_with_duplicate_source");
    }

    @Test
    public void testShowCreate() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        this.assertUpdate("CREATE MATERIALIZED VIEW test_mv_show_create WITH (\n   partitioning = ARRAY['_date'],\n   format = 'ORC',\n   orc_bloom_filter_columns = ARRAY['_date'],\n   orc_bloom_filter_fpp = 0.1) AS SELECT _bigint, _date FROM base_table1");
        this.assertQuery("SELECT COUNT(*) FROM test_mv_show_create", "VALUES 6");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW test_mv_show_create"))).matches((CharSequence)("\\QCREATE MATERIALIZED VIEW iceberg." + schema + ".test_mv_show_create\nWITH (\n   format = 'ORC',\n   format_version = 2,\n   location = '" + this.getSchemaDirectory() + "/test_mv_show_create-\\E[0-9a-f]+\\Q',\n   max_commit_retry = 4,\n   orc_bloom_filter_columns = ARRAY['_date'],\n   orc_bloom_filter_fpp = 1E-1,\n   partitioning = ARRAY['_date'],\n   storage_schema = '" + schema + "'\n) AS\nSELECT\n  _bigint\n, _date\nFROM\n  base_table1"));
        this.assertUpdate("DROP MATERIALIZED VIEW test_mv_show_create");
    }

    @Test
    public void testSystemMaterializedViewProperties() {
        Assertions.assertThat((Iterable)this.computeActual("SELECT * FROM system.metadata.materialized_view_properties WHERE catalog_name = 'iceberg'")).contains((Object[])new MaterializedRow[]{new MaterializedRow(5, new Object[]{"iceberg", "partitioning", "[]", "array(varchar)", "Partition transforms"})});
    }

    @Test
    public void testSessionCatalogSchema() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        Session session = Session.builder((Session)this.getSession()).setCatalog("tpch").setSchema("tiny").build();
        String qualifiedMaterializedViewName = "iceberg." + schema + ".materialized_view_session_test";
        this.assertUpdate(session, "CREATE MATERIALIZED VIEW " + qualifiedMaterializedViewName + " AS SELECT * FROM nation");
        this.assertQuery(session, "SELECT COUNT(*) FROM " + qualifiedMaterializedViewName, "VALUES 25");
        this.assertUpdate(session, "DROP MATERIALIZED VIEW " + qualifiedMaterializedViewName);
        session = Session.builder((Session)this.getSession()).setCatalog(Optional.empty()).setSchema(Optional.empty()).build();
        this.assertUpdate(session, "CREATE MATERIALIZED VIEW " + qualifiedMaterializedViewName + " AS SELECT * FROM iceberg." + schema + ".base_table1");
        this.assertQuery(session, "SELECT COUNT(*) FROM " + qualifiedMaterializedViewName, "VALUES 6");
        this.assertUpdate(session, "DROP MATERIALIZED VIEW " + qualifiedMaterializedViewName);
    }

    @Test
    public void testDropIfExists() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        this.assertQueryFails("DROP MATERIALIZED VIEW non_existing_materialized_view", "line 1:1: Materialized view 'iceberg." + schema + ".non_existing_materialized_view' does not exist");
        this.assertUpdate("DROP MATERIALIZED VIEW IF EXISTS non_existing_materialized_view");
    }

    @Test
    public void testDropDenyPermission() {
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_drop_deny AS SELECT * FROM base_table1");
        this.assertAccessDenied("DROP MATERIALIZED VIEW materialized_view_drop_deny", "Cannot drop materialized view .*.materialized_view_drop_deny.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"materialized_view_drop_deny", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_MATERIALIZED_VIEW)});
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_drop_deny");
    }

    @Test
    public void testRenameDenyPermission() {
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_rename_deny AS SELECT * FROM base_table1");
        this.assertAccessDenied("ALTER MATERIALIZED VIEW materialized_view_rename_deny RENAME TO materialized_view_rename_deny_new", "Cannot rename materialized view .*.materialized_view_rename_deny.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"materialized_view_rename_deny", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_MATERIALIZED_VIEW)});
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_rename_deny");
    }

    @Test
    public void testRefreshDenyPermission() {
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_refresh_deny AS SELECT * FROM base_table1");
        this.assertAccessDenied("REFRESH MATERIALIZED VIEW materialized_view_refresh_deny", "Cannot refresh materialized view .*.materialized_view_refresh_deny.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"materialized_view_refresh_deny", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.REFRESH_MATERIALIZED_VIEW)});
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_refresh_deny");
    }

    @Test
    public void testCreateRefreshSelect() {
        Session session = this.getSession();
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_no_part as select * from base_table1");
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_agg as select _date, count(_date) as num_dates from base_table1 group by 1");
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_part WITH (partitioning = ARRAY['_date']) as select _date, count(_date) as num_dates from base_table1 group by 1");
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_join as select t2._bigint, _varchar, t1._date from base_table1 t1, base_table2 t2 where t1._date = t2._date");
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_join_part WITH (partitioning = ARRAY['_date', '_bigint']) as select t1._bigint, _varchar, t2._date, sum(1) as my_sum from base_table1 t1, base_table2 t2 where t1._date = t2._date group by 1, 2, 3 order by 1, 2");
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_no_part").getRowCount()).isEqualTo(6);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_no_part", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table1"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_no_part", 6L);
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_no_part").getRowCount()).isEqualTo(6);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_no_part", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1"});
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_agg").getRowCount()).isEqualTo(3);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_agg", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table1"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_agg", 3L);
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_agg").getRowCount()).isEqualTo(3);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_agg", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1"});
        this.assertQuery(session, "SELECT * FROM materialized_view_agg", "VALUES (DATE '2019-09-10', 2),(DATE '2019-09-08', 1), (DATE '2019-09-09', 3)");
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_part").getRowCount()).isEqualTo(3);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_part", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table1"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_part", 3L);
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_part").getRowCount()).isEqualTo(3);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_part", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1"});
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_join").getRowCount()).isEqualTo(5);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table1", "base_table2"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_join", 5L);
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_join").getRowCount()).isEqualTo(5);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1", "base_table2"});
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_join_part").getRowCount()).isEqualTo(4);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join_part", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table1", "base_table2"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_join_part", 4L);
        Assertions.assertThat((int)this.computeActual("SELECT * FROM materialized_view_join_part").getRowCount()).isEqualTo(4);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join_part", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1", "base_table2"});
        this.assertQuery(session, "SELECT * FROM materialized_view_join_part", "VALUES (2, 'a', DATE '2019-09-09', 1), (0, 'a', DATE '2019-09-08', 2), (3, 'a', DATE '2019-09-09', 1), (1, 'a', DATE '2019-09-09', 1)");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_no_part");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_agg");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_part");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_join");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_join_part");
    }

    @Test
    public void testDetectStaleness() {
        this.assertUpdate("CREATE TABLE base_table3(_bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO base_table3 VALUES (0, DATE '2019-09-08'), (1, DATE '2019-09-09'), (2, DATE '2019-09-09')", 3L);
        this.assertUpdate("CREATE TABLE base_table4 (_varchar VARCHAR, _bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_bigint', '_date'])");
        this.assertUpdate("INSERT INTO base_table4 VALUES ('a', 0, DATE '2019-09-08'), ('a', 1, DATE '2019-09-08'), ('a', 0, DATE '2019-09-09')", 3L);
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_part_stale WITH (partitioning = ARRAY['_date']) AS SELECT _date, count(_date) AS num_dates FROM base_table3 GROUP BY 1");
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_join_stale as SELECT t2._bigint, _varchar, t1._date FROM base_table3 t1, base_table4 t2 WHERE t1._date = t2._date");
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_join_part_stale WITH (partitioning = ARRAY['_date', '_bigint']) as SELECT t1._bigint, _varchar, t2._date, sum(1) AS my_sum FROM base_table3 t1, base_table4 t2 WHERE t1._date = t2._date GROUP BY 1, 2, 3 ORDER BY 1, 2");
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_part_stale", 2L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_join_stale", 4L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_join_part_stale", 3L);
        this.assertUpdate("INSERT INTO base_table3 VALUES (3, DATE '2019-09-09'), (4, DATE '2019-09-10'), (5, DATE '2019-09-10')", 3L);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_part_stale", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table"});
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join_stale", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table"});
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join_part_stale", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_part_stale", 3L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_join_stale", 5L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_join_part_stale", 4L);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_part_stale", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table3"});
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join_stale", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table3", "base_table4"});
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_join_part_stale", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table3", "base_table4"});
        this.assertUpdate("DROP TABLE base_table3");
        this.assertUpdate("DROP TABLE base_table4");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_part_stale");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_join_stale");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_join_part_stale");
    }

    @Test
    public void testMaterializedViewOnExpiredTable() {
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "expire_snapshots_min_retention", "0s").build();
        this.assertUpdate("CREATE TABLE mv_on_expired_base_table AS SELECT 10 a", 1L);
        this.assertUpdate("CREATE MATERIALIZED VIEW mv_on_expired_the_mv\nGRACE PERIOD INTERVAL '0' SECOND\nAS SELECT sum(a) s FROM mv_on_expired_base_table");
        this.assertUpdate("REFRESH MATERIALIZED VIEW mv_on_expired_the_mv", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_expired_the_mv"))).matches("VALUES BIGINT '10'");
        this.assertUpdate("INSERT INTO mv_on_expired_base_table VALUES 7", 1L);
        this.assertUpdate("INSERT INTO mv_on_expired_base_table VALUES 5", 1L);
        this.computeActual(sessionWithShortRetentionUnlocked, "ALTER TABLE mv_on_expired_base_table EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_expired_the_mv"))).matches("VALUES BIGINT '22'");
        this.assertUpdate("REFRESH MATERIALIZED VIEW mv_on_expired_the_mv", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_expired_the_mv"))).matches("VALUES BIGINT '22'");
        this.assertUpdate("DROP TABLE mv_on_expired_base_table");
        this.assertUpdate("DROP MATERIALIZED VIEW mv_on_expired_the_mv");
    }

    @Test
    public void testMaterializedViewOnTableRolledBack() {
        this.assertUpdate("CREATE TABLE mv_on_rolled_back_base_table(a integer)");
        this.assertUpdate("CREATE MATERIALIZED VIEW mv_on_rolled_back_the_mv\nGRACE PERIOD INTERVAL '0' SECOND\nAS SELECT sum(a) s FROM mv_on_rolled_back_base_table");
        this.assertUpdate("INSERT INTO mv_on_rolled_back_base_table VALUES 4", 1L);
        long firstSnapshot = this.getLatestSnapshotId("mv_on_rolled_back_base_table");
        this.assertUpdate("INSERT INTO mv_on_rolled_back_base_table VALUES 8", 1L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW mv_on_rolled_back_the_mv", 1L);
        this.assertUpdate(String.format("ALTER TABLE mv_on_rolled_back_base_table EXECUTE rollback_to_snapshot(%s)", firstSnapshot));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_rolled_back_the_mv"))).matches("VALUES BIGINT '4'");
        this.assertUpdate("REFRESH MATERIALIZED VIEW mv_on_rolled_back_the_mv", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE mv_on_rolled_back_the_mv"))).matches("VALUES BIGINT '4'");
        this.assertUpdate("DROP TABLE mv_on_rolled_back_base_table");
        this.assertUpdate("DROP MATERIALIZED VIEW mv_on_rolled_back_the_mv");
    }

    @Test
    public void testSqlFeatures() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_window WITH (partitioning = ARRAY['_date']) AS SELECT _date, sum(_bigint) OVER (PARTITION BY _date ORDER BY _date) as sum_ints from base_table1");
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_window", 6L);
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_union WITH (partitioning = ARRAY['_date']) AS select _date, count(_date) as num_dates from base_table1 group by 1 UNION select _date, count(_date) as num_dates from base_table2 group by 1");
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_union", 5L);
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_subquery WITH (partitioning = ARRAY['_date']) AS SELECT _date, count(_date) AS num_dates FROM base_table1 WHERE _date = (select max(_date) FROM base_table2) GROUP BY 1");
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_subquery", 1L);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_window", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1"});
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_union", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1"});
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_subquery", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table1"});
        String qualifiedMaterializedViewName = "iceberg." + schema + ".materialized_view_window";
        this.assertQueryFails("SHOW CREATE VIEW materialized_view_window", "line 1:1: Relation '" + qualifiedMaterializedViewName + "' is a materialized view, not a view");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW materialized_view_window"))).matches((CharSequence)("\\QCREATE MATERIALIZED VIEW " + qualifiedMaterializedViewName + "\nWITH (\n   format = 'PARQUET',\n   format_version = 2,\n   location = '" + this.getSchemaDirectory() + "/materialized_view_window-\\E[0-9a-f]+\\Q',\n   max_commit_retry = 4,\n   partitioning = ARRAY['_date'],\n   storage_schema = '" + schema + "'\n) AS\nSELECT\n  _date\n, sum(_bigint) OVER (PARTITION BY _date ORDER BY _date ASC) sum_ints\nFROM\n  base_table1"));
        this.assertQueryFails("INSERT INTO materialized_view_window VALUES (0, '2019-09-08'), (1, DATE '2019-09-09'), (2, DATE '2019-09-09')", "line 1:1: Inserting into materialized views is not supported");
        this.computeScalar("EXPLAIN (TYPE LOGICAL) REFRESH MATERIALIZED VIEW materialized_view_window");
        this.computeScalar("EXPLAIN (TYPE DISTRIBUTED) REFRESH MATERIALIZED VIEW materialized_view_window");
        this.computeScalar("EXPLAIN (TYPE VALIDATE) REFRESH MATERIALIZED VIEW materialized_view_window");
        this.computeScalar("EXPLAIN (TYPE IO) REFRESH MATERIALIZED VIEW materialized_view_window");
        this.computeScalar("EXPLAIN ANALYZE REFRESH MATERIALIZED VIEW materialized_view_window");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_window");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_union");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_subquery");
    }

    @Test
    public void testReplace() {
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_replace WITH (partitioning = ARRAY['_date']) as select _date, count(_date) as num_dates from base_table1 group by 1");
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_replace", 3L);
        this.assertUpdate("CREATE OR REPLACE MATERIALIZED VIEW materialized_view_replace as select sum(1) as num_rows from base_table2");
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_replace", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table2"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_replace", 1L);
        this.computeScalar("SELECT * FROM materialized_view_replace");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM materialized_view_replace"))).matches("VALUES BIGINT '3'");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_replace");
    }

    @Test
    public void testCreateMaterializedViewWhenTableExists() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        this.assertUpdate("CREATE TABLE test_create_materialized_view_when_table_exists (a INT, b INT)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE OR REPLACE MATERIALIZED VIEW test_create_materialized_view_when_table_exists AS SELECT sum(1) AS num_rows FROM base_table2"))).failure().hasMessage("Existing table is not a Materialized View: " + schema + ".test_create_materialized_view_when_table_exists");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE MATERIALIZED VIEW IF NOT EXISTS test_create_materialized_view_when_table_exists AS SELECT sum(1) AS num_rows FROM base_table2"))).failure().hasMessage("Existing table is not a Materialized View: " + schema + ".test_create_materialized_view_when_table_exists");
        this.assertUpdate("DROP TABLE test_create_materialized_view_when_table_exists");
    }

    @Test
    public void testDropMaterializedViewCannotDropTable() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        this.assertUpdate("CREATE TABLE test_drop_materialized_view_cannot_drop_table (a INT, b INT)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DROP MATERIALIZED VIEW test_drop_materialized_view_cannot_drop_table"))).failure().hasMessageContaining("Materialized view 'iceberg." + schema + ".test_drop_materialized_view_cannot_drop_table' does not exist, but a table with that name exists");
        this.assertUpdate("DROP TABLE test_drop_materialized_view_cannot_drop_table");
    }

    @Test
    public void testRenameMaterializedViewCannotRenameTable() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        this.assertUpdate("CREATE TABLE test_rename_materialized_view_cannot_rename_table (a INT, b INT)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ALTER MATERIALIZED VIEW test_rename_materialized_view_cannot_rename_table RENAME TO new_materialized_view_name"))).failure().hasMessageContaining("Materialized View 'iceberg." + schema + ".test_rename_materialized_view_cannot_rename_table' does not exist, but a table with that name exists");
        this.assertUpdate("DROP TABLE test_rename_materialized_view_cannot_rename_table");
    }

    @Test
    public void testNestedMaterializedViews() {
        this.assertUpdate("CREATE TABLE base_table5(_bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO base_table5 VALUES (0, DATE '2019-09-08'), (1, DATE '2019-09-09'), (2, DATE '2019-09-09')", 3L);
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_level1 WITH (partitioning = ARRAY['_date']) as select _date, count(_date) as num_dates from base_table5 group by 1");
        this.assertUpdate("CREATE MATERIALIZED VIEW materialized_view_level2 WITH (partitioning = ARRAY['_date']) as select _date, num_dates from materialized_view_level1");
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_level2", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table5"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_level2", 2L);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_level2", ExplainType.Type.IO)).doesNotContain(new CharSequence[]{"base_table5"});
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_level2", 0L);
        this.assertUpdate("INSERT INTO base_table5 VALUES (3, DATE '2019-09-09'), (4, DATE '2019-09-10'), (5, DATE '2019-09-10')", 3L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW materialized_view_level2", 3L);
        Assertions.assertThat((String)this.getExplainPlan("SELECT * FROM materialized_view_level1", ExplainType.Type.IO)).contains(new CharSequence[]{"base_table5"});
        this.assertUpdate("DROP TABLE base_table5");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_level1");
        this.assertUpdate("DROP MATERIALIZED VIEW materialized_view_level2");
    }

    @Test
    public void testBucketPartitioning() {
        this.testBucketPartitioning("integer", "20050909");
        this.testBucketPartitioning("bigint", "200509091331001234");
        this.testBucketPartitioning("decimal(8,5)", "DECIMAL '876.54321'");
        this.testBucketPartitioning("decimal(28,21)", "DECIMAL '1234567.890123456789012345678'");
        this.testBucketPartitioning("date", "DATE '2005-09-09'");
        this.testBucketPartitioning("time(6)", "TIME '13:31:00.123456'");
        this.testBucketPartitioning("timestamp(6)", "TIMESTAMP '2005-09-10 13:31:00.123456'");
        this.testBucketPartitioning("timestamp(6) with time zone", "TIMESTAMP '2005-09-10 13:00:00.123456 Europe/Warsaw'");
        this.testBucketPartitioning("varchar", "VARCHAR 'Greetings from Warsaw!'");
        this.testBucketPartitioning("uuid", "UUID '406caec7-68b9-4778-81b2-a12ece70c8b1'");
        this.testBucketPartitioning("varbinary", "X'66696E6465706920726F636B7321'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBucketPartitioning(String dataType, String exampleValue) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT " + exampleValue))).matches("SELECT CAST(%s AS %S)".formatted(exampleValue, dataType));
        this.assertUpdate("CREATE MATERIALIZED VIEW test_bucket_partitioning WITH (partitioning=ARRAY['bucket(col, 4)']) AS SELECT * FROM (VALUES CAST(NULL AS %s), %s) t(col)".formatted(dataType, exampleValue));
        try {
            TableMetadata storageMetadata = this.getStorageTableMetadata("test_bucket_partitioning");
            Assertions.assertThat((List)storageMetadata.spec().fields()).hasSize(1);
            PartitionField bucketPartitionField = (PartitionField)Iterables.getOnlyElement((Iterable)storageMetadata.spec().fields());
            Assertions.assertThat((String)bucketPartitionField.name()).isEqualTo("col_bucket");
            Assertions.assertThat((String)bucketPartitionField.transform().toString()).isEqualTo("bucket[4]");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_bucket_partitioning WHERE col = " + exampleValue))).matches("SELECT " + exampleValue);
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW test_bucket_partitioning");
        }
    }

    @Test
    public void testTruncatePartitioning() {
        this.testTruncatePartitioning("integer", "20050909");
        this.testTruncatePartitioning("bigint", "200509091331001234");
        this.testTruncatePartitioning("decimal(8,5)", "DECIMAL '876.54321'");
        this.testTruncatePartitioning("decimal(28,21)", "DECIMAL '1234567.890123456789012345678'");
        this.testTruncatePartitioning("varchar", "VARCHAR 'Greetings from Warsaw!'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTruncatePartitioning(String dataType, String exampleValue) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT " + exampleValue))).matches("SELECT CAST(%s AS %S)".formatted(exampleValue, dataType));
        this.assertUpdate("CREATE MATERIALIZED VIEW test_truncate_partitioning WITH (partitioning=ARRAY['truncate(col, 4)']) AS SELECT * FROM (VALUES CAST(NULL AS %s), %s) t(col)".formatted(dataType, exampleValue));
        try {
            TableMetadata storageMetadata = this.getStorageTableMetadata("test_truncate_partitioning");
            Assertions.assertThat((List)storageMetadata.spec().fields()).hasSize(1);
            PartitionField bucketPartitionField = (PartitionField)Iterables.getOnlyElement((Iterable)storageMetadata.spec().fields());
            Assertions.assertThat((String)bucketPartitionField.name()).isEqualTo("col_trunc");
            Assertions.assertThat((String)bucketPartitionField.transform().toString()).isEqualTo("truncate[4]");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_truncate_partitioning WHERE col = " + exampleValue))).matches("SELECT " + exampleValue);
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW test_truncate_partitioning");
        }
    }

    @Test
    public void testTemporalPartitioning() {
        this.testTemporalPartitioning("year", "date", "DATE '2005-09-09'");
        this.testTemporalPartitioning("year", "timestamp(6)", "TIMESTAMP '2005-09-10 13:31:00.123456'");
        this.testTemporalPartitioning("year", "timestamp(6) with time zone", "TIMESTAMP '2005-09-10 13:00:00.123456 Europe/Warsaw'");
        this.testTemporalPartitioning("month", "date", "DATE '2005-09-09'");
        this.testTemporalPartitioning("month", "timestamp(6)", "TIMESTAMP '2005-09-10 13:31:00.123456'");
        this.testTemporalPartitioning("month", "timestamp(6) with time zone", "TIMESTAMP '2005-09-10 13:00:00.123456 Europe/Warsaw'");
        this.testTemporalPartitioning("day", "date", "DATE '2005-09-09'");
        this.testTemporalPartitioning("day", "timestamp(6)", "TIMESTAMP '2005-09-10 13:31:00.123456'");
        this.testTemporalPartitioning("day", "timestamp(6) with time zone", "TIMESTAMP '2005-09-10 13:00:00.123456 Europe/Warsaw'");
        this.testTemporalPartitioning("hour", "timestamp(6)", "TIMESTAMP '2005-09-10 13:31:00.123456'");
        this.testTemporalPartitioning("hour", "timestamp(6) with time zone", "TIMESTAMP '2005-09-10 13:00:00.123456 Europe/Warsaw'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTemporalPartitioning(String partitioning, String dataType, String exampleValue) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT " + exampleValue))).matches("SELECT CAST(%s AS %S)".formatted(exampleValue, dataType));
        this.assertUpdate("CREATE MATERIALIZED VIEW test_temporal_partitioning WITH (partitioning=ARRAY['%s(col)']) AS SELECT * FROM (VALUES CAST(NULL AS %s), %s) t(col)".formatted(partitioning, dataType, exampleValue));
        try {
            TableMetadata storageMetadata = this.getStorageTableMetadata("test_temporal_partitioning");
            Assertions.assertThat((List)storageMetadata.spec().fields()).hasSize(1);
            PartitionField bucketPartitionField = (PartitionField)Iterables.getOnlyElement((Iterable)storageMetadata.spec().fields());
            Assertions.assertThat((String)bucketPartitionField.name()).isEqualTo("col_" + partitioning);
            Assertions.assertThat((String)bucketPartitionField.transform().toString()).isEqualTo(partitioning);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_temporal_partitioning WHERE col = " + exampleValue))).matches("SELECT " + exampleValue);
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW test_temporal_partitioning");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaterializedViewSnapshotSummariesHaveTrinoQueryId() {
        String materializedViewName = "test_materialized_view_snapshot_query_ids" + TestingNames.randomNameSuffix();
        String sourceTableName = "test_source_table_for_mat_view" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a bigint, b bigint)", sourceTableName));
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s WITH (partitioning = ARRAY['a']) AS SELECT * FROM %s", materializedViewName, sourceTableName));
        try {
            this.assertUpdate(String.format("INSERT INTO %s VALUES (1, 1), (1, 4), (2, 2)", sourceTableName), 3L);
            QueryId refreshQueryId = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), String.format("REFRESH MATERIALIZED VIEW %s", materializedViewName)).queryId();
            String savedQueryId = (String)this.getStorageTableMetadata(materializedViewName).currentSnapshot().summary().get("trino_query_id");
            Assertions.assertThat((String)savedQueryId).isEqualTo(refreshQueryId.getId());
        }
        finally {
            this.assertUpdate("DROP TABLE " + sourceTableName);
            this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
        }
    }

    @Test
    public void testMaterializedViewStorageTypeCoercions() {
        String materializedViewName = "test_materialized_view_storage_type_coercion" + TestingNames.randomNameSuffix();
        String sourceTableName = "test_materialized_view_storage" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (\n    t_3 time(3),\n    t_9 time(9),\n    ts_3 timestamp(3),\n    ts_9 timestamp(9),\n    tswtz_3 timestamp(3) with time zone,\n    tswtz_9 timestamp(9) with time zone\n)\n", sourceTableName));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (localtime, localtime, localtimestamp, localtimestamp, current_timestamp, current_timestamp)", sourceTableName), 1L);
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s AS SELECT * FROM %s", materializedViewName, sourceTableName));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE t_3 < localtime", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE t_9 < localtime", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE ts_3 < localtimestamp", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE ts_9 < localtimestamp", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE tswtz_3 < current_timestamp", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE tswtz_9 < current_timestamp", materializedViewName)))).succeeds();
        this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW %s", materializedViewName), 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE t_3 < localtime", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE t_9 < localtime", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE ts_3 < localtimestamp", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE ts_9 < localtimestamp", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE tswtz_3 < current_timestamp", materializedViewName)))).succeeds();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE tswtz_9 < current_timestamp", materializedViewName)))).succeeds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropLegacyMaterializedView() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String materializedViewName = "test_drop_legacy_materialized_view" + TestingNames.randomNameSuffix();
        String sourceTableName = "test_source_table_for_mat_view" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a bigint, b bigint)", sourceTableName));
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW iceberg_legacy_mv.%s.%s AS SELECT * FROM %s", schemaName, materializedViewName, sourceTableName));
        try {
            this.assertUpdate(String.format("INSERT INTO %s VALUES (1, 1), (1, 4), (2, 2)", sourceTableName), 3L);
            this.assertUpdate(String.format("REFRESH MATERIALIZED VIEW iceberg_legacy_mv.%s.%s", schemaName, materializedViewName), 3L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (10, 10), (10, 40), (20, 20)", sourceTableName), 3L);
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + materializedViewName, 6L);
            String storageTableName = (String)this.computeScalar("SELECT storage_table FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + materializedViewName + "'");
            ((AbstractStringAssert)Assertions.assertThat((String)storageTableName).isEqualTo(this.computeScalar("SELECT storage_table FROM system.metadata.materialized_views WHERE catalog_name = 'iceberg_legacy_mv' AND schema_name = CURRENT_SCHEMA AND name = '" + materializedViewName + "'"))).startsWith((CharSequence)"st_");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + materializedViewName))).matches("TABLE " + sourceTableName);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + storageTableName))).matches("TABLE " + sourceTableName);
            this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + materializedViewName))).failure().hasMessageMatching(".* does not exist");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + storageTableName))).failure().hasMessageMatching(".* does not exist");
        }
        catch (Throwable throwable) {
            this.assertUpdate("DROP TABLE " + sourceTableName);
            this.assertUpdate(String.format("DROP MATERIALIZED VIEW IF EXISTS iceberg_legacy_mv.%s.%s", schemaName, materializedViewName));
            throw throwable;
        }
        this.assertUpdate("DROP TABLE " + sourceTableName);
        this.assertUpdate(String.format("DROP MATERIALIZED VIEW IF EXISTS iceberg_legacy_mv.%s.%s", schemaName, materializedViewName));
    }

    @Test
    public void testMaterializedViewCreatedFromTableFunction() {
        String viewName = "materialized_view_for_ptf_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM TABLE(mock.system.sequence_function())");
        this.assertFreshness(viewName, "STALE");
        Assertions.assertThat((Object)this.computeActual("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'").getOnlyValue()).isNull();
        int result1 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        int result2 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        Assertions.assertThat((int)result2).isNotEqualTo(result1);
        this.assertFreshness(viewName, "STALE");
        Assertions.assertThat((Object)this.computeActual("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'").getOnlyValue()).isNull();
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        this.assertFreshness(viewName, "UNKNOWN");
        ZonedDateTime lastFreshTime = (ZonedDateTime)this.computeActual("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'").getOnlyValue();
        Assertions.assertThat((ZonedDateTime)lastFreshTime).isNotNull();
        int result3 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        Assertions.assertThat((int)result3).isNotEqualTo(result2);
        int result4 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        int result5 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        Assertions.assertThat((int)result4).isEqualTo(result3);
        Assertions.assertThat((int)result4).isEqualTo(result5);
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        Assertions.assertThat((ZonedDateTime)((ZonedDateTime)this.computeActual("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'").getOnlyValue())).isAfter(lastFreshTime);
        this.assertFreshness(viewName, "UNKNOWN");
        int result6 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        Assertions.assertThat((int)result6).isNotEqualTo(result5);
    }

    @Test
    public void testMaterializedViewCreatedFromTableFunctionAndTable() {
        String sourceTableName = "source_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTableName + " (VALUE INTEGER)");
        this.assertUpdate("INSERT INTO " + sourceTableName + " VALUES 2", 1L);
        String viewName = "materialized_view_for_ptf_adn_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM TABLE(mock.system.sequence_function()) CROSS JOIN " + sourceTableName);
        List materializedRows = this.computeActual("SELECT * FROM " + viewName).getMaterializedRows();
        Assertions.assertThat((List)materializedRows).hasSize(1);
        Assertions.assertThat((Object)((MaterializedRow)materializedRows.get(0)).getField(1)).isEqualTo((Object)2);
        int valueFromPtf1 = (Integer)((MaterializedRow)materializedRows.get(0)).getField(0);
        this.assertFreshness(viewName, "STALE");
        Assertions.assertThat((Object)this.computeActual("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'").getOnlyValue()).isNull();
        materializedRows = this.computeActual("SELECT * FROM " + viewName).getMaterializedRows();
        Assertions.assertThat((List)materializedRows).hasSize(1);
        Assertions.assertThat((Object)((MaterializedRow)materializedRows.get(0)).getField(1)).isEqualTo((Object)2);
        int valueFromPtf2 = (Integer)((MaterializedRow)materializedRows.get(0)).getField(0);
        Assertions.assertThat((int)valueFromPtf2).isNotEqualTo(valueFromPtf1);
        this.assertFreshness(viewName, "STALE");
        Assertions.assertThat((Object)this.computeActual("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'").getOnlyValue()).isNull();
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        this.assertFreshness(viewName, "UNKNOWN");
        ZonedDateTime lastFreshTime = (ZonedDateTime)this.computeActual("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'").getOnlyValue();
        Assertions.assertThat((ZonedDateTime)lastFreshTime).isNotNull();
        materializedRows = this.computeActual("SELECT * FROM " + viewName).getMaterializedRows();
        Assertions.assertThat((List)materializedRows).hasSize(1);
        Assertions.assertThat((Object)((MaterializedRow)materializedRows.get(0)).getField(1)).isEqualTo((Object)2);
        int valueFromPtf3 = (Integer)((MaterializedRow)materializedRows.get(0)).getField(0);
        Assertions.assertThat((int)valueFromPtf3).isNotEqualTo(valueFromPtf1);
        Assertions.assertThat((int)valueFromPtf3).isNotEqualTo(valueFromPtf2);
        materializedRows = this.computeActual("SELECT * FROM " + viewName).getMaterializedRows();
        Assertions.assertThat((List)materializedRows).hasSize(1);
        Assertions.assertThat((Object)((MaterializedRow)materializedRows.get(0)).getField(1)).isEqualTo((Object)2);
        int valueFromPtf4 = (Integer)((MaterializedRow)materializedRows.get(0)).getField(0);
        Assertions.assertThat((int)valueFromPtf4).isNotEqualTo(valueFromPtf1);
        Assertions.assertThat((int)valueFromPtf4).isNotEqualTo(valueFromPtf2);
        Assertions.assertThat((int)valueFromPtf4).isEqualTo(valueFromPtf3);
    }

    @Test
    public void testMaterializedViewCreatedFromTableFunctionWithGracePeriod() throws InterruptedException {
        String viewName = "materialized_view_for_ptf_with_grace_period_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " GRACE PERIOD INTERVAL '1' SECOND AS SELECT * FROM TABLE(mock.system.sequence_function())");
        int result1 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        int result2 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        Assertions.assertThat((int)result2).isNotEqualTo(result1);
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        int result3 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        Assertions.assertThat((int)result3).isNotEqualTo(result2);
        Thread.sleep(1001L);
        int result4 = (Integer)this.computeActual("SELECT * FROM " + viewName).getOnlyValue();
        Assertions.assertThat((int)result4).isNotEqualTo(result3);
    }

    @Test
    public void testIncrementalRefresh() {
        String sourceTableName = "source_table" + TestingNames.randomNameSuffix();
        String materializedViewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        Session defaultSession = this.getSession();
        Session incrementalRefreshDisabled = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "incremental_refresh_enabled", "false").build();
        String matViewDef = "SELECT a, b FROM %s WHERE a < 3 OR a > 5".formatted(sourceTableName);
        this.assertUpdate("CREATE TABLE %s (a int, b varchar)".formatted(sourceTableName));
        this.assertUpdate("INSERT INTO %s VALUES (1, 'abc'), (2, 'def')".formatted(sourceTableName), 2L);
        this.assertUpdate("CREATE MATERIALIZED VIEW %s_1 AS %s".formatted(materializedViewName, matViewDef));
        this.assertUpdate("CREATE MATERIALIZED VIEW %s_2 AS %s".formatted(materializedViewName, matViewDef));
        this.assertUpdate("REFRESH MATERIALIZED VIEW %s_1".formatted(materializedViewName), 2L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW %s_2".formatted(materializedViewName), 2L);
        this.assertUpdate("INSERT INTO %s VALUES (3, 'ghi'), (4, 'jkl'), (5, 'mno'), (6, 'pqr')".formatted(sourceTableName), 4L);
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s_1".formatted(materializedViewName), 1L);
        this.assertUpdate(incrementalRefreshDisabled, "REFRESH MATERIALIZED VIEW %s_2".formatted(materializedViewName), 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s_1".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'abc'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s_2".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'abc'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr')");
        this.assertUpdate("DROP MATERIALIZED VIEW %s_1".formatted(materializedViewName));
        this.assertUpdate("DROP MATERIALIZED VIEW %s_2".formatted(materializedViewName));
        this.assertUpdate("DROP TABLE %s".formatted(sourceTableName));
    }

    @Test
    public void testFullRefreshForUnion() {
        String sourceTableName = "source_table" + TestingNames.randomNameSuffix();
        String materializedViewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        Session defaultSession = this.getSession();
        String matViewDef = "SELECT a, b FROM %s a WHERE a.a < 3 UNION ALL\nSELECT * FROM %s b WHERE b.a > 5".formatted(sourceTableName, sourceTableName);
        this.assertUpdate("CREATE TABLE %s (a int, b varchar)".formatted(sourceTableName));
        this.assertUpdate("INSERT INTO %s VALUES (1, 'abc'), (2, 'def')".formatted(sourceTableName), 2L);
        this.assertUpdate("CREATE MATERIALIZED VIEW %s AS %s".formatted(materializedViewName, matViewDef));
        this.assertUpdate("REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 2L);
        this.assertUpdate("INSERT INTO %s VALUES (3, 'ghi'), (4, 'jkl'), (5, 'mno'), (6, 'pqr')".formatted(sourceTableName), 4L);
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'abc'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr')");
        this.assertUpdate("DROP MATERIALIZED VIEW %s".formatted(materializedViewName));
        this.assertUpdate("DROP TABLE %s".formatted(sourceTableName));
    }

    @Test
    public void testFullRefreshForUpdates() {
        String sourceTableName = "source_table" + TestingNames.randomNameSuffix();
        String materializedViewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        Session defaultSession = this.getSession();
        String matViewDef = "SELECT a, b FROM %s WHERE a < 3 OR a > 5".formatted(sourceTableName);
        this.assertUpdate("CREATE TABLE %s (a int, b varchar)".formatted(sourceTableName));
        this.assertUpdate("INSERT INTO %s VALUES (1, 'abc'), (2, 'def')".formatted(sourceTableName), 2L);
        this.assertUpdate("CREATE MATERIALIZED VIEW %s AS %s".formatted(materializedViewName, matViewDef));
        this.assertUpdate("REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 2L);
        this.assertUpdate("INSERT INTO %s VALUES (3, 'ghi'), (4, 'jkl'), (5, 'mno'), (6, 'pqr')".formatted(sourceTableName), 4L);
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 1L);
        this.assertUpdate("UPDATE %s SET b = 'updated' WHERE a = 1".formatted(sourceTableName), 1L);
        this.assertUpdate("INSERT INTO %s VALUES (7, 'stv')".formatted(sourceTableName), 1L);
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 4L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'updated'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr'), (7, VARCHAR 'stv')");
        this.assertUpdate("INSERT INTO %s VALUES (8, 'wxy')".formatted(sourceTableName), 1L);
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'updated'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr'), (7, VARCHAR 'stv'), (8, VARCHAR 'wxy')");
        this.assertUpdate("DROP MATERIALIZED VIEW %s".formatted(materializedViewName));
        this.assertUpdate("DROP TABLE %s".formatted(sourceTableName));
    }

    @Test
    public void testRefreshWithCompaction() {
        String sourceTableName = "source_table" + TestingNames.randomNameSuffix();
        String materializedViewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        Session defaultSession = this.getSession();
        String matViewDef = "SELECT a, b FROM %s WHERE a < 3 OR a > 5".formatted(sourceTableName);
        this.assertUpdate("CREATE TABLE %s (a int, b varchar)".formatted(sourceTableName));
        this.assertUpdate("INSERT INTO %s VALUES (1, 'abc'), (2, 'def')".formatted(sourceTableName), 2L);
        this.assertUpdate("CREATE MATERIALIZED VIEW %s AS %s".formatted(materializedViewName, matViewDef));
        this.assertUpdate("REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 2L);
        this.assertUpdate("INSERT INTO %s VALUES (3, 'ghi'), (4, 'jkl'), (5, 'mno'), (6, 'pqr')".formatted(sourceTableName), 4L);
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'abc'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr')");
        this.assertUpdate(defaultSession, "ALTER TABLE %s EXECUTE OPTIMIZE".formatted(sourceTableName));
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 0L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'abc'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr')");
        this.assertUpdate("INSERT INTO %s VALUES (7, 'stv'), (8, 'wxy')".formatted(sourceTableName), 2L);
        this.assertUpdate(defaultSession, "REFRESH MATERIALIZED VIEW %s".formatted(materializedViewName), 2L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE %s".formatted(materializedViewName)))).matches("VALUES (1, VARCHAR 'abc'), (2, VARCHAR 'def'), (6, VARCHAR 'pqr'), (7, VARCHAR 'stv'), (8, VARCHAR 'wxy')");
        this.assertUpdate("DROP MATERIALIZED VIEW %s".formatted(materializedViewName));
        this.assertUpdate("DROP TABLE %s".formatted(sourceTableName));
    }

    @Test
    void testPreviousSnapshotCleanupDuringRefresh() throws IOException {
        String sourceTableName = "source_table" + TestingNames.randomNameSuffix();
        String materializedViewName = "test_materialized_view" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTableName + " (a int, b varchar)");
        this.assertUpdate("INSERT INTO " + sourceTableName + " VALUES (1, 'abc'), (2, 'def')", 2L);
        this.assertUpdate("CREATE MATERIALIZED VIEW " + materializedViewName + " AS SELECT a, b FROM " + sourceTableName + " WHERE a < 3 OR a > 5");
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + materializedViewName, 2L);
        TrinoFileSystem fileSystemFactory = IcebergTestUtils.getFileSystemFactory(this.getQueryRunner()).create(ConnectorIdentity.ofUser((String)"test"));
        Location metadataLocation = Location.of((String)this.getStorageMetadataLocation(materializedViewName));
        FileIterator tableFiles = fileSystemFactory.listFiles(Location.of((String)metadataLocation.toString().substring(0, metadataLocation.toString().indexOf("/metadata"))));
        ImmutableSet.Builder previousDataFiles = ImmutableSet.builder();
        ImmutableSet.Builder previousMetadataFiles = ImmutableSet.builder();
        ImmutableSet.Builder previousManifestsFiles = ImmutableSet.builder();
        while (tableFiles.hasNext()) {
            FileEntry file = tableFiles.next();
            String location = file.location().toString();
            if (location.contains("/data/")) {
                previousDataFiles.add((Object)file);
                continue;
            }
            if (location.contains("/metadata/") && location.endsWith(".json")) {
                previousMetadataFiles.add((Object)file);
                continue;
            }
            if (!location.contains("/metadata") || location.contains("snap-") || !location.endsWith(".avro")) continue;
            previousManifestsFiles.add((Object)file);
        }
        this.assertUpdate("DELETE FROM " + sourceTableName + " WHERE a = 1 OR a = 2", 2L);
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + sourceTableName);
        this.assertUpdate("INSERT INTO " + sourceTableName + " VALUES (7, 'pqr'), (8, 'xyz')", 2L);
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + materializedViewName, 2L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + materializedViewName))).matches("VALUES (7, VARCHAR 'pqr'), (8, VARCHAR 'xyz')");
        Location latestMetadataLocation = Location.of((String)this.getStorageMetadataLocation(materializedViewName));
        FileIterator latestTableFiles = fileSystemFactory.listFiles(Location.of((String)latestMetadataLocation.toString().substring(0, latestMetadataLocation.toString().indexOf("/metadata"))));
        ImmutableSet.Builder currentDataFiles = ImmutableSet.builder();
        ImmutableSet.Builder currentMetadataFiles = ImmutableSet.builder();
        ImmutableSet.Builder currentManifestsFiles = ImmutableSet.builder();
        while (latestTableFiles.hasNext()) {
            FileEntry file = latestTableFiles.next();
            String location = file.location().toString();
            if (location.contains("/data/")) {
                currentDataFiles.add((Object)file);
                continue;
            }
            if (location.contains("/metadata/") && location.endsWith(".json")) {
                currentMetadataFiles.add((Object)file);
                continue;
            }
            if (!location.contains("/metadata") || location.contains("snap-") || !location.endsWith(".avro")) continue;
            currentManifestsFiles.add((Object)file);
        }
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)previousDataFiles.build()).isNotEmpty()).satisfies(new ThrowingConsumer[]{dataFilesBeforeMvRefresh -> ((AbstractCollectionAssert)Assertions.assertThat((Collection)currentDataFiles.build()).isNotEmpty()).doesNotContainAnyElementsOf((Iterable)dataFilesBeforeMvRefresh)});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)previousMetadataFiles.build()).isNotEmpty()).satisfies(new ThrowingConsumer[]{metadataFilesBeforeMvRefresh -> ((AbstractCollectionAssert)Assertions.assertThat((Collection)currentMetadataFiles.build()).isNotEmpty()).containsAll((Iterable)metadataFilesBeforeMvRefresh)});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)previousManifestsFiles.build()).isNotEmpty()).satisfies(new ThrowingConsumer[]{manifestsBeforeMvRefresh -> ((AbstractCollectionAssert)Assertions.assertThat((Collection)currentManifestsFiles.build()).isNotEmpty()).doesNotContainAnyElementsOf((Iterable)manifestsBeforeMvRefresh)});
        this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
        this.assertUpdate("DROP TABLE " + sourceTableName);
    }

    protected String getColumnComment(String tableName, String columnName) {
        return (String)this.computeScalar("SELECT comment FROM information_schema.columns WHERE table_schema = '" + (String)this.getSession().getSchema().orElseThrow() + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'");
    }

    private TableMetadata getStorageTableMetadata(String materializedViewName) {
        QueryRunner queryRunner = this.getQueryRunner();
        TrinoFileSystem fileSystemFactory = IcebergTestUtils.getFileSystemFactory(queryRunner).create(ConnectorIdentity.ofUser((String)"test"));
        Location metadataLocation = Location.of((String)this.getStorageMetadataLocation(materializedViewName));
        return TableMetadataParser.read((FileIO)new ForwardingFileIo(fileSystemFactory), (String)metadataLocation.toString());
    }

    private long getLatestSnapshotId(String tableName) {
        return (Long)this.computeScalar(String.format("SELECT snapshot_id FROM \"%s$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES", tableName));
    }

    private void assertFreshness(String viewName, String expected) {
        Assertions.assertThat((String)((String)this.computeScalar("SELECT freshness FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + viewName + "'"))).isEqualTo(expected);
    }

    public static class SequenceTableFunction
    extends AbstractConnectorTableFunction {
        public SequenceTableFunction() {
            super("system", "sequence_function", List.of(), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new SequenceTableFunctionHandle()).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field("next_value", Optional.of(IntegerType.INTEGER))))).build();
        }
    }

    public static class SequenceTableFunctionHandle
    implements ConnectorTableFunctionHandle {
    }

    public record SequenceConnectorSplit() implements ConnectorSplit
    {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SequenceConnectorSplit.class);

        @JsonIgnore
        public SplitWeight getSplitWeight() {
            return SplitWeight.standard();
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE;
        }
    }

    public static class SequenceFunctionProcessor
    implements TableFunctionSplitProcessor {
        private static final AtomicInteger generator = new AtomicInteger(10);
        private final AtomicBoolean finished = new AtomicBoolean(false);

        public TableFunctionProcessorState process() {
            if (this.finished.get()) {
                return TableFunctionProcessorState.Finished.FINISHED;
            }
            BlockBuilder builder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
            IntegerType.INTEGER.writeInt(builder, generator.getAndIncrement());
            this.finished.set(true);
            return TableFunctionProcessorState.Processed.produced((Page)new Page(new Block[]{builder.build()}));
        }

        public void reset() {
            this.finished.set(false);
        }
    }

    public static class SequenceTableFunctionProcessorProvider
    implements TableFunctionProcessorProvider {
        private final SequenceFunctionProcessor sequenceFunctionProcessor = new SequenceFunctionProcessor();

        public TableFunctionSplitProcessor getSplitProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle, ConnectorSplit split) {
            this.sequenceFunctionProcessor.reset();
            return this.sequenceFunctionProcessor;
        }
    }
}

