/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metastore.Column;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveType;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.minio.MinioClient;
import io.trino.testing.sql.TestTable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public abstract class BaseIcebergMinioConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private final String schemaName;
    private final String bucketName;
    private Hive3MinioDataLake hiveMinioDataLake;

    protected BaseIcebergMinioConnectorSmokeTest(FileFormat format) {
        super(format);
        this.schemaName = "tpch_" + format.name().toLowerCase(Locale.ENGLISH);
        this.bucketName = "test-iceberg-minio-smoke-test-" + TestingNames.randomNameSuffix();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)this.hiveMinioDataLake.getHiveMetastoreEndpoint().toString()).put((Object)"hive.metastore.thrift.client.read-timeout", (Object)"1m").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"s3.max-connections", (Object)"2").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").put((Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").putAll(this.getAdditionalIcebergProperties()).buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName(this.schemaName).withClonedTpchTables(REQUIRED_TPCH_TABLES).withSchemaProperties(Map.of("location", "'s3://" + this.bucketName + "/" + this.schemaName + "'")).build()).build();
    }

    public Map<String, String> getAdditionalIcebergProperties() {
        return ImmutableMap.of();
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA IF NOT EXISTS " + schemaName + " WITH (location = 's3://" + this.bucketName + "/" + schemaName + "')";
    }

    @Test
    public void testRenameSchema() {
        this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", this.schemaName, this.schemaName + TestingNames.randomNameSuffix()), "Hive metastore does not support renaming schemas");
    }

    @Test
    public void testS3LocationWithTrailingSlash() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_s3_location_with_trailing_slash_" + TestingNames.randomNameSuffix();
        String location = "s3://%s/%s/%s/".formatted(this.bucketName, schemaName, tableName);
        Assertions.assertThat((String)location).doesNotContain(new CharSequence[]{"#"});
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location='" + location + "') AS SELECT 1 col", 1L);
        List dataFiles = this.hiveMinioDataLake.getMinioClient().listObjects(this.bucketName, "%s/%s/data".formatted(schemaName, tableName));
        ((ListAssert)((ListAssert)Assertions.assertThat((List)dataFiles).isNotEmpty()).filteredOn(filePath -> filePath.contains("#"))).isEmpty();
        List metadataFiles = this.hiveMinioDataLake.getMinioClient().listObjects(this.bucketName, "%s/%s/metadata".formatted(schemaName, tableName));
        ((ListAssert)((ListAssert)Assertions.assertThat((List)metadataFiles).isNotEmpty()).filteredOn(filePath -> filePath.contains("#"))).isEmpty();
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN new_col int");
        this.assertTableColumnNames(tableName, new String[]{"col", "new_col"});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMetadataLocationWithDoubleSlash() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "test_meatdata_location_with_double_slash_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 col", 1L);
        String tableId = this.onMetastore("SELECT tbl_id FROM TBLS t INNER JOIN DBS db ON t.db_id = db.db_id WHERE db.name = '" + schemaName + "' and t.tbl_name = '" + tableName + "'");
        String metadataLocation = this.onMetastore("SELECT param_value FROM TABLE_PARAMS WHERE param_key = 'metadata_location' AND tbl_id = " + tableId);
        String newMetadataLocation = metadataLocation.replace("/metadata/", "//metadata/");
        this.onMetastore("UPDATE TABLE_PARAMS SET param_value = '" + newMetadataLocation + "' WHERE tbl_id = " + tableId + " AND param_key = 'metadata_location'");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1), (2)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testHiveMetastoreTableParameter() {
        try (TestTable table = this.newTrinoTable("test_table_params", "(id int)");){
            String snapshotId = this.getTableParameterValue(table.getName(), "current-snapshot-id");
            String snapshotTimestamp = this.getTableParameterValue(table.getName(), "current-snapshot-timestamp-ms");
            Assertions.assertThat((String)snapshotId).isNotNull();
            Assertions.assertThat((String)snapshotTimestamp).isNotNull();
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            Assertions.assertThat((String)this.getTableParameterValue(table.getName(), "current-snapshot-id")).isNotEqualTo((Object)snapshotId);
            Assertions.assertThat((String)this.getTableParameterValue(table.getName(), "current-snapshot-timestamp-ms")).isNotEqualTo((Object)snapshotTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testHiveMetastoreMaterializedParameter() {
        String mvName = "test_mv_params_" + TestingNames.randomNameSuffix();
        try (TestTable table = this.newTrinoTable("test_mv_params", "(id int)");){
            this.assertUpdate("CREATE MATERIALIZED VIEW " + mvName + " AS SELECT * FROM " + table.getName());
            String snapshotId = this.getTableParameterValue(mvName, "current-snapshot-id");
            String snapshotTimestamp = this.getTableParameterValue(mvName, "current-snapshot-timestamp-ms");
            Assertions.assertThat((String)snapshotId).isNotNull();
            Assertions.assertThat((String)snapshotTimestamp).isNotNull();
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + mvName, 1L);
            Assertions.assertThat((String)this.getTableParameterValue(mvName, "current-snapshot-id")).isNotEqualTo((Object)snapshotId);
            Assertions.assertThat((String)this.getTableParameterValue(mvName, "current-snapshot-timestamp-ms")).isNotEqualTo((Object)snapshotTimestamp);
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW IF EXISTS " + mvName);
        }
    }

    private String getTableParameterValue(String tableName, String parameterKey) {
        String tableId = this.onMetastore("SELECT tbl_id FROM TBLS t INNER JOIN DBS db ON t.db_id = db.db_id WHERE db.name = '" + this.schemaName + "' and t.tbl_name = '" + tableName + "'");
        return this.onMetastore("SELECT param_value FROM TABLE_PARAMS WHERE param_key = '" + parameterKey + "' AND tbl_id = " + tableId);
    }

    @Test
    public void testExpireSnapshotsBatchDeletes() {
        String tableName = "test_expiring_snapshots_" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = this.prepareCleanUpSession();
        String location = "s3://%s/%s/%s/".formatted(this.bucketName, this.schemaName, tableName);
        ConcurrentLinkedQueue events = new ConcurrentLinkedQueue();
        this.hiveMinioDataLake.getMinioClient().captureBucketNotifications(this.bucketName, event -> {
            if (event.eventType().toString().toLowerCase(Locale.ENGLISH).contains("remove")) {
                events.add(event);
            }
        });
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer) WITH (location='" + location + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (VARCHAR 'one', 1), (VARCHAR 'two', 2)");
        List initialMetadataFiles = this.hiveMinioDataLake.getMinioClient().listObjects(this.bucketName, "%s/%s/metadata".formatted(this.schemaName, tableName));
        Assertions.assertThat((List)initialMetadataFiles).isNotEmpty();
        List<Long> initialSnapshots = this.getSnapshotIds(tableName);
        Assertions.assertThat(initialSnapshots).hasSizeGreaterThan(1);
        this.assertQuerySucceeds(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE EXPIRE_SNAPSHOTS (retention_threshold => '0s')");
        List updatedMetadataFiles = this.hiveMinioDataLake.getMinioClient().listObjects(this.bucketName, "%s/%s/metadata".formatted(this.schemaName, tableName));
        ((ListAssert)Assertions.assertThat((List)updatedMetadataFiles).isNotEmpty()).hasSizeLessThan(initialMetadataFiles.size());
        List<Long> updatedSnapshots = this.getSnapshotIds(tableName);
        Assertions.assertThat(updatedSnapshots).hasSize(1);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (VARCHAR 'one', 1), (VARCHAR 'two', 2)");
        Assertions.assertThat(events).hasSize(3);
        Assertions.assertThat((Collection)((Collection)events.stream().map(event -> (String)event.responseElements().get("x-amz-request-id")).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPathContainsSpecialCharacter() {
        String tableName = "test_path_special_character" + TestingNames.randomNameSuffix();
        String location = "s3://%s/%s/%s/".formatted(this.bucketName, this.schemaName, tableName);
        this.assertUpdate(String.format("CREATE TABLE %s (id bigint, part varchar) WITH (partitioning = ARRAY['part'], location='%s')", tableName, location));
        String values = "(1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslashes'),(6, 'with\\backslash'),(7, 'with=equal'),(8, 'with?question'),(9, 'with!exclamation'),(10, 'with%percent'),(11, 'with%%percents'),(12, 'with space')";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + values, 12L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES " + values);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Override
    protected AutoCloseable createSparkIcebergTable(String schema) {
        HiveMetastore metastore = IcebergTestUtils.getHiveMetastore(this.getQueryRunner());
        Table lowerCaseTableType = Table.builder().setDatabaseName(schema).setTableName("lowercase_type_" + TestingNames.randomNameSuffix()).setOwner(Optional.empty()).setDataColumns((List)ImmutableList.of((Object)new Column("id", HiveType.HIVE_STRING, Optional.empty(), (Map)ImmutableMap.of()))).setTableType(TableType.EXTERNAL_TABLE.name()).withStorage(storage -> storage.setStorageFormat(AbstractIcebergTableOperations.ICEBERG_METASTORE_STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("table_type", "iceberg".toLowerCase(Locale.ENGLISH)).build();
        metastore.createTable(lowerCaseTableType, PrincipalPrivileges.NO_PRIVILEGES);
        return () -> metastore.dropTable(lowerCaseTableType.getDatabaseName(), lowerCaseTableType.getTableName(), true);
    }

    private String onMetastore(@Language(value="SQL") String sql) {
        return this.hiveMinioDataLake.getHiveHadoop().runOnMetastore(sql);
    }

    private Session prepareCleanUpSession() {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "expire_snapshots_min_retention", "0s").build();
    }

    private List<Long> getSnapshotIds(String tableName) {
        return (List)this.getQueryRunner().execute(String.format("SELECT snapshot_id FROM \"%s$snapshots\"", tableName)).getOnlyColumn().map(Long.class::cast).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        BaseIcebergMinioConnectorSmokeTest baseIcebergMinioConnectorSmokeTest = this;
        BridgingHiveMetastore metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveMinioDataLake.getHiveMetastoreEndpoint()).build(x$0 -> baseIcebergMinioConnectorSmokeTest.closeAfterClass((AutoCloseable)x$0)));
        metastore.dropTable(this.schemaName, tableName, false);
        Assertions.assertThat((Optional)metastore.getTable(this.schemaName, tableName)).isEmpty();
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        BaseIcebergMinioConnectorSmokeTest baseIcebergMinioConnectorSmokeTest = this;
        BridgingHiveMetastore metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveMinioDataLake.getHiveMetastoreEndpoint()).build(x$0 -> baseIcebergMinioConnectorSmokeTest.closeAfterClass((AutoCloseable)x$0)));
        return (String)((Table)metastore.getTable(this.schemaName, tableName).orElseThrow()).getParameters().get("metadata_location");
    }

    @Override
    protected String schemaPath() {
        return String.format("s3://%s/%s", this.bucketName, this.schemaName);
    }

    @Override
    protected boolean locationExists(String location) {
        String prefix = "s3://" + this.bucketName + "/";
        return !this.hiveMinioDataLake.listFiles(location.substring(prefix.length())).isEmpty();
    }

    @Override
    protected void deleteDirectory(String location) {
        String prefix = "s3://" + this.bucketName + "/";
        String key = location.substring(prefix.length());
        MinioClient minio = this.hiveMinioDataLake.getMinioClient();
        for (String file : minio.listObjects(this.bucketName, key)) {
            minio.removeObject(this.bucketName, file);
        }
        Assertions.assertThat((List)minio.listObjects(this.bucketName, key)).isEmpty();
    }
}

