/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.util.EqualityDeleteUtils;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseIcebergSystemTables
extends AbstractTestQueryFramework {
    private final IcebergFileFormat format;
    private HiveMetastore metastore;
    private TrinoFileSystemFactory fileSystemFactory;

    protected BaseIcebergSystemTables(IcebergFileFormat format) {
        this.format = Objects.requireNonNull(format, "format is null");
    }

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.of((Object)"iceberg.file-format", (Object)this.format.name())).build();
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        this.fileSystemFactory = IcebergTestUtils.getFileSystemFactory((QueryRunner)queryRunner);
        return queryRunner;
    }

    @BeforeAll
    public void setUp() {
        this.assertUpdate("CREATE SCHEMA test_schema");
        this.assertUpdate("CREATE TABLE test_schema.test_table (_bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO test_schema.test_table VALUES (0, CAST('2019-09-08' AS DATE)), (1, CAST('2019-09-09' AS DATE)), (2, CAST('2019-09-09' AS DATE))", 3L);
        this.assertUpdate("INSERT INTO test_schema.test_table VALUES (3, CAST('2019-09-09' AS DATE)), (4, CAST('2019-09-10' AS DATE)), (5, CAST('2019-09-10' AS DATE))", 3L);
        this.assertQuery("SELECT count(*) FROM test_schema.test_table", "VALUES 6");
        this.assertUpdate("CREATE TABLE test_schema.test_table_multilevel_partitions (_varchar VARCHAR, _bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_bigint', '_date'])");
        this.assertUpdate("INSERT INTO test_schema.test_table_multilevel_partitions VALUES ('a', 0, CAST('2019-09-08' AS DATE)), ('a', 1, CAST('2019-09-08' AS DATE)), ('a', 0, CAST('2019-09-09' AS DATE))", 3L);
        this.assertQuery("SELECT count(*) FROM test_schema.test_table_multilevel_partitions", "VALUES 3");
        this.assertUpdate("CREATE TABLE test_schema.test_table_drop_column (_varchar VARCHAR, _bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO test_schema.test_table_drop_column VALUES ('a', 0, CAST('2019-09-08' AS DATE)), ('a', 1, CAST('2019-09-09' AS DATE)), ('b', 2, CAST('2019-09-09' AS DATE))", 3L);
        this.assertUpdate("INSERT INTO test_schema.test_table_drop_column VALUES ('c', 3, CAST('2019-09-09' AS DATE)), ('a', 4, CAST('2019-09-10' AS DATE)), ('b', 5, CAST('2019-09-10' AS DATE))", 3L);
        this.assertQuery("SELECT count(*) FROM test_schema.test_table_drop_column", "VALUES 6");
        this.assertUpdate("ALTER TABLE test_schema.test_table_drop_column DROP COLUMN _varchar");
        this.assertUpdate("CREATE TABLE test_schema.test_table_nan (_bigint BIGINT, _double DOUBLE, _real REAL, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO test_schema.test_table_nan VALUES (1, 1.1, 1.2, CAST('2022-01-01' AS DATE)), (2, nan(), 2.2, CAST('2022-01-02' AS DATE)), (3, 3.3, nan(), CAST('2022-01-03' AS DATE))", 3L);
        this.assertUpdate("INSERT INTO test_schema.test_table_nan VALUES (4, nan(), 4.1, CAST('2022-01-04' AS DATE)), (5, 4.2, nan(), CAST('2022-01-04' AS DATE)), (6, nan(), nan(), CAST('2022-01-04' AS DATE))", 3L);
        this.assertQuery("SELECT count(*) FROM test_schema.test_table_nan", "VALUES 6");
        this.assertUpdate("CREATE TABLE test_schema.test_table_with_dml (_varchar VARCHAR, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO test_schema.test_table_with_dml VALUES ('a1', DATE '2022-01-01'), ('a2', DATE '2022-01-01'), ('b1', DATE '2022-02-02'), ('b2', DATE '2022-02-02'), ('c1', DATE '2022-03-03'), ('c2', DATE '2022-03-03')", 6L);
        this.assertUpdate("UPDATE test_schema.test_table_with_dml SET _varchar = 'a1.updated' WHERE _date = DATE '2022-01-01' AND _varchar = 'a1'", 1L);
        this.assertUpdate("DELETE FROM test_schema.test_table_with_dml WHERE _date = DATE '2022-02-02' AND _varchar = 'b2'", 1L);
        this.assertUpdate("INSERT INTO test_schema.test_table_with_dml VALUES ('c3', DATE '2022-03-03'), ('d1', DATE '2022-04-04')", 2L);
        this.assertQuery("SELECT count(*) FROM test_schema.test_table_with_dml", "VALUES 7");
    }

    @AfterAll
    public void tearDown() {
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_table");
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_table_multilevel_partitions");
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_table_drop_column");
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_table_nan");
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_table_with_dml");
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_metadata_log_entries");
        this.assertUpdate("DROP SCHEMA IF EXISTS test_schema");
    }

    @Test
    public void testPartitionsTable() {
        this.assertQuery("SELECT count(*) FROM test_schema.test_table", "VALUES 6");
        this.assertQuery("SHOW COLUMNS FROM test_schema.\"test_table$partitions\"", "VALUES ('partition', 'row(_date date)', '', ''),('record_count', 'bigint', '', ''),('file_count', 'bigint', '', ''),('total_size', 'bigint', '', ''),('data', 'row(_bigint row(min bigint, max bigint, null_count bigint, nan_count bigint))', '', '')");
        MaterializedResult result = this.computeActual("SELECT * from test_schema.\"test_table$partitions\"");
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        Map rowsByPartition = (Map)result.getMaterializedRows().stream().collect(ImmutableMap.toImmutableMap(row -> (LocalDate)((MaterializedRow)row.getField(0)).getField(0), Function.identity()));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2019-09-08"))).getField(1)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2019-09-09"))).getField(1)).isEqualTo((Object)3L);
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2019-09-10"))).getField(1)).isEqualTo((Object)2L);
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2019-09-08"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{0L, 0L, 0L, null})}));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2019-09-09"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{1L, 3L, 0L, null})}));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2019-09-10"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{4L, 5L, 0L, null})}));
    }

    @Test
    public void testPartitionsTableWithNan() {
        this.assertQuery("SELECT count(*) FROM test_schema.test_table_nan", "VALUES 6");
        MaterializedResult result = this.computeActual("SELECT * from test_schema.\"test_table_nan$partitions\"");
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        Map rowsByPartition = (Map)result.getMaterializedRows().stream().collect(ImmutableMap.toImmutableMap(row -> (LocalDate)((MaterializedRow)row.getField(0)).getField(0), Function.identity()));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-01"))).getField(1)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-02"))).getField(1)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-03"))).getField(1)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-04"))).getField(1)).isEqualTo((Object)3L);
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-01"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{1L, 1L, 0L, null}), new MaterializedRow(5, new Object[]{1.1, 1.1, 0L, null}), new MaterializedRow(5, new Object[]{Float.valueOf(1.2f), Float.valueOf(1.2f), 0L, null})}));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-02"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{2L, 2L, 0L, null}), new MaterializedRow(5, new Object[]{null, null, 0L, this.nanCount(1L)}), new MaterializedRow(5, new Object[]{Float.valueOf(2.2f), Float.valueOf(2.2f), 0L, null})}));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-03"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{3L, 3L, 0L, null}), new MaterializedRow(5, new Object[]{3.3, 3.3, 0L, null}), new MaterializedRow(5, new Object[]{null, null, 0L, this.nanCount(1L)})}));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartition.get(LocalDate.parse("2022-01-04"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{4L, 6L, 0L, null}), new MaterializedRow(5, new Object[]{null, null, 0L, this.nanCount(2L)}), new MaterializedRow(5, new Object[]{null, null, 0L, this.nanCount(2L)})}));
    }

    @Test
    public void testPartitionsTableAfterAddColumn() {
        try (TestTable table = this.newTrinoTable("test_partitions_new_column", "AS SELECT 1 col");){
            Assertions.assertThat((Object)this.computeScalar("SELECT data.col FROM \"" + table.getName() + "$partitions\"")).isEqualTo((Object)new MaterializedRow(5, new Object[]{1, 1, 0L, null}));
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN new_col int");
            Assertions.assertThat((Object)this.computeScalar("SELECT data.col FROM \"" + table.getName() + "$partitions\"")).isEqualTo((Object)new MaterializedRow(5, new Object[]{1, 1, 0L, null}));
            Assertions.assertThat((Object)this.computeScalar("SELECT data.new_col FROM \"" + table.getName() + "$partitions\"")).isNull();
        }
    }

    @Test
    public void testPartitionsTableOnDropColumn() {
        MaterializedResult resultAfterDrop = this.computeActual("SELECT * from test_schema.\"test_table_drop_column$partitions\"");
        Assertions.assertThat((int)resultAfterDrop.getRowCount()).isEqualTo(3);
        Map rowsByPartitionAfterDrop = (Map)resultAfterDrop.getMaterializedRows().stream().collect(ImmutableMap.toImmutableMap(row -> (LocalDate)((MaterializedRow)row.getField(0)).getField(0), Function.identity()));
        Assertions.assertThat((Object)((MaterializedRow)rowsByPartitionAfterDrop.get(LocalDate.parse("2019-09-08"))).getField(4)).isEqualTo((Object)new MaterializedRow(5, new Object[]{new MaterializedRow(5, new Object[]{0L, 0L, 0L, null})}));
    }

    @Test
    public void testFilesTableOnDropColumn() {
        this.assertQuery("SELECT sum(record_count) FROM test_schema.\"test_table_drop_column$files\"", "VALUES 6");
    }

    @Test
    public void testHistoryTable() {
        this.assertQuery("SHOW COLUMNS FROM test_schema.\"test_table$history\"", "VALUES ('made_current_at', 'timestamp(3) with time zone', '', ''),('snapshot_id', 'bigint', '', ''),('parent_id', 'bigint', '', ''),('is_current_ancestor', 'boolean', '', '')");
        this.assertQuery("SELECT count(*) FROM test_schema.\"test_table$history\"", "VALUES 3");
    }

    @Test
    public void testMetadataLogEntriesTable() {
        this.assertQuery("SHOW COLUMNS FROM test_schema.\"test_table$metadata_log_entries\"", "VALUES ('timestamp', 'timestamp(3) with time zone', '', ''),('file', 'varchar', '', ''),('latest_snapshot_id', 'bigint', '', ''),('latest_schema_id', 'integer', '', ''),('latest_sequence_number', 'bigint', '', '')");
        ArrayList<Integer> latestSchemaIds = new ArrayList<Integer>();
        ArrayList<Long> latestSequenceNumbers = new ArrayList<Long>();
        this.assertUpdate("CREATE TABLE test_schema.test_metadata_log_entries (c1 BIGINT)");
        latestSchemaIds.add(0);
        latestSequenceNumbers.add(1L);
        this.assertMetadataLogEntries(latestSchemaIds, latestSequenceNumbers);
        this.assertUpdate("INSERT INTO test_schema.test_metadata_log_entries VALUES (1)", 1L);
        latestSchemaIds.add(0);
        latestSchemaIds.add(0);
        latestSequenceNumbers.add(2L);
        latestSequenceNumbers.add(2L);
        this.assertMetadataLogEntries(latestSchemaIds, latestSequenceNumbers);
        this.assertUpdate("ALTER TABLE test_schema.test_metadata_log_entries ADD COLUMN c2 VARCHAR");
        latestSchemaIds.add(0);
        latestSequenceNumbers.add(2L);
        this.assertMetadataLogEntries(latestSchemaIds, latestSequenceNumbers);
        this.assertUpdate("DELETE FROM test_schema.test_metadata_log_entries WHERE c1 = 1", 1L);
        latestSchemaIds.add(1);
        latestSequenceNumbers.add(3L);
        this.assertMetadataLogEntries(latestSchemaIds, latestSequenceNumbers);
        this.assertUpdate("ALTER TABLE test_schema.test_metadata_log_entries execute optimize");
        latestSchemaIds.add(1);
        latestSchemaIds.add(1);
        latestSequenceNumbers.add(4L);
        latestSequenceNumbers.add(4L);
        this.assertMetadataLogEntries(latestSchemaIds, latestSequenceNumbers);
        this.assertUpdate("CREATE OR REPLACE TABLE test_schema.test_metadata_log_entries (c3 INTEGER)");
        latestSchemaIds.add(2);
        latestSequenceNumbers.add(5L);
        this.assertMetadataLogEntries(latestSchemaIds, latestSequenceNumbers);
        this.assertUpdate("INSERT INTO test_schema.test_metadata_log_entries VALUES (1)", 1L);
        latestSchemaIds.add(2);
        latestSequenceNumbers.add(6L);
        latestSchemaIds.add(2);
        latestSequenceNumbers.add(6L);
        this.assertMetadataLogEntries(latestSchemaIds, latestSequenceNumbers);
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_metadata_log_entries");
    }

    private void assertMetadataLogEntries(List<Integer> latestSchemaIds, List<Long> latestSequenceNumbers) {
        MaterializedResult result = this.computeActual("SELECT latest_schema_id, latest_sequence_number FROM test_schema.\"test_metadata_log_entries$metadata_log_entries\" ORDER BY timestamp");
        List materializedRows = result.getMaterializedRows();
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(latestSchemaIds.size());
        for (int i = 0; i < result.getRowCount(); ++i) {
            Assertions.assertThat((Object)((MaterializedRow)materializedRows.get(i)).getField(0)).isEqualTo((Object)latestSchemaIds.get(i));
            Assertions.assertThat((Object)((MaterializedRow)materializedRows.get(i)).getField(1)).isEqualTo((Object)latestSequenceNumbers.get(i));
        }
    }

    @Test
    public void testSnapshotsTable() {
        this.assertQuery("SHOW COLUMNS FROM test_schema.\"test_table$snapshots\"", "VALUES ('committed_at', 'timestamp(3) with time zone', '', ''),('snapshot_id', 'bigint', '', ''),('parent_id', 'bigint', '', ''),('operation', 'varchar', '', ''),('manifest_list', 'varchar', '', ''),('summary', 'map(varchar, varchar)', '', '')");
        this.assertQuery("SELECT operation FROM test_schema.\"test_table$snapshots\"", "VALUES 'append', 'append', 'append'");
        this.assertQuery("SELECT summary['total-records'] FROM test_schema.\"test_table$snapshots\"", "VALUES '0', '3', '6'");
    }

    @Test
    void testAllManifests() {
        try (TestTable table = this.newTrinoTable("test_all_manifests", "(x) AS VALUES 1, 2");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM \"" + table.getName() + "$all_manifests\""))).skippingTypesCheck().matches("VALUES ('path', 'varchar', '', ''),('length', 'bigint', '', ''),('partition_spec_id', 'integer', '', ''),('added_snapshot_id', 'bigint', '', ''),('added_data_files_count', 'integer', '', ''),('existing_data_files_count', 'integer', '', ''),('deleted_data_files_count', 'integer', '', ''),('added_delete_files_count', 'integer', '', ''),('existing_delete_files_count', 'integer', '', ''),('deleted_delete_files_count', 'integer', '', ''),('partition_summaries', 'array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar))', '', ''),('reference_snapshot_id', 'bigint', '', '')");
            Assertions.assertThat((String)((String)this.computeScalar("SELECT path FROM \"" + table.getName() + "$all_manifests\""))).endsWith((CharSequence)"-m0.avro");
            Assertions.assertThat((Long)((Long)this.computeScalar("SELECT length FROM \"" + table.getName() + "$all_manifests\""))).isPositive();
            Assertions.assertThat((Integer)((Integer)this.computeScalar("SELECT partition_spec_id FROM \"" + table.getName() + "$all_manifests\""))).isZero();
            Assertions.assertThat((Long)((Long)this.computeScalar("SELECT added_snapshot_id FROM \"" + table.getName() + "$all_manifests\""))).isPositive();
            Assertions.assertThat((Integer)((Integer)this.computeScalar("SELECT added_data_files_count FROM \"" + table.getName() + "$all_manifests\""))).isEqualTo(1);
            Assertions.assertThat((Integer)((Integer)this.computeScalar("SELECT existing_data_files_count FROM \"" + table.getName() + "$all_manifests\""))).isZero();
            Assertions.assertThat((Integer)((Integer)this.computeScalar("SELECT deleted_data_files_count FROM \"" + table.getName() + "$all_manifests\""))).isZero();
            Assertions.assertThat((Integer)((Integer)this.computeScalar("SELECT added_delete_files_count FROM \"" + table.getName() + "$all_manifests\""))).isZero();
            Assertions.assertThat((Integer)((Integer)this.computeScalar("SELECT existing_delete_files_count FROM \"" + table.getName() + "$all_manifests\""))).isZero();
            Assertions.assertThat((Integer)((Integer)this.computeScalar("SELECT deleted_delete_files_count FROM \"" + table.getName() + "$all_manifests\""))).isZero();
            Assertions.assertThat((List)((List)this.computeScalar("SELECT partition_summaries FROM \"" + table.getName() + "$all_manifests\""))).isEmpty();
            Assertions.assertThat((Long)((Long)this.computeScalar("SELECT reference_snapshot_id FROM \"" + table.getName() + "$all_manifests\""))).isPositive();
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE x = 1", 1L);
            Assertions.assertThat((Long)((Long)this.computeScalar("SELECT count(1) FROM \"" + table.getName() + "$all_manifests\""))).isEqualTo(3L);
            Assertions.assertThat((Long)((Long)this.computeScalar("SELECT count(1) FROM \"" + table.getName() + "$all_manifests\" WHERE added_delete_files_count > 0"))).isEqualTo(1L);
        }
    }

    @Test
    void testAllManifestsWithPartitionTable() {
        try (TestTable table = this.newTrinoTable("test_all_manifests", "WITH (partitioning = ARRAY['dt']) AS SELECT 1 x, DATE '2021-01-01' dt");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition_summaries FROM \"" + table.getName() + "$all_manifests\""))).matches("VALUES CAST(ARRAY[ROW(false, false, VARCHAR '2021-01-01', VARCHAR '2021-01-01')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar)))");
        }
    }

    @Test
    public void testManifestsTable() {
        this.assertQuery("SHOW COLUMNS FROM test_schema.\"test_table$manifests\"", "VALUES ('path', 'varchar', '', ''),('length', 'bigint', '', ''),('partition_spec_id', 'integer', '', ''),('added_snapshot_id', 'bigint', '', ''),('added_data_files_count', 'integer', '', ''),('added_rows_count', 'bigint', '', ''),('existing_data_files_count', 'integer', '', ''),('existing_rows_count', 'bigint', '', ''),('deleted_data_files_count', 'integer', '', ''),('deleted_rows_count', 'bigint', '', ''),('partition_summaries', 'array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar))', '', '')");
        this.assertQuerySucceeds("SELECT * FROM test_schema.\"test_table$manifests\"");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT added_data_files_count, existing_rows_count, added_rows_count, deleted_data_files_count, deleted_rows_count, partition_summaries FROM test_schema.\"test_table$manifests\""))).matches("VALUES     (2, BIGINT '0', BIGINT '3', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '2019-09-08', '2019-09-09')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar)))) ,     (2, BIGINT '0', BIGINT '3', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '2019-09-09', '2019-09-10')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar))))");
        this.assertQuerySucceeds("SELECT * FROM test_schema.\"test_table_multilevel_partitions$manifests\"");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT added_data_files_count, existing_rows_count, added_rows_count, deleted_data_files_count, deleted_rows_count, partition_summaries FROM test_schema.\"test_table_multilevel_partitions$manifests\""))).matches("VALUES (3, BIGINT '0', BIGINT '3', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '0', '1'), ROW(false, false, '2019-09-08', '2019-09-09')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar))))");
        this.assertQuerySucceeds("SELECT * FROM test_schema.\"test_table_with_dml$manifests\"");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT added_data_files_count, existing_rows_count, added_rows_count, deleted_data_files_count, deleted_rows_count, partition_summaries FROM test_schema.\"test_table_with_dml$manifests\""))).matches("VALUES (3, BIGINT '0', BIGINT '6', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '2022-01-01', '2022-03-03')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar)))), (1, BIGINT '0', BIGINT '1', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '2022-01-01', '2022-01-01')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar)))), (1, BIGINT '0', BIGINT '1', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '2022-01-01', '2022-01-01')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar)))), (1, BIGINT '0', BIGINT '1', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '2022-02-02', '2022-02-02')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar)))), (2, BIGINT '0', BIGINT '2', 0, BIGINT '0', CAST(ARRAY[ROW(false, false, '2022-03-03', '2022-04-04')] AS array(row(contains_null boolean, contains_nan boolean, lower_bound varchar, upper_bound varchar))))");
    }

    @Test
    public void testFilesTable() {
        try (TestTable table = this.newTrinoTable("test_files_table", "AS SELECT 1 x");){
            MaterializedResult result = this.computeActual("DESCRIBE " + table.getName());
            Assertions.assertThat(result.getMaterializedRows().stream().map(row -> (String)row.getField(0))).doesNotContain((Object[])new String[]{"partition"});
            this.assertQuerySucceeds("SELECT * FROM \"" + table.getName() + "$files\"");
        }
    }

    @Test
    public void testFilesPartitionTable() {
        this.assertQuery("SHOW COLUMNS FROM test_schema.\"test_table$files\"", "VALUES ('content', 'integer', '', ''),('file_path', 'varchar', '', ''),('file_format', 'varchar', '', ''),('spec_id', 'integer', '', ''),('partition', 'row(_date date)', '', ''),('record_count', 'bigint', '', ''),('file_size_in_bytes', 'bigint', '', ''),('column_sizes', 'map(integer, bigint)', '', ''),('value_counts', 'map(integer, bigint)', '', ''),('null_value_counts', 'map(integer, bigint)', '', ''),('nan_value_counts', 'map(integer, bigint)', '', ''),('lower_bounds', 'map(integer, varchar)', '', ''),('upper_bounds', 'map(integer, varchar)', '', ''),('key_metadata', 'varbinary', '', ''),('split_offsets', 'array(bigint)', '', ''),('equality_ids', 'array(integer)', '', ''),('sort_order_id', 'integer', '', ''),('readable_metrics', 'json', '', '')");
        this.assertQuerySucceeds("SELECT * FROM test_schema.\"test_table$files\"");
        long offset = this.format == IcebergFileFormat.PARQUET ? 4L : 3L;
        Assertions.assertThat((Iterable)this.computeActual("SELECT split_offsets FROM test_schema.\"test_table$files\"")).isEqualTo((Object)MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT))).row(new Object[]{ImmutableList.of((Object)offset)}).row(new Object[]{ImmutableList.of((Object)offset)}).row(new Object[]{ImmutableList.of((Object)offset)}).row(new Object[]{ImmutableList.of((Object)offset)}).build());
    }

    @Test
    void testFilesTableReadableMetrics() {
        this.testFilesTableReadableMetrics("boolean", "VALUES  true, false, NULL", "{\"x\":{\"column_size\":" + this.columnSize(33L) + ",\"value_count\":3,\"null_value_count\":1,\"nan_value_count\":null,\"lower_bound\":false,\"upper_bound\":true}}");
        this.testFilesTableReadableMetrics("int", "VALUES -1, 1", "{\"x\":{\"column_size\":" + this.columnSize(40L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":-1,\"upper_bound\":1}}");
        this.testFilesTableReadableMetrics("bigint", "VALUES -123, 999", "{\"x\":{\"column_size\":" + this.columnSize(48L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":-123,\"upper_bound\":999}}");
        this.testFilesTableReadableMetrics("real", "VALUES -1.1, 1.1, nan()", "{\"x\":{\"column_size\":" + this.columnSize(44L) + ",\"value_count\":3,\"null_value_count\":0,\"nan_value_count\":" + this.nanCount(1L) + ",\"lower_bound\":null,\"upper_bound\":null}}");
        this.testFilesTableReadableMetrics("double", "VALUES -1.1, 1.1, nan()", "{\"x\":{\"column_size\":" + this.columnSize(53L) + ",\"value_count\":3,\"null_value_count\":0,\"nan_value_count\":" + this.nanCount(1L) + ",\"lower_bound\":null,\"upper_bound\":null}}");
        this.testFilesTableReadableMetrics("decimal(3,1)", "VALUES -3.14, 3.14", "{\"x\":{\"column_size\":" + this.columnSize(40L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":\"-3.1\",\"upper_bound\":\"3.1\"}}");
        this.testFilesTableReadableMetrics("date", "VALUES DATE '1960-01-01', DATE '9999-12-31'", "{\"x\":{\"column_size\":" + this.columnSize(40L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":\"1960-01-01\",\"upper_bound\":\"9999-12-31\"}}");
        this.testFilesTableReadableMetrics("time", "VALUES TIME '00:00:00.000', TIME '12:34:56.999999'", "{\"x\":{\"column_size\":" + this.columnSize(48L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":\"00:00:00\",\"upper_bound\":\"12:34:56.999999\"}}");
        this.testFilesTableReadableMetrics("timestamp", "VALUES TIMESTAMP '1960-01-01 00:00:00', TIMESTAMP '9999-12-31 12:34:56.999999'", "{\"x\":{\"column_size\":" + this.columnSize(48L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":\"1960-01-01T00:00:00\",\"upper_bound\":\"9999-12-31T12:34:56.999999\"}}");
        this.testFilesTableReadableMetrics("timestamp with time zone", "VALUES TIMESTAMP '1960-01-01 00:00:00 UTC', TIMESTAMP '9999-12-31 12:34:56.999999 UTC'", "{\"x\":{\"column_size\":" + this.columnSize(48L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":\"1960-01-01T00:00:00+00:00\",\"upper_bound\":\"9999-12-31T12:34:56.999999+00:00\"}}");
        this.testFilesTableReadableMetrics("varchar", "VALUES 'alice', 'bob'", "{\"x\":{\"column_size\":" + this.columnSize(48L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":\"alice\",\"upper_bound\":\"bob\"}}");
        this.testFilesTableReadableMetrics("uuid", "VALUES UUID '09e1efb9-9e87-465e-abaf-0c67f4841114', UUID '0f2ef2b3-3c5a-4834-ba91-61be53ff8fbb'", "{\"x\":{\"column_size\":" + this.columnSize(64L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":" + String.valueOf(this.value("\"09e1efb9-9e87-465e-abaf-0c67f4841114\"", null)) + ",\"upper_bound\":" + String.valueOf(this.value("\"0f2ef2b3-3c5a-4834-ba91-61be53ff8fbb\"", null)) + "}}");
        this.testFilesTableReadableMetrics("varbinary", "VALUES x'12', x'34'", "{\"x\":{\"column_size\":" + this.columnSize(42L) + ",\"value_count\":2,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":" + String.valueOf(this.value("\"12\"", null)) + ",\"upper_bound\":" + String.valueOf(this.value("\"34\"", null)) + "}}");
        this.testFilesTableReadableMetrics("row(y int)", "SELECT (CAST(ROW(123) AS ROW(y int)))", "{\"x.y\":{\"column_size\":" + this.columnSize(37L) + ",\"value_count\":1,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":123,\"upper_bound\":123}}");
        this.testFilesTableReadableMetrics("array(int)", "VALUES ARRAY[123]", "{\"x.element\":{\"column_size\":" + this.columnSize(43L) + ",\"value_count\":" + String.valueOf(this.value(1, null)) + ",\"null_value_count\":" + String.valueOf(this.value(0, null)) + ",\"nan_value_count\":null,\"lower_bound\":null,\"upper_bound\":null}}");
        this.testFilesTableReadableMetrics("map(int, int)", "VALUES map(ARRAY[1,3], ARRAY[2,4])", "{\"x.key\":{\"column_size\":" + this.columnSize(47L) + ",\"value_count\":" + String.valueOf(this.value(2, null)) + ",\"null_value_count\":" + String.valueOf(this.value(0, null)) + ",\"nan_value_count\":null,\"lower_bound\":null,\"upper_bound\":null},\"x.value\":{\"column_size\":" + this.columnSize(47L) + ",\"value_count\":" + String.valueOf(this.value(2, null)) + ",\"null_value_count\":" + String.valueOf(this.value(0, null)) + ",\"nan_value_count\":null,\"lower_bound\":null,\"upper_bound\":null}}");
    }

    private void testFilesTableReadableMetrics(@Language(value="SQL") String type, @Language(value="SQL") String values, String ... readableMetrics) {
        try (TestTable table = this.newTrinoTable("test_files_table", "(x " + type + ")");){
            this.getQueryRunner().execute("INSERT INTO " + table.getName() + " " + values);
            Assertions.assertThat((Collection)this.computeActual("SELECT readable_metrics FROM \"" + table.getName() + "$files\"").getOnlyColumnAsSet()).containsExactlyInAnyOrder((Object[])readableMetrics);
        }
    }

    @Test
    public void testFilesSchemaEvolution() {
        try (TestTable table = this.newTrinoTable("test_files_table", "WITH (partitioning = ARRAY['part']) AS SELECT 1 x, 2 part");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM \"" + table.getName() + "$files\""))).matches("SELECT CAST(ROW(2) AS ROW(part int))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN another_part int");
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES partitioning = ARRAY['part', 'another_part']");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM \"" + table.getName() + "$files\""))).matches("SELECT CAST(ROW(2, NULL) AS ROW(part int, another_part int))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN part TO part_renamed");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM \"" + table.getName() + "$files\""))).matches("SELECT CAST(ROW(2, NULL) AS ROW(part int, another_part int))");
        }
    }

    @Test
    public void testFilesNestedPartition() {
        try (TestTable table = this.newTrinoTable("test_files_table", "WITH (partitioning = ARRAY['\"part.nested\"']) AS SELECT 1 x, CAST(ROW(2) AS ROW(nested int)) part");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.\"part.nested\" FROM \"" + table.getName() + "$files\""))).matches("VALUES 2");
        }
    }

    @Test
    public void testFilesTableWithDelete() {
        this.assertUpdate("CREATE TABLE test_schema.test_table_with_delete (_bigint BIGINT, _date DATE) WITH (partitioning = ARRAY['_date'])");
        this.assertUpdate("INSERT INTO test_schema.test_table_with_delete VALUES (0, CAST('2019-09-08' AS DATE)), (1, CAST('2019-09-09' AS DATE)), (2, CAST('2019-09-09' AS DATE))", 3L);
        this.assertUpdate("INSERT INTO test_schema.test_table_with_delete VALUES (3, CAST('2019-09-09' AS DATE)), (4, CAST('2019-09-10' AS DATE)), (5, CAST('2019-09-10' AS DATE))", 3L);
        this.assertUpdate("DELETE FROM test_schema.test_table_with_delete WHERE _bigint = 5", 1L);
        this.assertUpdate("DELETE FROM test_schema.test_table_with_delete WHERE _bigint = 2", 1L);
        this.assertQuery("SELECT count(*) FROM test_schema.test_table_with_delete", "VALUES 4");
        this.assertQuery("SELECT count(*) FROM test_schema.\"test_table_with_delete$files\" WHERE content = " + FileContent.DATA.id(), "VALUES 4");
        this.assertQuery("SELECT count(*) FROM test_schema.\"test_table_with_delete$files\" WHERE content = " + FileContent.POSITION_DELETES.id(), "VALUES 2");
        this.assertQuery("SELECT count(*) FROM test_schema.\"test_table_with_delete$files\" WHERE content = " + FileContent.EQUALITY_DELETES.id(), "VALUES 0");
        this.assertUpdate("DROP TABLE IF EXISTS test_schema.test_table_with_delete");
    }

    @Test
    void testAllEntriesTable() {
        try (TestTable table = this.newTrinoTable("test_all_entries", "AS SELECT 1 id, DATE '2014-01-01' dt");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE \"" + table.getName() + "$all_entries\""))).matches("DESCRIBE \"" + table.getName() + "$entries\"");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"" + table.getName() + "$all_entries\""))).matches("SELECT * FROM \"" + table.getName() + "$entries\"");
            this.assertUpdate("DELETE FROM " + table.getName(), 1L);
            Assertions.assertThat((Collection)this.computeActual("SELECT status FROM \"" + table.getName() + "$all_entries\"").getOnlyColumnAsSet()).containsExactly(new Object[]{1, 2});
            Assertions.assertThat((Collection)this.computeActual("SELECT status FROM \"" + table.getName() + "$entries\"").getOnlyColumnAsSet()).containsExactly(new Object[]{2});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"" + table.getName() + "$all_entries\" WHERE status = 2"))).matches("SELECT * FROM \"" + table.getName() + "$entries\"");
        }
    }

    @Test
    void testEntriesTable() {
        try (TestTable table = this.newTrinoTable("test_entries", "AS SELECT 1 id, DATE '2014-01-01' dt");){
            this.assertQuery("SHOW COLUMNS FROM \"" + table.getName() + "$entries\"", "VALUES ('status', 'integer', '', ''),('snapshot_id', 'bigint', '', ''),('sequence_number', 'bigint', '', ''),('file_sequence_number', 'bigint', '', ''),('data_file', 'row(content integer, file_path varchar, file_format varchar, spec_id integer, record_count bigint, file_size_in_bytes bigint, column_sizes map(integer, bigint), value_counts map(integer, bigint), null_value_counts map(integer, bigint), nan_value_counts map(integer, bigint), lower_bounds map(integer, varchar), upper_bounds map(integer, varchar), key_metadata varbinary, split_offsets array(bigint), equality_ids array(integer), sort_order_id integer)', '', ''),('readable_metrics', 'json', '', '')");
            BaseTable icebergTable = this.loadTable(table.getName());
            Snapshot snapshot = icebergTable.currentSnapshot();
            long snapshotId = snapshot.snapshotId();
            long sequenceNumber = snapshot.sequenceNumber();
            Assertions.assertThat((Object)this.computeScalar("SELECT status FROM \"" + table.getName() + "$entries\"")).isEqualTo((Object)1);
            Assertions.assertThat((Object)this.computeScalar("SELECT snapshot_id FROM \"" + table.getName() + "$entries\"")).isEqualTo((Object)snapshotId);
            Assertions.assertThat((Object)this.computeScalar("SELECT sequence_number FROM \"" + table.getName() + "$entries\"")).isEqualTo((Object)sequenceNumber);
            Assertions.assertThat((Object)this.computeScalar("SELECT file_sequence_number FROM \"" + table.getName() + "$entries\"")).isEqualTo((Object)1L);
            MaterializedRow dataFile = (MaterializedRow)this.computeScalar("SELECT data_file FROM \"" + table.getName() + "$entries\"");
            Assertions.assertThat((int)dataFile.getFieldCount()).isEqualTo(16);
            Assertions.assertThat((Object)dataFile.getField(0)).isEqualTo((Object)0);
            Assertions.assertThat((String)((String)dataFile.getField(1))).endsWith((CharSequence)this.format.toString().toLowerCase(Locale.ENGLISH));
            Assertions.assertThat((Object)dataFile.getField(2)).isEqualTo((Object)this.format.toString());
            Assertions.assertThat((Object)dataFile.getField(3)).isEqualTo((Object)0);
            Assertions.assertThat((Object)dataFile.getField(4)).isEqualTo((Object)1L);
            Assertions.assertThat((long)((Long)dataFile.getField(5))).isPositive();
            Assertions.assertThat((Object)dataFile.getField(6)).isEqualTo(this.value(Map.of(1, 36L, 2, 36L), null));
            Assertions.assertThat((Object)dataFile.getField(7)).isEqualTo(Map.of(1, 1L, 2, 1L));
            Assertions.assertThat((Object)dataFile.getField(8)).isEqualTo(Map.of(1, 0L, 2, 0L));
            Assertions.assertThat((Object)dataFile.getField(9)).isEqualTo(this.value(Map.of(), null));
            Assertions.assertThat((Object)dataFile.getField(10)).isEqualTo(Map.of(1, "1", 2, "2014-01-01"));
            Assertions.assertThat((Object)dataFile.getField(11)).isEqualTo(Map.of(1, "1", 2, "2014-01-01"));
            Assertions.assertThat((Object)dataFile.getField(12)).isNull();
            Assertions.assertThat((Object)dataFile.getField(13)).isEqualTo(List.of(this.value(4L, 3L)));
            Assertions.assertThat((Object)dataFile.getField(14)).isNull();
            Assertions.assertThat((Object)dataFile.getField(15)).isEqualTo((Object)0);
            Assertions.assertThat((Object)this.computeScalar("SELECT readable_metrics FROM \"" + table.getName() + "$entries\"")).isEqualTo((Object)("{\"dt\":{\"column_size\":" + String.valueOf(this.value(36, null)) + ",\"value_count\":1,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":\"2014-01-01\",\"upper_bound\":\"2014-01-01\"},\"id\":{\"column_size\":" + String.valueOf(this.value(36, null)) + ",\"value_count\":1,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":1,\"upper_bound\":1}}"));
        }
    }

    @Test
    void testEntriesAfterPositionDelete() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_entries", "AS SELECT 1 id, DATE '2014-01-01' dt");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE id = 1", 1L);
            BaseTable icebergTable = this.loadTable(table.getName());
            Snapshot snapshot = icebergTable.currentSnapshot();
            long snapshotId = snapshot.snapshotId();
            long sequenceNumber = snapshot.sequenceNumber();
            Assertions.assertThat((Object)this.computeScalar("SELECT status FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)1);
            Assertions.assertThat((Object)this.computeScalar("SELECT snapshot_id FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)snapshotId);
            Assertions.assertThat((Object)this.computeScalar("SELECT sequence_number FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)sequenceNumber);
            Assertions.assertThat((Object)this.computeScalar("SELECT file_sequence_number FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)2L);
            MaterializedRow deleteFile = (MaterializedRow)this.computeScalar("SELECT data_file FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId);
            Assertions.assertThat((int)deleteFile.getFieldCount()).isEqualTo(16);
            Assertions.assertThat((Object)deleteFile.getField(0)).isEqualTo((Object)1);
            Assertions.assertThat((String)((String)deleteFile.getField(1))).endsWith((CharSequence)this.format.toString().toLowerCase(Locale.ENGLISH));
            Assertions.assertThat((Object)deleteFile.getField(2)).isEqualTo((Object)this.format.toString());
            Assertions.assertThat((Object)deleteFile.getField(3)).isEqualTo((Object)0);
            Assertions.assertThat((Object)deleteFile.getField(4)).isEqualTo((Object)1L);
            Assertions.assertThat((long)((Long)deleteFile.getField(5))).isPositive();
            Map columnSizes = (Map)deleteFile.getField(6);
            switch (this.format) {
                case ORC: {
                    Assertions.assertThat((Map)columnSizes).isNull();
                    break;
                }
                case PARQUET: {
                    ((MapAssert)((MapAssert)Assertions.assertThat((Map)columnSizes).hasSize(2)).satisfies(new ThrowingConsumer[]{map -> Assertions.assertThat((Long)((Long)columnSizes.get(MetadataColumns.DELETE_FILE_POS.fieldId()))).isPositive()})).satisfies(new ThrowingConsumer[]{map -> Assertions.assertThat((Long)((Long)columnSizes.get(MetadataColumns.DELETE_FILE_PATH.fieldId()))).isPositive()});
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported format: " + String.valueOf(this.format));
                }
            }
            Assertions.assertThat((Object)deleteFile.getField(7)).isEqualTo(Map.of(MetadataColumns.DELETE_FILE_POS.fieldId(), 1L, MetadataColumns.DELETE_FILE_PATH.fieldId(), 1L));
            Assertions.assertThat((Object)deleteFile.getField(8)).isEqualTo(Map.of(MetadataColumns.DELETE_FILE_POS.fieldId(), 0L, MetadataColumns.DELETE_FILE_PATH.fieldId(), 0L));
            Assertions.assertThat((Object)deleteFile.getField(9)).isEqualTo(this.value(Map.of(), null));
            Map lowerBounds = (Map)deleteFile.getField(10);
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)lowerBounds).hasSize(2)).satisfies(new ThrowingConsumer[]{map -> Assertions.assertThat((String)((String)lowerBounds.get(MetadataColumns.DELETE_FILE_POS.fieldId()))).isEqualTo("0")})).satisfies(new ThrowingConsumer[]{map -> Assertions.assertThat((String)((String)lowerBounds.get(MetadataColumns.DELETE_FILE_PATH.fieldId()))).contains(new CharSequence[]{table.getName()})});
            Map upperBounds = (Map)deleteFile.getField(11);
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)upperBounds).hasSize(2)).satisfies(new ThrowingConsumer[]{map -> Assertions.assertThat((String)((String)upperBounds.get(MetadataColumns.DELETE_FILE_POS.fieldId()))).isEqualTo("0")})).satisfies(new ThrowingConsumer[]{map -> Assertions.assertThat((String)((String)upperBounds.get(MetadataColumns.DELETE_FILE_PATH.fieldId()))).contains(new CharSequence[]{table.getName()})});
            Assertions.assertThat((Object)deleteFile.getField(12)).isNull();
            Assertions.assertThat((Object)deleteFile.getField(13)).isEqualTo(List.of(this.value(4L, 3L)));
            Assertions.assertThat((Object)deleteFile.getField(14)).isNull();
            Assertions.assertThat((Object)deleteFile.getField(15)).isNull();
            Assertions.assertThat((Object)this.computeScalar("SELECT readable_metrics FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)"{\"dt\":{\"column_size\":null,\"value_count\":null,\"null_value_count\":null,\"nan_value_count\":null,\"lower_bound\":null,\"upper_bound\":null},\"id\":{\"column_size\":null,\"value_count\":null,\"null_value_count\":null,\"nan_value_count\":null,\"lower_bound\":null,\"upper_bound\":null}}");
        }
    }

    @Test
    void testEntriesAfterEqualityDelete() throws Exception {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_entries", "AS SELECT 1 id, DATE '2014-01-01' dt");){
            BaseTable icebergTable = this.loadTable(table.getName());
            Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"0");
            EqualityDeleteUtils.writeEqualityDeleteForTable((Table)icebergTable, this.fileSystemFactory, Optional.empty(), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"id", (Object)1), Optional.empty());
            Assertions.assertThat((Map)icebergTable.currentSnapshot().summary()).containsEntry((Object)"total-equality-deletes", (Object)"1");
            Snapshot snapshot = icebergTable.currentSnapshot();
            long snapshotId = snapshot.snapshotId();
            long sequenceNumber = snapshot.sequenceNumber();
            Assertions.assertThat((Object)this.computeScalar("SELECT status FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)1);
            Assertions.assertThat((Object)this.computeScalar("SELECT snapshot_id FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)snapshotId);
            Assertions.assertThat((Object)this.computeScalar("SELECT sequence_number FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)sequenceNumber);
            Assertions.assertThat((Object)this.computeScalar("SELECT file_sequence_number FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)2L);
            MaterializedRow dataFile = (MaterializedRow)this.computeScalar("SELECT data_file FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId);
            Assertions.assertThat((int)dataFile.getFieldCount()).isEqualTo(16);
            Assertions.assertThat((Object)dataFile.getField(0)).isEqualTo((Object)2);
            Assertions.assertThat((Object)dataFile.getField(3)).isEqualTo((Object)0);
            Assertions.assertThat((Object)dataFile.getField(4)).isEqualTo((Object)1L);
            Assertions.assertThat((long)((Long)dataFile.getField(5))).isPositive();
            Assertions.assertThat((Object)dataFile.getField(6)).isEqualTo(Map.of(1, 45L));
            Assertions.assertThat((Object)dataFile.getField(7)).isEqualTo(Map.of(1, 1L));
            Assertions.assertThat((Object)dataFile.getField(8)).isEqualTo(Map.of(1, 0L));
            Assertions.assertThat((Object)dataFile.getField(9)).isEqualTo(Map.of());
            Assertions.assertThat((Object)dataFile.getField(10)).isEqualTo(Map.of(1, "1"));
            Assertions.assertThat((Object)dataFile.getField(11)).isEqualTo(Map.of(1, "1"));
            Assertions.assertThat((Object)dataFile.getField(12)).isNull();
            Assertions.assertThat((Object)dataFile.getField(13)).isEqualTo(List.of(Long.valueOf(4L)));
            Assertions.assertThat((Object)dataFile.getField(14)).isEqualTo(List.of(Integer.valueOf(1)));
            Assertions.assertThat((Object)dataFile.getField(15)).isEqualTo((Object)0);
            Assertions.assertThat((Object)this.computeScalar("SELECT readable_metrics FROM \"" + table.getName() + "$entries\" WHERE snapshot_id = " + snapshotId)).isEqualTo((Object)"{\"dt\":{\"column_size\":null,\"value_count\":null,\"null_value_count\":null,\"nan_value_count\":null,\"lower_bound\":null,\"upper_bound\":null},\"id\":{\"column_size\":45,\"value_count\":1,\"null_value_count\":0,\"nan_value_count\":null,\"lower_bound\":1,\"upper_bound\":1}}");
        }
    }

    @Test
    public void testPartitionsColumns() {
        try (TestTable testTable = this.newTrinoTable("test_partition_columns", "WITH (partitioning = ARRAY[\n    '\"r1.f1\"',\n    'bucket(b1, 4)'\n]) AS\nSELECT\n    CAST(ROW(1, 2) AS ROW(f1 INTEGER, f2 integeR)) as r1\n    , CAST('b' AS VARCHAR) as b1");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM \"" + testTable.getName() + "$partitions\""))).matches("SELECT CAST(ROW(1, 3) AS ROW(\"r1.f1\" INTEGER, b1_bucket INTEGER))");
        }
        testTable = this.newTrinoTable("test_partition_columns", "WITH (partitioning = ARRAY[\n    '\"r1.f2\"',\n    'bucket(b1, 4)',\n    '\"r1.f1\"'\n]) AS\nSELECT\n    CAST(ROW('f1', 'f2') AS ROW(f1 VARCHAR, f2 VARCHAR)) as r1\n    , CAST('b' AS VARCHAR) as b1");
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM \"" + testTable.getName() + "$partitions\""))).matches("SELECT CAST(ROW('f2', 3, 'f1') AS ROW(\"r1.f2\" VARCHAR, b1_bucket INTEGER, \"r1.f1\" VARCHAR))");
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
    }

    @Test
    void testEntriesPartitionTable() {
        try (TestTable table = this.newTrinoTable("test_entries_partition", "WITH (partitioning = ARRAY['dt']) AS SELECT 1 id, DATE '2014-01-01' dt");){
            this.assertQuery("SHOW COLUMNS FROM \"" + table.getName() + "$entries\"", "VALUES ('status', 'integer', '', ''),('snapshot_id', 'bigint', '', ''),('sequence_number', 'bigint', '', ''),('file_sequence_number', 'bigint', '', ''),('data_file', 'row(content integer, file_path varchar, file_format varchar, spec_id integer, partition row(dt date), record_count bigint, file_size_in_bytes bigint, column_sizes map(integer, bigint), value_counts map(integer, bigint), null_value_counts map(integer, bigint), nan_value_counts map(integer, bigint), lower_bounds map(integer, varchar), upper_bounds map(integer, varchar), key_metadata varbinary, split_offsets array(bigint), equality_ids array(integer), sort_order_id integer)', '', ''),('readable_metrics', 'json', '', '')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT data_file.partition FROM \"" + table.getName() + "$entries\""))).matches("SELECT CAST(ROW(DATE '2014-01-01') AS ROW(dt date))");
        }
    }

    @Test
    public void testPropertiesTable() {
        try (TestTable table = this.newTrinoTable("test_properties", "(x BIGINT,y DOUBLE) WITH (sorted_by = ARRAY['y'])");){
            BaseTable icebergTable = this.loadTable(table.getName());
            Map<String, String> actualProperties = this.getTableProperties(table.getName());
            if (this.format == IcebergFileFormat.PARQUET) {
                Assertions.assertThat(actualProperties).hasSize(9);
            } else {
                Assertions.assertThat(actualProperties).hasSize(10);
                Assertions.assertThat(actualProperties).contains(new Map.Entry[]{Map.entry("write.%s.compression-codec".formatted(this.format.name().toLowerCase(Locale.ENGLISH)), "zstd")});
            }
            Assertions.assertThat(actualProperties).contains(new Map.Entry[]{Map.entry("format", "iceberg/" + this.format.name()), Map.entry("provider", "iceberg"), Map.entry("current-snapshot-id", Long.toString(icebergTable.currentSnapshot().snapshotId())), Map.entry("location", icebergTable.location()), Map.entry("format-version", "2"), Map.entry("sort-order", "y ASC NULLS FIRST"), Map.entry("write.format.default", this.format.name()), Map.entry("write.parquet.compression-codec", "zstd"), Map.entry("commit.retry.num-retries", "4")});
        }
    }

    private Map<String, String> getTableProperties(String tableName) {
        return (Map)this.computeActual("SELECT key, value FROM \"" + tableName + "$properties\"").getMaterializedRows().stream().collect(ImmutableMap.toImmutableMap(row -> (String)row.getField(0), row -> (String)row.getField(1)));
    }

    private Long nanCount(long value) {
        return this.format == IcebergFileFormat.PARQUET ? null : Long.valueOf(value);
    }

    private Long columnSize(long value) {
        return this.format == IcebergFileFormat.ORC ? null : Long.valueOf(value);
    }

    private Object value(Object parquet, Object orc) {
        return this.format == IcebergFileFormat.PARQUET ? parquet : orc;
    }

    private BaseTable loadTable(String tableName) {
        return IcebergTestUtils.loadTable(tableName, this.metastore, this.fileSystemFactory, "hive", "tpch");
    }
}

