/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingNames;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseSharedMetastoreTest
extends AbstractTestQueryFramework {
    protected final String tpchSchema = "test_tpch_shared_schema_" + TestingNames.randomNameSuffix();
    protected final String testSchema = "test_mutable_shared_schema_" + TestingNames.randomNameSuffix();

    protected abstract String getExpectedHiveCreateSchema(String var1);

    protected abstract String getExpectedIcebergCreateSchema(String var1);

    @Test
    public void testSelect() {
        this.assertQuery("SELECT * FROM iceberg." + this.tpchSchema + ".nation", "SELECT * FROM nation");
        this.assertQuery("SELECT * FROM hive." + this.tpchSchema + ".region", "SELECT * FROM region");
        this.assertQuery("SELECT * FROM hive_with_redirections." + this.tpchSchema + ".nation", "SELECT * FROM nation");
        this.assertQuery("SELECT * FROM hive_with_redirections." + this.tpchSchema + ".region", "SELECT * FROM region");
        this.assertQuery("SELECT * FROM iceberg_with_redirections." + this.tpchSchema + ".nation", "SELECT * FROM nation");
        this.assertQuery("SELECT * FROM iceberg_with_redirections." + this.tpchSchema + ".region", "SELECT * FROM region");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM iceberg." + this.tpchSchema + ".region"))).failure().hasMessageContaining("Not an Iceberg table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM iceberg." + this.tpchSchema + ".\"region$data\""))).failure().hasMessageMatching(".* Table .* does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM iceberg." + this.tpchSchema + ".\"region$files\""))).failure().hasMessageMatching(".* Table .* does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM hive." + this.tpchSchema + ".nation"))).failure().hasMessageContaining("Cannot query Iceberg table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM hive." + this.tpchSchema + ".\"nation$partitions\""))).failure().hasMessageMatching(".* Table .* does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM hive." + this.tpchSchema + ".\"nation$properties\""))).failure().hasMessageMatching(".* Table .* does not exist");
    }

    @Test
    public void testReadInformationSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM hive.information_schema.tables WHERE table_name = 'region' AND table_schema='" + this.tpchSchema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM iceberg.information_schema.tables WHERE table_name = 'nation' AND table_schema='" + this.tpchSchema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM hive_with_redirections.information_schema.tables WHERE table_name = 'region' AND table_schema='" + this.tpchSchema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM hive_with_redirections.information_schema.tables WHERE table_name = 'nation' AND table_schema='" + this.tpchSchema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM iceberg_with_redirections.information_schema.tables WHERE table_name = 'region' AND table_schema='" + this.tpchSchema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        this.assertQuery("SELECT table_name, column_name from hive.information_schema.columns WHERE table_schema = '" + this.tpchSchema + "'", "VALUES ('region', 'regionkey'), ('region', 'name'), ('region', 'comment')");
        this.assertQuery("SELECT table_name, column_name from iceberg.information_schema.columns WHERE table_schema = '" + this.tpchSchema + "'", "VALUES ('nation', 'nationkey'), ('nation', 'name'), ('nation', 'regionkey'), ('nation', 'comment')");
        this.assertQuery("SELECT table_name, column_name from hive_with_redirections.information_schema.columns WHERE table_schema = '" + this.tpchSchema + "'", "VALUES('region', 'regionkey'), ('region', 'name'), ('region', 'comment'), ('nation', 'nationkey'), ('nation', 'name'), ('nation', 'regionkey'), ('nation', 'comment')");
        this.assertQuery("SELECT table_name, column_name from iceberg_with_redirections.information_schema.columns WHERE table_schema = '" + this.tpchSchema + "'", "VALUES('region', 'regionkey'), ('region', 'name'), ('region', 'comment'), ('nation', 'nationkey'), ('nation', 'name'), ('nation', 'regionkey'), ('nation', 'comment')");
    }

    @Test
    void testHiveSelectTableColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = '" + this.tpchSchema + "' AND table_name = 'region'"))).skippingTypesCheck().matches("VALUES ('hive', '" + this.tpchSchema + "', 'region', 'regionkey'),('hive', '" + this.tpchSchema + "', 'region', 'name'),('hive', '" + this.tpchSchema + "', 'region', 'comment')");
        this.assertQueryReturnsEmptyResult("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = '" + this.tpchSchema + "' AND table_name = 'nation'");
    }

    @Test
    public void testShowTables() {
        this.assertQuery("SHOW TABLES FROM iceberg." + this.tpchSchema, "VALUES 'region', 'nation'");
        this.assertQuery("SHOW TABLES FROM hive." + this.tpchSchema, "VALUES 'region', 'nation'");
        this.assertQuery("SHOW TABLES FROM hive_with_redirections." + this.tpchSchema, "VALUES 'region', 'nation'");
        this.assertQuery("SHOW TABLES FROM iceberg_with_redirections." + this.tpchSchema, "VALUES 'region', 'nation'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW CREATE TABLE iceberg." + this.tpchSchema + ".region"))).failure().hasMessageContaining("Not an Iceberg table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW CREATE TABLE hive." + this.tpchSchema + ".nation"))).failure().hasMessageContaining("Cannot query Iceberg table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE iceberg." + this.tpchSchema + ".region"))).failure().hasMessageContaining("Not an Iceberg table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE hive." + this.tpchSchema + ".nation"))).failure().hasMessageContaining("Cannot query Iceberg table");
    }

    @Test
    public void testShowSchemas() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS FROM hive"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS FROM iceberg"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS FROM hive_with_redirections"))).skippingTypesCheck().containsAll("VALUES '" + this.tpchSchema + "'");
        String showCreateHiveSchema = (String)this.computeActual("SHOW CREATE SCHEMA hive." + this.tpchSchema).getOnlyValue();
        Assertions.assertThat((String)showCreateHiveSchema).isEqualTo(this.getExpectedHiveCreateSchema("hive"));
        String showCreateIcebergSchema = (String)this.computeActual("SHOW CREATE SCHEMA iceberg." + this.tpchSchema).getOnlyValue();
        Assertions.assertThat((String)showCreateIcebergSchema).isEqualTo(this.getExpectedIcebergCreateSchema("iceberg"));
        String showCreateHiveWithRedirectionsSchema = (String)this.computeActual("SHOW CREATE SCHEMA hive_with_redirections." + this.tpchSchema).getOnlyValue();
        Assertions.assertThat((String)showCreateHiveWithRedirectionsSchema).isEqualTo(this.getExpectedHiveCreateSchema("hive_with_redirections"));
        String showCreateIcebergWithRedirectionsSchema = (String)this.computeActual("SHOW CREATE SCHEMA iceberg_with_redirections." + this.tpchSchema).getOnlyValue();
        Assertions.assertThat((String)showCreateIcebergWithRedirectionsSchema).isEqualTo(this.getExpectedIcebergCreateSchema("iceberg_with_redirections"));
    }

    @Test
    public void testIcebergTablesSystemTable() {
        this.assertQuery("SELECT * FROM iceberg.system.iceberg_tables WHERE table_schema = '%s'".formatted(this.tpchSchema), "VALUES ('%s', 'nation')".formatted(this.tpchSchema));
        this.assertQuery("SELECT * FROM iceberg_with_redirections.system.iceberg_tables WHERE table_schema = '%s'".formatted(this.tpchSchema), "VALUES ('%s', 'nation')".formatted(this.tpchSchema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeTravelWithRedirection() throws InterruptedException {
        try {
            this.assertUpdate(String.format("CREATE TABLE iceberg.%s.nation_test AS SELECT * FROM nation", this.testSchema), 25L);
            this.assertQuery("SELECT * FROM hive_with_redirections." + this.testSchema + ".nation_test", "SELECT * FROM nation");
            long snapshot1 = this.getLatestSnapshotId(this.testSchema);
            long v1EpochMillis = this.getCommittedAtInEpochMilliSeconds(snapshot1, this.testSchema);
            Thread.sleep(1L);
            this.assertUpdate(String.format("INSERT INTO hive_with_redirections.%s.nation_test VALUES(25, 'POLAND', 3, 'test 1')", this.testSchema), 1L);
            long snapshot2 = this.getLatestSnapshotId(this.testSchema);
            long v2EpochMillis = this.getCommittedAtInEpochMilliSeconds(snapshot2, this.testSchema);
            Thread.sleep(1L);
            this.assertUpdate(String.format("INSERT INTO hive_with_redirections.%s.nation_test VALUES(26, 'CHILE', 1, 'test 2')", this.testSchema), 1L);
            long snapshot3 = this.getLatestSnapshotId(this.testSchema);
            long v3EpochMillis = this.getCommittedAtInEpochMilliSeconds(snapshot3, this.testSchema);
            long incorrectSnapshot = 2324324333L;
            Thread.sleep(1L);
            this.assertQuery(String.format("SELECT * FROM hive_with_redirections.%s.nation_test FOR VERSION AS OF %d", this.testSchema, snapshot1), "SELECT * FROM nation");
            this.assertQuery(String.format("SELECT * FROM hive_with_redirections.%s.nation_test FOR TIMESTAMP AS OF %s", this.testSchema, BaseSharedMetastoreTest.timestampLiteral(v1EpochMillis)), "SELECT * FROM nation");
            this.assertQuery(String.format("SELECT count(*) FROM hive_with_redirections.%s.nation_test FOR VERSION AS OF %d", this.testSchema, snapshot2), "VALUES(26)");
            this.assertQuery(String.format("SELECT count(*) FROM iceberg_with_redirections.%s.nation_test FOR TIMESTAMP AS OF %s", this.testSchema, BaseSharedMetastoreTest.timestampLiteral(v2EpochMillis)), "VALUES(26)");
            this.assertQuery(String.format("SELECT count(*) FROM hive_with_redirections.%s.nation_test FOR VERSION AS OF %d", this.testSchema, snapshot3), "VALUES(27)");
            this.assertQuery(String.format("SELECT count(*) FROM hive_with_redirections.%s.nation_test FOR TIMESTAMP AS OF %s", this.testSchema, BaseSharedMetastoreTest.timestampLiteral(v3EpochMillis)), "VALUES(27)");
            this.assertQueryFails(String.format("SELECT * FROM hive_with_redirections.%s.nation_test FOR VERSION AS OF %d", this.testSchema, incorrectSnapshot), "Iceberg snapshot ID does not exists: " + incorrectSnapshot);
            this.assertQueryFails(String.format("SELECT * FROM hive_with_redirections.%s.nation_test FOR TIMESTAMP AS OF TIMESTAMP '1970-01-01 00:00:00.001000000 Z'", this.testSchema), String.format("\\QNo version history table \"%s\".\"nation_test\" at or before 1970-01-01T00:00:00.001Z", this.testSchema));
            this.assertQueryFails(String.format("SELECT * FROM iceberg_with_redirections.%s.region FOR TIMESTAMP AS OF TIMESTAMP '1970-01-01 00:00:00.001000000 Z'", this.tpchSchema), "\\QThis connector does not support versioned tables");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS iceberg." + this.testSchema + ".nation_test");
        }
    }

    @Test
    void testIcebergCannotCreateTableNamesakeToHiveTable() {
        String tableName = "test_iceberg_create_namesake_hive_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.%s.%s".formatted(this.testSchema, tableName);
        String icebergTableName = "iceberg.%s.%s".formatted(this.testSchema, tableName);
        this.assertUpdate("CREATE TABLE " + hiveTableName + "(a bigint)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE TABLE " + icebergTableName + "(a bigint)"))).failure().hasMessageMatching(".* Table .* of unsupported type already exists");
        this.assertUpdate("DROP TABLE " + hiveTableName);
    }

    @Test
    void testHiveCannotCreateTableNamesakeToIcebergTable() {
        String tableName = "test_iceberg_create_namesake_hive_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.%s.%s".formatted(this.testSchema, tableName);
        String icebergTableName = "iceberg.%s.%s".formatted(this.testSchema, tableName);
        this.assertUpdate("CREATE TABLE " + icebergTableName + "(a bigint)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CREATE TABLE " + hiveTableName + "(a bigint)"))).failure().hasMessageMatching(".* Table .* of unsupported type already exists");
        this.assertUpdate("DROP TABLE " + icebergTableName);
    }

    @Test
    public void testMigrateTable() {
        String tableName = "test_migrate_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.%s.%s".formatted(this.testSchema, tableName);
        String icebergTableName = "iceberg.%s.%s".formatted(this.testSchema, tableName);
        this.assertUpdate("CREATE TABLE " + hiveTableName + " AS SELECT 1 id", 1L);
        this.assertQueryFails("SELECT * FROM " + icebergTableName, "Not an Iceberg table: .*");
        this.assertUpdate("CALL iceberg.system.migrate('" + this.testSchema + "', '" + tableName + "')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + icebergTableName);
    }

    @Test
    public void testMigratePartitionedTable() {
        String tableName = "test_migrate_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.%s.%s".formatted(this.testSchema, tableName);
        String icebergTableName = "iceberg.%s.%s".formatted(this.testSchema, tableName);
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (partitioned_by = ARRAY['part']) AS SELECT 1 id, 'test' part", 1L);
        this.assertQueryFails("SELECT * FROM " + icebergTableName, "Not an Iceberg table: .*");
        this.assertUpdate("CALL iceberg.system.migrate('" + this.testSchema + "', '" + tableName + "')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'test')");
        this.assertUpdate("DROP TABLE " + icebergTableName);
    }

    private long getLatestSnapshotId(String schema) {
        return (Long)this.computeScalar(String.format("SELECT snapshot_id FROM iceberg.%s.\"nation_test$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES", schema));
    }

    private long getCommittedAtInEpochMilliSeconds(long snapshotId, String schema) {
        return ((ZonedDateTime)this.computeScalar(String.format("SELECT committed_at FROM iceberg.%s.\"nation_test$snapshots\" WHERE snapshot_id=%s", schema, snapshotId))).toInstant().toEpochMilli();
    }

    private static String timestampLiteral(long epochMilliSeconds) {
        return DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss." + "S".repeat(9) + " VV''").format(Instant.ofEpochMilli(epochMilliSeconds).atZone(ZoneOffset.UTC));
    }
}

