/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.testing.MaterializedRow;
import java.util.Map;
import org.assertj.core.api.Assertions;

public class DataFileRecord {
    private final int content;
    private final String filePath;
    private final String fileFormat;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final Map<Integer, Long> columnSizes;
    private final Map<Integer, Long> valueCounts;
    private final Map<Integer, Long> nullValueCounts;
    private final Map<Integer, Long> nanValueCounts;
    private final Map<Integer, String> lowerBounds;
    private final Map<Integer, String> upperBounds;

    public static DataFileRecord toDataFileRecord(MaterializedRow row) {
        Assertions.assertThat((int)row.getFieldCount()).isEqualTo(17);
        return new DataFileRecord((Integer)row.getField(0), (String)row.getField(1), (String)row.getField(2), (Long)row.getField(4), (Long)row.getField(5), (Map<Integer, Long>)(row.getField(6) != null ? ImmutableMap.copyOf((Map)((Map)row.getField(6))) : null), (Map<Integer, Long>)(row.getField(7) != null ? ImmutableMap.copyOf((Map)((Map)row.getField(7))) : null), (Map<Integer, Long>)(row.getField(8) != null ? ImmutableMap.copyOf((Map)((Map)row.getField(8))) : null), (Map<Integer, Long>)(row.getField(9) != null ? ImmutableMap.copyOf((Map)((Map)row.getField(9))) : null), (Map<Integer, String>)(row.getField(10) != null ? ImmutableMap.copyOf((Map)((Map)row.getField(10))) : null), (Map<Integer, String>)(row.getField(11) != null ? ImmutableMap.copyOf((Map)((Map)row.getField(11))) : null));
    }

    private DataFileRecord(int content, String filePath, String fileFormat, long recordCount, long fileSizeInBytes, Map<Integer, Long> columnSizes, Map<Integer, Long> valueCounts, Map<Integer, Long> nullValueCounts, Map<Integer, Long> nanValueCounts, Map<Integer, String> lowerBounds, Map<Integer, String> upperBounds) {
        this.content = content;
        this.filePath = filePath;
        this.fileFormat = fileFormat;
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.columnSizes = columnSizes;
        this.valueCounts = valueCounts;
        this.nullValueCounts = nullValueCounts;
        this.nanValueCounts = nanValueCounts;
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
    }

    public int getContent() {
        return this.content;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public long getFileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public Map<Integer, Long> getColumnSizes() {
        return this.columnSizes;
    }

    public Map<Integer, Long> getValueCounts() {
        return this.valueCounts;
    }

    public Map<Integer, Long> getNullValueCounts() {
        return this.nullValueCounts;
    }

    public Map<Integer, Long> getNanValueCounts() {
        return this.nanValueCounts;
    }

    public Map<Integer, String> getLowerBounds() {
        return this.lowerBounds;
    }

    public Map<Integer, String> getUpperBounds() {
        return this.upperBounds;
    }
}

