/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.iceberg.catalog.jdbc.TestingIcebergJdbcServer;
import io.trino.plugin.iceberg.catalog.rest.RestCatalogTestUtils;
import io.trino.plugin.iceberg.catalog.rest.TestingPolarisCatalog;
import io.trino.plugin.iceberg.containers.NessieContainer;
import io.trino.plugin.iceberg.containers.UnityCatalogContainer;
import io.trino.plugin.tpcds.TpcdsPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingProperties;
import io.trino.testing.TestingSession;
import io.trino.testing.containers.Minio;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.rest.DelegatingRestSessionCatalog;

public final class IcebergQueryRunner {
    public static final String ICEBERG_CATALOG = "iceberg";

    private IcebergQueryRunner() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String schema) {
        return new Builder(schema);
    }

    private static Builder icebergQueryRunnerMainBuilder() {
        return ((Builder)IcebergQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).setTpcdsCatalogEnabled(true);
    }

    static {
        Logging logging = Logging.initialize();
        logging.setLevel("org.apache.iceberg", Level.OFF);
    }

    public static class Builder
    extends DistributedQueryRunner.Builder<Builder> {
        private Optional<File> metastoreDirectory = Optional.empty();
        private ImmutableMap.Builder<String, String> icebergProperties = ImmutableMap.builder();
        private Optional<SchemaInitializer> schemaInitializer = Optional.of(SchemaInitializer.builder().build());
        private boolean tpcdsCatalogEnabled;

        protected Builder() {
            super(TestingSession.testSessionBuilder().setCatalog(IcebergQueryRunner.ICEBERG_CATALOG).setSchema("tpch").build());
        }

        protected Builder(String schema) {
            super(TestingSession.testSessionBuilder().setCatalog(IcebergQueryRunner.ICEBERG_CATALOG).setSchema(schema).build());
        }

        public Builder setMetastoreDirectory(File metastoreDirectory) {
            this.metastoreDirectory = Optional.of(metastoreDirectory);
            return (Builder)this.self();
        }

        public Builder setIcebergProperties(Map<String, String> icebergProperties) {
            this.icebergProperties = ImmutableMap.builder().putAll(Objects.requireNonNull(icebergProperties, "icebergProperties is null"));
            return (Builder)this.self();
        }

        public Builder addIcebergProperty(String key, String value) {
            this.icebergProperties.put((Object)key, (Object)value);
            return (Builder)this.self();
        }

        public Builder setInitialTables(TpchTable<?> ... initialTables) {
            return this.setInitialTables((Iterable<TpchTable<?>>)ImmutableList.copyOf((Object[])initialTables));
        }

        public Builder setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.setSchemaInitializer(SchemaInitializer.builder().withClonedTpchTables(initialTables).build());
            return (Builder)this.self();
        }

        public Builder setSchemaInitializer(SchemaInitializer schemaInitializer) {
            this.schemaInitializer = Optional.of(Objects.requireNonNull(schemaInitializer, "schemaInitializer is null"));
            this.amendSession(sessionBuilder -> sessionBuilder.setSchema(schemaInitializer.getSchemaName()));
            return (Builder)this.self();
        }

        public Builder disableSchemaInitializer() {
            this.schemaInitializer = Optional.empty();
            return (Builder)this.self();
        }

        public Builder setTpcdsCatalogEnabled(boolean tpcdsCatalogEnabled) {
            this.tpcdsCatalogEnabled = tpcdsCatalogEnabled;
            return (Builder)this.self();
        }

        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                queryRunner.createCatalog("tpch", "tpch");
                if (this.tpcdsCatalogEnabled) {
                    queryRunner.installPlugin((Plugin)new TpcdsPlugin());
                    queryRunner.createCatalog("tpcds", "tpcds");
                }
                if (this.icebergProperties.buildOrThrow().keySet().stream().noneMatch(key -> key.equals("fs.hadoop.enabled") || key.startsWith("fs.native-"))) {
                    this.icebergProperties.put((Object)"fs.hadoop.enabled", (Object)"true");
                }
                Path dataDir = this.metastoreDirectory.map(File::toPath).orElseGet(() -> queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data"));
                queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(dataDir));
                queryRunner.createCatalog(IcebergQueryRunner.ICEBERG_CATALOG, IcebergQueryRunner.ICEBERG_CATALOG, (Map)this.icebergProperties.buildOrThrow());
                this.schemaInitializer.ifPresent(initializer -> initializer.accept((QueryRunner)queryRunner));
                return queryRunner;
            }
            catch (Exception e) {
                Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
                throw e;
            }
        }
    }

    public static final class IcebergQueryRunnerWithTaskRetries {
        private IcebergQueryRunnerWithTaskRetries() {
        }

        public static void main(String[] args) throws Exception {
            Logger log = Logger.get(IcebergQueryRunnerWithTaskRetries.class);
            File exchangeManagerDirectory = Files.createTempDirectory("exchange_manager", new FileAttribute[0]).toFile();
            ImmutableMap exchangeManagerProperties = ImmutableMap.builder().put((Object)"exchange.base-directories", (Object)exchangeManagerDirectory.getAbsolutePath()).buildOrThrow();
            exchangeManagerDirectory.deleteOnExit();
            File metastoreDir = Files.createTempDirectory("iceberg_query_runner", new FileAttribute[0]).toFile();
            metastoreDir.deleteOnExit();
            DistributedQueryRunner queryRunner = ((Builder)((Builder)IcebergQueryRunner.icebergQueryRunnerMainBuilder().addIcebergProperty("hive.metastore.catalog.dir", metastoreDir.toURI().toString()).setExtraProperties((Map)ImmutableMap.builder().put((Object)"retry-policy", (Object)"TASK").put((Object)"fault-tolerant-execution-task-memory", (Object)"1GB").buildOrThrow())).setInitialTables(TpchTable.getTables()).setAdditionalSetup(arg_0 -> IcebergQueryRunnerWithTaskRetries.lambda$main$0((Map)exchangeManagerProperties, arg_0))).build();
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }

        private static /* synthetic */ void lambda$main$0(Map exchangeManagerProperties, QueryRunner runner) {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", exchangeManagerProperties);
        }
    }

    public static final class DefaultIcebergQueryRunnerMain {
        private DefaultIcebergQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            Logger log = Logger.get(DefaultIcebergQueryRunnerMain.class);
            File metastoreDir = Files.createTempDirectory("iceberg_query_runner", new FileAttribute[0]).toFile();
            metastoreDir.deleteOnExit();
            DistributedQueryRunner queryRunner = IcebergQueryRunner.icebergQueryRunnerMainBuilder().addIcebergProperty("hive.metastore.catalog.dir", metastoreDir.toURI().toString()).setInitialTables(TpchTable.getTables()).build();
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergNessieQueryRunnerMain {
        private IcebergNessieQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            NessieContainer nessieContainer = NessieContainer.builder().build();
            nessieContainer.start();
            Path tempDir = Files.createTempDirectory("trino_nessie_catalog", new FileAttribute[0]);
            DistributedQueryRunner queryRunner = ((Builder)((Builder)IcebergQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).setBaseDataDir(Optional.of(tempDir))).setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"nessie").put((Object)"iceberg.nessie-catalog.uri", (Object)nessieContainer.getRestApiUri()).put((Object)"iceberg.nessie-catalog.default-warehouse-dir", (Object)tempDir.toString()).buildOrThrow()).setInitialTables(TpchTable.getTables()).build();
            Logger log = Logger.get(IcebergNessieQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergSnowflakeQueryRunnerMain {
        private IcebergSnowflakeQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            DistributedQueryRunner queryRunner = IcebergQueryRunner.icebergQueryRunnerMainBuilder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"snowflake").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.s3.access-key")).put((Object)"s3.aws-secret-key", (Object)TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.s3.secret-key")).put((Object)"s3.region", (Object)TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.s3.region")).put((Object)"iceberg.file-format", (Object)"PARQUET").put((Object)"iceberg.snowflake-catalog.account-uri", (Object)TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.account-url")).put((Object)"iceberg.snowflake-catalog.user", (Object)TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.user")).put((Object)"iceberg.snowflake-catalog.password", (Object)TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.password")).put((Object)"iceberg.snowflake-catalog.database", (Object)TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.database")).buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName("tpch").build()).build();
            Logger log = Logger.get(IcebergSnowflakeQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergJdbcQueryRunnerMain {
        private IcebergJdbcQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            Path warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
            warehouseLocation.toFile().deleteOnExit();
            TestingIcebergJdbcServer server = new TestingIcebergJdbcServer();
            DistributedQueryRunner queryRunner = IcebergQueryRunner.icebergQueryRunnerMainBuilder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"jdbc").put((Object)"iceberg.jdbc-catalog.driver-class", (Object)"org.postgresql.Driver").put((Object)"iceberg.jdbc-catalog.connection-url", (Object)server.getJdbcUrl()).put((Object)"iceberg.jdbc-catalog.connection-user", (Object)"test").put((Object)"iceberg.jdbc-catalog.connection-password", (Object)"test").put((Object)"iceberg.jdbc-catalog.catalog-name", (Object)"tpch").put((Object)"iceberg.jdbc-catalog.default-warehouse-dir", (Object)warehouseLocation.toAbsolutePath().toString()).buildOrThrow()).setInitialTables(TpchTable.getTables()).build();
            Logger log = Logger.get(IcebergJdbcQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergAzureQueryRunnerMain {
        private IcebergAzureQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            String azureContainer = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-container");
            String azureAccount = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-account");
            String azureAccessKey = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-access-key");
            String abfsSpecificCoreSiteXmlContent = Resources.toString((URL)Resources.getResource((String)"hdp3.1-core-site.xml.abfs-template"), (Charset)StandardCharsets.UTF_8).replace("%ABFS_ACCESS_KEY%", azureAccessKey).replace("%ABFS_ACCOUNT%", azureAccount);
            FileAttribute<Set<PosixFilePermission>> posixFilePermissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
            Path hadoopCoreSiteXmlTempFile = Files.createTempFile("core-site", ".xml", posixFilePermissions);
            hadoopCoreSiteXmlTempFile.toFile().deleteOnExit();
            Files.writeString(hadoopCoreSiteXmlTempFile, (CharSequence)abfsSpecificCoreSiteXmlContent, new OpenOption[0]);
            HiveHadoop hiveHadoop = ((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withImage(HiveHadoop.HIVE3_IMAGE)).withFilesToMount((Map)ImmutableMap.of((Object)"/etc/hadoop/conf/core-site.xml", (Object)hadoopCoreSiteXmlTempFile.normalize().toAbsolutePath().toString()))).build();
            hiveHadoop.start();
            DistributedQueryRunner queryRunner = IcebergQueryRunner.icebergQueryRunnerMainBuilder().setIcebergProperties(Map.of("iceberg.catalog.type", "HIVE_METASTORE", "hive.metastore.uri", hiveHadoop.getHiveMetastoreEndpoint().toString(), "fs.native-azure.enabled", "true", "azure.auth-type", "ACCESS_KEY", "azure.access-key", azureAccessKey)).setSchemaInitializer(SchemaInitializer.builder().withSchemaName("tpch").withClonedTpchTables(TpchTable.getTables()).withSchemaProperties(Map.of("location", "'abfs://%s@%s.dfs.core.windows.net/test-bucket/'".formatted(azureContainer, azureAccount))).build()).build();
            Logger log = Logger.get(IcebergAzureQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergMinioQueryRunnerMain {
        private IcebergMinioQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            Logging.initialize();
            String bucketName = "test-bucket";
            Minio minio = Minio.builder().build();
            minio.start();
            minio.createBucket(bucketName);
            DistributedQueryRunner queryRunner = IcebergQueryRunner.icebergQueryRunnerMainBuilder().setIcebergProperties(Map.of("iceberg.catalog.type", "TESTING_FILE_METASTORE", "hive.metastore.catalog.dir", "s3://%s/".formatted(bucketName), "fs.native-s3.enabled", "true", "s3.aws-access-key", "accesskey", "s3.aws-secret-key", "secretkey", "s3.region", "us-east-1", "s3.endpoint", "http://" + String.valueOf(minio.getMinioApiEndpoint()), "s3.path-style-access", "true", "s3.streaming.part-size", "5MB")).setSchemaInitializer(SchemaInitializer.builder().withSchemaName("tpch").withClonedTpchTables(TpchTable.getTables()).build()).build();
            Logger log = Logger.get(IcebergMinioQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergMinioHiveMetastoreQueryRunnerMain {
        private IcebergMinioHiveMetastoreQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            String bucketName = "test-bucket";
            Hive3MinioDataLake hiveMinioDataLake = new Hive3MinioDataLake(bucketName);
            hiveMinioDataLake.start();
            DistributedQueryRunner queryRunner = ((Builder)IcebergQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).setIcebergProperties(Map.of("iceberg.catalog.type", "HIVE_METASTORE", "hive.metastore.uri", hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint().toString(), "fs.native-s3.enabled", "true", "s3.aws-access-key", "accesskey", "s3.aws-secret-key", "secretkey", "s3.region", "us-east-1", "s3.endpoint", hiveMinioDataLake.getMinio().getMinioAddress(), "s3.path-style-access", "true", "s3.streaming.part-size", "5MB")).setSchemaInitializer(SchemaInitializer.builder().withSchemaName("tpch").withClonedTpchTables(TpchTable.getTables()).withSchemaProperties(Map.of("location", "'s3://" + bucketName + "/tpch'")).build()).build();
            Logger log = Logger.get(IcebergMinioHiveMetastoreQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergExternalQueryRunnerMain {
        private IcebergExternalQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            DistributedQueryRunner queryRunner = IcebergQueryRunner.icebergQueryRunnerMainBuilder().setIcebergProperties((Map<String, String>)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)System.getProperty("iceberg.catalog.type"))).build();
            Logger log = Logger.get(IcebergExternalQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergUnityQueryRunnerMain {
        private IcebergUnityQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            Path warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
            warehouseLocation.toFile().deleteOnExit();
            UnityCatalogContainer unityCatalog = new UnityCatalogContainer("unity", "tpch");
            DistributedQueryRunner queryRunner = ((Builder)((Builder)IcebergQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).setBaseDataDir(Optional.of(warehouseLocation))).addIcebergProperty("iceberg.security", "read_only").addIcebergProperty("iceberg.catalog.type", "rest").addIcebergProperty("iceberg.rest-catalog.uri", unityCatalog.uri() + "/iceberg").addIcebergProperty("iceberg.rest-catalog.warehouse", "unity").addIcebergProperty("iceberg.register-table-procedure.enabled", "true").disableSchemaInitializer().build();
            unityCatalog.copyTpchTables(TpchTable.getTables());
            Logger log = Logger.get(IcebergUnityQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergPolarisQueryRunnerMain {
        private IcebergPolarisQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            Path warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
            warehouseLocation.toFile().deleteOnExit();
            TestingPolarisCatalog polarisCatalog = new TestingPolarisCatalog(warehouseLocation.toString());
            DistributedQueryRunner queryRunner = ((Builder)IcebergQueryRunner.icebergQueryRunnerMainBuilder().setBaseDataDir(Optional.of(warehouseLocation))).addIcebergProperty("iceberg.catalog.type", "rest").addIcebergProperty("iceberg.rest-catalog.uri", polarisCatalog.restUri() + "/api/catalog").addIcebergProperty("iceberg.rest-catalog.warehouse", "polaris").addIcebergProperty("iceberg.rest-catalog.security", "OAUTH2").addIcebergProperty("iceberg.rest-catalog.oauth2.credential", "root:s3cr3t").addIcebergProperty("iceberg.rest-catalog.oauth2.scope", "PRINCIPAL_ROLE:ALL").setInitialTables(TpchTable.getTables()).build();
            Logger log = Logger.get(IcebergPolarisQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }

    public static final class IcebergRestQueryRunnerMain {
        private IcebergRestQueryRunnerMain() {
        }

        public static void main(String[] args) throws Exception {
            Path warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
            warehouseLocation.toFile().deleteOnExit();
            Catalog backend = RestCatalogTestUtils.backendCatalog(warehouseLocation);
            DelegatingRestSessionCatalog delegatingCatalog = DelegatingRestSessionCatalog.builder().delegate(backend).build();
            TestingHttpServer testServer = delegatingCatalog.testServer();
            testServer.start();
            DistributedQueryRunner queryRunner = ((Builder)IcebergQueryRunner.icebergQueryRunnerMainBuilder().setBaseDataDir(Optional.of(warehouseLocation))).setIcebergProperties((Map<String, String>)ImmutableMap.of((Object)"iceberg.catalog.type", (Object)"rest", (Object)"iceberg.rest-catalog.uri", (Object)testServer.getBaseUrl().toString())).setInitialTables(TpchTable.getTables()).build();
            Logger log = Logger.get(IcebergRestQueryRunnerMain.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }
}

