/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Verify;
import com.google.common.collect.Iterators;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.metadata.OrcType;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.parquet.reader.MetadataReader;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TrinoOrcDataSource;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.file.FileMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingInputFile;
import io.trino.plugin.iceberg.util.FileOperationUtils;
import io.trino.spi.block.Block;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.InputFile;
import org.joda.time.DateTimeZone;

public final class IcebergTestUtils {
    public static final ConnectorSession SESSION = TestingConnectorSession.builder().setPropertyMetadata(new IcebergSessionProperties(new IcebergConfig(), new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig()).getSessionProperties()).build();

    private IcebergTestUtils() {
    }

    public static Session withSmallRowGroups(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty("iceberg", "orc_writer_max_stripe_rows", "20").setCatalogSessionProperty("iceberg", "parquet_writer_block_size", "1kB").setCatalogSessionProperty("iceberg", "parquet_writer_batch_size", "20").build();
    }

    public static boolean checkOrcFileSorting(TrinoFileSystem fileSystem, Location path, String sortColumnName) {
        return IcebergTestUtils.checkOrcFileSorting(() -> {
            try {
                return new TrinoOrcDataSource(fileSystem.newInputFile(path), new OrcReaderOptions(), new FileFormatDataSourceStats());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, sortColumnName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkOrcFileSorting(Supplier<OrcDataSource> dataSourceSupplier, String sortColumnName) {
        OrcReaderOptions readerOptions = new OrcReaderOptions();
        try (OrcDataSource dataSource = dataSourceSupplier.get();){
            OrcReader orcReader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)dataSource, (OrcReaderOptions)readerOptions).orElseThrow();
            OrcColumn sortColumn = (OrcColumn)orcReader.getRootColumn().getNestedColumns().stream().filter(column -> column.getColumnName().equals(sortColumnName)).collect(MoreCollectors.onlyElement());
            Type sortColumnType = IcebergTestUtils.getType(sortColumn.getColumnType().getOrcTypeKind());
            try (OrcRecordReader recordReader = orcReader.createRecordReader(List.of(sortColumn), List.of(sortColumnType), false, OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1, RuntimeException::new);){
                Comparable previousMax = null;
                SourcePage page = recordReader.nextPage();
                while (page != null) {
                    Block block = page.getBlock(0);
                    for (int position = 0; position < block.getPositionCount(); ++position) {
                        Comparable current = (Comparable)TypeUtils.readNativeValue((Type)sortColumnType, (Block)block, (int)position);
                        if (previousMax != null && previousMax.compareTo(current) > 0) {
                            boolean bl = false;
                            return bl;
                        }
                        previousMax = current;
                    }
                    page = recordReader.nextPage();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Type getType(OrcType.OrcTypeKind orcTypeKind) {
        switch (orcTypeKind) {
            case STRING: 
            case VARCHAR: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported orc type: " + String.valueOf(orcTypeKind));
            }
        }
        return VarcharType.VARCHAR;
    }

    public static boolean checkParquetFileSorting(TrinoInputFile inputFile, String sortColumnName) {
        List blocks;
        ParquetMetadata parquetMetadata = IcebergTestUtils.getParquetFileMetadata(inputFile);
        try {
            blocks = parquetMetadata.getBlocks();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Comparable previousMax = null;
        Verify.verify((blocks.size() > 1 ? 1 : 0) != 0, (String)"Test must produce at least two row groups", (Object[])new Object[0]);
        for (BlockMetadata blockMetaData : blocks) {
            ColumnChunkMetadata columnMetadata = (ColumnChunkMetadata)blockMetaData.columns().stream().filter(column -> ((String)Iterators.getOnlyElement((Iterator)column.getPath().iterator())).equalsIgnoreCase(sortColumnName)).collect(MoreCollectors.onlyElement());
            if (previousMax != null && previousMax.compareTo(columnMetadata.getStatistics().genericGetMin()) > 0) {
                return false;
            }
            previousMax = columnMetadata.getStatistics().genericGetMax();
        }
        return true;
    }

    public static TrinoFileSystemFactory getFileSystemFactory(QueryRunner queryRunner) {
        return (TrinoFileSystemFactory)((IcebergConnector)queryRunner.getCoordinator().getConnector("iceberg")).getInjector().getInstance(TrinoFileSystemFactory.class);
    }

    public static HiveMetastore getHiveMetastore(QueryRunner queryRunner) {
        return ((HiveMetastoreFactory)((IcebergConnector)queryRunner.getCoordinator().getConnector("iceberg")).getInjector().getInstance(HiveMetastoreFactory.class)).createMetastore(Optional.empty());
    }

    public static BaseTable loadTable(String tableName, HiveMetastore metastore, TrinoFileSystemFactory fileSystemFactory, String catalogName, String schemaName) {
        FileMetastoreTableOperationsProvider tableOperationsProvider = new FileMetastoreTableOperationsProvider(fileSystemFactory);
        TrinoCatalog catalog = IcebergTestUtils.getTrinoCatalog(metastore, fileSystemFactory, catalogName);
        return IcebergUtil.loadIcebergTable((TrinoCatalog)catalog, (IcebergTableOperationsProvider)tableOperationsProvider, (ConnectorSession)SESSION, (SchemaTableName)new SchemaTableName(schemaName, tableName));
    }

    public static TrinoCatalog getTrinoCatalog(HiveMetastore metastore, TrinoFileSystemFactory fileSystemFactory, String catalogName) {
        FileMetastoreTableOperationsProvider tableOperationsProvider = new FileMetastoreTableOperationsProvider(fileSystemFactory);
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)metastore, (long)1000L);
        return new TrinoHiveCatalog(new CatalogName(catalogName), cachingHiveMetastore, new TrinoViewHiveMetastore((HiveMetastore)cachingHiveMetastore, false, "trino-version", "test"), fileSystemFactory, (TypeManager)new TestingTypeManager(), (IcebergTableOperationsProvider)tableOperationsProvider, false, false, false, new IcebergConfig().isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
    }

    public static Map<String, Long> getMetadataFileAndUpdatedMillis(TrinoFileSystem trinoFileSystem, String tableLocation) throws IOException {
        FileIterator fileIterator = trinoFileSystem.listFiles(Location.of((String)(tableLocation + "/metadata")));
        HashMap<String, Long> metadataFiles = new HashMap<String, Long>();
        while (fileIterator.hasNext()) {
            FileEntry entry = fileIterator.next();
            if (FileOperationUtils.FileType.fromFilePath(entry.location().path()) != FileOperationUtils.FileType.METADATA_JSON) continue;
            TableMetadata tableMetadata = TableMetadataParser.read(null, (InputFile)new ForwardingInputFile(trinoFileSystem.newInputFile(entry.location())));
            metadataFiles.put(entry.location().path(), tableMetadata.lastUpdatedMillis());
        }
        return metadataFiles;
    }

    public static ParquetMetadata getParquetFileMetadata(TrinoInputFile inputFile) {
        try {
            return MetadataReader.readFooter((ParquetDataSource)new TrinoParquetDataSource(inputFile, ParquetReaderOptions.defaultOptions(), new FileFormatDataSourceStats()), Optional.empty());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

