/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SchemaInitializer
implements Consumer<QueryRunner> {
    private final String schemaName;
    private final Map<String, String> schemaProperties;
    private final Iterable<TpchTable<?>> clonedTpchTables;

    private SchemaInitializer(String schemaName, Map<String, String> schemaProperties, Iterable<TpchTable<?>> tpchTablesToClone) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.schemaProperties = Objects.requireNonNull(schemaProperties, "schemaProperties is null");
        this.clonedTpchTables = Objects.requireNonNull(tpchTablesToClone, "tpchTablesToClone is null");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public void accept(QueryRunner queryRunner) {
        String schemaProperties = this.schemaProperties.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(Collectors.joining(", ", " WITH ( ", " )"));
        queryRunner.execute("CREATE SCHEMA IF NOT EXISTS \"" + this.schemaName + "\"" + (this.schemaProperties.size() > 0 ? schemaProperties : ""));
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", this.clonedTpchTables);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String schemaName = "tpch";
        private Map<String, String> schemaProperties = ImmutableMap.of();
        private Iterable<TpchTable<?>> cloneTpchTables = ImmutableSet.of();

        public Builder withSchemaName(String schemaName) {
            this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
            return this;
        }

        public Builder withSchemaProperties(Map<String, String> schemaProperties) {
            this.schemaProperties = Objects.requireNonNull(schemaProperties, "schemaProperties is null");
            return this;
        }

        public Builder withClonedTpchTables(Iterable<TpchTable<?>> tpchTables) {
            this.cloneTpchTables = ImmutableSet.copyOf(tpchTables);
            return this;
        }

        public SchemaInitializer build() {
            return new SchemaInitializer(this.schemaName, this.schemaProperties, this.cloneTpchTables);
        }
    }
}

