/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.MetricsWrapper;
import io.trino.plugin.iceberg.TableType;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.testing.TestingNames;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestFileBasedConflictDetection {
    private static final HadoopTables HADOOP_TABLES = new HadoopTables(new Configuration(false));
    private static final String COLUMN_1_NAME = "col1";
    private static final ColumnIdentity COLUMN_1_IDENTITY = new ColumnIdentity(1, "col1", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
    private static final IcebergColumnHandle COLUMN_1_HANDLE = new IcebergColumnHandle(COLUMN_1_IDENTITY, (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
    private static final String COLUMN_2_NAME = "part";
    private static final ColumnIdentity COLUMN_2_IDENTITY = new ColumnIdentity(2, "part", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
    private static final IcebergColumnHandle COLUMN_2_HANDLE = new IcebergColumnHandle(COLUMN_2_IDENTITY, (io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of(), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
    private static final String CHILD_COLUMN_NAME = "child";
    private static final ColumnIdentity CHILD_COLUMN_IDENTITY = new ColumnIdentity(4, "child", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
    private static final String PARENT_COLUMN_NAME = "parent";
    private static final ColumnIdentity PARENT_COLUMN_IDENTITY = new ColumnIdentity(3, "parent", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)CHILD_COLUMN_IDENTITY));
    private static final IcebergColumnHandle CHILD_COLUMN_HANDLE = new IcebergColumnHandle(PARENT_COLUMN_IDENTITY, (io.trino.spi.type.Type)RowType.rowType((RowType.Field[])new RowType.Field[]{new RowType.Field(Optional.of("child"), (io.trino.spi.type.Type)IntegerType.INTEGER)}), (List)ImmutableList.of((Object)CHILD_COLUMN_IDENTITY.getId()), (io.trino.spi.type.Type)IntegerType.INTEGER, true, Optional.empty());
    private static final Schema TABLE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)COLUMN_1_IDENTITY.getId(), (String)"col1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)COLUMN_2_IDENTITY.getId(), (String)"part", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)PARENT_COLUMN_IDENTITY.getId(), (String)"parent", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)CHILD_COLUMN_IDENTITY.getId(), (String)"child", (Type)Types.IntegerType.get())}))});

    TestFileBasedConflictDetection() {
    }

    @Test
    void testConflictDetectionOnNonPartitionedTable() {
        PartitionSpec partitionSpec = PartitionSpec.unpartitioned();
        Table icebergTable = TestFileBasedConflictDetection.createIcebergTable(partitionSpec);
        List<CommitTaskData> commitTasks = TestFileBasedConflictDetection.getCommitTaskDataForUpdate(partitionSpec, Optional.empty());
        TupleDomain icebergColumnHandleTupleDomain = IcebergMetadata.extractTupleDomainsFromCommitTasks((IcebergTableHandle)TestFileBasedConflictDetection.getIcebergTableHandle(partitionSpec), (Table)icebergTable, commitTasks, null);
        Assertions.assertThat((Map)((Map)icebergColumnHandleTupleDomain.getDomains().orElseThrow())).isEmpty();
        TestFileBasedConflictDetection.dropIcebergTable(icebergTable);
    }

    @Test
    void testConflictDetectionOnPartitionedTable() {
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).identity(COLUMN_2_NAME).build();
        Table icebergTable = TestFileBasedConflictDetection.createIcebergTable(partitionSpec);
        String partitionDataJson = "{\"partitionValues\":[40]}\n";
        Map<IcebergColumnHandle, Domain> expectedDomains = Map.of(COLUMN_2_HANDLE, Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)40L));
        List<CommitTaskData> commitTasks = TestFileBasedConflictDetection.getCommitTaskDataForUpdate(partitionSpec, Optional.of(partitionDataJson));
        TupleDomain icebergColumnHandleTupleDomain = IcebergMetadata.extractTupleDomainsFromCommitTasks((IcebergTableHandle)TestFileBasedConflictDetection.getIcebergTableHandle(partitionSpec), (Table)icebergTable, commitTasks, null);
        Assertions.assertThat((Map)((Map)icebergColumnHandleTupleDomain.getDomains().orElseThrow())).isEqualTo(expectedDomains);
        TestFileBasedConflictDetection.dropIcebergTable(icebergTable);
    }

    @Test
    void testConflictDetectionOnPartitionedTableWithMultiplePartitionValues() {
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).identity(COLUMN_2_NAME).build();
        Table icebergTable = TestFileBasedConflictDetection.createIcebergTable(partitionSpec);
        String partitionDataJson1 = "{\"partitionValues\":[40]}\n";
        String partitionDataJson2 = "{\"partitionValues\":[50]}\n";
        Map<IcebergColumnHandle, Domain> expectedDomains = Map.of(COLUMN_2_HANDLE, Domain.multipleValues((io.trino.spi.type.Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)40L, (Object)50L)));
        List commitTasks = (List)Stream.concat(TestFileBasedConflictDetection.getCommitTaskDataForUpdate(partitionSpec, Optional.of(partitionDataJson1)).stream(), TestFileBasedConflictDetection.getCommitTaskDataForUpdate(partitionSpec, Optional.of(partitionDataJson2)).stream()).collect(ImmutableList.toImmutableList());
        TupleDomain icebergColumnHandleTupleDomain = IcebergMetadata.extractTupleDomainsFromCommitTasks((IcebergTableHandle)TestFileBasedConflictDetection.getIcebergTableHandle(partitionSpec), (Table)icebergTable, (List)commitTasks, null);
        Assertions.assertThat((Map)((Map)icebergColumnHandleTupleDomain.getDomains().orElseThrow())).isEqualTo(expectedDomains);
        TestFileBasedConflictDetection.dropIcebergTable(icebergTable);
    }

    @Test
    void testConflictDetectionOnNestedPartitionedTable() {
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).identity("parent.child").build();
        Table icebergTable = TestFileBasedConflictDetection.createIcebergTable(partitionSpec);
        String partitionDataJson = "{\"partitionValues\":[40]}\n";
        Map<IcebergColumnHandle, Domain> expectedDomains = Map.of(CHILD_COLUMN_HANDLE, Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)40L));
        List<CommitTaskData> commitTasks = TestFileBasedConflictDetection.getCommitTaskDataForUpdate(partitionSpec, Optional.of(partitionDataJson));
        TupleDomain icebergColumnHandleTupleDomain = IcebergMetadata.extractTupleDomainsFromCommitTasks((IcebergTableHandle)TestFileBasedConflictDetection.getIcebergTableHandle(partitionSpec), (Table)icebergTable, commitTasks, null);
        Assertions.assertThat((Map)((Map)icebergColumnHandleTupleDomain.getDomains().orElseThrow())).isEqualTo(expectedDomains);
        TestFileBasedConflictDetection.dropIcebergTable(icebergTable);
    }

    @Test
    void testConflictDetectionOnTableWithTwoPartitions() {
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).identity(COLUMN_2_NAME).identity(COLUMN_1_NAME).build();
        Table icebergTable = TestFileBasedConflictDetection.createIcebergTable(partitionSpec);
        String partitionDataJson = "{\"partitionValues\":[40, 12]}\n";
        Map<IcebergColumnHandle, Domain> expectedDomains = Map.of(COLUMN_2_HANDLE, Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)40L), COLUMN_1_HANDLE, Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)12L));
        List<CommitTaskData> commitTasks = TestFileBasedConflictDetection.getCommitTaskDataForUpdate(partitionSpec, Optional.of(partitionDataJson));
        TupleDomain icebergColumnHandleTupleDomain = IcebergMetadata.extractTupleDomainsFromCommitTasks((IcebergTableHandle)TestFileBasedConflictDetection.getIcebergTableHandle(partitionSpec), (Table)icebergTable, commitTasks, null);
        Assertions.assertThat((Map)((Map)icebergColumnHandleTupleDomain.getDomains().orElseThrow())).isEqualTo(expectedDomains);
        TestFileBasedConflictDetection.dropIcebergTable(icebergTable);
    }

    @Test
    void testConflictDetectionOnTableWithTwoPartitionsAndMissingPartitionData() {
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).identity(COLUMN_2_NAME).identity(COLUMN_1_NAME).build();
        Table icebergTable = TestFileBasedConflictDetection.createIcebergTable(partitionSpec);
        String partitionDataJson = "{\"partitionValues\":[40]}\n";
        Map<IcebergColumnHandle, Domain> expectedDomains = Map.of(COLUMN_2_HANDLE, Domain.singleValue((io.trino.spi.type.Type)IntegerType.INTEGER, (Object)40L), COLUMN_1_HANDLE, Domain.onlyNull((io.trino.spi.type.Type)IntegerType.INTEGER));
        List<CommitTaskData> commitTasks = TestFileBasedConflictDetection.getCommitTaskDataForUpdate(partitionSpec, Optional.of(partitionDataJson));
        TupleDomain icebergColumnHandleTupleDomain = IcebergMetadata.extractTupleDomainsFromCommitTasks((IcebergTableHandle)TestFileBasedConflictDetection.getIcebergTableHandle(partitionSpec), (Table)icebergTable, commitTasks, null);
        Assertions.assertThat((Map)((Map)icebergColumnHandleTupleDomain.getDomains().orElseThrow())).isEqualTo(expectedDomains);
        TestFileBasedConflictDetection.dropIcebergTable(icebergTable);
    }

    @Test
    void testConflictDetectionOnEvolvedTable() {
        PartitionSpec previousPartitionSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).identity(COLUMN_1_NAME).build();
        PartitionSpec currentPartitionSpec = PartitionSpec.builderFor((Schema)TABLE_SCHEMA).identity(COLUMN_2_NAME).build();
        Table icebergTable = TestFileBasedConflictDetection.createIcebergTable(currentPartitionSpec);
        String partitionDataJson = "{\"partitionValues\":[40]}\n";
        CommitTaskData commitTaskData1 = new CommitTaskData("test_location/data/new.parquet", IcebergFileFormat.PARQUET, 0L, new MetricsWrapper(new Metrics()), PartitionSpecParser.toJson((PartitionSpec)currentPartitionSpec), Optional.of(partitionDataJson), FileContent.DATA, Optional.empty(), Optional.empty());
        CommitTaskData commitTaskData2 = new CommitTaskData("test_location/data/old.parquet", IcebergFileFormat.PARQUET, 0L, new MetricsWrapper(new Metrics()), PartitionSpecParser.toJson((PartitionSpec)previousPartitionSpec), Optional.of(partitionDataJson), FileContent.POSITION_DELETES, Optional.empty(), Optional.empty());
        TupleDomain icebergColumnHandleTupleDomain = IcebergMetadata.extractTupleDomainsFromCommitTasks((IcebergTableHandle)TestFileBasedConflictDetection.getIcebergTableHandle(currentPartitionSpec), (Table)icebergTable, List.of(commitTaskData1, commitTaskData2), null);
        Assertions.assertThat((Map)((Map)icebergColumnHandleTupleDomain.getDomains().orElseThrow())).isEmpty();
        TestFileBasedConflictDetection.dropIcebergTable(icebergTable);
    }

    private static List<CommitTaskData> getCommitTaskDataForUpdate(PartitionSpec partitionSpec, Optional<String> partitionDataJson) {
        CommitTaskData commitTaskData1 = new CommitTaskData("test_location/data/new.parquet", IcebergFileFormat.PARQUET, 0L, new MetricsWrapper(new Metrics()), PartitionSpecParser.toJson((PartitionSpec)partitionSpec), partitionDataJson, FileContent.DATA, Optional.empty(), Optional.empty());
        CommitTaskData commitTaskData2 = new CommitTaskData("test_location/data/old.parquet", IcebergFileFormat.PARQUET, 0L, new MetricsWrapper(new Metrics()), PartitionSpecParser.toJson((PartitionSpec)partitionSpec), partitionDataJson, FileContent.POSITION_DELETES, Optional.empty(), Optional.empty());
        return List.of(commitTaskData1, commitTaskData2);
    }

    private static IcebergTableHandle getIcebergTableHandle(PartitionSpec partitionSpec) {
        String partitionSpecJson = PartitionSpecParser.toJson((PartitionSpec)partitionSpec);
        return new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), "schemaName", "tableName", TableType.DATA, Optional.empty(), SchemaParser.toJson((Schema)TABLE_SCHEMA), Optional.of(partitionSpecJson), 1, TupleDomain.all(), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of(), Optional.empty(), "dummy_table_location", (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false));
    }

    private static Table createIcebergTable(PartitionSpec partitionSpec) {
        return HADOOP_TABLES.create(TABLE_SCHEMA, partitionSpec, SortOrder.unsorted(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)"ORC"), "table_location" + TestingNames.randomNameSuffix());
    }

    private static void dropIcebergTable(Table icebergTable) {
        HADOOP_TABLES.dropTable(icebergTable.location());
    }
}

