/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.filesystem.Location;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingProperties;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergAbfsConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private final String container = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-container");
    private final String account = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-account");
    private final String accessKey = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-access-key");
    private final String schemaName = "tpch_" + this.format.name().toLowerCase(Locale.ENGLISH);
    private final String bucketName = "test-iceberg-smoke-test-" + TestingNames.randomNameSuffix();
    private HiveHadoop hiveHadoop;

    public TestIcebergAbfsConnectorSmokeTest() {
        super(FileFormat.ORC);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        String abfsSpecificCoreSiteXmlContent = Resources.toString((URL)Resources.getResource((String)"hdp3.1-core-site.xml.abfs-template"), (Charset)StandardCharsets.UTF_8).replace("%ABFS_ACCESS_KEY%", this.accessKey).replace("%ABFS_ACCOUNT%", this.account);
        FileAttribute<Set<PosixFilePermission>> posixFilePermissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
        Path hadoopCoreSiteXmlTempFile = Files.createTempFile("core-site", ".xml", posixFilePermissions);
        hadoopCoreSiteXmlTempFile.toFile().deleteOnExit();
        Files.writeString(hadoopCoreSiteXmlTempFile, (CharSequence)abfsSpecificCoreSiteXmlContent, new OpenOption[0]);
        this.hiveHadoop = (HiveHadoop)this.closeAfterClass((AutoCloseable)((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withImage(HiveHadoop.HIVE3_IMAGE)).withFilesToMount((Map)ImmutableMap.of((Object)"/etc/hadoop/conf/core-site.xml", (Object)hadoopCoreSiteXmlTempFile.normalize().toAbsolutePath().toString()))).build());
        this.hiveHadoop.start();
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)this.hiveHadoop.getHiveMetastoreEndpoint().toString()).put((Object)"hive.metastore.thrift.client.read-timeout", (Object)"1m").put((Object)"fs.native-azure.enabled", (Object)"true").put((Object)"azure.auth-type", (Object)"ACCESS_KEY").put((Object)"azure.access-key", (Object)this.accessKey).put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").put((Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName(this.schemaName).withClonedTpchTables(REQUIRED_TPCH_TABLES).withSchemaProperties(Map.of("location", "'" + TestIcebergAbfsConnectorSmokeTest.formatAbfsUrl(this.container, this.account, this.bucketName) + this.schemaName + "'")).build()).build();
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA IF NOT EXISTS " + schemaName + " WITH (location = '" + TestIcebergAbfsConnectorSmokeTest.formatAbfsUrl(this.container, this.account, this.bucketName) + schemaName + "')";
    }

    @Test
    public void testRenameSchema() {
        this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", this.schemaName, this.schemaName + TestingNames.randomNameSuffix()), "Hive metastore does not support renaming schemas");
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        TestIcebergAbfsConnectorSmokeTest testIcebergAbfsConnectorSmokeTest = this;
        BridgingHiveMetastore metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveHadoop.getHiveMetastoreEndpoint()).build(x$0 -> testIcebergAbfsConnectorSmokeTest.closeAfterClass((AutoCloseable)x$0)));
        metastore.dropTable(this.schemaName, tableName, false);
        Assertions.assertThat((Optional)metastore.getTable(this.schemaName, tableName)).isEmpty();
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        TestIcebergAbfsConnectorSmokeTest testIcebergAbfsConnectorSmokeTest = this;
        BridgingHiveMetastore metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveHadoop.getHiveMetastoreEndpoint()).build(x$0 -> testIcebergAbfsConnectorSmokeTest.closeAfterClass((AutoCloseable)x$0)));
        return (String)((Table)metastore.getTable(this.schemaName, tableName).orElseThrow()).getParameters().get("metadata_location");
    }

    @Override
    protected String schemaPath() {
        return TestIcebergAbfsConnectorSmokeTest.formatAbfsUrl(this.container, this.account, this.bucketName) + this.schemaName;
    }

    @Override
    protected boolean locationExists(String location) {
        return this.hiveHadoop.executeInContainer(new String[]{"hadoop", "fs", "-test", "-d", location}).getExitCode() == 0;
    }

    @Override
    protected void deleteDirectory(String location) {
        this.hiveHadoop.executeInContainerFailOnError(new String[]{"hadoop", "fs", "-rm", "-f", "-r", location});
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }

    private static String formatAbfsUrl(String container, String account, String bucketName) {
        return String.format("abfs://%s@%s.dfs.core.windows.net/%s/", container, account, bucketName);
    }
}

