/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.tracing.CacheFileSystemTraceUtils;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.util.FileOperationUtils;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergAlluxioCacheFileOperations
extends AbstractTestQueryFramework {
    public static final String TEST_SCHEMA = "test_alluxio_schema";
    private Path cacheDirectory;

    protected DistributedQueryRunner createQueryRunner() throws Exception {
        this.cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)this.cacheDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        Path metastoreDirectory = Files.createTempDirectory("iceberg", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)metastoreDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        ImmutableMap icebergProperties = ImmutableMap.builder().put((Object)"fs.cache.enabled", (Object)"true").put((Object)"fs.cache.directories", (Object)this.cacheDirectory.toAbsolutePath().toString()).put((Object)"fs.cache.max-sizes", (Object)"100MB").put((Object)"iceberg.metadata-cache.enabled", (Object)"false").put((Object)"hive.metastore.catalog.dir", (Object)metastoreDirectory.toUri().toString()).buildOrThrow();
        DistributedQueryRunner queryRunner = ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setSchemaInitializer(SchemaInitializer.builder().withSchemaName(TEST_SCHEMA).build()).setIcebergProperties((Map<String, String>)icebergProperties).setWorkerCount(0)).build();
        queryRunner.execute("CREATE SCHEMA IF NOT EXISTS test_alluxio_schema");
        return queryRunner;
    }

    @Test
    public void testCacheFileOperations() {
        this.assertUpdate("DROP TABLE IF EXISTS test_cache_file_operations");
        this.assertUpdate("CREATE TABLE test_cache_file_operations(key varchar, data varchar) with (partitioning=ARRAY['key'])");
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p1', '1-abc')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p2', '2-xyz')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheOperation("Input.readFully", FileOperationUtils.FileType.DATA), 2).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.DATA), 2).addCopies((Object)new CacheOperation("Alluxio.writeCache", FileOperationUtils.FileType.DATA), 2).add((Object)new CacheOperation("Alluxio.readExternalStream", FileOperationUtils.FileType.METADATA_JSON)).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.METADATA_JSON)).add((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.METADATA_JSON)).add((Object)new CacheOperation("Alluxio.writeCache", FileOperationUtils.FileType.METADATA_JSON)).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.SNAPSHOT), 2).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.SNAPSHOT)).addCopies((Object)new CacheOperation("Alluxio.readExternalStream", FileOperationUtils.FileType.MANIFEST), 2).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.MANIFEST), 4).addCopies((Object)new CacheOperation("Alluxio.writeCache", FileOperationUtils.FileType.MANIFEST), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.DATA), 2).add((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.METADATA_JSON)).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.METADATA_JSON)).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.SNAPSHOT), 2).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.SNAPSHOT)).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.MANIFEST), 4).build());
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p3', '3-xyz')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p4', '4-xyz')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p5', '5-xyz')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheOperation("Input.readFully", FileOperationUtils.FileType.DATA), 3).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.DATA), 5).addCopies((Object)new CacheOperation("Alluxio.writeCache", FileOperationUtils.FileType.DATA), 3).add((Object)new CacheOperation("Alluxio.readExternalStream", FileOperationUtils.FileType.METADATA_JSON)).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.METADATA_JSON)).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.METADATA_JSON), 2).add((Object)new CacheOperation("Alluxio.writeCache", FileOperationUtils.FileType.METADATA_JSON)).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.SNAPSHOT), 2).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.SNAPSHOT)).addCopies((Object)new CacheOperation("Alluxio.readExternalStream", FileOperationUtils.FileType.MANIFEST), 3).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.MANIFEST), 10).addCopies((Object)new CacheOperation("Alluxio.writeCache", FileOperationUtils.FileType.MANIFEST), 3).build());
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.DATA), 5).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.METADATA_JSON), 2).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.SNAPSHOT), 2).addCopies((Object)new CacheOperation("Alluxio.readCached", FileOperationUtils.FileType.MANIFEST), 10).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.METADATA_JSON)).add((Object)new CacheOperation("InputFile.length", FileOperationUtils.FileType.SNAPSHOT)).build());
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<CacheOperation> expectedCacheAccesses) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        queryRunner.executeWithPlan(queryRunner.getDefaultSession(), query);
        MultisetAssertions.assertMultisetsEqual(this.getCacheOperations(), expectedCacheAccesses);
    }

    private Multiset<CacheOperation> getCacheOperations() {
        return (Multiset)CacheFileSystemTraceUtils.getCacheOperationSpans((QueryRunner)this.getQueryRunner()).stream().filter(span -> !span.getName().startsWith("InputFile.newStream")).map(CacheOperation::create).collect(Collectors.toCollection(HashMultiset::create));
    }

    private record CacheOperation(String operationName, FileOperationUtils.FileType fileType) {
        public static CacheOperation create(SpanData span) {
            String path = CacheFileSystemTraceUtils.getFileLocation((SpanData)span);
            return new CacheOperation(span.getName(), FileOperationUtils.FileType.fromFilePath(path));
        }
    }
}

