/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.InternalTypeManager;
import io.trino.type.TypeDeserializer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergColumnHandle {
    @Test
    public void testRoundTrip() {
        this.testRoundTrip(new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)12, (String)"blah"), (Type)BigintType.BIGINT, (List)ImmutableList.of(), (Type)BigintType.BIGINT, true, Optional.of("this is a comment")));
        ColumnIdentity foo1 = new ColumnIdentity(1, "foo1", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity foo2 = new ColumnIdentity(2, "foo2", ColumnIdentity.TypeCategory.PRIMITIVE, (List)ImmutableList.of());
        ColumnIdentity foo3 = new ColumnIdentity(3, "foo3", ColumnIdentity.TypeCategory.ARRAY, (List)ImmutableList.of((Object)foo1));
        RowType nestedColumnType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"foo2", (Type)BigintType.BIGINT), (Object)RowType.field((String)"foo3", (Type)new ArrayType((Type)BigintType.BIGINT))));
        IcebergColumnHandle nestedColumn = new IcebergColumnHandle(new ColumnIdentity(5, "foo5", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)foo2, (Object)foo3)), (Type)nestedColumnType, (List)ImmutableList.of(), (Type)nestedColumnType, true, Optional.empty());
        this.testRoundTrip(nestedColumn);
        IcebergColumnHandle partialColumn = new IcebergColumnHandle(new ColumnIdentity(5, "foo5", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)foo2, (Object)foo3)), (Type)nestedColumnType, (List)ImmutableList.of((Object)2), (Type)BigintType.BIGINT, true, Optional.empty());
        this.testRoundTrip(partialColumn);
    }

    private void testRoundTrip(IcebergColumnHandle expected) {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(IcebergColumnHandle.class);
        String json = codec.toJson((Object)expected);
        IcebergColumnHandle actual = (IcebergColumnHandle)codec.fromJson(json);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        Assertions.assertThat((Object)actual.getBaseColumnIdentity()).isEqualTo((Object)expected.getBaseColumnIdentity());
        Assertions.assertThat((Object)actual.getBaseType()).isEqualTo((Object)expected.getBaseType());
        Assertions.assertThat((String)actual.getQualifiedName()).isEqualTo(expected.getQualifiedName());
        Assertions.assertThat((String)actual.getName()).isEqualTo(expected.getName());
        Assertions.assertThat((Object)actual.getColumnIdentity()).isEqualTo((Object)expected.getColumnIdentity());
        Assertions.assertThat((int)actual.getId()).isEqualTo(expected.getId());
        Assertions.assertThat((Object)actual.getType()).isEqualTo((Object)expected.getType());
        Assertions.assertThat((Optional)actual.getComment()).isEqualTo((Object)expected.getComment());
    }
}

