/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.iceberg.CatalogType;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import jakarta.validation.constraints.AssertFalse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestIcebergConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((IcebergConfig)ConfigAssertions.recordDefaults(IcebergConfig.class)).setFileFormat(IcebergFileFormat.PARQUET).setCompressionCodec(HiveCompressionOption.ZSTD).setMaxCommitRetry(4).setUseFileSizeFromMetadata(true).setMaxPartitionsPerWriter(100).setUniqueTableLocation(true).setCatalogType(CatalogType.HIVE_METASTORE).setDynamicFilteringWaitTimeout(new Duration(1.0, TimeUnit.SECONDS)).setTableStatisticsEnabled(true).setExtendedStatisticsEnabled(true).setCollectExtendedStatisticsOnWrite(true).setProjectionPushdownEnabled(true).setHiveCatalogName(null).setFormatVersion(2).setExpireSnapshotsMinRetention(new Duration(7.0, TimeUnit.DAYS)).setRemoveOrphanFilesMinRetention(new Duration(7.0, TimeUnit.DAYS)).setDeleteSchemaLocationsFallback(false).setTargetMaxFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setIdleWriterMinFileSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMinimumAssignedSplitWeight(0.05).setHideMaterializedViewStorageTable(true).setMaterializedViewsStorageSchema(null).setRegisterTableProcedureEnabled(false).setAddFilesProcedureEnabled(false).setSortedWritingEnabled(true).setQueryPartitionFilterRequired(false).setQueryPartitionFilterRequiredSchemas((Set)ImmutableSet.of()).setSplitManagerThreads(Integer.toString(Runtime.getRuntime().availableProcessors() * 2)).setPlanningThreads(Integer.toString(Runtime.getRuntime().availableProcessors())).setAllowedExtraProperties((List)ImmutableList.of()).setIncrementalRefreshEnabled(true).setMetadataCacheEnabled(true).setIncrementalRefreshEnabled(true).setObjectStoreLayoutEnabled(false).setMetadataParallelism(8).setBucketExecutionEnabled(true).setFileBasedConflictDetectionEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)"ORC").put((Object)"iceberg.compression-codec", (Object)"NONE").put((Object)"iceberg.max-commit-retry", (Object)"100").put((Object)"iceberg.use-file-size-from-metadata", (Object)"false").put((Object)"iceberg.max-partitions-per-writer", (Object)"222").put((Object)"iceberg.unique-table-location", (Object)"false").put((Object)"iceberg.catalog.type", (Object)"GLUE").put((Object)"iceberg.dynamic-filtering.wait-timeout", (Object)"1h").put((Object)"iceberg.table-statistics-enabled", (Object)"false").put((Object)"iceberg.extended-statistics.enabled", (Object)"false").put((Object)"iceberg.extended-statistics.collect-on-write", (Object)"false").put((Object)"iceberg.projection-pushdown-enabled", (Object)"false").put((Object)"iceberg.hive-catalog-name", (Object)"hive").put((Object)"iceberg.format-version", (Object)"1").put((Object)"iceberg.expire-snapshots.min-retention", (Object)"13h").put((Object)"iceberg.remove-orphan-files.min-retention", (Object)"14h").put((Object)"iceberg.delete-schema-locations-fallback", (Object)"true").put((Object)"iceberg.target-max-file-size", (Object)"1MB").put((Object)"iceberg.idle-writer-min-file-size", (Object)"1MB").put((Object)"iceberg.minimum-assigned-split-weight", (Object)"0.01").put((Object)"iceberg.materialized-views.hide-storage-table", (Object)"false").put((Object)"iceberg.materialized-views.storage-schema", (Object)"mv_storage_schema").put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.add-files-procedure.enabled", (Object)"true").put((Object)"iceberg.sorted-writing-enabled", (Object)"false").put((Object)"iceberg.query-partition-filter-required", (Object)"true").put((Object)"iceberg.query-partition-filter-required-schemas", (Object)"bronze,silver").put((Object)"iceberg.split-manager-threads", (Object)"42").put((Object)"iceberg.planning-threads", (Object)"42").put((Object)"iceberg.allowed-extra-properties", (Object)"propX,propY").put((Object)"iceberg.incremental-refresh-enabled", (Object)"false").put((Object)"iceberg.metadata-cache.enabled", (Object)"false").put((Object)"iceberg.object-store-layout.enabled", (Object)"true").put((Object)"iceberg.metadata.parallelism", (Object)"10").put((Object)"iceberg.bucket-execution", (Object)"false").put((Object)"iceberg.file-based-conflict-detection", (Object)"false").buildOrThrow();
        IcebergConfig expected = new IcebergConfig().setFileFormat(IcebergFileFormat.ORC).setCompressionCodec(HiveCompressionOption.NONE).setMaxCommitRetry(100).setUseFileSizeFromMetadata(false).setMaxPartitionsPerWriter(222).setUniqueTableLocation(false).setCatalogType(CatalogType.GLUE).setDynamicFilteringWaitTimeout(Duration.valueOf((String)"1h")).setTableStatisticsEnabled(false).setExtendedStatisticsEnabled(false).setCollectExtendedStatisticsOnWrite(false).setProjectionPushdownEnabled(false).setHiveCatalogName("hive").setFormatVersion(1).setExpireSnapshotsMinRetention(new Duration(13.0, TimeUnit.HOURS)).setRemoveOrphanFilesMinRetention(new Duration(14.0, TimeUnit.HOURS)).setDeleteSchemaLocationsFallback(true).setTargetMaxFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setIdleWriterMinFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMinimumAssignedSplitWeight(0.01).setHideMaterializedViewStorageTable(false).setMaterializedViewsStorageSchema("mv_storage_schema").setRegisterTableProcedureEnabled(true).setAddFilesProcedureEnabled(true).setSortedWritingEnabled(false).setQueryPartitionFilterRequired(true).setQueryPartitionFilterRequiredSchemas((Set)ImmutableSet.of((Object)"bronze", (Object)"silver")).setSplitManagerThreads("42").setPlanningThreads("42").setAllowedExtraProperties((List)ImmutableList.of((Object)"propX", (Object)"propY")).setIncrementalRefreshEnabled(false).setMetadataCacheEnabled(false).setIncrementalRefreshEnabled(false).setObjectStoreLayoutEnabled(true).setMetadataParallelism(10).setBucketExecutionEnabled(false).setFileBasedConflictDetectionEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidation() {
        ValidationAssertions.assertFailsValidation((Object)new IcebergConfig().setHideMaterializedViewStorageTable(true).setMaterializedViewsStorageSchema("storage_schema"), (String)"storageSchemaSetWhenHidingIsEnabled", (String)"iceberg.materialized-views.storage-schema may only be set when iceberg.materialized-views.hide-storage-table is set to false", AssertFalse.class);
    }
}

