/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Table;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private HiveMetastore metastore;

    public TestIcebergConnectorSmokeTest() {
        super(FileFormat.ORC);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setInitialTables(TpchTable.NATION, TpchTable.ORDERS, TpchTable.REGION).setIcebergProperties((Map<String, String>)ImmutableMap.of((Object)"iceberg.file-format", (Object)this.format.name(), (Object)"iceberg.register-table-procedure.enabled", (Object)"true", (Object)"iceberg.writer-sort-buffer-size", (Object)"1MB", (Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max")).build();
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        return queryRunner;
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        this.metastore.dropTable((String)this.getSession().getSchema().orElseThrow(), tableName, false);
        ((OptionalAssert)Assertions.assertThat((Optional)this.metastore.getTable((String)this.getSession().getSchema().orElseThrow(), tableName)).as("Table in metastore should be dropped", new Object[0])).isEmpty();
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        return (String)((Table)this.metastore.getTable((String)this.getSession().getSchema().orElseThrow(), tableName).orElseThrow()).getParameters().get("metadata_location");
    }

    @Override
    protected String schemaPath() {
        return "local:///%s".formatted(this.getSession().getSchema().orElseThrow());
    }

    @Override
    protected boolean locationExists(String location) {
        try {
            return this.fileSystem.newInputFile(Location.of((String)location)).exists();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void deleteDirectory(String location) {
        try {
            this.fileSystem.deleteDirectory(Location.of((String)location));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }

    @Test
    public void testRowConstructorColumnLimitForMergeQuery() {
        String[] colNames = new String[]{"orderkey", "custkey", "orderstatus", "totalprice", "orderpriority", "clerk", "shippriority", "comment", "orderdate"};
        String[] colTypes = new String[]{"bigint", "bigint", "varchar", "decimal(12,2)", "varchar", "varchar", "int", "varchar", "date"};
        Object tableDefinition = "(";
        Object columns = "(";
        Object selectQuery = "select ";
        Object notMatchedClause = "";
        Object matchedClause = "";
        for (int i = 0; i < 36; ++i) {
            for (int j = 0; j < 9; ++j) {
                String columnName = colNames[j];
                String columnType = colTypes[j];
                tableDefinition = (String)tableDefinition + columnName + "_" + i + " " + columnType + ",";
                selectQuery = (String)selectQuery + columnName + " " + columnName + "_" + i + ",";
                columns = (String)columns + columnName + "_" + i + ",";
                notMatchedClause = (String)notMatchedClause + "s." + columnName + "_" + i + ",";
                matchedClause = (String)matchedClause + columnName + "_" + i + " = s." + columnName + "_" + i + ",";
            }
        }
        tableDefinition = (String)tableDefinition + "orderkey bigint, custkey bigint,  orderstatus varchar, totalprice decimal(12,2), orderpriority varchar) ";
        selectQuery = (String)selectQuery + "orderkey, custkey,  orderstatus, totalprice, orderpriority from orders limit 1 ";
        columns = (String)columns + "orderkey, custkey,  orderstatus, totalprice, orderpriority) ";
        notMatchedClause = (String)notMatchedClause + "s.orderkey, s.custkey,  s.orderstatus, s.totalprice, s.orderpriority ";
        matchedClause = (String)matchedClause + "orderkey = s.orderkey, custkey = s.custkey,  orderstatus = s.orderstatus, totalprice = t.totalprice, orderpriority = s.orderpriority ";
        TestTable table = this.newTrinoTable("test_merge_", (String)tableDefinition);
        this.assertUpdate("INSERT INTO " + table.getName() + " " + (String)columns + " " + (String)selectQuery, 1L);
        TestTable mergeTable = this.newTrinoTable("test_table_", (String)tableDefinition);
        this.assertUpdate("INSERT INTO " + mergeTable.getName() + " " + (String)columns + " " + (String)selectQuery, 1L);
        this.assertUpdate("MERGE INTO %s t\nUSING (select * from %s ) s\nON (t.orderkey = s.orderkey)\nWHEN MATCHED THEN UPDATE SET %s\nWHEN NOT MATCHED THEN INSERT VALUES (%s)\n".formatted(mergeTable.getName(), table.getName(), matchedClause, notMatchedClause), 1L);
    }
}

