/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.testing.BaseDynamicPartitionPruningTest;
import io.trino.testing.QueryRunner;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestIcebergDynamicPartitionPruningTest
extends BaseDynamicPartitionPruningTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setExtraProperties(EXTRA_PROPERTIES)).setIcebergProperties(Map.of("iceberg.dynamic-filtering.wait-timeout", "1h")).setInitialTables(REQUIRED_TABLES).build();
    }

    protected void createLineitemTable(String tableName, List<String> columns, List<String> partitionColumns) {
        String sql = String.format("CREATE TABLE %s WITH (partitioning=array[%s]) AS SELECT %s FROM tpch.tiny.lineitem", tableName, partitionColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")), String.join((CharSequence)",", columns));
        this.getQueryRunner().execute(sql);
    }

    protected void createPartitionedTable(String tableName, List<String> columns, List<String> partitionColumns) {
        String sql = String.format("CREATE TABLE %s (%s) WITH (partitioning=array[%s])", tableName, String.join((CharSequence)",", columns), partitionColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")));
        this.getQueryRunner().execute(sql);
    }

    protected void createPartitionedAndBucketedTable(String tableName, List<String> columns, List<String> partitionColumns, List<String> bucketColumns) {
        ImmutableList.Builder partitioning = ImmutableList.builder();
        partitionColumns.forEach(arg_0 -> ((ImmutableList.Builder)partitioning).add(arg_0));
        bucketColumns.forEach(column -> partitioning.add((Object)"bucket(%s,10)".formatted(column)));
        Object[] objectArray = new Object[3];
        objectArray[0] = tableName;
        objectArray[1] = String.join((CharSequence)",", columns);
        String string = "'%s'";
        objectArray[2] = String.join((CharSequence)",", partitioning.build().stream().map(arg_0 -> TestIcebergDynamicPartitionPruningTest.lambda$createPartitionedAndBucketedTable$1("'%s'", arg_0)).toList());
        String sql = String.format("CREATE TABLE %s (%s) WITH (partitioning=ARRAY[%s])", objectArray);
        this.getQueryRunner().execute(sql);
    }

    private static /* synthetic */ String lambda$createPartitionedAndBucketedTable$1(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }
}

