/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.iceberg.util.EqualityDeleteUtils;
import io.trino.plugin.iceberg.util.FileOperationUtils;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.ThreadPools;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergFileOperations
extends AbstractTestQueryFramework {
    private static final int MAX_PREFIXES_COUNT = 10;
    private HiveMetastore metastore;
    private TrinoFileSystemFactory fileSystemFactory;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("iceberg").setSchema("test_schema").setSystemProperty("min_input_size_per_task", "0MB").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(0).addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(10)).build();
        Path dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data");
        dataDirectory.toFile().mkdirs();
        queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(dataDirectory));
        queryRunner.createCatalog("iceberg", "iceberg", (Map)ImmutableMap.builder().put((Object)"iceberg.split-manager-threads", (Object)"0").put((Object)"iceberg.metadata-cache.enabled", (Object)"false").buildOrThrow());
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        queryRunner.execute("CREATE SCHEMA test_schema");
        return queryRunner;
    }

    @BeforeAll
    public void initFileSystemFactory() {
        this.fileSystemFactory = IcebergTestUtils.getFileSystemFactory((QueryRunner)this.getDistributedQueryRunner());
    }

    @Test
    public void testCreateTable() {
        this.assertFileSystemAccesses("CREATE TABLE test_create (id VARCHAR, age INT)", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).build());
    }

    @Test
    public void testCreateOrReplaceTable() {
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).build());
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).build());
    }

    @Test
    public void testCreateTableAsSelect() {
        this.assertFileSystemAccesses(TestIcebergFileOperations.withStatsOnWrite(this.getSession(), false), "CREATE TABLE test_create_as_select AS SELECT 1 col_name", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "OutputFile.create")).build());
        this.assertFileSystemAccesses(TestIcebergFileOperations.withStatsOnWrite(this.getSession(), true), "CREATE TABLE test_create_as_select_with_stats AS SELECT 1 col_name", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.STATS, "OutputFile.create")).build());
    }

    @Test
    public void testCreateOrReplaceTableAsSelect() {
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace_as_select AS SELECT 1 col_name", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.STATS, "OutputFile.create")).build());
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace_as_select AS SELECT 1 col_name", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.STATS, "OutputFile.create")).build());
    }

    @Test
    public void testInsert() {
        this.assertUpdate("CREATE TABLE test_insert (id VARCHAR, age INT)");
        this.assertFileSystemAccesses("INSERT INTO test_insert VALUES('a', 1)", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 3).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length"), 3).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream"), 3).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.STATS, "OutputFile.create")).build());
        this.assertFileSystemAccesses("INSERT INTO test_insert VALUES('b', 2)", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "OutputFile.create"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 3).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream"), 3).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length"), 3).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.STATS, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "OutputFile.create")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.STATS, "OutputFile.create")).build());
    }

    @Test
    public void testSelect() {
        this.assertUpdate("CREATE TABLE test_select AS SELECT 1 col_name", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_select", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
    }

    @ParameterizedTest
    @MethodSource(value={"testSelectWithLimitDataProvider"})
    public void testSelectWithLimit(int numberOfFiles) {
        this.assertUpdate("DROP TABLE IF EXISTS test_select_with_limit");
        this.assertUpdate("CREATE TABLE test_select_with_limit(k varchar, v integer) WITH (partitioning=ARRAY['truncate(k, 1)'])");
        for (int i = 0; i < numberOfFiles; ++i) {
            String k = Integer.toString(10 + i * 5);
            this.assertUpdate("INSERT INTO test_select_with_limit VALUES ('" + k + "', " + i + ")", 1L);
        }
        int icebergManifestPrefetching = 2 * ThreadPools.WORKER_THREAD_POOL_SIZE;
        this.assertFileSystemAccesses("SELECT * FROM test_select_with_limit LIMIT 3", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), Math.min(icebergManifestPrefetching, numberOfFiles)).build());
        this.assertFileSystemAccesses("EXPLAIN SELECT * FROM test_select_with_limit LIMIT 3", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), numberOfFiles).build());
        this.assertFileSystemAccesses("EXPLAIN ANALYZE SELECT * FROM test_select_with_limit LIMIT 3", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), numberOfFiles + Math.min(icebergManifestPrefetching, numberOfFiles)).build());
        this.assertUpdate("DROP TABLE test_select_with_limit");
    }

    public Object[][] testSelectWithLimitDataProvider() {
        return new Object[][]{{10}, {50}, {4 * ThreadPools.WORKER_THREAD_POOL_SIZE + 6}};
    }

    @Test
    public void testReadWholePartition() {
        this.assertUpdate("DROP TABLE IF EXISTS test_read_part_key");
        this.assertUpdate("CREATE TABLE test_read_part_key(key varchar, data varchar) WITH (partitioning=ARRAY['key'])");
        this.assertUpdate("INSERT INTO test_read_part_key(key, data) VALUES ('p1', '1-abc'), ('p1', '1-def'), ('p2', '2-abc'), ('p2', '2-def')", 4L);
        this.assertUpdate("INSERT INTO test_read_part_key(key, data) VALUES ('p1', '1-baz'), ('p2', '2-baz')", 2L);
        this.assertFileSystemAccesses("SELECT key, max(data) FROM test_read_part_key GROUP BY key", FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.DATA, "InputFile.newInput"), 4).build());
        this.assertFileSystemAccesses("SELECT key, count(*) FROM test_read_part_key GROUP BY key", FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT count(*) FROM test_read_part_key WHERE key = 'p1'", FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT count(*), array_agg(\"$path\"), max(\"$file_modified_time\") FROM test_read_part_key GROUP BY key", FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.DATA, "InputFile.newInput"), 4).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.DATA, "InputFile.lastModified"), 4).build());
        this.assertFileSystemAccesses("SELECT count(*) FROM test_read_part_key", FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).build());
        this.assertUpdate("DROP TABLE test_read_part_key");
    }

    @Test
    public void testReadWholePartitionSplittableFile() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        this.assertUpdate("DROP TABLE IF EXISTS test_read_whole_splittable_file");
        this.assertUpdate("CREATE TABLE test_read_whole_splittable_file(key varchar, data varchar) WITH (partitioning=ARRAY['key'])");
        this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("writer_scaling_min_data_processed", "1PB").setCatalogSessionProperty(catalog, "parquet_writer_block_size", "1kB").setCatalogSessionProperty(catalog, "orc_writer_max_stripe_size", "1kB").setCatalogSessionProperty(catalog, "orc_writer_max_stripe_rows", "1000").build(), "INSERT INTO test_read_whole_splittable_file SELECT 'single partition', comment FROM tpch.tiny.orders", 15000L);
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "experimental_split_size", "1kB").build();
        this.assertFileSystemAccesses(session, "SELECT key, count(*) FROM test_read_whole_splittable_file GROUP BY key", FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).build());
        this.assertFileSystemAccesses(session, "SELECT count(*) FROM test_read_whole_splittable_file", FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).build());
        this.assertUpdate("DROP TABLE test_read_whole_splittable_file");
    }

    @Test
    public void testSelectFromVersionedTable() {
        String tableName = "test_select_from_versioned_table";
        this.assertUpdate("CREATE TABLE " + tableName + " (id int, age int)");
        long v1SnapshotId = this.getLatestSnapshotId(tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 20)", 1L);
        long v2SnapshotId = this.getLatestSnapshotId(tableName);
        this.assertUpdate("INSERT INTO " + tableName + "  VALUES (3, 30)", 1L);
        long v3SnapshotId = this.getLatestSnapshotId(tableName);
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v1SnapshotId, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).build());
    }

    @Test
    public void testSelectFromVersionedTableWithSchemaEvolution() {
        String tableName = "test_select_from_versioned_table_with_schema_evolution";
        this.assertUpdate("CREATE TABLE " + tableName + " (id int, age int)");
        long v1SnapshotId = this.getLatestSnapshotId(tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 20)", 1L);
        long v2SnapshotId = this.getLatestSnapshotId(tableName);
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN address varchar");
        this.assertUpdate("INSERT INTO " + tableName + "  VALUES (3, 30, 'London')", 1L);
        long v3SnapshotId = this.getLatestSnapshotId(tableName);
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v1SnapshotId, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v2SnapshotId, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF " + v3SnapshotId, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).build());
    }

    @Test
    public void testSelectWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_with_filter AS SELECT 1 col_name", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_select_with_filter WHERE col_name = 1", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
    }

    @Test
    public void testPartialTimestampPartitionPruningEffectivenessWithPartitionTransform() {
        this.testPartialTimestampPartitionPruningEffectivenessWithPartitionTransform("hour(d)", 4);
        this.testPartialTimestampPartitionPruningEffectivenessWithPartitionTransform("day(d)", 2);
        this.testPartialTimestampPartitionPruningEffectivenessWithPartitionTransform("month(d)", 2);
        this.testPartialTimestampPartitionPruningEffectivenessWithPartitionTransform("year(d)", 2);
        this.testPartialTimestampPartitionPruningEffectivenessWithPartitionTransform("bucket(d, 4)", 2);
    }

    private void testPartialTimestampPartitionPruningEffectivenessWithPartitionTransform(String partitionTransform, int expectedDataFileOperations) {
        String tableName = "test_transform_timestamp" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (d TIMESTAMP(6), b BIGINT) WITH (partitioning = ARRAY['%s'])", tableName, partitionTransform));
        String values = "VALUES\n    (NULL, 101),\n    (TIMESTAMP '1969-12-25 15:13:12.876543', 8),\n    (TIMESTAMP '1969-12-30 18:47:33.345678', 9),\n    (TIMESTAMP '1969-12-31 00:00:00.000000', 10),\n    (TIMESTAMP '1969-12-31 05:06:07.234567', 11),\n    (TIMESTAMP '1970-01-01 12:03:08.456789', 12),\n    (TIMESTAMP '2015-01-01 10:01:23.123456', 1),\n    (TIMESTAMP '2015-01-01 11:10:02.987654', 2),\n    (TIMESTAMP '2015-01-01 12:55:00.456789', 3),\n    (TIMESTAMP '2015-05-15 13:05:01.234567', 4),\n    (TIMESTAMP '2015-05-15 14:21:02.345678', 5),\n    (TIMESTAMP '2020-02-21 15:11:11.876543', 6),\n    (TIMESTAMP '2020-02-21 16:12:12.654321', 7)\n";
        this.assertUpdate("INSERT INTO " + tableName + " " + values, 13L);
        this.assertQuery("SELECT * FROM " + tableName, values);
        String selectQuery = "SELECT * FROM " + tableName + " WHERE d >= TIMESTAMP '2015-05-15 01:23:45.678901'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectQuery))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        this.assertFileSystemAccesses(this.getSession(), selectQuery, FileOperationUtils.Scope.ALL_FILES, (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.DATA, "InputFile.newInput"), expectedDataFileOperations).build());
        Assertions.assertThat((long)((Long)this.computeScalar("SELECT COUNT(DISTINCT file_path) FROM \"" + tableName + "$files\""))).isGreaterThan((long)expectedDataFileOperations);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testJoin() {
        this.assertUpdate("CREATE TABLE test_join_t1 AS SELECT 2 AS age, 'id1' AS id", 1L);
        this.assertUpdate("CREATE TABLE test_join_t2 AS SELECT 'name1' AS name, 'id1' AS id", 1L);
        this.assertFileSystemAccesses("SELECT name, age FROM test_join_t1 JOIN test_join_t2 ON test_join_t2.id = test_join_t1.id", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 4).build());
    }

    @Test
    public void testSelfJoinStatistics() {
        this.assertUpdate("CREATE TABLE test_self_join AS SELECT 'name1' AS name, 2 AS age, 'id1' AS id", 1L);
        this.assertFileSystemAccesses("EXPLAIN SELECT t1.name, t1.age FROM test_self_join t1 JOIN test_self_join t2 ON t1.id = t2.id", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("EXPLAIN SELECT t1.age FROM test_self_join t1 JOIN test_self_join t2 ON t1.id = t2.id WHERE t2.age > 0", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).build());
        this.assertFileSystemAccesses("EXPLAIN SELECT t1.name FROM test_self_join t1 JOIN test_self_join t2 ON t1.name = t2.id", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).build());
    }

    @Test
    public void testJoinWithPartitionedTable() {
        this.assertUpdate("CREATE TABLE test_join_partitioned_t1 (a BIGINT, b TIMESTAMP(6) with time zone) WITH (partitioning = ARRAY['a', 'day(b)'])");
        this.assertUpdate("CREATE TABLE test_join_partitioned_t2 (foo BIGINT)");
        this.assertUpdate("INSERT INTO test_join_partitioned_t2 VALUES(123)", 1L);
        this.assertUpdate("INSERT INTO test_join_partitioned_t1 VALUES(123, current_date)", 1L);
        this.assertFileSystemAccesses("SELECT count(*) FROM test_join_partitioned_t1 t1 join test_join_partitioned_t2 t2 on t1.a = t2.foo", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 4).build());
    }

    @Test
    public void testExplainSelect() {
        this.assertUpdate("CREATE TABLE test_explain AS SELECT 2 AS age", 1L);
        this.assertFileSystemAccesses("EXPLAIN SELECT * FROM test_explain", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
    }

    @Test
    public void testShowStatsForTable() {
        this.assertUpdate("CREATE TABLE test_show_stats AS SELECT 2 AS age", 1L);
        this.assertFileSystemAccesses("SHOW STATS FOR test_show_stats", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
    }

    @Test
    public void testShowStatsForPartitionedTable() {
        this.assertUpdate("CREATE TABLE test_show_stats_partitioned WITH (partitioning = ARRAY['regionkey']) AS SELECT * FROM tpch.tiny.nation", 25L);
        this.assertFileSystemAccesses("SHOW STATS FOR test_show_stats_partitioned", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
    }

    @Test
    public void testShowStatsForTableWithFilter() {
        this.assertUpdate("CREATE TABLE test_show_stats_with_filter AS SELECT 2 AS age", 1L);
        this.assertFileSystemAccesses("SHOW STATS FOR (SELECT * FROM test_show_stats_with_filter WHERE age >= 2)", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
    }

    @Test
    public void testPredicateWithVarcharCastToDate() {
        this.assertUpdate("CREATE TABLE test_varchar_as_date_predicate(a varchar) WITH (partitioning=ARRAY['truncate(a, 4)'])");
        this.assertUpdate("INSERT INTO test_varchar_as_date_predicate VALUES '2001-01-31'", 1L);
        this.assertUpdate("INSERT INTO test_varchar_as_date_predicate VALUES '2005-09-10'", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_varchar_as_date_predicate", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM test_varchar_as_date_predicate WHERE CAST(a AS date) >= DATE '2005-01-01'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_varchar_as_date_predicate WHERE CAST(a AS date) BETWEEN DATE '2005-01-01' AND DATE '2005-12-31'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_varchar_as_date_predicate WHERE date(a) >= DATE '2005-01-01'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream")).add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream")).build());
        this.assertUpdate("DROP TABLE test_varchar_as_date_predicate");
    }

    @Test
    public void testRemoveOrphanFiles() {
        String tableName = "test_remove_orphan_files_" + TestingNames.randomNameSuffix();
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty("iceberg", "remove_orphan_files_min_retention", "0s").build();
        this.assertUpdate("CREATE TABLE " + tableName + " (key varchar, value integer)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('one', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('two', 2), ('three', 3)", 2L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE key = 'two'", 1L);
        this.assertFileSystemAccesses(sessionWithShortRetentionUnlocked, "ALTER TABLE " + tableName + " EXECUTE REMOVE_ORPHAN_FILES (retention_threshold => '0s')", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.length"), 4).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.SNAPSHOT, "InputFile.newStream"), 4).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.MANIFEST, "InputFile.newStream"), 5).build());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @ParameterizedTest
    @MethodSource(value={"metadataQueriesTestTableCountDataProvider"})
    public void testInformationSchemaColumns(int tables) {
        int i;
        String schemaName = "test_i_s_columns_schema" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "CREATE TABLE test_select_i_s_columns" + i + "(id varchar, age integer)");
            this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('abc', 11)", 1L);
            this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('xyz', 12)", 1L);
            this.assertUpdate(session, "CREATE TABLE test_other_select_i_s_columns" + i + "(id varchar, age integer)");
        }
        this.assertFileSystemAccesses(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name LIKE 'test_select_i_s_columns%'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), tables * 2).build());
        this.assertFileSystemAccesses(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = 'test_select_i_s_columns0'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).build());
        this.assertFileSystemAccesses(session, "DESCRIBE test_select_i_s_columns0", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).build());
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "DROP TABLE test_select_i_s_columns" + i);
            this.assertUpdate(session, "DROP TABLE test_other_select_i_s_columns" + i);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"metadataQueriesTestTableCountDataProvider"})
    public void testSystemMetadataTableComments(int tables) {
        int i;
        String schemaName = "test_s_m_table_comments" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "CREATE TABLE test_select_s_m_t_comments" + i + "(id varchar, age integer)");
            this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('abc', 11)", 1L);
            this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('xyz', 12)", 1L);
            this.assertUpdate(session, "CREATE TABLE test_other_select_s_m_t_comments" + i + "(id varchar, age integer)");
        }
        this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), tables * 2).build());
        this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name IN (CURRENT_SCHEMA, 'non_existent') AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), tables * 2).build());
        this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name = 'test_select_s_m_t_comments0'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream")).build());
        for (i = 0; i < tables; ++i) {
            this.assertUpdate(session, "DROP TABLE test_select_s_m_t_comments" + i);
            this.assertUpdate(session, "DROP TABLE test_other_select_s_m_t_comments" + i);
        }
    }

    public Object[][] metadataQueriesTestTableCountDataProvider() {
        return new Object[][]{{3}, {10}, {13}};
    }

    @Test
    public void testSystemMetadataMaterializedViews() {
        String schemaName = "test_materialized_views_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
        this.assertUpdate(session, "CREATE TABLE test_table1 AS SELECT 1 a", 1L);
        this.assertUpdate(session, "CREATE TABLE test_table2 AS SELECT 1 a", 1L);
        this.assertUpdate(session, "CREATE MATERIALIZED VIEW mv1 AS SELECT * FROM test_table1 JOIN test_table2 USING (a)");
        this.assertUpdate(session, "REFRESH MATERIALIZED VIEW mv1", 1L);
        this.assertUpdate(session, "CREATE MATERIALIZED VIEW mv2 AS SELECT count(*) c FROM test_table1 JOIN test_table2 USING (a)");
        this.assertUpdate(session, "REFRESH MATERIALIZED VIEW mv2", 1L);
        this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 4).build());
        this.assertFileSystemAccesses(session, "SELECT schema_name, name FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.of());
        this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.materialized_views WHERE schema_name IN (CURRENT_SCHEMA, 'non_existent')", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 4).build());
        this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA AND name = 'mv1'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.METADATA_JSON, "InputFile.newStream"), 3).build());
        this.assertFileSystemAccesses(session, "SELECT schema_name, name FROM system.metadata.materialized_views WHERE schema_name = CURRENT_SCHEMA AND name = 'mv1'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.of());
        this.assertFileSystemAccesses(session, "SELECT * FROM iceberg.information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = 'mv1'", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.of());
        this.assertUpdate("DROP SCHEMA " + schemaName + " CASCADE");
    }

    @Test
    public void testV2TableEnsureEqualityDeleteFilesAreReadOnce() throws Exception {
        String tableName = "test_equality_deletes_ensure_delete_read_count" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id INT, age INT)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 20), (3, 30)", 2L);
        this.assertUpdate("INSERT INTO " + tableName + "  VALUES (2, 22)", 1L);
        BaseTable icebergTable = IcebergTestUtils.loadTable(tableName, this.metastore, this.fileSystemFactory, "iceberg", "test_schema");
        EqualityDeleteUtils.writeEqualityDeleteForTable((Table)icebergTable, this.fileSystemFactory, Optional.of(icebergTable.spec()), Optional.empty(), (Map<String, Object>)ImmutableMap.of((Object)"id", (Object)2), Optional.empty());
        ImmutableMultiset expectedAccesses = ImmutableMultiset.builder().addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.DATA, "InputFile.newInput"), 2).addCopies((Object)new FileOperationUtils.FileOperation(FileOperationUtils.FileType.DELETE, "InputFile.newInput"), 1).build();
        QueryRunner.MaterializedResultWithPlan queryResult = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), "SELECT * FROM " + tableName);
        ((AbstractIntegerAssert)Assertions.assertThat((int)queryResult.result().getRowCount()).describedAs("query result row count", new Object[0])).isEqualTo(1);
        MultisetAssertions.assertMultisetsEqual((Multiset)((Multiset)FileOperationUtils.getOperations(this.getDistributedQueryRunner().getSpans()).stream().filter(operation -> ImmutableSet.of((Object)((Object)FileOperationUtils.FileType.DATA), (Object)((Object)FileOperationUtils.FileType.DELETE)).contains((Object)operation.fileType())).collect(ImmutableMultiset.toImmutableMultiset())), (Multiset)expectedAccesses);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testShowTables() {
        this.assertFileSystemAccesses("SHOW TABLES", (Multiset<FileOperationUtils.FileOperation>)ImmutableMultiset.of());
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<FileOperationUtils.FileOperation> expectedAccesses) {
        this.assertFileSystemAccesses(query, FileOperationUtils.Scope.METADATA_FILES, expectedAccesses);
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, FileOperationUtils.Scope scope, Multiset<FileOperationUtils.FileOperation> expectedAccesses) {
        this.assertFileSystemAccesses(this.getSession(), query, scope, expectedAccesses);
    }

    private void assertFileSystemAccesses(Session session, @Language(value="SQL") String query, Multiset<FileOperationUtils.FileOperation> expectedAccesses) {
        this.assertFileSystemAccesses(session, query, FileOperationUtils.Scope.METADATA_FILES, expectedAccesses);
    }

    private synchronized void assertFileSystemAccesses(Session session, @Language(value="SQL") String query, FileOperationUtils.Scope scope, Multiset<FileOperationUtils.FileOperation> expectedAccesses) {
        this.getDistributedQueryRunner().executeWithPlan(session, query);
        MultisetAssertions.assertMultisetsEqual((Multiset)((Multiset)FileOperationUtils.getOperations(this.getDistributedQueryRunner().getSpans()).stream().filter(scope).collect(ImmutableMultiset.toImmutableMultiset())), expectedAccesses);
    }

    private long getLatestSnapshotId(String tableName) {
        return (Long)this.computeScalar(String.format("SELECT snapshot_id FROM \"%s$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES", tableName));
    }

    private static Session withStatsOnWrite(Session session, boolean enabled) {
        String catalog = (String)session.getCatalog().orElseThrow();
        return Session.builder((Session)session).setCatalogSessionProperty(catalog, "collect_extended_statistics_on_write", Boolean.toString(enabled)).build();
    }
}

