/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.log.Logger;
import io.trino.filesystem.Location;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergGcsConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private static final Logger LOG = Logger.get(TestIcebergGcsConnectorSmokeTest.class);
    private static final FileAttribute<?> READ_ONLY_PERMISSIONS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
    private final String gcpStorageBucket = TestingProperties.requiredNonEmptySystemProperty((String)"testing.gcp-storage-bucket");
    private final String gcpCredentialKey = TestingProperties.requiredNonEmptySystemProperty((String)"testing.gcp-credentials-key");
    private final String schema = "test_iceberg_gcs_connector_smoke_test_" + TestingNames.randomNameSuffix();
    private HiveHadoop hiveHadoop;

    public TestIcebergGcsConnectorSmokeTest() {
        super(FileFormat.ORC);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        byte[] jsonKeyBytes = Base64.getDecoder().decode(this.gcpCredentialKey);
        Path gcpCredentialsFile = Files.createTempFile("gcp-credentials", ".json", READ_ONLY_PERMISSIONS);
        gcpCredentialsFile.toFile().deleteOnExit();
        Files.write(gcpCredentialsFile, jsonKeyBytes, new OpenOption[0]);
        String gcpCredentials = new String(jsonKeyBytes, StandardCharsets.UTF_8);
        String gcpSpecificCoreSiteXmlContent = Resources.toString((URL)Resources.getResource((String)"hdp3.1-core-site.xml.gcs-template"), (Charset)StandardCharsets.UTF_8).replace("%GCP_CREDENTIALS_FILE_PATH%", "/etc/hadoop/conf/gcp-credentials.json");
        Path hadoopCoreSiteXmlTempFile = Files.createTempFile("core-site", ".xml", READ_ONLY_PERMISSIONS);
        hadoopCoreSiteXmlTempFile.toFile().deleteOnExit();
        Files.writeString(hadoopCoreSiteXmlTempFile, (CharSequence)gcpSpecificCoreSiteXmlContent, new OpenOption[0]);
        this.hiveHadoop = (HiveHadoop)this.closeAfterClass((AutoCloseable)((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withImage(HiveHadoop.HIVE3_IMAGE)).withFilesToMount((Map)ImmutableMap.of((Object)"/etc/hadoop/conf/core-site.xml", (Object)hadoopCoreSiteXmlTempFile.normalize().toAbsolutePath().toString(), (Object)"/etc/hadoop/conf/gcp-credentials.json", (Object)gcpCredentialsFile.toAbsolutePath().toString()))).build());
        this.hiveHadoop.start();
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"hive_metastore").put((Object)"fs.native-gcs.enabled", (Object)"true").put((Object)"gcs.json-key", (Object)gcpCredentials).put((Object)"hive.metastore.uri", (Object)this.hiveHadoop.getHiveMetastoreEndpoint().toString()).put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").put((Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withClonedTpchTables(REQUIRED_TPCH_TABLES).withSchemaName(this.schema).withSchemaProperties((Map<String, String>)ImmutableMap.of((Object)"location", (Object)("'" + this.schemaPath() + "'"))).build()).build();
    }

    @AfterAll
    public void removeTestData() {
        try {
            this.fileSystem.deleteDirectory(Location.of((String)this.schemaPath()));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to clean up GCS test directory: %s", new Object[]{this.schemaPath()});
        }
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_RENAME_SCHEMA: {
                return false;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    protected String createSchemaSql(String schema) {
        return String.format("CREATE SCHEMA %1$s WITH (location = '%2$s%1$s')", schema, this.schemaPath());
    }

    @Override
    protected String schemaPath() {
        return String.format("gs://%s/%s/", this.gcpStorageBucket, this.schema);
    }

    @Override
    protected boolean locationExists(String location) {
        try {
            return this.fileSystem.newInputFile(Location.of((String)location)).exists();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test
    public void testRenameSchema() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", schemaName, schemaName + TestingNames.randomNameSuffix()), "Hive metastore does not support renaming schemas");
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        TestIcebergGcsConnectorSmokeTest testIcebergGcsConnectorSmokeTest = this;
        BridgingHiveMetastore metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveHadoop.getHiveMetastoreEndpoint()).build(x$0 -> testIcebergGcsConnectorSmokeTest.closeAfterClass((AutoCloseable)x$0)));
        metastore.dropTable(this.schema, tableName, false);
        Assertions.assertThat((Optional)metastore.getTable(this.schema, tableName)).isEmpty();
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        TestIcebergGcsConnectorSmokeTest testIcebergGcsConnectorSmokeTest = this;
        BridgingHiveMetastore metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(this.hiveHadoop.getHiveMetastoreEndpoint()).build(x$0 -> testIcebergGcsConnectorSmokeTest.closeAfterClass((AutoCloseable)x$0)));
        return (String)((Table)metastore.getTable(this.schema, tableName).orElseThrow()).getParameters().get("metadata_location");
    }

    @Override
    protected void deleteDirectory(String location) {
        try {
            this.fileSystem.deleteDirectory(Location.of((String)location));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }
}

