/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.Session;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.security.PrincipalType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergGetTableStatisticsOperations
extends AbstractTestQueryFramework {
    private QueryRunner queryRunner;
    private Path metastoreDir;

    protected QueryRunner createQueryRunner() throws Exception {
        this.queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSession()).setWorkerCount(0).build();
        this.queryRunner.installPlugin((Plugin)new TpchPlugin());
        this.queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
        this.metastoreDir = Files.createTempDirectory("test_iceberg_get_table_statistics_operations", new FileAttribute[0]);
        this.queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(this.metastoreDir));
        this.queryRunner.createCatalog("iceberg", "iceberg", (Map)ImmutableMap.of());
        HiveMetastore metastore = IcebergTestUtils.getHiveMetastore(this.queryRunner);
        Database database = Database.builder().setDatabaseName("tiny").setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
        metastore.createDatabase(database);
        this.queryRunner.execute("CREATE TABLE iceberg.tiny.orders AS SELECT * FROM tpch.tiny.orders");
        this.queryRunner.execute("CREATE TABLE iceberg.tiny.lineitem AS SELECT * FROM tpch.tiny.lineitem");
        this.queryRunner.execute("CREATE TABLE iceberg.tiny.customer AS SELECT * FROM tpch.tiny.customer");
        return this.queryRunner;
    }

    @Test
    public void testTwoWayJoin() {
        this.planDistributedQuery("SELECT * FROM iceberg.tiny.orders o, iceberg.tiny.lineitem l WHERE o.orderkey = l.orderkey");
        Assertions.assertThat((long)this.getTableStatisticsMethodInvocations()).isEqualTo(2L);
    }

    @Test
    public void testThreeWayJoin() {
        this.planDistributedQuery("SELECT * FROM iceberg.tiny.customer c, iceberg.tiny.orders o, iceberg.tiny.lineitem l WHERE o.orderkey = l.orderkey AND c.custkey = o.custkey");
        Assertions.assertThat((long)this.getTableStatisticsMethodInvocations()).isEqualTo(3L);
    }

    private void planDistributedQuery(@Language(value="SQL") String sql) {
        this.queryRunner.inTransaction(transactionSession -> this.queryRunner.createPlan(transactionSession, sql));
    }

    private long getTableStatisticsMethodInvocations() {
        return this.queryRunner.getSpans().stream().map(SpanData::getName).filter(name -> name.equals("Metadata.getTableStatistics")).count();
    }
}

