/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.plugin.iceberg.IcebergInputInfo;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergInputInfo
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder().setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION)).build();
    }

    @Test
    public void testInputWithPartitioning() {
        String tableName = "test_input_info_with_part_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioning = ARRAY['regionkey', 'truncate(name, 1)']) AS SELECT * FROM nation WHERE nationkey < 10", 10L);
        this.assertInputInfo(tableName, (List<String>)ImmutableList.of((Object)"regionkey: identity", (Object)"name_trunc: truncate[1]"), "PARQUET", 9L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInputWithoutPartitioning() {
        String tableName = "test_input_info_without_part_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation WHERE nationkey < 10", 10L);
        this.assertInputInfo(tableName, (List<String>)ImmutableList.of(), "PARQUET", 1L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInputWithOrcFileFormat() {
        String tableName = "test_input_info_with_orc_file_format_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (format = 'ORC') AS SELECT * FROM nation WHERE nationkey < 10", 10L);
        this.assertInputInfo(tableName, (List<String>)ImmutableList.of(), "ORC", 1L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void assertInputInfo(String tableName, List<String> partitionFields, String expectedFileFormat, long dataFiles) {
        this.inTransaction(session -> {
            Metadata metadata = this.getQueryRunner().getPlannerContext().getMetadata();
            QualifiedObjectName qualifiedObjectName = new QualifiedObjectName(session.getCatalog().orElse("iceberg"), session.getSchema().orElse("tpch"), tableName);
            Optional tableHandle = metadata.getTableHandle(session, qualifiedObjectName);
            Assertions.assertThat((Optional)tableHandle).isPresent();
            Optional tableInfo = metadata.getInfo(session, (TableHandle)tableHandle.get());
            Assertions.assertThat((Optional)tableInfo).isPresent();
            IcebergInputInfo icebergInputInfo = (IcebergInputInfo)tableInfo.get();
            Assertions.assertThat((Object)icebergInputInfo).isEqualTo((Object)new IcebergInputInfo(icebergInputInfo.snapshotId(), partitionFields, expectedFileFormat, Optional.of("10"), Optional.empty(), Optional.of(String.valueOf(dataFiles)), Optional.of("0")));
        });
    }
}

